/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.pon.profile.line;

import com.tplink.smb.omada.manager.device.api.web.validation.olt.SortedField;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class TcontVO {
    @Schema(name="tcontId", description="T-cont ID should be within the range of 1 to 127 and should not be null", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="tcontId should not be null")
    @Range(min=1L, max=127L, message="tcontId should be a number between {min}-{max}")
    @SortedField
    private @NotNull(message="tcontId should not be null") @Range(min=1L, max=127L, message="tcontId should be a number between {min}-{max}") Integer tcontId;
    @Schema(name="dbaId", description="The DBA template ID bound to the T-cont. DbaId should be a within the range of 0 to 512. Currently existing DBA templates, including DBA system templates, can also be referenced by the T-cont.", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="dbaId should not be null")
    @Range(min=0L, max=512L, message="dbaId should be a number between {min}-{max}")
    private @NotNull(message="dbaId should not be null") @Range(min=0L, max=512L, message="dbaId should be a number between {min}-{max}") Integer dbaId;
    @Schema(name="gemPortIds", description="A list of GEM Port IDs bound to this T-Cont.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Null(message="gemPortIds should be null.")
    private @Null(message="gemPortIds should be null.") List<Integer> gemPortIds;
    @Schema(name="isInUse", description="Whether the T-cont has been used. If it has been used, it cannot be deleted. True indicates it has been used, while false or null indicates it has not been used. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Null(message="isInUse should be null.")
    private @Null(message="isInUse should be null.") Boolean isInUse;

    @Generated
    public Integer getTcontId() {
        return this.tcontId;
    }

    @Generated
    public Integer getDbaId() {
        return this.dbaId;
    }

    @Generated
    public List<Integer> getGemPortIds() {
        return this.gemPortIds;
    }

    @Generated
    public Boolean getIsInUse() {
        return this.isInUse;
    }

    @Generated
    public void setTcontId(Integer tcontId) {
        this.tcontId = tcontId;
    }

    @Generated
    public void setDbaId(Integer dbaId) {
        this.dbaId = dbaId;
    }

    @Generated
    public void setGemPortIds(List<Integer> gemPortIds) {
        this.gemPortIds = gemPortIds;
    }

    @Generated
    public void setIsInUse(Boolean isInUse) {
        this.isInUse = isInUse;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof TcontVO)) {
            return false;
        }
        TcontVO other = (TcontVO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$tcontId = this.getTcontId();
        Integer other$tcontId = other.getTcontId();
        if (this$tcontId == null ? other$tcontId != null : !((Object)this$tcontId).equals(other$tcontId)) {
            return false;
        }
        Integer this$dbaId = this.getDbaId();
        Integer other$dbaId = other.getDbaId();
        if (this$dbaId == null ? other$dbaId != null : !((Object)this$dbaId).equals(other$dbaId)) {
            return false;
        }
        Boolean this$isInUse = this.getIsInUse();
        Boolean other$isInUse = other.getIsInUse();
        if (this$isInUse == null ? other$isInUse != null : !((Object)this$isInUse).equals(other$isInUse)) {
            return false;
        }
        List<Integer> this$gemPortIds = this.getGemPortIds();
        List<Integer> other$gemPortIds = other.getGemPortIds();
        return !(this$gemPortIds == null ? other$gemPortIds != null : !((Object)this$gemPortIds).equals(other$gemPortIds));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TcontVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $tcontId = this.getTcontId();
        result = result * 59 + ($tcontId == null ? 43 : ((Object)$tcontId).hashCode());
        Integer $dbaId = this.getDbaId();
        result = result * 59 + ($dbaId == null ? 43 : ((Object)$dbaId).hashCode());
        Boolean $isInUse = this.getIsInUse();
        result = result * 59 + ($isInUse == null ? 43 : ((Object)$isInUse).hashCode());
        List<Integer> $gemPortIds = this.getGemPortIds();
        result = result * 59 + ($gemPortIds == null ? 43 : ((Object)$gemPortIds).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TcontVO(tcontId=" + this.getTcontId() + ", dbaId=" + this.getDbaId() + ", gemPortIds=" + this.getGemPortIds() + ", isInUse=" + this.getIsInUse() + ")";
    }

    @Generated
    public TcontVO(Integer tcontId, Integer dbaId, List<Integer> gemPortIds, Boolean isInUse) {
        this.tcontId = tcontId;
        this.dbaId = dbaId;
        this.gemPortIds = gemPortIds;
        this.isInUse = isInUse;
    }

    @Generated
    public TcontVO() {
    }
}

