/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.pon.profile.line;

import com.tplink.smb.omada.manager.c.b.aT;
import com.tplink.smb.omada.manager.c.b.ac;
import com.tplink.smb.omada.manager.device.api.web.validation.olt.SearchIgnore;
import com.tplink.smb.omada.manager.device.api.web.validation.olt.SortedField;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import com.tplink.smb.omada.manager.device.olt.pon.profile.line.LineProfileDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class LineProfileVO
extends DpmsBaseDeviceDTO {
    @Schema(name="lineProfileId", description="ID of line profile should be within the range of 1 to 512")
    @Range(min=1L, max=512L, message="lineProfileId should be a number between {min}-{max}")
    @SortedField
    private @Range(min=1L, max=512L, message="lineProfileId should be a number between {min}-{max}") Integer lineProfileId;
    @Schema(name="name", description="The name of the Line template, an optional configuration. If not configured by the user, it will be automatically generated by the device. Name should contain 1 to 32 characters including digits, upper and lower letters, and the following six characters: -@_:/. . It can be left empty; if empty, it will be assigned automatically by the device.")
    @Length(min=1, max=32, message="name should between {min}~{max} characters")
    @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{1,32}$", message="only 1-32 bits numbers, Upper and lower letters, -@_:/. are allowed.")
    private @Length(min=1, max=32, message="name should between {min}~{max} characters") @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{1,32}$", message="only 1-32 bits numbers, Upper and lower letters, -@_:/. are allowed.") String name;
    @Schema(name="isSystemProfile", description="IsSystemProfile should be null, because it's generated by device.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Null(message="isSystemProfile should be null, because it's generated by device.")
    @SearchIgnore
    private @Null(message="isSystemProfile should be null, because it's generated by device.") Boolean isSystemProfile;
    @Schema(name="isInUse", description="Whether the Line Profile is in use: if it is in use, deletion is not allowed. True indicates it is in use, while false indicates it is not in use. This field should not be provided.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Null(message="inUse should be null.")
    private @Null(message="inUse should be null.") String inUse;
    @Schema(name="upstreamFEC", description="Enable/Disable Upstream FEC feature. UpstreamFEC should be a value as follows: DISABLE;ENABLE. Default value: DISABLE.", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="upstreamFEC should not be null")
    private @NotNull(message="upstreamFEC should not be null") ac upstreamFEC;
    @Schema(name="mappingMode", description="Mapping method for the ONT. MappingMode should be a value as follows: VLAN, PRIORITY, VLAN_PRIORITY, PORT, PORT_VLAN, PORT_PRIORITY, PORT_VLAN_PRIORITY. Default value: VLAN.", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="mappingMode should not be null")
    private @NotNull(message="mappingMode should not be null") aT mappingMode;
    @Schema(name="omccEncrypt", description="Whether to enable OMCC encryption feature: when OMCC encryption is enabled, OMCI messages will be encrypted; otherwise, they will not be encrypted. OmccEncrypt should be a value as follows: ENABLE;DISABLE. Default value: DISABLE.")
    @SearchIgnore
    private ac omccEncrypt;
    @Schema(name="tcontNum", description="The number of T-conts created under this Line template is non-configurable.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Null(message="tcontNum should be null.")
    private @Null(message="tcontNum should be null.") Long tcontNum;
    @Schema(name="gemPortNum", description="The number of gem ports created under this Line template is non-configurable.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Null(message="gemPortNum should be null.")
    private @Null(message="gemPortNum should be null.") Long gemPortNum;

    public LineProfileVO(LineProfileDTO lineProfileDTO) {
        this.setLineProfileId(lineProfileDTO.getLineProfileId());
        this.setName(lineProfileDTO.getName());
        this.setIsSystemProfile(lineProfileDTO.getIsSystemProfile());
        this.setInUse(lineProfileDTO.getIsInUse() != false ? "In Use" : "Unused");
        this.setUpstreamFEC(lineProfileDTO.getUpstreamFEC());
        this.setMappingMode(lineProfileDTO.getMappingMode());
        this.setOmccEncrypt(lineProfileDTO.getOmccEncrypt());
        this.setTcontNum(lineProfileDTO.getTcontNum());
        this.setGemPortNum(lineProfileDTO.getGemPortNum());
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof LineProfileVO)) {
            return false;
        }
        LineProfileVO other = (LineProfileVO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$lineProfileId = this.getLineProfileId();
        Integer other$lineProfileId = other.getLineProfileId();
        if (this$lineProfileId == null ? other$lineProfileId != null : !((Object)this$lineProfileId).equals(other$lineProfileId)) {
            return false;
        }
        Boolean this$isSystemProfile = this.getIsSystemProfile();
        Boolean other$isSystemProfile = other.getIsSystemProfile();
        if (this$isSystemProfile == null ? other$isSystemProfile != null : !((Object)this$isSystemProfile).equals(other$isSystemProfile)) {
            return false;
        }
        Long this$tcontNum = this.getTcontNum();
        Long other$tcontNum = other.getTcontNum();
        if (this$tcontNum == null ? other$tcontNum != null : !((Object)this$tcontNum).equals(other$tcontNum)) {
            return false;
        }
        Long this$gemPortNum = this.getGemPortNum();
        Long other$gemPortNum = other.getGemPortNum();
        if (this$gemPortNum == null ? other$gemPortNum != null : !((Object)this$gemPortNum).equals(other$gemPortNum)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$inUse = this.getInUse();
        String other$inUse = other.getInUse();
        if (this$inUse == null ? other$inUse != null : !this$inUse.equals(other$inUse)) {
            return false;
        }
        ac this$upstreamFEC = this.getUpstreamFEC();
        ac other$upstreamFEC = other.getUpstreamFEC();
        if (this$upstreamFEC == null ? other$upstreamFEC != null : !this$upstreamFEC.equals(other$upstreamFEC)) {
            return false;
        }
        aT this$mappingMode = this.getMappingMode();
        aT other$mappingMode = other.getMappingMode();
        if (this$mappingMode == null ? other$mappingMode != null : !this$mappingMode.equals(other$mappingMode)) {
            return false;
        }
        ac this$omccEncrypt = this.getOmccEncrypt();
        ac other$omccEncrypt = other.getOmccEncrypt();
        return !(this$omccEncrypt == null ? other$omccEncrypt != null : !this$omccEncrypt.equals(other$omccEncrypt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LineProfileVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $lineProfileId = this.getLineProfileId();
        result = result * 59 + ($lineProfileId == null ? 43 : ((Object)$lineProfileId).hashCode());
        Boolean $isSystemProfile = this.getIsSystemProfile();
        result = result * 59 + ($isSystemProfile == null ? 43 : ((Object)$isSystemProfile).hashCode());
        Long $tcontNum = this.getTcontNum();
        result = result * 59 + ($tcontNum == null ? 43 : ((Object)$tcontNum).hashCode());
        Long $gemPortNum = this.getGemPortNum();
        result = result * 59 + ($gemPortNum == null ? 43 : ((Object)$gemPortNum).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $inUse = this.getInUse();
        result = result * 59 + ($inUse == null ? 43 : $inUse.hashCode());
        ac $upstreamFEC = this.getUpstreamFEC();
        result = result * 59 + ($upstreamFEC == null ? 43 : $upstreamFEC.hashCode());
        aT $mappingMode = this.getMappingMode();
        result = result * 59 + ($mappingMode == null ? 43 : $mappingMode.hashCode());
        ac $omccEncrypt = this.getOmccEncrypt();
        result = result * 59 + ($omccEncrypt == null ? 43 : $omccEncrypt.hashCode());
        return result;
    }

    @Generated
    public Integer getLineProfileId() {
        return this.lineProfileId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getIsSystemProfile() {
        return this.isSystemProfile;
    }

    @Generated
    public String getInUse() {
        return this.inUse;
    }

    @Generated
    public ac getUpstreamFEC() {
        return this.upstreamFEC;
    }

    @Generated
    public aT getMappingMode() {
        return this.mappingMode;
    }

    @Generated
    public ac getOmccEncrypt() {
        return this.omccEncrypt;
    }

    @Generated
    public Long getTcontNum() {
        return this.tcontNum;
    }

    @Generated
    public Long getGemPortNum() {
        return this.gemPortNum;
    }

    @Generated
    public void setLineProfileId(Integer lineProfileId) {
        this.lineProfileId = lineProfileId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setIsSystemProfile(Boolean isSystemProfile) {
        this.isSystemProfile = isSystemProfile;
    }

    @Generated
    public void setInUse(String inUse) {
        this.inUse = inUse;
    }

    @Generated
    public void setUpstreamFEC(ac upstreamFEC) {
        this.upstreamFEC = upstreamFEC;
    }

    @Generated
    public void setMappingMode(aT mappingMode) {
        this.mappingMode = mappingMode;
    }

    @Generated
    public void setOmccEncrypt(ac omccEncrypt) {
        this.omccEncrypt = omccEncrypt;
    }

    @Generated
    public void setTcontNum(Long tcontNum) {
        this.tcontNum = tcontNum;
    }

    @Generated
    public void setGemPortNum(Long gemPortNum) {
        this.gemPortNum = gemPortNum;
    }

    @Generated
    public String toString() {
        return "LineProfileVO(lineProfileId=" + this.getLineProfileId() + ", name=" + this.getName() + ", isSystemProfile=" + this.getIsSystemProfile() + ", inUse=" + this.getInUse() + ", upstreamFEC=" + this.getUpstreamFEC() + ", mappingMode=" + this.getMappingMode() + ", omccEncrypt=" + this.getOmccEncrypt() + ", tcontNum=" + this.getTcontNum() + ", gemPortNum=" + this.getGemPortNum() + ")";
    }
}

