/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.pon.profile.line;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.manager.c.b.bM;
import com.tplink.smb.omada.manager.c.b.cQ;
import com.tplink.smb.omada.manager.device.api.web.validation.olt.SortedField;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class GemMappingDTO
extends DpmsBaseDeviceDTO {
    private static final long serialVersionUID = 8058078993737389159L;
    @Schema(name="gemMappingId", description="GemMappingId should be within the range of 1 to 8,and should not be null", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="gemMappingId should not be null")
    @Range(min=1L, max=8L, message="Gem mapping id should be a number between {min}-{max}")
    @SortedField
    private @NotNull(message="gemMappingId should not be null") @Range(min=1L, max=8L, message="Gem mapping id should be a number between {min}-{max}") Integer gemMappingId;
    @Schema(name="lineProfileId", description="The ID of the associated Line Profile should be within the range of 1 to 512.")
    private Integer lineProfileId;
    @Schema(name="gemPortId", description="Gem port ID should be within the range of 1 to 1023", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="gemPortId should not be null")
    @Range(min=1L, max=1023L, message="gemPortId should be a number between {min}-{max}")
    private @NotNull(message="gemPortId should not be null") @Range(min=1L, max=1023L, message="gemPortId should be a number between {min}-{max}") Integer gemPortId;
    @Schema(name="vlanType", description="The mapping relationship between Gem Port and VLAN is valid when the Line Profile's mappingMode is set to: Vlan, Vlan-Priority, Port-Vlan, or Port-VLAN-Priority. VlanType should be a value as follows: TAGGED;UNTAGGED, with the default value being TAGGED.")
    private cQ vlanType;
    @Schema(name="vlanId", description="VLAN ID is valid when the vlanType is set to Tagged. VlanId should be within the range of 1 to 4094.")
    @Range(min=1L, max=4095L, message="vlanId should be a number between {min}-{max}")
    private @Range(min=1L, max=4095L, message="vlanId should be a number between {min}-{max}") Integer vlanId;
    @Schema(name="priority", description="The mapping relationship between Gem Port and 802.1p priority.It is valid when the Line Profile's mappingMode is set to: Priority, Vlan-Priority, Port-Priority, or Port-VLAN-Priority. Priority should be within the range of 0 to 7.")
    @Range(min=-1L, max=7L, message="priority should be a number between {min}-{max}")
    private @Range(min=-1L, max=7L, message="priority should be a number between {min}-{max}") Integer priority;
    @Schema(name="portMappingType", description="The mapping relationship between Gem Port and ONT Port ID is valid when the Line Profile's mappingMode is set to: Port, Port-Vlan, Port-Priority, or Port-Vlan-Priority. PortMappingType should be a value as follows:ETH;POTS, with the default value being ETH.")
    private bM portMappingType;
    @Schema(name="portId", description="The mapped ONT port ID is valid when the portMappingType has a value. When portMappingType is ETH, portId should be within the range of 1 to 24.")
    private Integer portId;

    public OperationResponse check() {
        if (Objects.equals(this.vlanType, cQ.a) && Objects.isNull(this.vlanId)) {
            return new OperationResponse(b.d, "vlanId should not to be empty when vlanType is Tagged.", null);
        }
        if (Objects.equals(this.portMappingType, bM.a) && Objects.isNull(this.portId)) {
            return new OperationResponse(b.d, "Port id should not to be empty when vlan is Tagged.", null);
        }
        if (!Objects.equals(this.portMappingType, bM.a) && Objects.nonNull(this.portId)) {
            return new OperationResponse(b.d, "Port id should to be empty when vlan is not Tagged.", null);
        }
        if (Objects.nonNull(this.portMappingType) && Objects.nonNull(this.portId)) {
            switch (this.portMappingType) {
                case a: {
                    if (1 <= this.portId && 24 >= this.portId) break;
                    return new OperationResponse(b.d, "portId should between 1~24 whent portMappingType is ETH", null);
                }
                default: {
                    if (1 <= this.portId && 4 >= this.portId) break;
                    return new OperationResponse(b.d, "portId should between 1~4 whent portMappingType is POTS", null);
                }
            }
        }
        return null;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof GemMappingDTO)) {
            return false;
        }
        GemMappingDTO other = (GemMappingDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$gemMappingId = this.getGemMappingId();
        Integer other$gemMappingId = other.getGemMappingId();
        if (this$gemMappingId == null ? other$gemMappingId != null : !((Object)this$gemMappingId).equals(other$gemMappingId)) {
            return false;
        }
        Integer this$lineProfileId = this.getLineProfileId();
        Integer other$lineProfileId = other.getLineProfileId();
        if (this$lineProfileId == null ? other$lineProfileId != null : !((Object)this$lineProfileId).equals(other$lineProfileId)) {
            return false;
        }
        Integer this$gemPortId = this.getGemPortId();
        Integer other$gemPortId = other.getGemPortId();
        if (this$gemPortId == null ? other$gemPortId != null : !((Object)this$gemPortId).equals(other$gemPortId)) {
            return false;
        }
        Integer this$vlanId = this.getVlanId();
        Integer other$vlanId = other.getVlanId();
        if (this$vlanId == null ? other$vlanId != null : !((Object)this$vlanId).equals(other$vlanId)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        Integer this$portId = this.getPortId();
        Integer other$portId = other.getPortId();
        if (this$portId == null ? other$portId != null : !((Object)this$portId).equals(other$portId)) {
            return false;
        }
        cQ this$vlanType = this.getVlanType();
        cQ other$vlanType = other.getVlanType();
        if (this$vlanType == null ? other$vlanType != null : !this$vlanType.equals(other$vlanType)) {
            return false;
        }
        bM this$portMappingType = this.getPortMappingType();
        bM other$portMappingType = other.getPortMappingType();
        return !(this$portMappingType == null ? other$portMappingType != null : !this$portMappingType.equals(other$portMappingType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GemMappingDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $gemMappingId = this.getGemMappingId();
        result = result * 59 + ($gemMappingId == null ? 43 : ((Object)$gemMappingId).hashCode());
        Integer $lineProfileId = this.getLineProfileId();
        result = result * 59 + ($lineProfileId == null ? 43 : ((Object)$lineProfileId).hashCode());
        Integer $gemPortId = this.getGemPortId();
        result = result * 59 + ($gemPortId == null ? 43 : ((Object)$gemPortId).hashCode());
        Integer $vlanId = this.getVlanId();
        result = result * 59 + ($vlanId == null ? 43 : ((Object)$vlanId).hashCode());
        Integer $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        Integer $portId = this.getPortId();
        result = result * 59 + ($portId == null ? 43 : ((Object)$portId).hashCode());
        cQ $vlanType = this.getVlanType();
        result = result * 59 + ($vlanType == null ? 43 : $vlanType.hashCode());
        bM $portMappingType = this.getPortMappingType();
        result = result * 59 + ($portMappingType == null ? 43 : $portMappingType.hashCode());
        return result;
    }

    @Generated
    public GemMappingDTO() {
    }

    @Generated
    public Integer getGemMappingId() {
        return this.gemMappingId;
    }

    @Generated
    public Integer getLineProfileId() {
        return this.lineProfileId;
    }

    @Generated
    public Integer getGemPortId() {
        return this.gemPortId;
    }

    @Generated
    public cQ getVlanType() {
        return this.vlanType;
    }

    @Generated
    public Integer getVlanId() {
        return this.vlanId;
    }

    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    @Generated
    public bM getPortMappingType() {
        return this.portMappingType;
    }

    @Generated
    public Integer getPortId() {
        return this.portId;
    }

    @Generated
    public GemMappingDTO setGemMappingId(Integer gemMappingId) {
        this.gemMappingId = gemMappingId;
        return this;
    }

    @Generated
    public GemMappingDTO setLineProfileId(Integer lineProfileId) {
        this.lineProfileId = lineProfileId;
        return this;
    }

    @Generated
    public GemMappingDTO setGemPortId(Integer gemPortId) {
        this.gemPortId = gemPortId;
        return this;
    }

    @Generated
    public GemMappingDTO setVlanType(cQ vlanType) {
        this.vlanType = vlanType;
        return this;
    }

    @Generated
    public GemMappingDTO setVlanId(Integer vlanId) {
        this.vlanId = vlanId;
        return this;
    }

    @Generated
    public GemMappingDTO setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Generated
    public GemMappingDTO setPortMappingType(bM portMappingType) {
        this.portMappingType = portMappingType;
        return this;
    }

    @Generated
    public GemMappingDTO setPortId(Integer portId) {
        this.portId = portId;
        return this;
    }

    @Generated
    public String toString() {
        return "GemMappingDTO(gemMappingId=" + this.getGemMappingId() + ", lineProfileId=" + this.getLineProfileId() + ", gemPortId=" + this.getGemPortId() + ", vlanType=" + this.getVlanType() + ", vlanId=" + this.getVlanId() + ", priority=" + this.getPriority() + ", portMappingType=" + this.getPortMappingType() + ", portId=" + this.getPortId() + ")";
    }
}

