/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.pon.profile.dba;

import com.tplink.smb.omada.manager.c.b.M;
import com.tplink.smb.omada.manager.device.api.web.validation.olt.SearchIgnore;
import com.tplink.smb.omada.manager.device.api.web.validation.olt.SortedField;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import com.tplink.smb.omada.manager.device.olt.pon.profile.dba.DBAProfileDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class DBAProfileVO
extends DpmsBaseDeviceDTO {
    @Schema(name="dbaId", description="DBA ID should be within the range of 1 to 512.")
    @Range(min=1L, max=512L, message="dbaId should be a number between {min}-{max}")
    @SortedField
    private @Range(min=1L, max=512L, message="dbaId should be a number between {min}-{max}") Integer dbaId;
    @Schema(name="name", description="The name of the DBA profile should contain 1 to 32 characters including digits, upper and lower letters, and the following six characters: -@_:/. .")
    @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{1,32}$", message="only 1-32 bits numbers, Upper and lower letters, -@_:/. are allowed.")
    private @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{1,32}$", message="only 1-32 bits numbers, Upper and lower letters, -@_:/. are allowed.") String name;
    @Schema(name="isSystemProfile", description="IsSystemProfile should be null, because it's generated by device.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Null(message="isSystemProfile should be null, because it's generated by device.")
    @SearchIgnore
    private @Null(message="isSystemProfile should be null, because it's generated by device.") Boolean isSystemProfile;
    @Schema(name="isInUse", description="Whether the DBA profile is in use.DBA Profile cannot be deleted if it has already been used. A value of true indicates that it has been used, while false indicates that it has not been used. If this field is not provided, the default value is false.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Null(message="inUse should be null.")
    private @Null(message="inUse should be null.") String inUse;
    @Schema(name="type", description="DBA bandwidth allocation methods.Type should be a value as follows: FIX, ASSURE, MAX, ASSURE_MAX, and FIX_ASSURE_MAX. The default value is FIX.", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="DBA type should not be null")
    private @NotNull(message="DBA type should not be null") M type;
    @Schema(name="fix", description="The value for fixed bandwidth is only required when the Type is set to FIX or FIX_ASSURE_MAX. Fix should be within the range of 128 to 720000, with the unit in kbit/s.")
    @Range(min=128L, max=720000L, message="fix should be a number between {min}-{max}")
    private @Range(min=128L, max=720000L, message="fix should be a number between {min}-{max}") Integer fix;
    @Schema(name="assure", description="The value for guaranteed bandwidth is required when the Type is set to ASSURE, ASSURE_MAX, or FIX_ASSURE_MAX. Assure should be within the range of 128 to 1200000, with the unit in kbit/s.")
    @Range(min=128L, max=1200000L, message="assure should be a number between {min}-{max}")
    private @Range(min=128L, max=1200000L, message="assure should be a number between {min}-{max}") Integer assure;
    @Schema(name="max", description="The value for maximum bandwidth is required when the Type is set to MAX, ASSURE_MAX, or FIX_ASSURE_MAX. Max should be within the range of 128 to 1244160, with the unit in kbit/s.")
    @Range(min=128L, max=1244160L, message="max should be a number between {min}-{max}")
    private @Range(min=128L, max=1244160L, message="max should be a number between {min}-{max}") Integer max;
    @Schema(name="tcontNum", description="The number of T-conts using this DBA template is not configurable and will be returned upon inquiry.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Null(message="tcontNum should be null.")
    private @Null(message="tcontNum should be null.") Long tcontNum;

    public DBAProfileVO(DBAProfileDTO dbaProfileDTO) {
        this.setDbaId(dbaProfileDTO.getDbaId());
        this.setName(dbaProfileDTO.getName());
        this.setIsSystemProfile(dbaProfileDTO.getIsSystemProfile());
        this.setInUse(dbaProfileDTO.getIsInUse() != false ? "In Use" : "Unused");
        this.setType(dbaProfileDTO.getType());
        this.setFix(dbaProfileDTO.getFix());
        this.setAssure(dbaProfileDTO.getAssure());
        this.setMax(dbaProfileDTO.getMax());
        this.setTcontNum(dbaProfileDTO.getTcontNum());
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof DBAProfileVO)) {
            return false;
        }
        DBAProfileVO other = (DBAProfileVO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$dbaId = this.getDbaId();
        Integer other$dbaId = other.getDbaId();
        if (this$dbaId == null ? other$dbaId != null : !((Object)this$dbaId).equals(other$dbaId)) {
            return false;
        }
        Boolean this$isSystemProfile = this.getIsSystemProfile();
        Boolean other$isSystemProfile = other.getIsSystemProfile();
        if (this$isSystemProfile == null ? other$isSystemProfile != null : !((Object)this$isSystemProfile).equals(other$isSystemProfile)) {
            return false;
        }
        Integer this$fix = this.getFix();
        Integer other$fix = other.getFix();
        if (this$fix == null ? other$fix != null : !((Object)this$fix).equals(other$fix)) {
            return false;
        }
        Integer this$assure = this.getAssure();
        Integer other$assure = other.getAssure();
        if (this$assure == null ? other$assure != null : !((Object)this$assure).equals(other$assure)) {
            return false;
        }
        Integer this$max = this.getMax();
        Integer other$max = other.getMax();
        if (this$max == null ? other$max != null : !((Object)this$max).equals(other$max)) {
            return false;
        }
        Long this$tcontNum = this.getTcontNum();
        Long other$tcontNum = other.getTcontNum();
        if (this$tcontNum == null ? other$tcontNum != null : !((Object)this$tcontNum).equals(other$tcontNum)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$inUse = this.getInUse();
        String other$inUse = other.getInUse();
        if (this$inUse == null ? other$inUse != null : !this$inUse.equals(other$inUse)) {
            return false;
        }
        M this$type = this.getType();
        M other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DBAProfileVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $dbaId = this.getDbaId();
        result = result * 59 + ($dbaId == null ? 43 : ((Object)$dbaId).hashCode());
        Boolean $isSystemProfile = this.getIsSystemProfile();
        result = result * 59 + ($isSystemProfile == null ? 43 : ((Object)$isSystemProfile).hashCode());
        Integer $fix = this.getFix();
        result = result * 59 + ($fix == null ? 43 : ((Object)$fix).hashCode());
        Integer $assure = this.getAssure();
        result = result * 59 + ($assure == null ? 43 : ((Object)$assure).hashCode());
        Integer $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
        Long $tcontNum = this.getTcontNum();
        result = result * 59 + ($tcontNum == null ? 43 : ((Object)$tcontNum).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $inUse = this.getInUse();
        result = result * 59 + ($inUse == null ? 43 : $inUse.hashCode());
        M $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Generated
    public Integer getDbaId() {
        return this.dbaId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getIsSystemProfile() {
        return this.isSystemProfile;
    }

    @Generated
    public String getInUse() {
        return this.inUse;
    }

    @Generated
    public M getType() {
        return this.type;
    }

    @Generated
    public Integer getFix() {
        return this.fix;
    }

    @Generated
    public Integer getAssure() {
        return this.assure;
    }

    @Generated
    public Integer getMax() {
        return this.max;
    }

    @Generated
    public Long getTcontNum() {
        return this.tcontNum;
    }

    @Generated
    public void setDbaId(Integer dbaId) {
        this.dbaId = dbaId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setIsSystemProfile(Boolean isSystemProfile) {
        this.isSystemProfile = isSystemProfile;
    }

    @Generated
    public void setInUse(String inUse) {
        this.inUse = inUse;
    }

    @Generated
    public void setType(M type) {
        this.type = type;
    }

    @Generated
    public void setFix(Integer fix) {
        this.fix = fix;
    }

    @Generated
    public void setAssure(Integer assure) {
        this.assure = assure;
    }

    @Generated
    public void setMax(Integer max) {
        this.max = max;
    }

    @Generated
    public void setTcontNum(Long tcontNum) {
        this.tcontNum = tcontNum;
    }

    @Generated
    public String toString() {
        return "DBAProfileVO(dbaId=" + this.getDbaId() + ", name=" + this.getName() + ", isSystemProfile=" + this.getIsSystemProfile() + ", inUse=" + this.getInUse() + ", type=" + this.getType() + ", fix=" + this.getFix() + ", assure=" + this.getAssure() + ", max=" + this.getMax() + ", tcontNum=" + this.getTcontNum() + ")";
    }
}

