/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.pon.profile.dba;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.J;
import com.tplink.smb.omada.manager.c.b.M;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class DBAProfileModifyDTO
extends DpmsBaseDeviceDTO {
    private static final long serialVersionUID = -4811764667552743160L;
    @Schema(name="dbaId", description="DBA ID should be within the range of 1 to 512 and should not be null", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="dbaId should not be null")
    @Range(min=0L, max=512L, message="dbaId should be a number between {min}-{max}")
    private @NotNull(message="dbaId should not be null") @Range(min=0L, max=512L, message="dbaId should be a number between {min}-{max}") Integer dbaId;
    @Schema(name="name", description="Name of DBA profile should contain 1 to 32 characters including digits, upper and lower letters, and the following six characters: -@_:/. .")
    @Length(min=1, max=32, message="name should between {min}~{max} characters")
    @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{1,32}$", message="only 1-32 bits numbers, Upper and lower letters, -@_:/. are allowed.")
    private @Length(min=1, max=32, message="name should between {min}~{max} characters") @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{1,32}$", message="only 1-32 bits numbers, Upper and lower letters, -@_:/. are allowed.") String name;
    @Schema(name="type", description="DBA bandwidth allocation methods.Type should be a value as follows: FIX, ASSURE, MAX, ASSURE_MAX, and FIX_ASSURE_MAX. The default value is FIX.")
    private M type;
    @Schema(name="fix", description="The value for fixed bandwidth is required when the Type is set to FIX or FIX_ASSURE_MAX. Fix should be within the range of 128 to 720000, with the unit in kbit/s.")
    @Range(min=128L, max=720000L, message="fix should be a number between {min}-{max}")
    private @Range(min=128L, max=720000L, message="fix should be a number between {min}-{max}") Integer fix;
    @Schema(name="assure", description="The value for guaranteed bandwidth is required when the Type is set to ASSURE, ASSURE_MAX, or FIX_ASSURE_MAX. Assure should be within the range of 128 to 1200000, with the unit in kbit/s.")
    @Range(min=128L, max=1200000L, message="assure should be a number between {min}-{max}")
    private @Range(min=128L, max=1200000L, message="assure should be a number between {min}-{max}") Integer assure;
    @Schema(name="max", description="The value for maximum bandwidth is required when the Type is set to MAX, ASSURE_MAX, or FIX_ASSURE_MAX. Max should be within the range of 128 to 1244160, with the unit in kbit/s.")
    @Range(min=128L, max=1244160L, message="max should be a number between {min}-{max}")
    private @Range(min=128L, max=1244160L, message="max should be a number between {min}-{max}") Integer max;

    public OperationResponse<Void> check() {
        boolean containsMax;
        if (this.type == null) {
            return null;
        }
        String typeStr = this.type.toString().toLowerCase();
        boolean containsFix = typeStr.contains(M.a.toString().toLowerCase());
        if (containsFix && J.b((Object)this.fix)) {
            return new OperationResponse(b.d, "in " + typeStr + " type fix bandwidth must not null", null);
        }
        if (!containsFix && J.c((Object)this.fix)) {
            return new OperationResponse(b.d, "in " + typeStr + " type fix bandwidth must null", null);
        }
        boolean containsAssure = typeStr.contains(M.b.toString().toLowerCase());
        if (containsAssure) {
            if (J.b((Object)this.assure)) {
                return new OperationResponse(b.d, "in " + typeStr + " type assure bandwidth must not null", null);
            }
            if (M.e.equals((Object)this.type) && this.assure > 1200000) {
                return new OperationResponse(b.d);
            }
        } else if (J.c((Object)this.assure)) {
            return new OperationResponse(b.d, "in " + typeStr + " type assure bandwidth must null", null);
        }
        if ((containsMax = typeStr.contains(M.c.toString().toLowerCase())) && J.b((Object)this.max)) {
            return new OperationResponse(b.d, "in " + typeStr + " type max bandwidth must not null", null);
        }
        if (!containsMax && J.c((Object)this.max)) {
            return new OperationResponse(b.d, "in " + typeStr + " type max bandwidth must null", null);
        }
        if (Objects.equals(this.type, M.d) && this.max < this.assure) {
            return new OperationResponse(b.d, "The Max Bandwidth should be larger than the Assure Bandwidth.", null);
        }
        if (Objects.equals(this.type, M.e) && this.max < this.assure + this.fix) {
            return new OperationResponse(b.d, "The Max Bandwidth should be larger than or equal to the sum of the Fix Bandwidth and the Assure Bandwidth.", null);
        }
        if (Objects.equals(this.type, M.e) && this.assure + this.fix > 1200000) {
            return new OperationResponse(b.d, "The sum of the Fix Bandwidth and the Assure Bandwidth is larger than the maximum value.", null);
        }
        return null;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof DBAProfileModifyDTO)) {
            return false;
        }
        DBAProfileModifyDTO other = (DBAProfileModifyDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$dbaId = this.getDbaId();
        Integer other$dbaId = other.getDbaId();
        if (this$dbaId == null ? other$dbaId != null : !((Object)this$dbaId).equals(other$dbaId)) {
            return false;
        }
        Integer this$fix = this.getFix();
        Integer other$fix = other.getFix();
        if (this$fix == null ? other$fix != null : !((Object)this$fix).equals(other$fix)) {
            return false;
        }
        Integer this$assure = this.getAssure();
        Integer other$assure = other.getAssure();
        if (this$assure == null ? other$assure != null : !((Object)this$assure).equals(other$assure)) {
            return false;
        }
        Integer this$max = this.getMax();
        Integer other$max = other.getMax();
        if (this$max == null ? other$max != null : !((Object)this$max).equals(other$max)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        M this$type = this.getType();
        M other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DBAProfileModifyDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $dbaId = this.getDbaId();
        result = result * 59 + ($dbaId == null ? 43 : ((Object)$dbaId).hashCode());
        Integer $fix = this.getFix();
        result = result * 59 + ($fix == null ? 43 : ((Object)$fix).hashCode());
        Integer $assure = this.getAssure();
        result = result * 59 + ($assure == null ? 43 : ((Object)$assure).hashCode());
        Integer $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        M $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Generated
    public DBAProfileModifyDTO() {
    }

    @Generated
    public Integer getDbaId() {
        return this.dbaId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public M getType() {
        return this.type;
    }

    @Generated
    public Integer getFix() {
        return this.fix;
    }

    @Generated
    public Integer getAssure() {
        return this.assure;
    }

    @Generated
    public Integer getMax() {
        return this.max;
    }

    @Generated
    public void setDbaId(Integer dbaId) {
        this.dbaId = dbaId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(M type) {
        this.type = type;
    }

    @Generated
    public void setFix(Integer fix) {
        this.fix = fix;
    }

    @Generated
    public void setAssure(Integer assure) {
        this.assure = assure;
    }

    @Generated
    public void setMax(Integer max) {
        this.max = max;
    }

    @Generated
    public String toString() {
        return "DBAProfileModifyDTO(dbaId=" + this.getDbaId() + ", name=" + this.getName() + ", type=" + this.getType() + ", fix=" + this.getFix() + ", assure=" + this.getAssure() + ", max=" + this.getMax() + ")";
    }
}

