/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.pon.ponport;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.device.manage.message.body.olt.DeviceResponseBody;
import com.tplink.smb.omada.manager.c.b.L;
import com.tplink.smb.omada.manager.c.b.ac;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import com.tplink.smb.omada.manager.device.olt.pon.ponport.ReactivePonPortDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.Range;

public class PonPortModifyDTO
extends DpmsBaseDeviceDTO {
    private static final long serialVersionUID = -2940104560558939924L;
    @Schema(description="Port ID", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotBlank(message="portId should not empty")
    private @NotBlank(message="portId should not empty") String portId;
    @Schema(description="Whether to enable the laser for the PON port.Status should be a value as follows:DISABLE,ENABLE.")
    private ac status;
    @Schema(description="Whether to start downstream FEC function of the port.DownstreamFEC should be a value as follows:DISABLE,ENABLE.")
    private ac downstreamFEC;
    @Schema(description="Configure the downstream encryption ONT key update time. KeyExchangePeriod should be within the range of 0 to 60 minutes, where 0 means key update is disabled.", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="KeyExchangePeriod should not be null")
    @Range(min=0L, max=60L, message="keyExchangePeriod should be a number between {min}-{max}")
    private @NotNull(message="KeyExchangePeriod should not be null") @Range(min=0L, max=60L, message="keyExchangePeriod should be a number between {min}-{max}") Integer keyExchangePeriod;
    @Schema(description="Configure the DBA calculation cycle mode. DbaCalculateMode should be a value as follows: MIN_DELAY:In minimum delay mode, the DBA calculation cycle is related to the number of T-CONTs. The more T-CONTs there are, the longer the calculation cycle. Under the premise that the bandwidth can complete the calculation, it is advisable to use as few calculation cycles as possible. When dealing with TDM services, the minimum delay mode must be selected; MAX_BW:In maximum bandwidth utilization mode, the DBA calculation cycle is allocated over multiple frames, with each frame lasting 125 \u00b5s. This method is suitable when the service does not have high delay requirements.")
    private L dbaCalculateMode;
    @Schema(description="The maximum logical distance of the ONT.MaxDistance should be within the range of 1 to 60 (km). The difference between the maximum logical distance and the minimum logical distance must not exceed 40 km.", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="MaxDistance should not be null")
    @Range(min=1L, max=60L, message="maxDistance should be a number between {min}-{max}")
    private @NotNull(message="MaxDistance should not be null") @Range(min=1L, max=60L, message="maxDistance should be a number between {min}-{max}") Integer maxDistance;
    @Schema(description="The minimum logical distance of the ONT.MinDistance should be within the range of 1 to 40 (km). The difference between the maximum logical distance and the minimum logical distance must not exceed 40 km.", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="MinDistance should not be null")
    @Range(min=0L, max=40L, message="minDistance should be a number between {min}-{max}")
    private @NotNull(message="MinDistance should not be null") @Range(min=0L, max=40L, message="minDistance should be a number between {min}-{max}") Integer minDistance;
    @Schema(description="Whether to enable port rogue ONU automatic detection function.LongLaserOnuAutoDetect should be a value as follows:DISABLE,ENABLE.Default value:DISABLE")
    private ac longLaserOnuAutoDetect;
    @Schema(description="Set the interval time for port traffic ONU detection, unit: minutes.AutoDetectInternal should be within the range of 1 to 100.Default value:15", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="AutoDetectInterval should not be null")
    @Range(min=1L, max=100L, message="autoDetectInterval should be a number between {min}-{max}")
    private @NotNull(message="AutoDetectInterval should not be null") @Range(min=1L, max=100L, message="autoDetectInterval should be a number between {min}-{max}") Integer autoDetectInterval;
    @Schema(description="Whether to enable port rogue ONU automatic isolation function.LongLaserOnuAutoIsolate should be a value as follows:DISABLE,ENABLE.Default value:DISABLE")
    private ac longLaserOnuAutoIsolate;
    @Schema(description="Set port isolation function.(only DS-P7001-04\u3001DS-P7001-08 OLT support this function,other olts should not provide or display this field)When enabled, the port cannot communicate with other ports, and the ONU on this port cannot communicate with ONUs on other ports.PortIsolation should be a value as follows:DISABLE,ENABLE.", hidden=true)
    private ac portIsolate;
    @Schema(description="Set ONU isolation function.(only DS-P7001-04\u3001DS-P7001-08 OLT support this function,other olts should not provide or display this field)When enabled, different ONUs on the same port cannot communicate with each other.OnuIsolate should be a value as follows:DISABLE,ENABLE.", hidden=true)
    private ac onuIsolate;

    public OperationResponse<DeviceResponseBody<ReactivePonPortDTO>> check() {
        if (this.maxDistance != null && this.minDistance != null) {
            if (this.minDistance > this.maxDistance) {
                return new OperationResponse(b.d, "Max-distance should greater or equal than Min-distance.", null);
            }
            if (this.maxDistance - this.minDistance > 40) {
                return new OperationResponse(b.d, "The difference between the Max-distance and the Min-distance should be less than 40km.", null);
            }
        }
        return null;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof PonPortModifyDTO)) {
            return false;
        }
        PonPortModifyDTO other = (PonPortModifyDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$keyExchangePeriod = this.getKeyExchangePeriod();
        Integer other$keyExchangePeriod = other.getKeyExchangePeriod();
        if (this$keyExchangePeriod == null ? other$keyExchangePeriod != null : !((Object)this$keyExchangePeriod).equals(other$keyExchangePeriod)) {
            return false;
        }
        Integer this$maxDistance = this.getMaxDistance();
        Integer other$maxDistance = other.getMaxDistance();
        if (this$maxDistance == null ? other$maxDistance != null : !((Object)this$maxDistance).equals(other$maxDistance)) {
            return false;
        }
        Integer this$minDistance = this.getMinDistance();
        Integer other$minDistance = other.getMinDistance();
        if (this$minDistance == null ? other$minDistance != null : !((Object)this$minDistance).equals(other$minDistance)) {
            return false;
        }
        Integer this$autoDetectInterval = this.getAutoDetectInterval();
        Integer other$autoDetectInterval = other.getAutoDetectInterval();
        if (this$autoDetectInterval == null ? other$autoDetectInterval != null : !((Object)this$autoDetectInterval).equals(other$autoDetectInterval)) {
            return false;
        }
        String this$portId = this.getPortId();
        String other$portId = other.getPortId();
        if (this$portId == null ? other$portId != null : !this$portId.equals(other$portId)) {
            return false;
        }
        ac this$status = this.getStatus();
        ac other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        ac this$downstreamFEC = this.getDownstreamFEC();
        ac other$downstreamFEC = other.getDownstreamFEC();
        if (this$downstreamFEC == null ? other$downstreamFEC != null : !this$downstreamFEC.equals(other$downstreamFEC)) {
            return false;
        }
        L this$dbaCalculateMode = this.getDbaCalculateMode();
        L other$dbaCalculateMode = other.getDbaCalculateMode();
        if (this$dbaCalculateMode == null ? other$dbaCalculateMode != null : !this$dbaCalculateMode.equals(other$dbaCalculateMode)) {
            return false;
        }
        ac this$longLaserOnuAutoDetect = this.getLongLaserOnuAutoDetect();
        ac other$longLaserOnuAutoDetect = other.getLongLaserOnuAutoDetect();
        if (this$longLaserOnuAutoDetect == null ? other$longLaserOnuAutoDetect != null : !this$longLaserOnuAutoDetect.equals(other$longLaserOnuAutoDetect)) {
            return false;
        }
        ac this$longLaserOnuAutoIsolate = this.getLongLaserOnuAutoIsolate();
        ac other$longLaserOnuAutoIsolate = other.getLongLaserOnuAutoIsolate();
        if (this$longLaserOnuAutoIsolate == null ? other$longLaserOnuAutoIsolate != null : !this$longLaserOnuAutoIsolate.equals(other$longLaserOnuAutoIsolate)) {
            return false;
        }
        ac this$portIsolate = this.getPortIsolate();
        ac other$portIsolate = other.getPortIsolate();
        if (this$portIsolate == null ? other$portIsolate != null : !this$portIsolate.equals(other$portIsolate)) {
            return false;
        }
        ac this$onuIsolate = this.getOnuIsolate();
        ac other$onuIsolate = other.getOnuIsolate();
        return !(this$onuIsolate == null ? other$onuIsolate != null : !this$onuIsolate.equals(other$onuIsolate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PonPortModifyDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $keyExchangePeriod = this.getKeyExchangePeriod();
        result = result * 59 + ($keyExchangePeriod == null ? 43 : ((Object)$keyExchangePeriod).hashCode());
        Integer $maxDistance = this.getMaxDistance();
        result = result * 59 + ($maxDistance == null ? 43 : ((Object)$maxDistance).hashCode());
        Integer $minDistance = this.getMinDistance();
        result = result * 59 + ($minDistance == null ? 43 : ((Object)$minDistance).hashCode());
        Integer $autoDetectInterval = this.getAutoDetectInterval();
        result = result * 59 + ($autoDetectInterval == null ? 43 : ((Object)$autoDetectInterval).hashCode());
        String $portId = this.getPortId();
        result = result * 59 + ($portId == null ? 43 : $portId.hashCode());
        ac $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        ac $downstreamFEC = this.getDownstreamFEC();
        result = result * 59 + ($downstreamFEC == null ? 43 : $downstreamFEC.hashCode());
        L $dbaCalculateMode = this.getDbaCalculateMode();
        result = result * 59 + ($dbaCalculateMode == null ? 43 : $dbaCalculateMode.hashCode());
        ac $longLaserOnuAutoDetect = this.getLongLaserOnuAutoDetect();
        result = result * 59 + ($longLaserOnuAutoDetect == null ? 43 : $longLaserOnuAutoDetect.hashCode());
        ac $longLaserOnuAutoIsolate = this.getLongLaserOnuAutoIsolate();
        result = result * 59 + ($longLaserOnuAutoIsolate == null ? 43 : $longLaserOnuAutoIsolate.hashCode());
        ac $portIsolate = this.getPortIsolate();
        result = result * 59 + ($portIsolate == null ? 43 : $portIsolate.hashCode());
        ac $onuIsolate = this.getOnuIsolate();
        result = result * 59 + ($onuIsolate == null ? 43 : $onuIsolate.hashCode());
        return result;
    }

    @Generated
    public PonPortModifyDTO() {
    }

    @Generated
    public String getPortId() {
        return this.portId;
    }

    @Generated
    public ac getStatus() {
        return this.status;
    }

    @Generated
    public ac getDownstreamFEC() {
        return this.downstreamFEC;
    }

    @Generated
    public Integer getKeyExchangePeriod() {
        return this.keyExchangePeriod;
    }

    @Generated
    public L getDbaCalculateMode() {
        return this.dbaCalculateMode;
    }

    @Generated
    public Integer getMaxDistance() {
        return this.maxDistance;
    }

    @Generated
    public Integer getMinDistance() {
        return this.minDistance;
    }

    @Generated
    public ac getLongLaserOnuAutoDetect() {
        return this.longLaserOnuAutoDetect;
    }

    @Generated
    public Integer getAutoDetectInterval() {
        return this.autoDetectInterval;
    }

    @Generated
    public ac getLongLaserOnuAutoIsolate() {
        return this.longLaserOnuAutoIsolate;
    }

    @Generated
    public ac getPortIsolate() {
        return this.portIsolate;
    }

    @Generated
    public ac getOnuIsolate() {
        return this.onuIsolate;
    }

    @Generated
    public void setPortId(String portId) {
        this.portId = portId;
    }

    @Generated
    public void setStatus(ac status) {
        this.status = status;
    }

    @Generated
    public void setDownstreamFEC(ac downstreamFEC) {
        this.downstreamFEC = downstreamFEC;
    }

    @Generated
    public void setKeyExchangePeriod(Integer keyExchangePeriod) {
        this.keyExchangePeriod = keyExchangePeriod;
    }

    @Generated
    public void setDbaCalculateMode(L dbaCalculateMode) {
        this.dbaCalculateMode = dbaCalculateMode;
    }

    @Generated
    public void setMaxDistance(Integer maxDistance) {
        this.maxDistance = maxDistance;
    }

    @Generated
    public void setMinDistance(Integer minDistance) {
        this.minDistance = minDistance;
    }

    @Generated
    public void setLongLaserOnuAutoDetect(ac longLaserOnuAutoDetect) {
        this.longLaserOnuAutoDetect = longLaserOnuAutoDetect;
    }

    @Generated
    public void setAutoDetectInterval(Integer autoDetectInterval) {
        this.autoDetectInterval = autoDetectInterval;
    }

    @Generated
    public void setLongLaserOnuAutoIsolate(ac longLaserOnuAutoIsolate) {
        this.longLaserOnuAutoIsolate = longLaserOnuAutoIsolate;
    }

    @Generated
    public void setPortIsolate(ac portIsolate) {
        this.portIsolate = portIsolate;
    }

    @Generated
    public void setOnuIsolate(ac onuIsolate) {
        this.onuIsolate = onuIsolate;
    }

    @Generated
    public String toString() {
        return "PonPortModifyDTO(portId=" + this.getPortId() + ", status=" + this.getStatus() + ", downstreamFEC=" + this.getDownstreamFEC() + ", keyExchangePeriod=" + this.getKeyExchangePeriod() + ", dbaCalculateMode=" + this.getDbaCalculateMode() + ", maxDistance=" + this.getMaxDistance() + ", minDistance=" + this.getMinDistance() + ", longLaserOnuAutoDetect=" + this.getLongLaserOnuAutoDetect() + ", autoDetectInterval=" + this.getAutoDetectInterval() + ", longLaserOnuAutoIsolate=" + this.getLongLaserOnuAutoIsolate() + ", portIsolate=" + this.getPortIsolate() + ", onuIsolate=" + this.getOnuIsolate() + ")";
    }
}

