/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.pon.ponport;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.device.manage.message.body.olt.DeviceResponseBody;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import com.tplink.smb.omada.manager.device.olt.pon.ponport.ReactivePonPortDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.Range;

public class PonPortModifyAppDTO
extends DpmsBaseDeviceDTO {
    private static final long serialVersionUID = -2940104560558939924L;
    @NotBlank(message="portId should not empty")
    @Schema(name="portId", description="Port ID of OLT", requiredMode=Schema.RequiredMode.REQUIRED)
    private @NotBlank(message="portId should not empty") String portId;
    @Schema(name="status", description="Whether the pon optical laser is enabled.Status should be a value as follows: 0:DISABLE;1:ENABLE")
    private Integer status;
    @Schema(name="downstreamFEC", description="Whether the downstream FEC function is enabled on this port,downstreamFEC should be a value as follows: 0:DISABLE;1:ENABLE")
    private Integer downstreamFEC;
    @Range(min=0L, max=60L, message="keyExchangePeriod should be a number between {min}-{max}")
    @Schema(name="keyExchangePeriod", description="Downstream encryption ONT key update time. KeyExchangePeriod should be within the range of 0 to 60, 0 indicates disabling key updates (unit: min).")
    private @Range(min=0L, max=60L, message="keyExchangePeriod should be a number between {min}-{max}") Integer keyExchangePeriod;
    @Schema(name="dbaCalculateMode", description="DBA calculation cycle Mode,dbaCalculateMode should be a value as follows: 0:MIN_DELAY,Minimum delay: The DBA calculation cycle is related to the number of T-CONTs. The more T-CONTs there are, the longer the calculation cycle. Under the premise that the bandwidth can be calculated, use the fewest calculation cycles possible. When dealing with TDM services, the minimum delay mode must be selected.;1:MAX_BW.Maximum bandwidth utilization:This method is chosen when the latency requirements for the service are not high ")
    private Integer dbaCalculateMode;
    @Range(min=1L, max=60L, message="maxDistance should be a number between {min}-{max}")
    @Schema(name="maxDistance", description="Configure the maximum logical distance for the ONT. MaxDistance should be within the range of 1 to 60 (unit: km). Maximum logical distance - minimum logical distance <= 20 km.")
    private @Range(min=1L, max=60L, message="maxDistance should be a number between {min}-{max}") Integer maxDistance;
    @Range(min=0L, max=40L, message="minDistance should be a number between {min}-{max}")
    @Schema(name="minDistance", description="Configure the minimum logical distance for the ONT. MinDistance should be within the range of  0 to 40 (unit: km). Maximum logical distance - minimum logical distance <= 20 km.")
    private @Range(min=0L, max=40L, message="minDistance should be a number between {min}-{max}") Integer minDistance;
    @Schema(name="longLaserOnuAutoDetect", description="Set the port rogue ONU auto-detection function switch.LongLaserOnuAutoDetect should be a value as follow: 0:DISABLE;1:ENABLE.Default value:DISABLE")
    private Integer longLaserOnuAutoDetect;
    @Range(min=1L, max=100L, message="autoDetectInterval should be a number between {min}-{max}")
    @Schema(name="autoDetectInterval", description="Set the interval time for port traffic ONU detection, unit: minutes. AutoDetectInterval should be a value between 1 to 100, default value: 15.")
    private @Range(min=1L, max=100L, message="autoDetectInterval should be a number between {min}-{max}") Integer autoDetectInterval;
    @Schema(name="downLinkSpeed", description="Set the port rogue ONU auto-isolation function switch. LongLaserOnuAutoIsolate should be a value as follow: 0:DISABLE;1:ENABLE, default value: DISABLE.")
    private Integer longLaserOnuAutoIsolate;
    @Schema(name="portIsolate", description="Set port isolation function. When enabled, this port cannot communicate with other ports, and the ONU on this port cannot communicate with ONUs on other ports. PortIsolate should be a value as follow: 0:DISABLE;1:ENABLE.")
    private Integer portIsolate;
    @Schema(name="onuIsolate", description="Set ONU isolation function. When enabled, different ONUs on the same port cannot communicate with each other. OnuIsolate should be a value as follow: 0:DISABLE;1:ENABLE.")
    private Integer onuIsolate;

    public OperationResponse<DeviceResponseBody<ReactivePonPortDTO>> check() {
        if (this.maxDistance != null && this.minDistance != null) {
            if (this.minDistance > this.maxDistance) {
                return new OperationResponse(b.d, "Max-distance should greater or equal than Min-distance.", null);
            }
            if (this.maxDistance - this.minDistance > 40) {
                return new OperationResponse(b.d, "The difference between the Max-distance and the Min-distance should be less than 40km.", null);
            }
        }
        return null;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof PonPortModifyAppDTO)) {
            return false;
        }
        PonPortModifyAppDTO other = (PonPortModifyAppDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$downstreamFEC = this.getDownstreamFEC();
        Integer other$downstreamFEC = other.getDownstreamFEC();
        if (this$downstreamFEC == null ? other$downstreamFEC != null : !((Object)this$downstreamFEC).equals(other$downstreamFEC)) {
            return false;
        }
        Integer this$keyExchangePeriod = this.getKeyExchangePeriod();
        Integer other$keyExchangePeriod = other.getKeyExchangePeriod();
        if (this$keyExchangePeriod == null ? other$keyExchangePeriod != null : !((Object)this$keyExchangePeriod).equals(other$keyExchangePeriod)) {
            return false;
        }
        Integer this$dbaCalculateMode = this.getDbaCalculateMode();
        Integer other$dbaCalculateMode = other.getDbaCalculateMode();
        if (this$dbaCalculateMode == null ? other$dbaCalculateMode != null : !((Object)this$dbaCalculateMode).equals(other$dbaCalculateMode)) {
            return false;
        }
        Integer this$maxDistance = this.getMaxDistance();
        Integer other$maxDistance = other.getMaxDistance();
        if (this$maxDistance == null ? other$maxDistance != null : !((Object)this$maxDistance).equals(other$maxDistance)) {
            return false;
        }
        Integer this$minDistance = this.getMinDistance();
        Integer other$minDistance = other.getMinDistance();
        if (this$minDistance == null ? other$minDistance != null : !((Object)this$minDistance).equals(other$minDistance)) {
            return false;
        }
        Integer this$longLaserOnuAutoDetect = this.getLongLaserOnuAutoDetect();
        Integer other$longLaserOnuAutoDetect = other.getLongLaserOnuAutoDetect();
        if (this$longLaserOnuAutoDetect == null ? other$longLaserOnuAutoDetect != null : !((Object)this$longLaserOnuAutoDetect).equals(other$longLaserOnuAutoDetect)) {
            return false;
        }
        Integer this$autoDetectInterval = this.getAutoDetectInterval();
        Integer other$autoDetectInterval = other.getAutoDetectInterval();
        if (this$autoDetectInterval == null ? other$autoDetectInterval != null : !((Object)this$autoDetectInterval).equals(other$autoDetectInterval)) {
            return false;
        }
        Integer this$longLaserOnuAutoIsolate = this.getLongLaserOnuAutoIsolate();
        Integer other$longLaserOnuAutoIsolate = other.getLongLaserOnuAutoIsolate();
        if (this$longLaserOnuAutoIsolate == null ? other$longLaserOnuAutoIsolate != null : !((Object)this$longLaserOnuAutoIsolate).equals(other$longLaserOnuAutoIsolate)) {
            return false;
        }
        Integer this$portIsolate = this.getPortIsolate();
        Integer other$portIsolate = other.getPortIsolate();
        if (this$portIsolate == null ? other$portIsolate != null : !((Object)this$portIsolate).equals(other$portIsolate)) {
            return false;
        }
        Integer this$onuIsolate = this.getOnuIsolate();
        Integer other$onuIsolate = other.getOnuIsolate();
        if (this$onuIsolate == null ? other$onuIsolate != null : !((Object)this$onuIsolate).equals(other$onuIsolate)) {
            return false;
        }
        String this$portId = this.getPortId();
        String other$portId = other.getPortId();
        return !(this$portId == null ? other$portId != null : !this$portId.equals(other$portId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PonPortModifyAppDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $downstreamFEC = this.getDownstreamFEC();
        result = result * 59 + ($downstreamFEC == null ? 43 : ((Object)$downstreamFEC).hashCode());
        Integer $keyExchangePeriod = this.getKeyExchangePeriod();
        result = result * 59 + ($keyExchangePeriod == null ? 43 : ((Object)$keyExchangePeriod).hashCode());
        Integer $dbaCalculateMode = this.getDbaCalculateMode();
        result = result * 59 + ($dbaCalculateMode == null ? 43 : ((Object)$dbaCalculateMode).hashCode());
        Integer $maxDistance = this.getMaxDistance();
        result = result * 59 + ($maxDistance == null ? 43 : ((Object)$maxDistance).hashCode());
        Integer $minDistance = this.getMinDistance();
        result = result * 59 + ($minDistance == null ? 43 : ((Object)$minDistance).hashCode());
        Integer $longLaserOnuAutoDetect = this.getLongLaserOnuAutoDetect();
        result = result * 59 + ($longLaserOnuAutoDetect == null ? 43 : ((Object)$longLaserOnuAutoDetect).hashCode());
        Integer $autoDetectInterval = this.getAutoDetectInterval();
        result = result * 59 + ($autoDetectInterval == null ? 43 : ((Object)$autoDetectInterval).hashCode());
        Integer $longLaserOnuAutoIsolate = this.getLongLaserOnuAutoIsolate();
        result = result * 59 + ($longLaserOnuAutoIsolate == null ? 43 : ((Object)$longLaserOnuAutoIsolate).hashCode());
        Integer $portIsolate = this.getPortIsolate();
        result = result * 59 + ($portIsolate == null ? 43 : ((Object)$portIsolate).hashCode());
        Integer $onuIsolate = this.getOnuIsolate();
        result = result * 59 + ($onuIsolate == null ? 43 : ((Object)$onuIsolate).hashCode());
        String $portId = this.getPortId();
        result = result * 59 + ($portId == null ? 43 : $portId.hashCode());
        return result;
    }

    @Generated
    public PonPortModifyAppDTO() {
    }

    @Generated
    public String getPortId() {
        return this.portId;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public Integer getDownstreamFEC() {
        return this.downstreamFEC;
    }

    @Generated
    public Integer getKeyExchangePeriod() {
        return this.keyExchangePeriod;
    }

    @Generated
    public Integer getDbaCalculateMode() {
        return this.dbaCalculateMode;
    }

    @Generated
    public Integer getMaxDistance() {
        return this.maxDistance;
    }

    @Generated
    public Integer getMinDistance() {
        return this.minDistance;
    }

    @Generated
    public Integer getLongLaserOnuAutoDetect() {
        return this.longLaserOnuAutoDetect;
    }

    @Generated
    public Integer getAutoDetectInterval() {
        return this.autoDetectInterval;
    }

    @Generated
    public Integer getLongLaserOnuAutoIsolate() {
        return this.longLaserOnuAutoIsolate;
    }

    @Generated
    public Integer getPortIsolate() {
        return this.portIsolate;
    }

    @Generated
    public Integer getOnuIsolate() {
        return this.onuIsolate;
    }

    @Generated
    public void setPortId(String portId) {
        this.portId = portId;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setDownstreamFEC(Integer downstreamFEC) {
        this.downstreamFEC = downstreamFEC;
    }

    @Generated
    public void setKeyExchangePeriod(Integer keyExchangePeriod) {
        this.keyExchangePeriod = keyExchangePeriod;
    }

    @Generated
    public void setDbaCalculateMode(Integer dbaCalculateMode) {
        this.dbaCalculateMode = dbaCalculateMode;
    }

    @Generated
    public void setMaxDistance(Integer maxDistance) {
        this.maxDistance = maxDistance;
    }

    @Generated
    public void setMinDistance(Integer minDistance) {
        this.minDistance = minDistance;
    }

    @Generated
    public void setLongLaserOnuAutoDetect(Integer longLaserOnuAutoDetect) {
        this.longLaserOnuAutoDetect = longLaserOnuAutoDetect;
    }

    @Generated
    public void setAutoDetectInterval(Integer autoDetectInterval) {
        this.autoDetectInterval = autoDetectInterval;
    }

    @Generated
    public void setLongLaserOnuAutoIsolate(Integer longLaserOnuAutoIsolate) {
        this.longLaserOnuAutoIsolate = longLaserOnuAutoIsolate;
    }

    @Generated
    public void setPortIsolate(Integer portIsolate) {
        this.portIsolate = portIsolate;
    }

    @Generated
    public void setOnuIsolate(Integer onuIsolate) {
        this.onuIsolate = onuIsolate;
    }

    @Generated
    public String toString() {
        return "PonPortModifyAppDTO(portId=" + this.getPortId() + ", status=" + this.getStatus() + ", downstreamFEC=" + this.getDownstreamFEC() + ", keyExchangePeriod=" + this.getKeyExchangePeriod() + ", dbaCalculateMode=" + this.getDbaCalculateMode() + ", maxDistance=" + this.getMaxDistance() + ", minDistance=" + this.getMinDistance() + ", longLaserOnuAutoDetect=" + this.getLongLaserOnuAutoDetect() + ", autoDetectInterval=" + this.getAutoDetectInterval() + ", longLaserOnuAutoIsolate=" + this.getLongLaserOnuAutoIsolate() + ", portIsolate=" + this.getPortIsolate() + ", onuIsolate=" + this.getOnuIsolate() + ")";
    }
}

