/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.pon.onu.register;

import com.tplink.smb.omada.manager.c.b.bp;
import com.tplink.smb.omada.manager.c.b.br;
import com.tplink.smb.omada.manager.device.api.web.validation.olt.StringRegexp;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnuActivationConfigDTO
extends DpmsBaseDeviceDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OnuActivationConfigDTO.class);
    @Schema(description="Entry identifier list", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="ponPorts can not be empty")
    private @NotNull(message="ponPorts can not be empty") List<String> keys;
    @Schema(description="Onu ID should be within the range of 0 to 127")
    @Range(min=0L, max=127L, message="onuId should be a number between {min}-{max}")
    private @Range(min=0L, max=127L, message="onuId should be a number between {min}-{max}") Integer onuId;
    @Schema(description="Authentication mode used by the automatically discovered ONU.AuthenticationMethod should be a value as follows:PASSWORD_AUTH,SN_AUTH,LOID_AUTH,SN_AND_PASSWORD_AUTH,LOID_AND_PASSWORD_AUTH", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="authenticationMethod can not be null")
    private @NotNull(message="authenticationMethod can not be null") bp authenticationMethod;
    @Schema(name="lineProfile", description="Line profile id bound to the ONU", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="lineProfile can not be null")
    private @NotNull(message="lineProfile can not be null") String lineProfile;
    @Schema(name="serviceProfile", description="Service profile id bound to the ONU", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="serviceProfile can not be null")
    private @NotNull(message="serviceProfile can not be null") String serviceProfile;
    @Schema(name="mgmtProfile", description="Management profile bound to the ONU", hidden=true)
    private String mgmtProfile;
    @Schema(name="description", description="Display the configured port description.Only 1-32 bits numbers, Upper and lower letters, -@_:/. are allowed.")
    @StringRegexp(min=0, max=32, message="this description is illegal.")
    private String description;
    @Schema(description="ONU auto discovery mode.DiscoveryMode should be a value as follows:ALWAYS_ON,ONCE_ON ")
    private br discoveryMode;
    @Schema(description="Re-Register-Authentication")
    private String reRegisterAuthentication;
    @Schema(description="Service port profile id bound to the ONU")
    private String servicePortProfile;

    @Generated
    public OnuActivationConfigDTO() {
    }

    @Generated
    public List<String> getKeys() {
        return this.keys;
    }

    @Generated
    public Integer getOnuId() {
        return this.onuId;
    }

    @Generated
    public bp getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    @Generated
    public String getLineProfile() {
        return this.lineProfile;
    }

    @Generated
    public String getServiceProfile() {
        return this.serviceProfile;
    }

    @Generated
    public String getMgmtProfile() {
        return this.mgmtProfile;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public br getDiscoveryMode() {
        return this.discoveryMode;
    }

    @Generated
    public String getReRegisterAuthentication() {
        return this.reRegisterAuthentication;
    }

    @Generated
    public String getServicePortProfile() {
        return this.servicePortProfile;
    }

    @Generated
    public OnuActivationConfigDTO setKeys(List<String> keys) {
        this.keys = keys;
        return this;
    }

    @Generated
    public OnuActivationConfigDTO setOnuId(Integer onuId) {
        this.onuId = onuId;
        return this;
    }

    @Generated
    public OnuActivationConfigDTO setAuthenticationMethod(bp authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
        return this;
    }

    @Generated
    public OnuActivationConfigDTO setLineProfile(String lineProfile) {
        this.lineProfile = lineProfile;
        return this;
    }

    @Generated
    public OnuActivationConfigDTO setServiceProfile(String serviceProfile) {
        this.serviceProfile = serviceProfile;
        return this;
    }

    @Generated
    public OnuActivationConfigDTO setMgmtProfile(String mgmtProfile) {
        this.mgmtProfile = mgmtProfile;
        return this;
    }

    @Generated
    public OnuActivationConfigDTO setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public OnuActivationConfigDTO setDiscoveryMode(br discoveryMode) {
        this.discoveryMode = discoveryMode;
        return this;
    }

    @Generated
    public OnuActivationConfigDTO setReRegisterAuthentication(String reRegisterAuthentication) {
        this.reRegisterAuthentication = reRegisterAuthentication;
        return this;
    }

    @Generated
    public OnuActivationConfigDTO setServicePortProfile(String servicePortProfile) {
        this.servicePortProfile = servicePortProfile;
        return this;
    }

    @Generated
    public String toString() {
        return "OnuActivationConfigDTO(keys=" + this.getKeys() + ", onuId=" + this.getOnuId() + ", authenticationMethod=" + this.getAuthenticationMethod() + ", lineProfile=" + this.getLineProfile() + ", serviceProfile=" + this.getServiceProfile() + ", mgmtProfile=" + this.getMgmtProfile() + ", description=" + this.getDescription() + ", discoveryMode=" + this.getDiscoveryMode() + ", reRegisterAuthentication=" + this.getReRegisterAuthentication() + ", servicePortProfile=" + this.getServicePortProfile() + ")";
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof OnuActivationConfigDTO)) {
            return false;
        }
        OnuActivationConfigDTO other = (OnuActivationConfigDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$onuId = this.getOnuId();
        Integer other$onuId = other.getOnuId();
        if (this$onuId == null ? other$onuId != null : !((Object)this$onuId).equals(other$onuId)) {
            return false;
        }
        List<String> this$keys = this.getKeys();
        List<String> other$keys = other.getKeys();
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        bp this$authenticationMethod = this.getAuthenticationMethod();
        bp other$authenticationMethod = other.getAuthenticationMethod();
        if (this$authenticationMethod == null ? other$authenticationMethod != null : !this$authenticationMethod.equals(other$authenticationMethod)) {
            return false;
        }
        String this$lineProfile = this.getLineProfile();
        String other$lineProfile = other.getLineProfile();
        if (this$lineProfile == null ? other$lineProfile != null : !this$lineProfile.equals(other$lineProfile)) {
            return false;
        }
        String this$serviceProfile = this.getServiceProfile();
        String other$serviceProfile = other.getServiceProfile();
        if (this$serviceProfile == null ? other$serviceProfile != null : !this$serviceProfile.equals(other$serviceProfile)) {
            return false;
        }
        String this$mgmtProfile = this.getMgmtProfile();
        String other$mgmtProfile = other.getMgmtProfile();
        if (this$mgmtProfile == null ? other$mgmtProfile != null : !this$mgmtProfile.equals(other$mgmtProfile)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        br this$discoveryMode = this.getDiscoveryMode();
        br other$discoveryMode = other.getDiscoveryMode();
        if (this$discoveryMode == null ? other$discoveryMode != null : !this$discoveryMode.equals(other$discoveryMode)) {
            return false;
        }
        String this$reRegisterAuthentication = this.getReRegisterAuthentication();
        String other$reRegisterAuthentication = other.getReRegisterAuthentication();
        if (this$reRegisterAuthentication == null ? other$reRegisterAuthentication != null : !this$reRegisterAuthentication.equals(other$reRegisterAuthentication)) {
            return false;
        }
        String this$servicePortProfile = this.getServicePortProfile();
        String other$servicePortProfile = other.getServicePortProfile();
        return !(this$servicePortProfile == null ? other$servicePortProfile != null : !this$servicePortProfile.equals(other$servicePortProfile));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OnuActivationConfigDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $onuId = this.getOnuId();
        result = result * 59 + ($onuId == null ? 43 : ((Object)$onuId).hashCode());
        List<String> $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        bp $authenticationMethod = this.getAuthenticationMethod();
        result = result * 59 + ($authenticationMethod == null ? 43 : $authenticationMethod.hashCode());
        String $lineProfile = this.getLineProfile();
        result = result * 59 + ($lineProfile == null ? 43 : $lineProfile.hashCode());
        String $serviceProfile = this.getServiceProfile();
        result = result * 59 + ($serviceProfile == null ? 43 : $serviceProfile.hashCode());
        String $mgmtProfile = this.getMgmtProfile();
        result = result * 59 + ($mgmtProfile == null ? 43 : $mgmtProfile.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        br $discoveryMode = this.getDiscoveryMode();
        result = result * 59 + ($discoveryMode == null ? 43 : $discoveryMode.hashCode());
        String $reRegisterAuthentication = this.getReRegisterAuthentication();
        result = result * 59 + ($reRegisterAuthentication == null ? 43 : $reRegisterAuthentication.hashCode());
        String $servicePortProfile = this.getServicePortProfile();
        result = result * 59 + ($servicePortProfile == null ? 43 : $servicePortProfile.hashCode());
        return result;
    }
}

