/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.pon.onu.register;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.device.manage.message.body.olt.DeviceResponseBody;
import com.tplink.smb.omada.manager.c.b.bp;
import com.tplink.smb.omada.manager.c.b.br;
import com.tplink.smb.omada.manager.c.b.bw;
import com.tplink.smb.omada.manager.device.api.web.device.a.e;
import com.tplink.smb.omada.manager.device.api.web.validation.olt.StringRegexp;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.io.Serializable;
import lombok.Generated;

public class AuthenticationConfigInfoDTO
implements Serializable {
    @Schema(description="Authentication mode used by the automatically discovered ONU.AuthenticationMethod should be a value as follows:PASSWORD_AUTH,SN_AUTH,LOID_AUTH,SN_AND_PASSWORD_AUTH,LOID_AND_PASSWORD_AUTH", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="authenticationMethod can not be null")
    private @NotNull(message="authenticationMethod can not be null") bp authenticationMethod;
    @Schema(description="Indicates the password type reported by the automatic discovery of the ONT.PasswordType should be a value as follows\uff1aASCII,HEX")
    private bw passwordType;
    @Schema(description="Automatic discovery ONT Authentication Password.Password should contain 1 to 10 characters in ASCII (from \\x21 to \\x7e) or 1 to 20 characters in hexadecimal.")
    @Pattern(regexp="^[\\x21-\\x7e]{1,10}|[0-9a-fA-F ]{1,20}$", message="this password is illegal.")
    private @Pattern(regexp="^[\\x21-\\x7e]{1,10}|[0-9a-fA-F ]{1,20}$", message="this password is illegal.") String password;
    @Schema(description="ONU auto discovery mode.DiscoveryMode should be a value as follows:ALWAYS_ON,ONCE_ON ")
    private br discoveryMode;
    @Schema(name="serialNumber", description="SerialNumber of ONU, serialNumber should contain 12, 13, or 16 characters, in the format XXXXXXXXXXXX,XXXX-XXXXXXXX,XXXXXXXXXXXXXXXX.When the serialNumber contains 16 characters, the first 8 characters will be grouped into pairs of two, resulting in 4 hexadecimal characters, and each hexadecimal character must fall within the range of 0x21 to 0x7E.")
    private String serialNumber;
    @Schema(description="Loid set by automatic discovery of the ONT, loid should be 1-32 characters, including letters, numbers, and symbols (-@_:/.).")
    @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{1,32}$", message="this loid is illegal.")
    private @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{1,32}$", message="this loid is illegal.") String loid;
    @Schema(description="Loid password set by automatic discovery of the ONT,loidPassword should be ASCII characters from \\x21 to \\x7e")
    private String loidPassword;
    @Schema(description="Re-Register-Authentication")
    private String reRegisterAuthentication;
    @Schema(name="lineProfile", description="Line profile id bound to the ONU", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="lineProfile can not be null")
    private @NotNull(message="lineProfile can not be null") String lineProfile;
    @Schema(name="serviceProfile", description="Service profile id bound to the ONU", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="serviceProfile can not be null")
    private @NotNull(message="serviceProfile can not be null") String serviceProfile;
    @Schema(description="Service port profile id bound to the ONU")
    private String servicePortProfile;
    @Schema(name="mgmtProfile", description="Bound management template is displayed as: Mgmt_Profile_Name + Mgmt_Profile_ID. Set the ID and name of the management template for automatic authentication of the ONT. The value range includes existing management templates in the system. This template is optional and can be left unbound. If no template is bound, do not include this field.", hidden=true)
    private String mgmtProfile;
    @Schema(name="description", description="Display the configured port description.Only 1-32 bits numbers, Upper and lower letters, -@_:/. are allowed.")
    @StringRegexp(min=0, max=32, message="this description is illegal.")
    private String description;
    @Schema(description="Online status should be a value as follows:DISABLE,ENABLE")
    private String onlineStatus;
    @Schema(description="Admin status of ONU.AdminStatus should be a value as follows:ACTIVE,DEACTIVE")
    private String adminStatus;
    @Schema(description="Whether OLT has successfully delivered configurations to ONU.ConfigStatus should be a value as follows:FAILED,SUCCESS")
    private String configStatus;

    public OperationResponse<DeviceResponseBody<Void>> check() {
        if (T.a((Object)this.loidPassword) && !e.a((String)"^[\\x21-\\x7e]{1,12}$", (String)this.loidPassword)) {
            return new OperationResponse(b.d, "invalid format in loidPassword.", null);
        }
        return null;
    }

    @Generated
    public AuthenticationConfigInfoDTO() {
    }

    @Generated
    public bp getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    @Generated
    public bw getPasswordType() {
        return this.passwordType;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public br getDiscoveryMode() {
        return this.discoveryMode;
    }

    @Generated
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Generated
    public String getLoid() {
        return this.loid;
    }

    @Generated
    public String getLoidPassword() {
        return this.loidPassword;
    }

    @Generated
    public String getReRegisterAuthentication() {
        return this.reRegisterAuthentication;
    }

    @Generated
    public String getLineProfile() {
        return this.lineProfile;
    }

    @Generated
    public String getServiceProfile() {
        return this.serviceProfile;
    }

    @Generated
    public String getServicePortProfile() {
        return this.servicePortProfile;
    }

    @Generated
    public String getMgmtProfile() {
        return this.mgmtProfile;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getOnlineStatus() {
        return this.onlineStatus;
    }

    @Generated
    public String getAdminStatus() {
        return this.adminStatus;
    }

    @Generated
    public String getConfigStatus() {
        return this.configStatus;
    }

    @Generated
    public void setAuthenticationMethod(bp authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    @Generated
    public void setPasswordType(bw passwordType) {
        this.passwordType = passwordType;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setDiscoveryMode(br discoveryMode) {
        this.discoveryMode = discoveryMode;
    }

    @Generated
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @Generated
    public void setLoid(String loid) {
        this.loid = loid;
    }

    @Generated
    public void setLoidPassword(String loidPassword) {
        this.loidPassword = loidPassword;
    }

    @Generated
    public void setReRegisterAuthentication(String reRegisterAuthentication) {
        this.reRegisterAuthentication = reRegisterAuthentication;
    }

    @Generated
    public void setLineProfile(String lineProfile) {
        this.lineProfile = lineProfile;
    }

    @Generated
    public void setServiceProfile(String serviceProfile) {
        this.serviceProfile = serviceProfile;
    }

    @Generated
    public void setServicePortProfile(String servicePortProfile) {
        this.servicePortProfile = servicePortProfile;
    }

    @Generated
    public void setMgmtProfile(String mgmtProfile) {
        this.mgmtProfile = mgmtProfile;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setOnlineStatus(String onlineStatus) {
        this.onlineStatus = onlineStatus;
    }

    @Generated
    public void setAdminStatus(String adminStatus) {
        this.adminStatus = adminStatus;
    }

    @Generated
    public void setConfigStatus(String configStatus) {
        this.configStatus = configStatus;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof AuthenticationConfigInfoDTO)) {
            return false;
        }
        AuthenticationConfigInfoDTO other = (AuthenticationConfigInfoDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        bp this$authenticationMethod = this.getAuthenticationMethod();
        bp other$authenticationMethod = other.getAuthenticationMethod();
        if (this$authenticationMethod == null ? other$authenticationMethod != null : !this$authenticationMethod.equals(other$authenticationMethod)) {
            return false;
        }
        bw this$passwordType = this.getPasswordType();
        bw other$passwordType = other.getPasswordType();
        if (this$passwordType == null ? other$passwordType != null : !this$passwordType.equals(other$passwordType)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        br this$discoveryMode = this.getDiscoveryMode();
        br other$discoveryMode = other.getDiscoveryMode();
        if (this$discoveryMode == null ? other$discoveryMode != null : !this$discoveryMode.equals(other$discoveryMode)) {
            return false;
        }
        String this$serialNumber = this.getSerialNumber();
        String other$serialNumber = other.getSerialNumber();
        if (this$serialNumber == null ? other$serialNumber != null : !this$serialNumber.equals(other$serialNumber)) {
            return false;
        }
        String this$loid = this.getLoid();
        String other$loid = other.getLoid();
        if (this$loid == null ? other$loid != null : !this$loid.equals(other$loid)) {
            return false;
        }
        String this$loidPassword = this.getLoidPassword();
        String other$loidPassword = other.getLoidPassword();
        if (this$loidPassword == null ? other$loidPassword != null : !this$loidPassword.equals(other$loidPassword)) {
            return false;
        }
        String this$reRegisterAuthentication = this.getReRegisterAuthentication();
        String other$reRegisterAuthentication = other.getReRegisterAuthentication();
        if (this$reRegisterAuthentication == null ? other$reRegisterAuthentication != null : !this$reRegisterAuthentication.equals(other$reRegisterAuthentication)) {
            return false;
        }
        String this$lineProfile = this.getLineProfile();
        String other$lineProfile = other.getLineProfile();
        if (this$lineProfile == null ? other$lineProfile != null : !this$lineProfile.equals(other$lineProfile)) {
            return false;
        }
        String this$serviceProfile = this.getServiceProfile();
        String other$serviceProfile = other.getServiceProfile();
        if (this$serviceProfile == null ? other$serviceProfile != null : !this$serviceProfile.equals(other$serviceProfile)) {
            return false;
        }
        String this$servicePortProfile = this.getServicePortProfile();
        String other$servicePortProfile = other.getServicePortProfile();
        if (this$servicePortProfile == null ? other$servicePortProfile != null : !this$servicePortProfile.equals(other$servicePortProfile)) {
            return false;
        }
        String this$mgmtProfile = this.getMgmtProfile();
        String other$mgmtProfile = other.getMgmtProfile();
        if (this$mgmtProfile == null ? other$mgmtProfile != null : !this$mgmtProfile.equals(other$mgmtProfile)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$onlineStatus = this.getOnlineStatus();
        String other$onlineStatus = other.getOnlineStatus();
        if (this$onlineStatus == null ? other$onlineStatus != null : !this$onlineStatus.equals(other$onlineStatus)) {
            return false;
        }
        String this$adminStatus = this.getAdminStatus();
        String other$adminStatus = other.getAdminStatus();
        if (this$adminStatus == null ? other$adminStatus != null : !this$adminStatus.equals(other$adminStatus)) {
            return false;
        }
        String this$configStatus = this.getConfigStatus();
        String other$configStatus = other.getConfigStatus();
        return !(this$configStatus == null ? other$configStatus != null : !this$configStatus.equals(other$configStatus));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthenticationConfigInfoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        bp $authenticationMethod = this.getAuthenticationMethod();
        result = result * 59 + ($authenticationMethod == null ? 43 : $authenticationMethod.hashCode());
        bw $passwordType = this.getPasswordType();
        result = result * 59 + ($passwordType == null ? 43 : $passwordType.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        br $discoveryMode = this.getDiscoveryMode();
        result = result * 59 + ($discoveryMode == null ? 43 : $discoveryMode.hashCode());
        String $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : $serialNumber.hashCode());
        String $loid = this.getLoid();
        result = result * 59 + ($loid == null ? 43 : $loid.hashCode());
        String $loidPassword = this.getLoidPassword();
        result = result * 59 + ($loidPassword == null ? 43 : $loidPassword.hashCode());
        String $reRegisterAuthentication = this.getReRegisterAuthentication();
        result = result * 59 + ($reRegisterAuthentication == null ? 43 : $reRegisterAuthentication.hashCode());
        String $lineProfile = this.getLineProfile();
        result = result * 59 + ($lineProfile == null ? 43 : $lineProfile.hashCode());
        String $serviceProfile = this.getServiceProfile();
        result = result * 59 + ($serviceProfile == null ? 43 : $serviceProfile.hashCode());
        String $servicePortProfile = this.getServicePortProfile();
        result = result * 59 + ($servicePortProfile == null ? 43 : $servicePortProfile.hashCode());
        String $mgmtProfile = this.getMgmtProfile();
        result = result * 59 + ($mgmtProfile == null ? 43 : $mgmtProfile.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $onlineStatus = this.getOnlineStatus();
        result = result * 59 + ($onlineStatus == null ? 43 : $onlineStatus.hashCode());
        String $adminStatus = this.getAdminStatus();
        result = result * 59 + ($adminStatus == null ? 43 : $adminStatus.hashCode());
        String $configStatus = this.getConfigStatus();
        result = result * 59 + ($configStatus == null ? 43 : $configStatus.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthenticationConfigInfoDTO(authenticationMethod=" + this.getAuthenticationMethod() + ", passwordType=" + this.getPasswordType() + ", password=" + this.getPassword() + ", discoveryMode=" + this.getDiscoveryMode() + ", serialNumber=" + this.getSerialNumber() + ", loid=" + this.getLoid() + ", loidPassword=" + this.getLoidPassword() + ", reRegisterAuthentication=" + this.getReRegisterAuthentication() + ", lineProfile=" + this.getLineProfile() + ", serviceProfile=" + this.getServiceProfile() + ", servicePortProfile=" + this.getServicePortProfile() + ", mgmtProfile=" + this.getMgmtProfile() + ", description=" + this.getDescription() + ", onlineStatus=" + this.getOnlineStatus() + ", adminStatus=" + this.getAdminStatus() + ", configStatus=" + this.getConfigStatus() + ")";
    }
}

