/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.pon.onu.management.information;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.c.b.aU;
import com.tplink.smb.omada.manager.c.b.bu;
import com.tplink.smb.omada.manager.c.b.cq;
import com.tplink.smb.omada.manager.c.b.j;
import com.tplink.smb.omada.manager.c.b.k;
import com.tplink.smb.omada.manager.device.api.web.validation.olt.StringRegexp;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import java.io.Serializable;
import lombok.Generated;

public class BasicDetailConfigDTO
implements Serializable {
    @Schema(name="onuDescription", description="ONU description.onuDescription should contain 0 to 32 characters, including uppercase and lowercase letters, numbers, and the symbols -@_:/. ")
    private String onuDescription;
    @Schema(name="serialNumber", description="SerialNumber of ONU should contain 12, 13, or 16 characters, in the format XXXXXXXXXXXX ,XXXX-XXXXXXXX,XXXXXXXXXXXXXXXX")
    private String serialNumber;
    @Schema(description="Mac address of ONU")
    @a
    private String macAddress;
    @Schema(description="The matching ONT vendor ID,vendorId should contain 1 to 4 characters in ASCII, with character range from \\x21 to \\x7e.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Null(message="vendorId must be null")
    private @Null(message="vendorId must be null") String vendorId;
    @Schema(name="equipmentId", description="ONT device ID should contain 1 to 20 characters in ASCII code from \\x21 to \\x7e.", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="equipId should not be null")
    @StringRegexp(min=1, max=20, regexp="[\\x21-\\x7e]", message="this equipId is illegal.")
    private @NotNull(message="equipId should not be null") String equipmentId;
    @Schema(description="Admin status should be a value as follows:ACTIVATE,DEACTIVATE")
    private j adminStatus;
    @Schema(description="Online status should be a value as follows:ONLINE,OFFLINE,UPGRADING")
    private bu onlineStatus;
    @Schema(description="Config status should be a value as follows:SUCCESS: Configuration successfully delivered and recognized by the ONU.FAILED: Configuration not successfully delivered or not recognized by the ONU.")
    private cq configStatus;
    @Schema(description="Match status should be a value as follows:MATCH: ONU hardware capabilities are consistent with the bound service template.MISMATCH: ONU hardware capabilities are inconsistent with the bound service template.")
    private aU matchStatus;
    @Schema(description="Active status should be a value as follows:ACTIVE: ONU is in an active state, capable of data communication and carrying services.\nINACTIVE: ONU is in an inactive state, possibly due to unactivated configuration, being offline, configuration failure, or mismatched configuration.")
    private k activeStatus;
    @Schema(name="onuDistance", description="Distance between ONU and OLT should be within the range of  0 to 20,000 m")
    private Integer onuDistance;
    @Schema(name="onlineTime", description="Duration of ONU registration and online status, format: hh:mm:ss.")
    private String onlineTime;
    @Schema(name="hardwareVersion", description="Hardware version of the ONU, hardwareVersion should contain 1 to 20 characters, including uppercase and lowercase letters, numbers, and the symbols -@_:/. ")
    private String hardwareVersion;
    @Schema(name="lineProfile", description="LineProfile is displayed in the format id(name)")
    private String lineProfile;
    @Schema(name="serviceProfile", description="ServiceProfile is displayed in the format id(name)")
    private String serviceProfile;
    @Schema(name="mgmtProfile", description="Bound management template is displayed as: Mgmt_Profile_Name + Mgmt_Profile_ID. Set the ID and name of the management template for automatic authentication of the ONT. The value range includes existing management templates in the system. This template is optional and can be left unbound. If no template is bound, do not include this field.", hidden=true)
    private String mgmtProfile;

    @Generated
    public BasicDetailConfigDTO() {
    }

    @Generated
    public String getOnuDescription() {
        return this.onuDescription;
    }

    @Generated
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Generated
    public String getMacAddress() {
        return this.macAddress;
    }

    @Generated
    public String getVendorId() {
        return this.vendorId;
    }

    @Generated
    public String getEquipmentId() {
        return this.equipmentId;
    }

    @Generated
    public j getAdminStatus() {
        return this.adminStatus;
    }

    @Generated
    public bu getOnlineStatus() {
        return this.onlineStatus;
    }

    @Generated
    public cq getConfigStatus() {
        return this.configStatus;
    }

    @Generated
    public aU getMatchStatus() {
        return this.matchStatus;
    }

    @Generated
    public k getActiveStatus() {
        return this.activeStatus;
    }

    @Generated
    public Integer getOnuDistance() {
        return this.onuDistance;
    }

    @Generated
    public String getOnlineTime() {
        return this.onlineTime;
    }

    @Generated
    public String getHardwareVersion() {
        return this.hardwareVersion;
    }

    @Generated
    public String getLineProfile() {
        return this.lineProfile;
    }

    @Generated
    public String getServiceProfile() {
        return this.serviceProfile;
    }

    @Generated
    public String getMgmtProfile() {
        return this.mgmtProfile;
    }

    @Generated
    public void setOnuDescription(String onuDescription) {
        this.onuDescription = onuDescription;
    }

    @Generated
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @Generated
    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    @Generated
    public void setVendorId(String vendorId) {
        this.vendorId = vendorId;
    }

    @Generated
    public void setEquipmentId(String equipmentId) {
        this.equipmentId = equipmentId;
    }

    @Generated
    public void setAdminStatus(j adminStatus) {
        this.adminStatus = adminStatus;
    }

    @Generated
    public void setOnlineStatus(bu onlineStatus) {
        this.onlineStatus = onlineStatus;
    }

    @Generated
    public void setConfigStatus(cq configStatus) {
        this.configStatus = configStatus;
    }

    @Generated
    public void setMatchStatus(aU matchStatus) {
        this.matchStatus = matchStatus;
    }

    @Generated
    public void setActiveStatus(k activeStatus) {
        this.activeStatus = activeStatus;
    }

    @Generated
    public void setOnuDistance(Integer onuDistance) {
        this.onuDistance = onuDistance;
    }

    @Generated
    public void setOnlineTime(String onlineTime) {
        this.onlineTime = onlineTime;
    }

    @Generated
    public void setHardwareVersion(String hardwareVersion) {
        this.hardwareVersion = hardwareVersion;
    }

    @Generated
    public void setLineProfile(String lineProfile) {
        this.lineProfile = lineProfile;
    }

    @Generated
    public void setServiceProfile(String serviceProfile) {
        this.serviceProfile = serviceProfile;
    }

    @Generated
    public void setMgmtProfile(String mgmtProfile) {
        this.mgmtProfile = mgmtProfile;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof BasicDetailConfigDTO)) {
            return false;
        }
        BasicDetailConfigDTO other = (BasicDetailConfigDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$onuDistance = this.getOnuDistance();
        Integer other$onuDistance = other.getOnuDistance();
        if (this$onuDistance == null ? other$onuDistance != null : !((Object)this$onuDistance).equals(other$onuDistance)) {
            return false;
        }
        String this$onuDescription = this.getOnuDescription();
        String other$onuDescription = other.getOnuDescription();
        if (this$onuDescription == null ? other$onuDescription != null : !this$onuDescription.equals(other$onuDescription)) {
            return false;
        }
        String this$serialNumber = this.getSerialNumber();
        String other$serialNumber = other.getSerialNumber();
        if (this$serialNumber == null ? other$serialNumber != null : !this$serialNumber.equals(other$serialNumber)) {
            return false;
        }
        String this$macAddress = this.getMacAddress();
        String other$macAddress = other.getMacAddress();
        if (this$macAddress == null ? other$macAddress != null : !this$macAddress.equals(other$macAddress)) {
            return false;
        }
        String this$vendorId = this.getVendorId();
        String other$vendorId = other.getVendorId();
        if (this$vendorId == null ? other$vendorId != null : !this$vendorId.equals(other$vendorId)) {
            return false;
        }
        String this$equipmentId = this.getEquipmentId();
        String other$equipmentId = other.getEquipmentId();
        if (this$equipmentId == null ? other$equipmentId != null : !this$equipmentId.equals(other$equipmentId)) {
            return false;
        }
        j this$adminStatus = this.getAdminStatus();
        j other$adminStatus = other.getAdminStatus();
        if (this$adminStatus == null ? other$adminStatus != null : !this$adminStatus.equals(other$adminStatus)) {
            return false;
        }
        bu this$onlineStatus = this.getOnlineStatus();
        bu other$onlineStatus = other.getOnlineStatus();
        if (this$onlineStatus == null ? other$onlineStatus != null : !this$onlineStatus.equals(other$onlineStatus)) {
            return false;
        }
        cq this$configStatus = this.getConfigStatus();
        cq other$configStatus = other.getConfigStatus();
        if (this$configStatus == null ? other$configStatus != null : !this$configStatus.equals(other$configStatus)) {
            return false;
        }
        aU this$matchStatus = this.getMatchStatus();
        aU other$matchStatus = other.getMatchStatus();
        if (this$matchStatus == null ? other$matchStatus != null : !this$matchStatus.equals(other$matchStatus)) {
            return false;
        }
        k this$activeStatus = this.getActiveStatus();
        k other$activeStatus = other.getActiveStatus();
        if (this$activeStatus == null ? other$activeStatus != null : !this$activeStatus.equals(other$activeStatus)) {
            return false;
        }
        String this$onlineTime = this.getOnlineTime();
        String other$onlineTime = other.getOnlineTime();
        if (this$onlineTime == null ? other$onlineTime != null : !this$onlineTime.equals(other$onlineTime)) {
            return false;
        }
        String this$hardwareVersion = this.getHardwareVersion();
        String other$hardwareVersion = other.getHardwareVersion();
        if (this$hardwareVersion == null ? other$hardwareVersion != null : !this$hardwareVersion.equals(other$hardwareVersion)) {
            return false;
        }
        String this$lineProfile = this.getLineProfile();
        String other$lineProfile = other.getLineProfile();
        if (this$lineProfile == null ? other$lineProfile != null : !this$lineProfile.equals(other$lineProfile)) {
            return false;
        }
        String this$serviceProfile = this.getServiceProfile();
        String other$serviceProfile = other.getServiceProfile();
        if (this$serviceProfile == null ? other$serviceProfile != null : !this$serviceProfile.equals(other$serviceProfile)) {
            return false;
        }
        String this$mgmtProfile = this.getMgmtProfile();
        String other$mgmtProfile = other.getMgmtProfile();
        return !(this$mgmtProfile == null ? other$mgmtProfile != null : !this$mgmtProfile.equals(other$mgmtProfile));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BasicDetailConfigDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $onuDistance = this.getOnuDistance();
        result = result * 59 + ($onuDistance == null ? 43 : ((Object)$onuDistance).hashCode());
        String $onuDescription = this.getOnuDescription();
        result = result * 59 + ($onuDescription == null ? 43 : $onuDescription.hashCode());
        String $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : $serialNumber.hashCode());
        String $macAddress = this.getMacAddress();
        result = result * 59 + ($macAddress == null ? 43 : $macAddress.hashCode());
        String $vendorId = this.getVendorId();
        result = result * 59 + ($vendorId == null ? 43 : $vendorId.hashCode());
        String $equipmentId = this.getEquipmentId();
        result = result * 59 + ($equipmentId == null ? 43 : $equipmentId.hashCode());
        j $adminStatus = this.getAdminStatus();
        result = result * 59 + ($adminStatus == null ? 43 : $adminStatus.hashCode());
        bu $onlineStatus = this.getOnlineStatus();
        result = result * 59 + ($onlineStatus == null ? 43 : $onlineStatus.hashCode());
        cq $configStatus = this.getConfigStatus();
        result = result * 59 + ($configStatus == null ? 43 : $configStatus.hashCode());
        aU $matchStatus = this.getMatchStatus();
        result = result * 59 + ($matchStatus == null ? 43 : $matchStatus.hashCode());
        k $activeStatus = this.getActiveStatus();
        result = result * 59 + ($activeStatus == null ? 43 : $activeStatus.hashCode());
        String $onlineTime = this.getOnlineTime();
        result = result * 59 + ($onlineTime == null ? 43 : $onlineTime.hashCode());
        String $hardwareVersion = this.getHardwareVersion();
        result = result * 59 + ($hardwareVersion == null ? 43 : $hardwareVersion.hashCode());
        String $lineProfile = this.getLineProfile();
        result = result * 59 + ($lineProfile == null ? 43 : $lineProfile.hashCode());
        String $serviceProfile = this.getServiceProfile();
        result = result * 59 + ($serviceProfile == null ? 43 : $serviceProfile.hashCode());
        String $mgmtProfile = this.getMgmtProfile();
        result = result * 59 + ($mgmtProfile == null ? 43 : $mgmtProfile.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BasicDetailConfigDTO(onuDescription=" + this.getOnuDescription() + ", serialNumber=" + this.getSerialNumber() + ", macAddress=" + this.getMacAddress() + ", vendorId=" + this.getVendorId() + ", equipmentId=" + this.getEquipmentId() + ", adminStatus=" + this.getAdminStatus() + ", onlineStatus=" + this.getOnlineStatus() + ", configStatus=" + this.getConfigStatus() + ", matchStatus=" + this.getMatchStatus() + ", activeStatus=" + this.getActiveStatus() + ", onuDistance=" + this.getOnuDistance() + ", onlineTime=" + this.getOnlineTime() + ", hardwareVersion=" + this.getHardwareVersion() + ", lineProfile=" + this.getLineProfile() + ", serviceProfile=" + this.getServiceProfile() + ", mgmtProfile=" + this.getMgmtProfile() + ")";
    }
}

