/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.pon.onu.management.information;

import com.tplink.smb.omada.manager.device.api.web.validation.olt.StringRegexp;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import java.io.Serializable;
import lombok.Generated;

public class BasicDetailConfigAppDTO
implements Serializable {
    @Schema(name="onuDescription", description="ONU description.onuDescription should contain 0 to 32 characters, including uppercase and lowercase letters, numbers, and the symbols -@_:/. ")
    private String onuDescription;
    @Schema(name="serialNumber", description="SerialNumber of ONU, serialNumber should contain 12, 13, or 16 characters, in the format XXXXXXXXXXXX,XXXX-XXXXXXXX,XXXXXXXXXXXXXXXX")
    private String serialNumber;
    @Schema(name="vendorId", description="The matching ONT vendor ID,vendorId should contain 1 to 4 characters in ASCII, with character range from \\x21 to \\x7e.")
    @Null(message="vendorId must be null")
    private @Null(message="vendorId must be null") String vendorId;
    @NotNull(message="equipId should not be null")
    @StringRegexp(min=1, max=20, regexp="[\\x21-\\x7e]", message="this equipId is illegal.")
    @Schema(name="equipmentId", description="ONT device ID, equipmentId should contain 1 to 20 characters in ASCII code from \\x21 to \\x7e.")
    private @NotNull(message="equipId should not be null") String equipmentId;
    @Schema(name="adminStatus", description="Admin status should be a value as follows:1:ACTIVATE;0:DEACTIVATE.")
    private Integer adminStatus;
    @Schema(name="onlineStatus", description="Online status should be a value as follows:1:ONLINE;0:OFFLINE")
    private Integer onlineStatus;
    @Schema(name="configStatus", description="Config status. ConfigStatus should be a value as follows: 1:SUCCESS,Configuration successfully delivered and recognized by the ONU; 2:FAILED,Configuration not successfully delivered or not recognized by the ONU.")
    private Integer configStatus;
    @Schema(name="matchStatus", description="Match status, matchStatus should be a value as follows: 1:MATCH, ONU hardware capability matches the bound service template, 0:MISMATCH, ONU hardware capability does not match the bound service template.")
    private Integer matchStatus;
    @Schema(name="activeStatus", description="Active status.ActiveStatus should be a value as follows: 1:ACTIVE, The ONU is in an active state, capable of data communication and carrying services;0:INACTIVE, The ONU is in an inactive state, possibly due to configuration not being activated, being offline, configuration failure, or configuration mismatch.")
    private Integer activeStatus;
    @Schema(name="onuDistance", description="Distance between ONU and OLT, onuDistance should be within the range of 0 to 20,000 m")
    private Integer onuDistance;
    @Schema(name="onlineTime", description="Duration of ONU registration and online status, format: hh:mm:ss.")
    private String onlineTime;
    @Schema(name="hardwareVersion", description="Hardware version of the ONU, hardwareVersion should contain 1 to 20 characters, including uppercase and lowercase letters, numbers, and the symbols -@_:/. ")
    private String hardwareVersion;
    @Schema(name="lineProfile", description="LineProfile is displayed in the format id(name).")
    private String lineProfile;
    @Schema(name="serviceProfile", description="ServiceProfile is displayed in the format id(name).")
    private String serviceProfile;
    @Schema(name="mgmtProfile", description="Bound management template is displayed as Mgmt_Profile_Name + Mgmt_Profile_ID. Set the ID and name of the management template for automatic authentication of the ONT. The value range includes existing management templates in the system. This template is optional and can be left unbound. If no template is bound, do not include this field.", hidden=true)
    private String mgmtProfile;

    @Generated
    public BasicDetailConfigAppDTO() {
    }

    @Generated
    public String getOnuDescription() {
        return this.onuDescription;
    }

    @Generated
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Generated
    public String getVendorId() {
        return this.vendorId;
    }

    @Generated
    public String getEquipmentId() {
        return this.equipmentId;
    }

    @Generated
    public Integer getAdminStatus() {
        return this.adminStatus;
    }

    @Generated
    public Integer getOnlineStatus() {
        return this.onlineStatus;
    }

    @Generated
    public Integer getConfigStatus() {
        return this.configStatus;
    }

    @Generated
    public Integer getMatchStatus() {
        return this.matchStatus;
    }

    @Generated
    public Integer getActiveStatus() {
        return this.activeStatus;
    }

    @Generated
    public Integer getOnuDistance() {
        return this.onuDistance;
    }

    @Generated
    public String getOnlineTime() {
        return this.onlineTime;
    }

    @Generated
    public String getHardwareVersion() {
        return this.hardwareVersion;
    }

    @Generated
    public String getLineProfile() {
        return this.lineProfile;
    }

    @Generated
    public String getServiceProfile() {
        return this.serviceProfile;
    }

    @Generated
    public String getMgmtProfile() {
        return this.mgmtProfile;
    }

    @Generated
    public void setOnuDescription(String onuDescription) {
        this.onuDescription = onuDescription;
    }

    @Generated
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @Generated
    public void setVendorId(String vendorId) {
        this.vendorId = vendorId;
    }

    @Generated
    public void setEquipmentId(String equipmentId) {
        this.equipmentId = equipmentId;
    }

    @Generated
    public void setAdminStatus(Integer adminStatus) {
        this.adminStatus = adminStatus;
    }

    @Generated
    public void setOnlineStatus(Integer onlineStatus) {
        this.onlineStatus = onlineStatus;
    }

    @Generated
    public void setConfigStatus(Integer configStatus) {
        this.configStatus = configStatus;
    }

    @Generated
    public void setMatchStatus(Integer matchStatus) {
        this.matchStatus = matchStatus;
    }

    @Generated
    public void setActiveStatus(Integer activeStatus) {
        this.activeStatus = activeStatus;
    }

    @Generated
    public void setOnuDistance(Integer onuDistance) {
        this.onuDistance = onuDistance;
    }

    @Generated
    public void setOnlineTime(String onlineTime) {
        this.onlineTime = onlineTime;
    }

    @Generated
    public void setHardwareVersion(String hardwareVersion) {
        this.hardwareVersion = hardwareVersion;
    }

    @Generated
    public void setLineProfile(String lineProfile) {
        this.lineProfile = lineProfile;
    }

    @Generated
    public void setServiceProfile(String serviceProfile) {
        this.serviceProfile = serviceProfile;
    }

    @Generated
    public void setMgmtProfile(String mgmtProfile) {
        this.mgmtProfile = mgmtProfile;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof BasicDetailConfigAppDTO)) {
            return false;
        }
        BasicDetailConfigAppDTO other = (BasicDetailConfigAppDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$adminStatus = this.getAdminStatus();
        Integer other$adminStatus = other.getAdminStatus();
        if (this$adminStatus == null ? other$adminStatus != null : !((Object)this$adminStatus).equals(other$adminStatus)) {
            return false;
        }
        Integer this$onlineStatus = this.getOnlineStatus();
        Integer other$onlineStatus = other.getOnlineStatus();
        if (this$onlineStatus == null ? other$onlineStatus != null : !((Object)this$onlineStatus).equals(other$onlineStatus)) {
            return false;
        }
        Integer this$configStatus = this.getConfigStatus();
        Integer other$configStatus = other.getConfigStatus();
        if (this$configStatus == null ? other$configStatus != null : !((Object)this$configStatus).equals(other$configStatus)) {
            return false;
        }
        Integer this$matchStatus = this.getMatchStatus();
        Integer other$matchStatus = other.getMatchStatus();
        if (this$matchStatus == null ? other$matchStatus != null : !((Object)this$matchStatus).equals(other$matchStatus)) {
            return false;
        }
        Integer this$activeStatus = this.getActiveStatus();
        Integer other$activeStatus = other.getActiveStatus();
        if (this$activeStatus == null ? other$activeStatus != null : !((Object)this$activeStatus).equals(other$activeStatus)) {
            return false;
        }
        Integer this$onuDistance = this.getOnuDistance();
        Integer other$onuDistance = other.getOnuDistance();
        if (this$onuDistance == null ? other$onuDistance != null : !((Object)this$onuDistance).equals(other$onuDistance)) {
            return false;
        }
        String this$onuDescription = this.getOnuDescription();
        String other$onuDescription = other.getOnuDescription();
        if (this$onuDescription == null ? other$onuDescription != null : !this$onuDescription.equals(other$onuDescription)) {
            return false;
        }
        String this$serialNumber = this.getSerialNumber();
        String other$serialNumber = other.getSerialNumber();
        if (this$serialNumber == null ? other$serialNumber != null : !this$serialNumber.equals(other$serialNumber)) {
            return false;
        }
        String this$vendorId = this.getVendorId();
        String other$vendorId = other.getVendorId();
        if (this$vendorId == null ? other$vendorId != null : !this$vendorId.equals(other$vendorId)) {
            return false;
        }
        String this$equipmentId = this.getEquipmentId();
        String other$equipmentId = other.getEquipmentId();
        if (this$equipmentId == null ? other$equipmentId != null : !this$equipmentId.equals(other$equipmentId)) {
            return false;
        }
        String this$onlineTime = this.getOnlineTime();
        String other$onlineTime = other.getOnlineTime();
        if (this$onlineTime == null ? other$onlineTime != null : !this$onlineTime.equals(other$onlineTime)) {
            return false;
        }
        String this$hardwareVersion = this.getHardwareVersion();
        String other$hardwareVersion = other.getHardwareVersion();
        if (this$hardwareVersion == null ? other$hardwareVersion != null : !this$hardwareVersion.equals(other$hardwareVersion)) {
            return false;
        }
        String this$lineProfile = this.getLineProfile();
        String other$lineProfile = other.getLineProfile();
        if (this$lineProfile == null ? other$lineProfile != null : !this$lineProfile.equals(other$lineProfile)) {
            return false;
        }
        String this$serviceProfile = this.getServiceProfile();
        String other$serviceProfile = other.getServiceProfile();
        if (this$serviceProfile == null ? other$serviceProfile != null : !this$serviceProfile.equals(other$serviceProfile)) {
            return false;
        }
        String this$mgmtProfile = this.getMgmtProfile();
        String other$mgmtProfile = other.getMgmtProfile();
        return !(this$mgmtProfile == null ? other$mgmtProfile != null : !this$mgmtProfile.equals(other$mgmtProfile));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BasicDetailConfigAppDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $adminStatus = this.getAdminStatus();
        result = result * 59 + ($adminStatus == null ? 43 : ((Object)$adminStatus).hashCode());
        Integer $onlineStatus = this.getOnlineStatus();
        result = result * 59 + ($onlineStatus == null ? 43 : ((Object)$onlineStatus).hashCode());
        Integer $configStatus = this.getConfigStatus();
        result = result * 59 + ($configStatus == null ? 43 : ((Object)$configStatus).hashCode());
        Integer $matchStatus = this.getMatchStatus();
        result = result * 59 + ($matchStatus == null ? 43 : ((Object)$matchStatus).hashCode());
        Integer $activeStatus = this.getActiveStatus();
        result = result * 59 + ($activeStatus == null ? 43 : ((Object)$activeStatus).hashCode());
        Integer $onuDistance = this.getOnuDistance();
        result = result * 59 + ($onuDistance == null ? 43 : ((Object)$onuDistance).hashCode());
        String $onuDescription = this.getOnuDescription();
        result = result * 59 + ($onuDescription == null ? 43 : $onuDescription.hashCode());
        String $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : $serialNumber.hashCode());
        String $vendorId = this.getVendorId();
        result = result * 59 + ($vendorId == null ? 43 : $vendorId.hashCode());
        String $equipmentId = this.getEquipmentId();
        result = result * 59 + ($equipmentId == null ? 43 : $equipmentId.hashCode());
        String $onlineTime = this.getOnlineTime();
        result = result * 59 + ($onlineTime == null ? 43 : $onlineTime.hashCode());
        String $hardwareVersion = this.getHardwareVersion();
        result = result * 59 + ($hardwareVersion == null ? 43 : $hardwareVersion.hashCode());
        String $lineProfile = this.getLineProfile();
        result = result * 59 + ($lineProfile == null ? 43 : $lineProfile.hashCode());
        String $serviceProfile = this.getServiceProfile();
        result = result * 59 + ($serviceProfile == null ? 43 : $serviceProfile.hashCode());
        String $mgmtProfile = this.getMgmtProfile();
        result = result * 59 + ($mgmtProfile == null ? 43 : $mgmtProfile.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BasicDetailConfigAppDTO(onuDescription=" + this.getOnuDescription() + ", serialNumber=" + this.getSerialNumber() + ", vendorId=" + this.getVendorId() + ", equipmentId=" + this.getEquipmentId() + ", adminStatus=" + this.getAdminStatus() + ", onlineStatus=" + this.getOnlineStatus() + ", configStatus=" + this.getConfigStatus() + ", matchStatus=" + this.getMatchStatus() + ", activeStatus=" + this.getActiveStatus() + ", onuDistance=" + this.getOnuDistance() + ", onlineTime=" + this.getOnlineTime() + ", hardwareVersion=" + this.getHardwareVersion() + ", lineProfile=" + this.getLineProfile() + ", serviceProfile=" + this.getServiceProfile() + ", mgmtProfile=" + this.getMgmtProfile() + ")";
    }
}

