/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.multicast.mld;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import jakarta.validation.constraints.Pattern;
import java.util.Locale;
import lombok.Generated;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.Range;

public class MldStaticGroupConfigDeleteDTO
extends DpmsBaseDeviceDTO {
    @Range(min=1L, max=4095L, message="VLAN id should be in {min}-{max}")
    private @Range(min=1L, max=4095L, message="VLAN id should be in {min}-{max}") Integer vlanId;
    @Pattern(regexp="^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$", message="mulicast IP is invalid")
    @NotBlank(message="multicastIp should not be blank")
    private @Pattern(regexp="^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$", message="mulicast IP is invalid") @NotBlank(message="multicastIp should not be blank") String multicastIp;

    public <T> OperationResponse<T> check() {
        if (!this.checkMulticastIp()) {
            return new OperationResponse(b.d, "The multicastIp is invalid", null);
        }
        return null;
    }

    private boolean checkMulticastIp() {
        String temp = this.multicastIp.trim().toLowerCase(Locale.ROOT);
        return temp.startsWith("ff");
    }

    @Generated
    public MldStaticGroupConfigDeleteDTO() {
    }

    @Generated
    public Integer getVlanId() {
        return this.vlanId;
    }

    @Generated
    public String getMulticastIp() {
        return this.multicastIp;
    }

    @Generated
    public MldStaticGroupConfigDeleteDTO setVlanId(Integer vlanId) {
        this.vlanId = vlanId;
        return this;
    }

    @Generated
    public MldStaticGroupConfigDeleteDTO setMulticastIp(String multicastIp) {
        this.multicastIp = multicastIp;
        return this;
    }

    @Generated
    public String toString() {
        return "MldStaticGroupConfigDeleteDTO(vlanId=" + this.getVlanId() + ", multicastIp=" + this.getMulticastIp() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MldStaticGroupConfigDeleteDTO)) {
            return false;
        }
        MldStaticGroupConfigDeleteDTO other = (MldStaticGroupConfigDeleteDTO)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$vlanId = this.getVlanId();
        Integer other$vlanId = other.getVlanId();
        if (this$vlanId == null ? other$vlanId != null : !((Object)this$vlanId).equals(other$vlanId)) {
            return false;
        }
        String this$multicastIp = this.getMulticastIp();
        String other$multicastIp = other.getMulticastIp();
        return !(this$multicastIp == null ? other$multicastIp != null : !this$multicastIp.equals(other$multicastIp));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MldStaticGroupConfigDeleteDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $vlanId = this.getVlanId();
        result = result * 59 + ($vlanId == null ? 43 : ((Object)$vlanId).hashCode());
        String $multicastIp = this.getMulticastIp();
        result = result * 59 + ($multicastIp == null ? 43 : $multicastIp.hashCode());
        return result;
    }
}

