/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.l3feature.dhcpservice.dhcpserver;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.J;
import com.tplink.smb.omada.device.manage.message.body.olt.DeviceResponseBody;
import com.tplink.smb.omada.manager.device.api.web.device.a.e;
import com.tplink.smb.omada.manager.device.api.web.validation.olt.StringRegexp;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.apache.poi.util.StringUtil;
import org.hibernate.validator.constraints.Range;

public class PoolConfigDTO
extends DpmsBaseDeviceDTO {
    @StringRegexp(min=1, max=8, message="poolName invalid format.")
    @NotNull(message="poolName should not be null")
    private @NotNull(message="poolName should not be null") String poolName;
    @Pattern(regexp="^\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b$", message="invalid format in networkAddress")
    @NotNull(message="networkAddress should not be null")
    private @Pattern(regexp="^\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b$", message="invalid format in networkAddress") @NotNull(message="networkAddress should not be null") String networkAddress;
    @Pattern(regexp="^(254|252|248|240|224|192|128|0).0.0.0|255.(254|252|248|240|224|192|128|0).0.0|255.255.(254|252|248|240|224|192|128|0).0|255.255.255.(254|252|248|240|224|192|128|0)$", message="invalid format in subnetMask")
    @NotNull(message="subnetMask should not be null")
    private @Pattern(regexp="^(254|252|248|240|224|192|128|0).0.0.0|255.(254|252|248|240|224|192|128|0).0.0|255.255.(254|252|248|240|224|192|128|0).0|255.255.255.(254|252|248|240|224|192|128|0)$", message="invalid format in subnetMask") @NotNull(message="subnetMask should not be null") String subnetMask;
    @Range(min=1L, max=2880L, message="leaseTime should be a number between {min}-{max}")
    private @Range(min=1L, max=2880L, message="leaseTime should be a number between {min}-{max}") Integer leaseTime;
    private List<String> defaultGatewayList;
    private List<String> dnsServerList;
    private List<String> netBIOSServerList;
    private String netBIOSNodeType;
    private String nextServerAddress;
    @StringRegexp(min=0, max=200, message="domainName invalid format.")
    private String domainName;
    @StringRegexp(min=0, max=128, message="bootfile invalid format.")
    private String bootfile;

    public OperationResponse<DeviceResponseBody<Void>> check() {
        if (J.c(this.defaultGatewayList)) {
            for (String defaultGateway : this.defaultGatewayList) {
                if (!StringUtil.isNotBlank((CharSequence)defaultGateway) || e.a((String)"^\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b$", (String)defaultGateway)) continue;
                return new OperationResponse(b.d, "invalid format in defaultGateway.", null);
            }
        }
        if (J.c(this.dnsServerList)) {
            for (String dnsServer : this.dnsServerList) {
                if (!StringUtil.isNotBlank((CharSequence)dnsServer) || e.a((String)"^\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b$", (String)dnsServer)) continue;
                return new OperationResponse(b.d, "invalid format in dnsServer.", null);
            }
        }
        if (J.c(this.netBIOSServerList)) {
            for (String netBIOSServer : this.netBIOSServerList) {
                if (!StringUtil.isNotBlank((CharSequence)netBIOSServer) || e.a((String)"^\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b$", (String)netBIOSServer)) continue;
                return new OperationResponse(b.d, "invalid format in netBIOSServer.", null);
            }
        }
        if (StringUtil.isNotBlank((CharSequence)this.nextServerAddress) && !e.a((String)"^\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b$", (String)this.nextServerAddress)) {
            return new OperationResponse(b.d, "invalid format in nextServerAddress.", null);
        }
        return null;
    }

    @Generated
    public PoolConfigDTO() {
    }

    @Generated
    public String getPoolName() {
        return this.poolName;
    }

    @Generated
    public String getNetworkAddress() {
        return this.networkAddress;
    }

    @Generated
    public String getSubnetMask() {
        return this.subnetMask;
    }

    @Generated
    public Integer getLeaseTime() {
        return this.leaseTime;
    }

    @Generated
    public List<String> getDefaultGatewayList() {
        return this.defaultGatewayList;
    }

    @Generated
    public List<String> getDnsServerList() {
        return this.dnsServerList;
    }

    @Generated
    public List<String> getNetBIOSServerList() {
        return this.netBIOSServerList;
    }

    @Generated
    public String getNetBIOSNodeType() {
        return this.netBIOSNodeType;
    }

    @Generated
    public String getNextServerAddress() {
        return this.nextServerAddress;
    }

    @Generated
    public String getDomainName() {
        return this.domainName;
    }

    @Generated
    public String getBootfile() {
        return this.bootfile;
    }

    @Generated
    public PoolConfigDTO setPoolName(String poolName) {
        this.poolName = poolName;
        return this;
    }

    @Generated
    public PoolConfigDTO setNetworkAddress(String networkAddress) {
        this.networkAddress = networkAddress;
        return this;
    }

    @Generated
    public PoolConfigDTO setSubnetMask(String subnetMask) {
        this.subnetMask = subnetMask;
        return this;
    }

    @Generated
    public PoolConfigDTO setLeaseTime(Integer leaseTime) {
        this.leaseTime = leaseTime;
        return this;
    }

    @Generated
    public PoolConfigDTO setDefaultGatewayList(List<String> defaultGatewayList) {
        this.defaultGatewayList = defaultGatewayList;
        return this;
    }

    @Generated
    public PoolConfigDTO setDnsServerList(List<String> dnsServerList) {
        this.dnsServerList = dnsServerList;
        return this;
    }

    @Generated
    public PoolConfigDTO setNetBIOSServerList(List<String> netBIOSServerList) {
        this.netBIOSServerList = netBIOSServerList;
        return this;
    }

    @Generated
    public PoolConfigDTO setNetBIOSNodeType(String netBIOSNodeType) {
        this.netBIOSNodeType = netBIOSNodeType;
        return this;
    }

    @Generated
    public PoolConfigDTO setNextServerAddress(String nextServerAddress) {
        this.nextServerAddress = nextServerAddress;
        return this;
    }

    @Generated
    public PoolConfigDTO setDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    @Generated
    public PoolConfigDTO setBootfile(String bootfile) {
        this.bootfile = bootfile;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PoolConfigDTO)) {
            return false;
        }
        PoolConfigDTO other = (PoolConfigDTO)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$leaseTime = this.getLeaseTime();
        Integer other$leaseTime = other.getLeaseTime();
        if (this$leaseTime == null ? other$leaseTime != null : !((Object)this$leaseTime).equals(other$leaseTime)) {
            return false;
        }
        String this$poolName = this.getPoolName();
        String other$poolName = other.getPoolName();
        if (this$poolName == null ? other$poolName != null : !this$poolName.equals(other$poolName)) {
            return false;
        }
        String this$networkAddress = this.getNetworkAddress();
        String other$networkAddress = other.getNetworkAddress();
        if (this$networkAddress == null ? other$networkAddress != null : !this$networkAddress.equals(other$networkAddress)) {
            return false;
        }
        String this$subnetMask = this.getSubnetMask();
        String other$subnetMask = other.getSubnetMask();
        if (this$subnetMask == null ? other$subnetMask != null : !this$subnetMask.equals(other$subnetMask)) {
            return false;
        }
        List<String> this$defaultGatewayList = this.getDefaultGatewayList();
        List<String> other$defaultGatewayList = other.getDefaultGatewayList();
        if (this$defaultGatewayList == null ? other$defaultGatewayList != null : !((Object)this$defaultGatewayList).equals(other$defaultGatewayList)) {
            return false;
        }
        List<String> this$dnsServerList = this.getDnsServerList();
        List<String> other$dnsServerList = other.getDnsServerList();
        if (this$dnsServerList == null ? other$dnsServerList != null : !((Object)this$dnsServerList).equals(other$dnsServerList)) {
            return false;
        }
        List<String> this$netBIOSServerList = this.getNetBIOSServerList();
        List<String> other$netBIOSServerList = other.getNetBIOSServerList();
        if (this$netBIOSServerList == null ? other$netBIOSServerList != null : !((Object)this$netBIOSServerList).equals(other$netBIOSServerList)) {
            return false;
        }
        String this$netBIOSNodeType = this.getNetBIOSNodeType();
        String other$netBIOSNodeType = other.getNetBIOSNodeType();
        if (this$netBIOSNodeType == null ? other$netBIOSNodeType != null : !this$netBIOSNodeType.equals(other$netBIOSNodeType)) {
            return false;
        }
        String this$nextServerAddress = this.getNextServerAddress();
        String other$nextServerAddress = other.getNextServerAddress();
        if (this$nextServerAddress == null ? other$nextServerAddress != null : !this$nextServerAddress.equals(other$nextServerAddress)) {
            return false;
        }
        String this$domainName = this.getDomainName();
        String other$domainName = other.getDomainName();
        if (this$domainName == null ? other$domainName != null : !this$domainName.equals(other$domainName)) {
            return false;
        }
        String this$bootfile = this.getBootfile();
        String other$bootfile = other.getBootfile();
        return !(this$bootfile == null ? other$bootfile != null : !this$bootfile.equals(other$bootfile));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PoolConfigDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $leaseTime = this.getLeaseTime();
        result = result * 59 + ($leaseTime == null ? 43 : ((Object)$leaseTime).hashCode());
        String $poolName = this.getPoolName();
        result = result * 59 + ($poolName == null ? 43 : $poolName.hashCode());
        String $networkAddress = this.getNetworkAddress();
        result = result * 59 + ($networkAddress == null ? 43 : $networkAddress.hashCode());
        String $subnetMask = this.getSubnetMask();
        result = result * 59 + ($subnetMask == null ? 43 : $subnetMask.hashCode());
        List<String> $defaultGatewayList = this.getDefaultGatewayList();
        result = result * 59 + ($defaultGatewayList == null ? 43 : ((Object)$defaultGatewayList).hashCode());
        List<String> $dnsServerList = this.getDnsServerList();
        result = result * 59 + ($dnsServerList == null ? 43 : ((Object)$dnsServerList).hashCode());
        List<String> $netBIOSServerList = this.getNetBIOSServerList();
        result = result * 59 + ($netBIOSServerList == null ? 43 : ((Object)$netBIOSServerList).hashCode());
        String $netBIOSNodeType = this.getNetBIOSNodeType();
        result = result * 59 + ($netBIOSNodeType == null ? 43 : $netBIOSNodeType.hashCode());
        String $nextServerAddress = this.getNextServerAddress();
        result = result * 59 + ($nextServerAddress == null ? 43 : $nextServerAddress.hashCode());
        String $domainName = this.getDomainName();
        result = result * 59 + ($domainName == null ? 43 : $domainName.hashCode());
        String $bootfile = this.getBootfile();
        result = result * 59 + ($bootfile == null ? 43 : $bootfile.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PoolConfigDTO(super=" + super.toString() + ", poolName=" + this.getPoolName() + ", networkAddress=" + this.getNetworkAddress() + ", subnetMask=" + this.getSubnetMask() + ", leaseTime=" + this.getLeaseTime() + ", defaultGatewayList=" + this.getDefaultGatewayList() + ", dnsServerList=" + this.getDnsServerList() + ", netBIOSServerList=" + this.getNetBIOSServerList() + ", netBIOSNodeType=" + this.getNetBIOSNodeType() + ", nextServerAddress=" + this.getNextServerAddress() + ", domainName=" + this.getDomainName() + ", bootfile=" + this.getBootfile() + ")";
    }
}

