/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.l2feature.stp;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.J;
import com.tplink.smb.omada.device.manage.message.body.olt.DeviceResponseBody;
import com.tplink.smb.omada.manager.c.b.aP;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class MSTPInstanceConfigEditDTO
extends DpmsBaseDeviceDTO {
    @NotNull(message="instanceId should not be null")
    @Range(min=1L, max=8L, message="instanceId should be a number between {min}-{max}")
    private @NotNull(message="instanceId should not be null") @Range(min=1L, max=8L, message="instanceId should be a number between {min}-{max}") Integer instanceId;
    @Range(min=0L, max=61440L, message="priority should be a number between {min}-{max}")
    private @Range(min=0L, max=61440L, message="priority should be a number between {min}-{max}") Integer priority;
    @NotNull(message="vlanId should not be null")
    private @NotNull(message="vlanId should not be null") String vlanId;
    @NotNull(message="vlanIdMode should not be null")
    private @NotNull(message="vlanIdMode should not be null") aP vlanIdMode;

    public OperationResponse<DeviceResponseBody<Void>> check() {
        if (J.c((Object)this.priority) && this.priority % 4096 != 0) {
            return new OperationResponse(b.d, "Invalid priority. Enter an integral multiple of 4096, ranging from 0-61440.", null);
        }
        String vlanIdStr = this.vlanId.replaceAll(",", "-");
        String[] vlanIds = vlanIdStr.split("-");
        if (vlanIds.length > 0) {
            for (String vlan : vlanIds) {
                int vlanIdNum;
                try {
                    vlanIdNum = Integer.parseInt(vlan);
                }
                catch (Exception e2) {
                    return new OperationResponse(b.d, "Invalid vlanId. This value should be a number between 1-4096.", null);
                }
                if (vlanIdNum <= 4096 && vlanIdNum >= 1) continue;
                return new OperationResponse(b.d, "Invalid vlanId. This value should be between 1-4096.", null);
            }
        } else {
            return new OperationResponse(b.d, "VlanId is invalid format.", null);
        }
        return null;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof MSTPInstanceConfigEditDTO)) {
            return false;
        }
        MSTPInstanceConfigEditDTO other = (MSTPInstanceConfigEditDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$instanceId = this.getInstanceId();
        Integer other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !((Object)this$instanceId).equals(other$instanceId)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        String this$vlanId = this.getVlanId();
        String other$vlanId = other.getVlanId();
        if (this$vlanId == null ? other$vlanId != null : !this$vlanId.equals(other$vlanId)) {
            return false;
        }
        aP this$vlanIdMode = this.getVlanIdMode();
        aP other$vlanIdMode = other.getVlanIdMode();
        return !(this$vlanIdMode == null ? other$vlanIdMode != null : !this$vlanIdMode.equals(other$vlanIdMode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MSTPInstanceConfigEditDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : ((Object)$instanceId).hashCode());
        Integer $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        String $vlanId = this.getVlanId();
        result = result * 59 + ($vlanId == null ? 43 : $vlanId.hashCode());
        aP $vlanIdMode = this.getVlanIdMode();
        result = result * 59 + ($vlanIdMode == null ? 43 : $vlanIdMode.hashCode());
        return result;
    }

    @Generated
    public MSTPInstanceConfigEditDTO() {
    }

    @Generated
    public Integer getInstanceId() {
        return this.instanceId;
    }

    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    @Generated
    public String getVlanId() {
        return this.vlanId;
    }

    @Generated
    public aP getVlanIdMode() {
        return this.vlanIdMode;
    }

    @Generated
    public void setInstanceId(Integer instanceId) {
        this.instanceId = instanceId;
    }

    @Generated
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @Generated
    public void setVlanId(String vlanId) {
        this.vlanId = vlanId;
    }

    @Generated
    public void setVlanIdMode(aP vlanIdMode) {
        this.vlanIdMode = vlanIdMode;
    }

    @Generated
    public String toString() {
        return "MSTPInstanceConfigEditDTO(super=" + super.toString() + ", instanceId=" + this.getInstanceId() + ", priority=" + this.getPriority() + ", vlanId=" + this.getVlanId() + ", vlanIdMode=" + this.getVlanIdMode() + ")";
    }
}

