/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.l2feature.ethport;

import com.tplink.smb.omada.manager.device.api.web.validation.olt.NumberSet;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;

public class EthUnit1PortAppDTO
extends DpmsBaseDeviceDTO {
    @NotNull(message="port should not be null")
    @Schema(name="port", description="OLT physical port", requiredMode=Schema.RequiredMode.REQUIRED)
    private @NotNull(message="port should not be null") String port;
    @Null(message="type should be null")
    @Schema(name="mediaType", description="Port media type", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private @Null(message="type should be null") Integer mediaType;
    @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{0,32}$", message="only 1-32 bits numbers, Upper and lower letters, -@_:/. are allowed.")
    @Schema(name="description", description="Display the configured port description.Description should contain 1-32 bits numbers, Upper and lower letters, -@_:/. .")
    private @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{0,32}$", message="only 1-32 bits numbers, Upper and lower letters, -@_:/. are allowed.") String description;
    @Schema(name="status", description="Port switch status.Status should be a value as follows:0:DISABLE;1:ENABLE")
    @NumberSet(value={0, 1}, message="status is supposed to be 0\u30011")
    private Integer status;
    @NumberSet(value={0, 10, 100, 1000, 2500, 10000}, message="speed is supposed to be 0/10/100/1000/2500/10000")
    @Schema(name="speed", description="Port speed negotiation mode.Speed should be a value as follows:0;10;100;1000;2500;10000.0 represents Auto, and all other values are in Mbps.")
    private Integer speed;
    @Schema(name="duplex", description="Port duplex negotiation mode.Duplex should be a value as follows: 2:FULL,0:AUTO")
    @NumberSet(value={0, 2}, message="duplex is supposed to be 0\u30012")
    private Integer duplex;
    @Schema(name="flowControl", description="Port flow control function switch.FlowControl should be a value as follows: 0:DISABLE;1:ENABLE")
    @NumberSet(value={0, 1}, message="flowControl is supposed to be 0\u30011")
    private Integer flowControl;
    @Schema(name="lag", description="The LAG to which the port belongs.")
    @Null(message="lag should be null")
    private @Null(message="lag should be null") String lag;
    @Null(message="speedLink should be null")
    @Schema(name="speedLink", description="Port speed negotiation mode: 0 represents Auto, and all other values are in Mbps.")
    private @Null(message="speedLink should be null") Integer speedLink;
    @Null(message="duplexLink should be null")
    @Schema(name="duplexLink", description="Actual port duplex mode.DuplexLink should be a value as follows: 0:DISABLE;1:ENABLE")
    private @Null(message="duplexLink should be null") Integer duplexLink;
    @Null(message="linkStatus should be null")
    @Schema(name="linkStatus", description="Connection status of the PON port. LinkStatus should be a value as follows:0:LINK_DOWN;1:LINK_UP")
    private @Null(message="linkStatus should be null") Integer linkStatus;
    @Null(message="type should be null")
    @Schema(name="type", description="Port type.Type should be null.Type is a value as follows:0:COPPER;1:COMBO;2:SFP;3:SFP+;4:RJ45")
    private @Null(message="type should be null") Integer type;
    @Null(message="speedMax should be null")
    @Schema(name="speedMax", description="The maximum rate that this port can achieve, in Mbps.SpeedMax should be null")
    private @Null(message="speedMax should be null") Integer speedMax;

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof EthUnit1PortAppDTO)) {
            return false;
        }
        EthUnit1PortAppDTO other = (EthUnit1PortAppDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$mediaType = this.getMediaType();
        Integer other$mediaType = other.getMediaType();
        if (this$mediaType == null ? other$mediaType != null : !((Object)this$mediaType).equals(other$mediaType)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$speed = this.getSpeed();
        Integer other$speed = other.getSpeed();
        if (this$speed == null ? other$speed != null : !((Object)this$speed).equals(other$speed)) {
            return false;
        }
        Integer this$duplex = this.getDuplex();
        Integer other$duplex = other.getDuplex();
        if (this$duplex == null ? other$duplex != null : !((Object)this$duplex).equals(other$duplex)) {
            return false;
        }
        Integer this$flowControl = this.getFlowControl();
        Integer other$flowControl = other.getFlowControl();
        if (this$flowControl == null ? other$flowControl != null : !((Object)this$flowControl).equals(other$flowControl)) {
            return false;
        }
        Integer this$speedLink = this.getSpeedLink();
        Integer other$speedLink = other.getSpeedLink();
        if (this$speedLink == null ? other$speedLink != null : !((Object)this$speedLink).equals(other$speedLink)) {
            return false;
        }
        Integer this$duplexLink = this.getDuplexLink();
        Integer other$duplexLink = other.getDuplexLink();
        if (this$duplexLink == null ? other$duplexLink != null : !((Object)this$duplexLink).equals(other$duplexLink)) {
            return false;
        }
        Integer this$linkStatus = this.getLinkStatus();
        Integer other$linkStatus = other.getLinkStatus();
        if (this$linkStatus == null ? other$linkStatus != null : !((Object)this$linkStatus).equals(other$linkStatus)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$speedMax = this.getSpeedMax();
        Integer other$speedMax = other.getSpeedMax();
        if (this$speedMax == null ? other$speedMax != null : !((Object)this$speedMax).equals(other$speedMax)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$lag = this.getLag();
        String other$lag = other.getLag();
        return !(this$lag == null ? other$lag != null : !this$lag.equals(other$lag));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EthUnit1PortAppDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $mediaType = this.getMediaType();
        result = result * 59 + ($mediaType == null ? 43 : ((Object)$mediaType).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $speed = this.getSpeed();
        result = result * 59 + ($speed == null ? 43 : ((Object)$speed).hashCode());
        Integer $duplex = this.getDuplex();
        result = result * 59 + ($duplex == null ? 43 : ((Object)$duplex).hashCode());
        Integer $flowControl = this.getFlowControl();
        result = result * 59 + ($flowControl == null ? 43 : ((Object)$flowControl).hashCode());
        Integer $speedLink = this.getSpeedLink();
        result = result * 59 + ($speedLink == null ? 43 : ((Object)$speedLink).hashCode());
        Integer $duplexLink = this.getDuplexLink();
        result = result * 59 + ($duplexLink == null ? 43 : ((Object)$duplexLink).hashCode());
        Integer $linkStatus = this.getLinkStatus();
        result = result * 59 + ($linkStatus == null ? 43 : ((Object)$linkStatus).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $speedMax = this.getSpeedMax();
        result = result * 59 + ($speedMax == null ? 43 : ((Object)$speedMax).hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $lag = this.getLag();
        result = result * 59 + ($lag == null ? 43 : $lag.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EthUnit1PortAppDTO(super=" + super.toString() + ", port=" + this.getPort() + ", mediaType=" + this.getMediaType() + ", description=" + this.getDescription() + ", status=" + this.getStatus() + ", speed=" + this.getSpeed() + ", duplex=" + this.getDuplex() + ", flowControl=" + this.getFlowControl() + ", lag=" + this.getLag() + ", speedLink=" + this.getSpeedLink() + ", duplexLink=" + this.getDuplexLink() + ", linkStatus=" + this.getLinkStatus() + ", type=" + this.getType() + ", speedMax=" + this.getSpeedMax() + ")";
    }

    @Generated
    public EthUnit1PortAppDTO() {
    }

    @Generated
    public String getPort() {
        return this.port;
    }

    @Generated
    public Integer getMediaType() {
        return this.mediaType;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public Integer getSpeed() {
        return this.speed;
    }

    @Generated
    public Integer getDuplex() {
        return this.duplex;
    }

    @Generated
    public Integer getFlowControl() {
        return this.flowControl;
    }

    @Generated
    public String getLag() {
        return this.lag;
    }

    @Generated
    public Integer getSpeedLink() {
        return this.speedLink;
    }

    @Generated
    public Integer getDuplexLink() {
        return this.duplexLink;
    }

    @Generated
    public Integer getLinkStatus() {
        return this.linkStatus;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Integer getSpeedMax() {
        return this.speedMax;
    }

    @Generated
    public void setPort(String port) {
        this.port = port;
    }

    @Generated
    public void setMediaType(Integer mediaType) {
        this.mediaType = mediaType;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setSpeed(Integer speed) {
        this.speed = speed;
    }

    @Generated
    public void setDuplex(Integer duplex) {
        this.duplex = duplex;
    }

    @Generated
    public void setFlowControl(Integer flowControl) {
        this.flowControl = flowControl;
    }

    @Generated
    public void setLag(String lag) {
        this.lag = lag;
    }

    @Generated
    public void setSpeedLink(Integer speedLink) {
        this.speedLink = speedLink;
    }

    @Generated
    public void setDuplexLink(Integer duplexLink) {
        this.duplexLink = duplexLink;
    }

    @Generated
    public void setLinkStatus(Integer linkStatus) {
        this.linkStatus = linkStatus;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setSpeedMax(Integer speedMax) {
        this.speedMax = speedMax;
    }
}

