/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.l2feature.ethport;

import com.tplink.smb.omada.manager.device.api.web.validation.olt.NumberSet;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;

public class EthLagPortAppDTO
extends DpmsBaseDeviceDTO {
    @NotNull(message="lag should not be null")
    @Schema(name="lag", description="ID of LAG", requiredMode=Schema.RequiredMode.REQUIRED)
    private @NotNull(message="lag should not be null") String lag;
    @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{0,32}$", message="only 1-32 bits numbers, Upper and lower letters, -@_:/. are allowed.")
    @Schema(name="description", description="Description of port")
    private @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{0,32}$", message="only 1-32 bits numbers, Upper and lower letters, -@_:/. are allowed.") String description;
    @Schema(name="status", description="Port switch status.Status should be a value as follows:0:DISABLE;1:ENABLE")
    @NumberSet(value={0, 1}, message="status is supposed to be 0\u30011")
    private Integer status;
    @NumberSet(value={0, 10, 100, 1000, 2500, 10000}, message="speed is supposed to be 0/10/100/1000/2500/10000")
    @Schema(name="speed", description="Port speed negotiation mode. speed should be a value as follows: 0;10;100;1000;2500;10000.0 represents Auto, and all other values are in Mbps.")
    private Integer speed;
    @Schema(name="duplex", description="Port duplex negotiation mode.Duplex should be a value as follows: 2:FULL,0:AUTO")
    @NumberSet(value={0, 2}, message="duplex is supposed to be 0\u30012")
    private Integer duplex;
    @Schema(name="flowControl", description="Port flow control function switch.FlowControl should be a value as follows: 0:DISABLE;1:ENABLE")
    @NumberSet(value={0, 1}, message="flowControl is supposed to be 0\u30011")
    private Integer flowControl;

    @Generated
    public EthLagPortAppDTO() {
    }

    @Generated
    public String getLag() {
        return this.lag;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public Integer getSpeed() {
        return this.speed;
    }

    @Generated
    public Integer getDuplex() {
        return this.duplex;
    }

    @Generated
    public Integer getFlowControl() {
        return this.flowControl;
    }

    @Generated
    public void setLag(String lag) {
        this.lag = lag;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setSpeed(Integer speed) {
        this.speed = speed;
    }

    @Generated
    public void setDuplex(Integer duplex) {
        this.duplex = duplex;
    }

    @Generated
    public void setFlowControl(Integer flowControl) {
        this.flowControl = flowControl;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof EthLagPortAppDTO)) {
            return false;
        }
        EthLagPortAppDTO other = (EthLagPortAppDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$speed = this.getSpeed();
        Integer other$speed = other.getSpeed();
        if (this$speed == null ? other$speed != null : !((Object)this$speed).equals(other$speed)) {
            return false;
        }
        Integer this$duplex = this.getDuplex();
        Integer other$duplex = other.getDuplex();
        if (this$duplex == null ? other$duplex != null : !((Object)this$duplex).equals(other$duplex)) {
            return false;
        }
        Integer this$flowControl = this.getFlowControl();
        Integer other$flowControl = other.getFlowControl();
        if (this$flowControl == null ? other$flowControl != null : !((Object)this$flowControl).equals(other$flowControl)) {
            return false;
        }
        String this$lag = this.getLag();
        String other$lag = other.getLag();
        if (this$lag == null ? other$lag != null : !this$lag.equals(other$lag)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EthLagPortAppDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $speed = this.getSpeed();
        result = result * 59 + ($speed == null ? 43 : ((Object)$speed).hashCode());
        Integer $duplex = this.getDuplex();
        result = result * 59 + ($duplex == null ? 43 : ((Object)$duplex).hashCode());
        Integer $flowControl = this.getFlowControl();
        result = result * 59 + ($flowControl == null ? 43 : ((Object)$flowControl).hashCode());
        String $lag = this.getLag();
        result = result * 59 + ($lag == null ? 43 : $lag.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EthLagPortAppDTO(super=" + super.toString() + ", lag=" + this.getLag() + ", description=" + this.getDescription() + ", status=" + this.getStatus() + ", speed=" + this.getSpeed() + ", duplex=" + this.getDuplex() + ", flowControl=" + this.getFlowControl() + ")";
    }
}

