/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.statistic.e;

import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.common.constant.SwitchTypeEnum;
import com.tplink.smb.omada.common.device.StandardOswPortIndex;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.body.osw.OswInformBody;
import com.tplink.smb.omada.device.manage.message.inform.osw.InformOswPort;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswInformDeviceInfo;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswPoeStatus;
import com.tplink.smb.omada.manager.device.api.internal.device.g;
import com.tplink.smb.omada.manager.device.api.internal.dto.osw.QuerySwitchesTypeDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.osw.SwitchesTypeDTO;
import com.tplink.smb.omada.manager.device.api.internal.event.inform.osw.OswInformDomainEventDTO;
import com.tplink.smb.omada.monitor.api.internal.enventcenter.OswStatInformDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OswStatDTO;
import com.tplink.smb.omada.monitor.common.g.a;
import com.tplink.smb.omada.monitor.statistic.c.d.b;
import com.tplink.smb.omada.monitor.statistic.c.d.c;
import com.tplink.smb.omada.monitor.statistic.c.d.d;
import com.tplink.smb.omada.monitor.statistic.common.dto.DeviceStatQueryDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.MacPoePowerDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.MacRebootTimesDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.MacTrafficDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.MacUtilDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.OswStackStatQueryDTO;
import com.tplink.smb.omada.monitor.statistic.e.m;
import com.tplink.smb.omada.monitor.statistic.port.a.f.e;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class u
implements DomainEventSubscriber<OswInformDomainEventDTO> {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(u.class);
    @Autowired
    private com.tplink.smb.omada.monitor.statistic.port.a.f.a b;
    @Autowired
    private b c;
    @Autowired
    private d d;
    @Autowired
    private c e;
    @Autowired
    private com.tplink.smb.omada.monitor.statistic.port.a.h.c f;
    @Autowired
    private com.tplink.smb.omada.monitor.statistic.port.a.h.b g;
    @Autowired
    @Qualifier(value="monitorDeviceInformWorkGroup")
    private ExecutorService h;
    private a i = new a();
    @Autowired
    private g j;
    @Autowired
    private m k;

    @PostConstruct
    public void a() {
        DomainEventBusHolder.getHandlerRegistry().register(OswInformDomainEventDTO.class, (DomainEventSubscriber)this, this.h);
    }

    public void a(OswInformDomainEventDTO deviceInform) {
        boolean isLiteCbc = com.tplink.smb.omada.monitor.common.g.a.a((String)deviceInform.getOmadacId());
        if (isLiteCbc) {
            this.k.a(deviceInform);
            return;
        }
        OswInformBody informBody = (OswInformBody)deviceInform.getInformBody();
        if (informBody.getDeviceInfo() == null && informBody.getPort() == null) {
            return;
        }
        OswInformDeviceInfo deviceInfo = informBody.getDeviceInfo();
        boolean isPro = Boolean.TRUE.equals(this.g.a(deviceInform.getOmadacId(), deviceInform.getSiteId()));
        if (deviceInfo != null && !CollectionUtils.isEmpty((Collection)deviceInfo.getStackUnits())) {
            this.a(deviceInform, isPro);
        } else {
            this.a(new OswStatInformDTO(informBody.getPoe(), informBody.getDeviceInfo(), informBody.getPort()), deviceInform.getDeviceMac(), deviceInform.getSiteId(), deviceInform.getOmadacId(), deviceInform.getTimestamp(), isPro);
        }
    }

    private void a(@Nonnull OswInformDomainEventDTO deviceInform, boolean isPro) {
        OswInformBody informBody = (OswInformBody)deviceInform.getInformBody();
        InformOswPort port = informBody.getPort();
        Map<Object, Object> unitPortStatusMap = new HashMap();
        if (port != null && !CollectionUtils.isEmpty((Collection)port.getPorts())) {
            unitPortStatusMap = port.getPorts().stream().filter(oswPortStatus -> {
                List indexList = StandardOswPortIndex.resolvePortStr((String)oswPortStatus.getStandardPort());
                return !CollectionUtils.isEmpty((Collection)indexList);
            }).collect(Collectors.groupingBy(oswPortStatus -> StandardOswPortIndex.resolveStandardPortIndex((Integer)oswPortStatus.getPort(), (String)oswPortStatus.getStandardPort()).getUnit()));
        }
        Map<Object, Object> unitPortRatesMap = new HashMap();
        if (port != null && !CollectionUtils.isEmpty((Collection)port.getRates())) {
            unitPortRatesMap = port.getRates().stream().filter(oswPortStatus -> {
                List indexList = StandardOswPortIndex.resolvePortStr((String)oswPortStatus.getStandardPort());
                return !CollectionUtils.isEmpty((Collection)indexList);
            }).collect(Collectors.groupingBy(oswPortRate -> StandardOswPortIndex.resolveStandardPortIndex((Integer)oswPortRate.getPort(), (String)oswPortRate.getStandardPort()).getUnit()));
        }
        OswPoeStatus poe = informBody.getPoe();
        Map<Object, Object> unitPoeStatusMap = new HashMap();
        if (poe != null && !CollectionUtils.isEmpty((Collection)poe.getPorts())) {
            unitPoeStatusMap = poe.getPorts().stream().collect(Collectors.groupingBy(oswPortPoeStatus -> StandardOswPortIndex.resolveStandardPortIndex((Integer)oswPortPoeStatus.getPortId(), (String)oswPortPoeStatus.getStandardOswPort()).getUnit()));
        }
        Map<Object, Object> unitPoePortStatusMap = new HashMap();
        if (poe != null && !CollectionUtils.isEmpty((Collection)poe.getStackUnitPoeStatuses())) {
            unitPoePortStatusMap = poe.getStackUnitPoeStatuses().stream().collect(Collectors.toMap(OswPoeStatus.StackUnitPoeStatus::getUnit, stackUnitPoeStatus -> stackUnitPoeStatus));
        }
        Map<Object, Object> unitDeviceInfoMap = new HashMap();
        if (informBody.getDeviceInfo() != null && !CollectionUtils.isEmpty((Collection)informBody.getDeviceInfo().getStackUnits())) {
            unitDeviceInfoMap = informBody.getDeviceInfo().getStackUnits().stream().collect(Collectors.toMap(OswInformDeviceInfo.OswInformDeviceInfoStackUnit::getUnit, oswInformDeviceInfoStackUnit -> oswInformDeviceInfoStackUnit));
        }
        OswInformDeviceInfo deviceInfo = informBody.getDeviceInfo();
        List stackUnits = deviceInfo.getStackUnits();
        for (OswInformDeviceInfo.OswInformDeviceInfoStackUnit stackUnit : stackUnits) {
            if (!this.a(stackUnit.getMac(), deviceInform)) {
                a.debug("OmadacId:{}, SiteId:{}, DeviceMac:{}, license is inactive, ignore it.", new Object[]{deviceInform.getOmadacId(), deviceInform.getSiteId(), stackUnit.getMac()});
                continue;
            }
            OswStatInformDTO oswStatInformDTO = new OswStatInformDTO();
            oswStatInformDTO.setDeviceInfo(this.a((OswInformDeviceInfo.OswInformDeviceInfoStackUnit)unitDeviceInfoMap.get(stackUnit.getUnit())));
            OswPoeStatus.StackUnitPoeStatus stackUnitPoeStatus2 = (OswPoeStatus.StackUnitPoeStatus)unitPoePortStatusMap.get(stackUnit.getUnit());
            List oswPortPoeStatuses = (List)unitPoeStatusMap.get(stackUnit.getUnit());
            if (stackUnitPoeStatus2 != null) {
                OswPoeStatus oswPoeStatus = new OswPoeStatus();
                oswPoeStatus.setPorts(oswPortPoeStatuses);
                oswPoeStatus.setTotal(stackUnitPoeStatus2.getTotal());
                oswPoeStatus.setFanStatus(stackUnitPoeStatus2.getFanStatus());
                oswPoeStatus.setRemain(stackUnitPoeStatus2.getRemain());
                oswPoeStatus.setRemainPercent(stackUnitPoeStatus2.getRemainPercent());
                oswStatInformDTO.setPoe(oswPoeStatus);
            }
            InformOswPort informOswPort = new InformOswPort();
            informOswPort.setPorts((List)unitPortStatusMap.get(stackUnit.getUnit()));
            informOswPort.setRates((List)unitPortRatesMap.get(stackUnit.getUnit()));
            oswStatInformDTO.setPort(informOswPort);
            this.a(oswStatInformDTO, stackUnit.getMac(), deviceInform.getSiteId(), deviceInform.getOmadacId(), deviceInform.getTimestamp(), isPro);
        }
    }

    private OswInformDeviceInfo a(OswInformDeviceInfo.OswInformDeviceInfoStackUnit oswInformDeviceInfoStackUnit) {
        OswInformDeviceInfo oswInformDeviceInfo = new OswInformDeviceInfo();
        oswInformDeviceInfo.setCpkts(oswInformDeviceInfoStackUnit.getCpkts());
        oswInformDeviceInfo.setCpuUtil(oswInformDeviceInfoStackUnit.getCpuUtil());
        oswInformDeviceInfo.setDevTemp(oswInformDeviceInfoStackUnit.getDevTemp());
        oswInformDeviceInfo.setFactory(oswInformDeviceInfoStackUnit.getFactory());
        oswInformDeviceInfo.setFirmwareVersion(oswInformDeviceInfoStackUnit.getFirmwareVersion());
        oswInformDeviceInfo.setHardwareVersion(oswInformDeviceInfoStackUnit.getHardwareVersion());
        oswInformDeviceInfo.setMemUtil(oswInformDeviceInfoStackUnit.getMemUtil());
        oswInformDeviceInfo.setModel(oswInformDeviceInfoStackUnit.getModel());
        oswInformDeviceInfo.setModelVersion(oswInformDeviceInfoStackUnit.getModelVersion());
        oswInformDeviceInfo.setSpecialModel(oswInformDeviceInfoStackUnit.getSpecialModel());
        oswInformDeviceInfo.setUpTime(oswInformDeviceInfoStackUnit.getUpTime());
        return oswInformDeviceInfo;
    }

    private void a(@Nonnull OswStatInformDTO oswStatInformDTO, String deviceMac, String siteId, String omadacId, Long timestamp, boolean isPro) {
        long cacheTime;
        long messageTime;
        e realtimeOswStat = this.b.d(deviceMac);
        if (realtimeOswStat != null && realtimeOswStat.g() >= timestamp) {
            return;
        }
        if (realtimeOswStat == null) {
            realtimeOswStat = new e(omadacId, siteId, deviceMac);
        } else if (!omadacId.equals(realtimeOswStat.d()) || !siteId.equals(realtimeOswStat.e())) {
            a.debug("osw {} changed omadacId {} or siteId {} in deviceInform {} {}", new Object[]{deviceMac, realtimeOswStat.d(), realtimeOswStat.e(), omadacId, siteId});
            this.a(17, realtimeOswStat.d(), realtimeOswStat.e(), deviceMac);
            realtimeOswStat = new e(omadacId, siteId, deviceMac);
        }
        if (realtimeOswStat.g() != 0L && (messageTime = timestamp / 1000L / 300L) > (cacheTime = realtimeOswStat.g() / 1000L / 300L)) {
            realtimeOswStat.a();
        }
        realtimeOswStat.a(oswStatInformDTO, timestamp, isPro);
        this.b.a(realtimeOswStat, isPro);
    }

    private boolean a(String mac, OswInformDomainEventDTO informDTO) {
        if (!Boolean.TRUE.equals(informDTO.getCheckoutLicense())) {
            return true;
        }
        return Optional.ofNullable(informDTO.getStackMemberActiveMap()).map(map -> map.getOrDefault(mac, false)).orElse(false);
    }

    public e a(String mac) {
        return this.b.d(mac);
    }

    public List<OswStatDTO> a(DeviceStatQueryDTO query, N granularity) {
        SwitchesTypeDTO switchesType = this.j.a(new QuerySwitchesTypeDTO(query.getOmadacId(), query.getSiteId(), Collections.singleton(query.getMac())));
        if (switchesType.getSwitchesTypeMap() != null && SwitchTypeEnum.b.c().equals(switchesType.getSwitchesTypeMap().get(query.getMac()))) {
            switch (granularity) {
                case a: {
                    return this.c.c(query);
                }
                case c: {
                    return this.d.c(query);
                }
                case d: 
                case e: {
                    return this.e.c(query);
                }
            }
        }
        switch (granularity) {
            case a: {
                return this.c.b(query);
            }
            case c: {
                return this.d.b(query);
            }
            case d: 
            case e: {
                return this.e.b(query);
            }
        }
        return Collections.emptyList();
    }

    public Map<String, List<OswStatDTO>> a(OswStackStatQueryDTO query, N granularity) {
        switch (granularity) {
            case a: {
                return this.c.a(query);
            }
            case c: {
                return this.d.a(query);
            }
            case d: {
                return this.e.a(query);
            }
        }
        a.info("invalid time granularity to getMultiOswStatMap from omadacId : {} siteId \uff1b {}", (Object)query.getOmadacId(), (Object)query.getSiteId());
        return Collections.emptyMap();
    }

    public MacTrafficDTO a(String omadacId, String siteId, String mac, Long start, Long end, N granularity) {
        switch (granularity) {
            case a: {
                return this.c.b(omadacId, siteId, mac, start, end);
            }
            case c: {
                return this.d.b(omadacId, siteId, mac, start, end);
            }
            case d: 
            case e: {
                return this.e.b(omadacId, siteId, mac, start, end);
            }
        }
        return null;
    }

    public List<MacTrafficDTO> a(N granularity, String omadacId, String siteId, long start, long end) {
        switch (granularity) {
            case a: {
                return this.c.e(omadacId, siteId, start, end);
            }
            case c: {
                List<MacTrafficDTO> hourlyMacTraffic = this.d.e(omadacId, siteId, start, end);
                return hourlyMacTraffic.isEmpty() ? this.a(N.a, omadacId, siteId, start, end) : hourlyMacTraffic;
            }
            case d: 
            case e: {
                List<MacTrafficDTO> dailyMacTraffic = this.e.e(omadacId, siteId, start, end);
                return dailyMacTraffic.isEmpty() ? this.a(N.c, omadacId, siteId, start, end) : dailyMacTraffic;
            }
        }
        a.info("invalid timeRange");
        return Collections.emptyList();
    }

    public List<MacTrafficDTO> b(N granularity, String omadacId, String siteId, long start, long end) {
        switch (granularity) {
            case a: {
                return this.c.e(omadacId, siteId, start, end);
            }
            case c: {
                return this.d.e(omadacId, siteId, start, end);
            }
            case d: 
            case e: {
                return this.e.e(omadacId, siteId, start, end);
            }
        }
        a.info("invalid timeRange");
        return Collections.emptyList();
    }

    public List<MacRebootTimesDTO> c(N granularity, String omadacId, String siteId, long start, long end) {
        switch (granularity) {
            case a: {
                return this.c.f(omadacId, siteId, start, end);
            }
            case c: {
                return this.d.f(omadacId, siteId, start, end);
            }
            case d: 
            case e: {
                return this.e.f(omadacId, siteId, start, end);
            }
        }
        a.info("invalid timeRange");
        return Collections.emptyList();
    }

    public List<MacUtilDTO> d(N granularity, String omadacId, String siteId, long start, long end) {
        switch (granularity) {
            case a: {
                return this.c.g(omadacId, siteId, start, end);
            }
            case c: {
                return this.d.g(omadacId, siteId, start, end);
            }
            case d: 
            case e: {
                return this.e.g(omadacId, siteId, start, end);
            }
        }
        a.info("invalid timeRange");
        return Collections.emptyList();
    }

    public List<MacUtilDTO> e(N granularity, String omadacId, String siteId, long start, long end) {
        switch (granularity) {
            case a: {
                return this.c.h(omadacId, siteId, start, end);
            }
            case c: {
                return this.d.h(omadacId, siteId, start, end);
            }
            case d: 
            case e: {
                return this.e.h(omadacId, siteId, start, end);
            }
        }
        a.info("invalid timeRange");
        return Collections.emptyList();
    }

    public List<MacUtilDTO> f(N granularity, String omadacId, String siteId, long start, long end) {
        switch (granularity) {
            case a: {
                return this.c.i(omadacId, siteId, start, end);
            }
            case c: {
                return this.d.i(omadacId, siteId, start, end);
            }
            case d: 
            case e: {
                return this.e.i(omadacId, siteId, start, end);
            }
        }
        a.info("invalid timeRange");
        return Collections.emptyList();
    }

    public List<MacPoePowerDTO> g(N granularity, String omadacId, String siteId, long start, long end) {
        switch (granularity) {
            case a: {
                return this.c.j(omadacId, siteId, start, end);
            }
            case c: {
                return this.d.j(omadacId, siteId, start, end);
            }
            case d: 
            case e: {
                return this.e.j(omadacId, siteId, start, end);
            }
        }
        a.info("invalid timeRange");
        return Collections.emptyList();
    }

    public void b(String omadacId) {
        this.b.a(omadacId);
    }

    public void a(String omadacId, String siteId) {
        this.b.a(omadacId, siteId);
    }

    public void a(int mode, String omadacId, String siteId, String mac) {
        if ((1 & mode) == 1) {
            this.b.c(siteId, mac);
        }
    }

    public void a(int mode, String omadacId, String siteId, List<String> macs) {
        if (com.tplink.smb.omada.monitor.common.g.a.a((String)omadacId)) {
            return;
        }
        if ((1 & mode) == 1) {
            for (String mac : macs) {
                this.b.c(siteId, mac);
            }
        }
    }

    public void a(String omadacId, String siteId, String mac) {
        if (com.tplink.smb.omada.monitor.common.g.a.a((String)omadacId)) {
            return;
        }
        this.b.a(omadacId, siteId, mac);
    }

    public Set<String> a(long time) {
        Collection<String> siteMacPairs = this.b.c();
        if (CollectionUtils.isEmpty(siteMacPairs)) {
            a.info("oswStatCache getSiteMac is empty,time:{}", (Object)time);
            return Collections.EMPTY_SET;
        }
        HashMap<String, Set<String>> siteMacsMap = new HashMap<String, Set<String>>(16);
        this.a(siteMacsMap, siteMacPairs);
        String omadacId = this.b.d();
        for (Map.Entry siteMacsPair : siteMacsMap.entrySet()) {
            this.a(omadacId, (String)siteMacsPair.getKey(), (Collection)siteMacsPair.getValue(), time);
        }
        return siteMacsMap.keySet();
    }

    private void a(String omadacId, String siteId, Collection<String> oswMacs, long time) {
        AtomicInteger counter = new AtomicInteger(0);
        com.tplink.smb.omada.monitor.statistic.port.a.f.c siteOswStat = new com.tplink.smb.omada.monitor.statistic.port.a.f.c(omadacId, siteId, "all_switch");
        oswMacs.forEach(mac -> {
            com.tplink.smb.omada.monitor.statistic.port.a.f.c oswStat = this.b.a((String)mac, time);
            if (oswStat != null && oswStat.a().equals(omadacId) && oswStat.b().equals(siteId)) {
                counter.getAndIncrement();
                siteOswStat.a(oswStat);
                siteOswStat.b(oswStat);
                this.c.a(oswStat, time);
                this.b.b(omadacId, siteId, (String)mac);
            } else {
                if (a.isDebugEnabled()) {
                    a.debug("removeMacOfSiteId, oswStat is {}, omadacId {}, siteId {}, mac {}", new Object[]{x.a((Object)oswStat), omadacId, siteId, mac});
                }
                this.b.b(siteId, (String)mac);
            }
        });
        if (counter.get() > 0) {
            this.c.a(siteOswStat, time);
            this.f.a(omadacId, siteId, siteOswStat, time);
        }
    }

    public void a(String omadacId, String siteId, long time) {
        Collection<String> oswMacs = this.b.b(siteId);
        a.debug("statistic oswstat5min omadacId: {} siteId: {} macs: {}", new Object[]{omadacId, siteId, oswMacs});
        if (CollectionUtils.isEmpty(oswMacs)) {
            return;
        }
        this.a(omadacId, siteId, oswMacs, time);
    }

    private void a(Map<String, Set<String>> siteMacsMap, Collection<String> siteMacPairs) {
        siteMacPairs.forEach(siteMacPair -> {
            try {
                String siteId = siteMacPair.split(":")[0];
                String mac = siteMacPair.split(":")[1];
                if (siteMacsMap.containsKey(siteId)) {
                    ((Set)siteMacsMap.get(siteId)).add(mac);
                } else {
                    siteMacsMap.put(siteId, new HashSet<String>(Collections.singleton(mac)));
                }
            }
            catch (Exception ex) {
                a.warn("site mac pairs in cache error: {}, {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)siteMacPair), (Object)ex);
            }
        });
    }

    public Set<String> a(long start, long end, N granularity) {
        Collection<String> siteMacPairs = this.b.c();
        if (CollectionUtils.isEmpty(siteMacPairs)) {
            return Collections.EMPTY_SET;
        }
        HashMap<String, Set<String>> siteMacsMap = new HashMap<String, Set<String>>(16);
        this.a(siteMacsMap, siteMacPairs);
        String omadacId = this.b.d();
        for (Map.Entry siteMacsPair : siteMacsMap.entrySet()) {
            this.a(start, end, granularity, omadacId, (String)siteMacsPair.getKey(), (Collection)siteMacsPair.getValue());
        }
        return siteMacsMap.keySet();
    }

    private void a(long start, long end, N granularity, String omadacId, String siteId, Collection<String> oswMacs) {
        com.tplink.smb.omada.monitor.statistic.c.d.a targetOswStatRepository;
        com.tplink.smb.omada.monitor.statistic.c.d.a sourceOswStatRepository;
        if (granularity == N.c) {
            sourceOswStatRepository = this.c;
            targetOswStatRepository = this.d;
        } else if (granularity == N.d) {
            sourceOswStatRepository = this.d;
            targetOswStatRepository = this.e;
        } else {
            return;
        }
        if (OmadacType.s() && granularity == N.c) {
            a.info("[STAT] {\"statName\":\"deviceCountInfo\",\"omadacId\":\"{}\",\"siteId\":\"{}\",\"deviceType\":\"switch\",\"macList\":\"{}\"}", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.a(oswMacs, (PIIMaskStrategy)PIIMaskStrategy.ENCRYPT)});
        }
        a.debug("statistic oswstat{} omadacId: {} siteId: {} macs: {}", new Object[]{granularity.a(), omadacId, siteId, oswMacs});
        if (CollectionUtils.isEmpty(oswMacs)) {
            return;
        }
        com.tplink.smb.omada.monitor.statistic.port.a.f.c siteOswStat = new com.tplink.smb.omada.monitor.statistic.port.a.f.c(omadacId, siteId, "all_switch");
        ArrayList<com.tplink.smb.omada.monitor.statistic.port.a.f.c> oswStats = new ArrayList<com.tplink.smb.omada.monitor.statistic.port.a.f.c>();
        oswMacs.forEach(mac -> {
            DeviceStatQueryDTO query = new DeviceStatQueryDTO(omadacId, siteId, (String)mac, (Long)start, (Long)end);
            List<OswStatDTO> list = sourceOswStatRepository.b(query);
            if (!CollectionUtils.isEmpty(list)) {
                com.tplink.smb.omada.monitor.statistic.port.a.f.c oswStat = new com.tplink.smb.omada.monitor.statistic.port.a.f.c(omadacId, siteId, (String)mac, list);
                oswStats.add(oswStat);
                if (oswStats.size() >= 100) {
                    targetOswStatRepository.a(oswStats, end);
                    oswStats.clear();
                }
                siteOswStat.a(oswStat);
            }
        });
        oswStats.add(siteOswStat);
        targetOswStatRepository.a(oswStats, end);
    }

    public void a(long start, long end, N granularity, String omadacId, String siteId) {
        Collection<String> oswMacs = this.b.b(siteId);
        a.debug("statistics 1hour / 1day oswMacs omadacId: {} siteId: {} macsSize: {}", new Object[]{omadacId, siteId, Optional.ofNullable(oswMacs).map(Collection::size).orElse(0)});
        if (CollectionUtils.isEmpty(oswMacs)) {
            return;
        }
        this.a(start, end, granularity, omadacId, siteId, oswMacs);
    }

    public Long a(String omadacId, String siteId, Long start, Long end) {
        N granularity = N.a((long)start, (long)end);
        MacTrafficDTO macTraffic = this.a(omadacId, siteId, "all_switch", start, end, granularity);
        return macTraffic == null ? 0L : macTraffic.getTraffic();
    }

    public void b(OswInformDomainEventDTO oswInformDTO) {
        this.a(oswInformDTO);
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.b((OswInformDomainEventDTO)object);
    }
}

