/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.statistic.e;

import com.google.common.collect.Sets;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.DeviceOutlineDTO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.ActiveDeviceVO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.DeviceTrafficActivityVO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.DeviceTrafficDistributionVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.BaseDeviceStatDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OswStatDTO;
import com.tplink.smb.omada.monitor.report.a;
import com.tplink.smb.omada.monitor.statistic.common.b.b;
import com.tplink.smb.omada.monitor.statistic.common.b.e;
import com.tplink.smb.omada.monitor.statistic.common.b.f;
import com.tplink.smb.omada.monitor.statistic.common.dto.DeviceStatQueryDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.MacTrafficDTO;
import com.tplink.smb.omada.monitor.statistic.e.u;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class t {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(t.class);
    @Autowired
    private com.tplink.smb.omada.monitor.statistic.port.a.b.b b;
    @Autowired
    private u c;
    @Autowired
    private com.tplink.smb.omada.manager.device.api.internal.device.b d;
    @Autowired
    private a e;

    public List<ActiveDeviceVO> a(String omadacId, String siteId, Long start, Long end, int numberMostActivities, int numberDistribution) {
        N granularity = N.a((long)start, (long)end);
        List<ActiveDeviceVO> activeDevices = this.b.c(omadacId, siteId, start = f.a(start, granularity), end = f.b(end, granularity));
        if (activeDevices != null) {
            a.info("retrieve active ap from cache");
            return activeDevices;
        }
        Map<String, DeviceOutlineDTO> deviceMap = this.d.a(new com.tplink.smb.omada.manager.device.api.internal.device.dto.b(omadacId, siteId, DeviceTypeEnum.c.b())).stream().filter(DeviceOutlineDTO::isIndbStatus).collect(Collectors.toMap(DeviceOutlineDTO::getMac, v2 -> v2, (v1, v2) -> v1));
        if (CollectionUtils.isEmpty(deviceMap)) {
            return Collections.emptyList();
        }
        List<MacTrafficDTO> trafficList = this.a(granularity, omadacId, siteId, start, end);
        if (CollectionUtils.isEmpty(trafficList)) {
            return Collections.emptyList();
        }
        int limit = Math.min(Math.max(numberMostActivities, numberDistribution), deviceMap.keySet().size());
        activeDevices = com.tplink.smb.omada.monitor.statistic.common.b.e.a(deviceMap, trafficList, limit);
        this.b.c(activeDevices, omadacId, siteId, start, end);
        return activeDevices;
    }

    public List<DeviceTrafficDistributionVO> a(String omadacId, String siteId, Long start, Long end, int numberMostActivities, int numberDistribution, Locale locale) {
        N granularity = N.a((long)start, (long)end);
        List<DeviceTrafficDistributionVO> distributionVOS = this.b.e(omadacId, siteId, start = f.a(start, granularity), end = f.b(end, granularity));
        if (distributionVOS != null) {
            a.info("retrieve ap distribution from cache");
            return distributionVOS;
        }
        Map<String, DeviceOutlineDTO> deviceMap = this.d.a(new com.tplink.smb.omada.manager.device.api.internal.device.dto.b(omadacId, siteId, DeviceTypeEnum.c.b())).stream().filter(DeviceOutlineDTO::isIndbStatus).collect(Collectors.toMap(DeviceOutlineDTO::getMac, v2 -> v2, (v1, v2) -> v1));
        if (CollectionUtils.isEmpty(deviceMap)) {
            return Collections.emptyList();
        }
        Set<String> macSet = deviceMap.keySet();
        int limit = Math.min(Math.max(numberMostActivities, numberDistribution), macSet.size());
        List<MacTrafficDTO> trafficList = this.a(granularity, omadacId, siteId, start, end);
        if (CollectionUtils.isEmpty(trafficList)) {
            return Collections.emptyList();
        }
        distributionVOS = com.tplink.smb.omada.monitor.statistic.common.b.e.a(deviceMap, trafficList, limit, locale);
        this.b.e(distributionVOS, omadacId, siteId, start, end);
        return distributionVOS;
    }

    public List<DeviceTrafficActivityVO> a(String omadacId, String siteId, Long start, Long end) {
        N granularity = N.a((long)start, (long)end);
        DeviceStatQueryDTO statisticQuery = new DeviceStatQueryDTO(omadacId, siteId, "all_switch", start, end);
        List<OswStatDTO> list = this.c.a(statisticQuery, granularity);
        List<DeviceTrafficActivityVO> deviceTrafficActivityVOS = com.tplink.smb.omada.monitor.statistic.common.b.b.a(list, granularity.equals((Object)N.e));
        deviceTrafficActivityVOS = this.e.a(start, end, granularity, deviceTrafficActivityVOS, DeviceTrafficActivityVO.class);
        return deviceTrafficActivityVOS;
    }

    public List<DeviceTrafficActivityVO> a(String omadacId, String siteId, Long time) {
        HashSet attrs;
        Long start = time - 86400L - 3600L;
        DeviceStatQueryDTO statisticQuery = new DeviceStatQueryDTO(omadacId, siteId, "all_switch", start, time, attrs = Sets.newHashSet((Object[])new String[]{"ports", "time"}), null);
        List<OswStatDTO> list = this.c.a(statisticQuery, N.c);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        list = new ArrayList(list.stream().collect(Collectors.toMap(BaseDeviceStatDTO::getTime, v2 -> v2, (v1, v2) -> v2, TreeMap::new)).values());
        int size = list.size();
        ArrayList<OswStatDTO> sampleList = new ArrayList<OswStatDTO>();
        long leftTime = f.d(start);
        long rightTime = leftTime + 7200L;
        int index = 0;
        while (leftTime <= time) {
            OswStatDTO statDTO = new OswStatDTO();
            if (index + 1 > size) {
                statDTO.setTime(leftTime);
            } else if (list.get(index).getTime() < rightTime && list.get(index).getTime() >= leftTime) {
                if (index + 1 < size && list.get(index + 1).getTime() < rightTime && list.get(index + 1).getTime() >= leftTime) {
                    statDTO = this.a(list.get(index), list.get(index + 1));
                    ++index;
                } else {
                    statDTO = list.get(index);
                }
                ++index;
            } else {
                statDTO.setTime(leftTime);
            }
            sampleList.add(statDTO);
            leftTime = rightTime;
            rightTime = leftTime + 7200L;
        }
        return com.tplink.smb.omada.monitor.statistic.common.b.b.b(sampleList, false);
    }

    public List<DeviceTrafficActivityVO> b(String omadacId, String siteId, Long start, Long end) {
        N granularity = N.c;
        DeviceStatQueryDTO statisticQuery = new DeviceStatQueryDTO(omadacId, siteId, "all_switch", start, end);
        List<OswStatDTO> list = this.c.a(statisticQuery, granularity);
        return com.tplink.smb.omada.monitor.statistic.common.b.b.a(list, false);
    }

    private List<MacTrafficDTO> a(N granularity, String omadacId, String siteId, long start, long end) {
        List<MacTrafficDTO> trafficList = this.b.i(omadacId, siteId, start, end);
        if (trafficList != null) {
            this.b.i(trafficList, omadacId, siteId, start, end);
            return trafficList;
        }
        return this.c.b(granularity, omadacId, siteId, start, end);
    }

    private OswStatDTO a(OswStatDTO pre, OswStatDTO next) {
        if (pre == null) {
            return next;
        }
        if (next == null) {
            return pre;
        }
        OswStatDTO statDTO = new OswStatDTO();
        statDTO.setTime(pre.getTime().longValue());
        statDTO.setPorts(OswStatDTO.OswPortStatDTO.merge((List)pre.getPorts(), (List)next.getPorts()));
        return statDTO;
    }
}

