/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.statistic.e;

import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.I;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.body.osg.OsgInformBody;
import com.tplink.smb.omada.manager.device.api.internal.event.inform.osg.OsgInformDomainEventDTO;
import com.tplink.smb.omada.monitor.api.internal.statistic.dto.OsgHealthStatDTO;
import com.tplink.smb.omada.monitor.api.internal.statistic.dto.OsgTotalTxAndRxDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OsgStatDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.WanStatDTO;
import com.tplink.smb.omada.monitor.statistic.c.c.a;
import com.tplink.smb.omada.monitor.statistic.c.c.c;
import com.tplink.smb.omada.monitor.statistic.c.c.d;
import com.tplink.smb.omada.monitor.statistic.common.dto.DeviceStatQueryDTO;
import com.tplink.smb.omada.monitor.statistic.port.a.e.b;
import com.tplink.smb.omada.monitor.statistic.port.a.e.f;
import com.tplink.smb.omada.monitor.statistic.port.a.e.g;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class r
implements DomainEventSubscriber<OsgInformDomainEventDTO> {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(r.class);
    @Autowired
    private b b;
    @Autowired
    private com.tplink.smb.omada.monitor.statistic.c.c.b c;
    @Autowired
    private d d;
    @Autowired
    private c e;
    @Autowired
    private com.tplink.smb.omada.monitor.statistic.port.a.h.c f;
    @Autowired
    private com.tplink.smb.omada.manager.device.api.internal.device.b g;
    @Autowired
    private com.tplink.smb.omada.monitor.statistic.port.a.h.b h;
    @Autowired
    private com.tplink.smb.omada.monitor.statistic.port.b.a i;
    @Autowired
    @Qualifier(value="monitorDeviceInformWorkGroup")
    private ExecutorService j;
    private com.tplink.smb.omada.monitor.common.g.a k = new com.tplink.smb.omada.monitor.common.g.a();

    @PostConstruct
    public void a() {
        DomainEventBusHolder.getHandlerRegistry().register(OsgInformDomainEventDTO.class, (DomainEventSubscriber)this, this.j);
    }

    public void a(OsgInformDomainEventDTO deviceInform) {
        long cacheTime;
        long messageTime;
        if (com.tplink.smb.omada.monitor.common.g.a.a((String)deviceInform.getOmadacId())) {
            return;
        }
        OsgInformBody informBody = (OsgInformBody)deviceInform.getInformBody();
        if (informBody.getDeviceInfo() == null && informBody.getTrafficStat() == null && informBody.getPortInfo() == null) {
            return;
        }
        g realtimeOsgStat = this.b.d(deviceInform.getDeviceMac());
        if (realtimeOsgStat != null && realtimeOsgStat.h() >= deviceInform.getTimestamp()) {
            return;
        }
        if (realtimeOsgStat == null) {
            realtimeOsgStat = new g(deviceInform.getOmadacId(), deviceInform.getSiteId(), deviceInform.getDeviceMac());
        } else if (!deviceInform.getOmadacId().equals(realtimeOsgStat.d()) || !deviceInform.getSiteId().equals(realtimeOsgStat.e())) {
            a.debug("osg {} changed omadacId {} or siteId {} in deviceInform {} {}", new Object[]{deviceInform.getDeviceMac(), realtimeOsgStat.d(), realtimeOsgStat.e(), deviceInform.getOmadacId(), deviceInform.getSiteId()});
            this.a(17, realtimeOsgStat.d(), realtimeOsgStat.e(), deviceInform.getDeviceMac());
            realtimeOsgStat = new g(deviceInform.getOmadacId(), deviceInform.getSiteId(), deviceInform.getDeviceMac());
        }
        if (realtimeOsgStat.h() != 0L && (messageTime = deviceInform.getTimestamp() / 1000L / 300L) > (cacheTime = realtimeOsgStat.h() / 1000L / 300L)) {
            realtimeOsgStat.a();
        }
        boolean isPro = Boolean.TRUE.equals(this.h.a(deviceInform.getOmadacId(), deviceInform.getSiteId()));
        realtimeOsgStat.a(informBody, deviceInform.getTimestamp(), isPro, deviceInform.getSeq());
        this.b.a(realtimeOsgStat, isPro);
    }

    public g a(String mac) {
        return this.b.d(mac);
    }

    public List<OsgStatDTO> a(DeviceStatQueryDTO query, N granularity) {
        switch (granularity) {
            case a: {
                return this.c.b(query);
            }
            case c: {
                return this.d.b(query);
            }
            case d: 
            case e: {
                return this.e.b(query);
            }
        }
        return Collections.emptyList();
    }

    public List<WanStatDTO> b(DeviceStatQueryDTO query, N granularity) {
        switch (granularity) {
            case a: {
                return this.c.c(query);
            }
            case c: {
                return this.d.c(query);
            }
            case d: 
            case e: {
                return this.e.c(query);
            }
        }
        return Collections.emptyList();
    }

    public Map<Integer, com.tplink.smb.omada.monitor.statistic.port.a.e.c> a(String mac, long time) {
        com.tplink.smb.omada.monitor.statistic.port.a.e.d periodOsgStat = this.b.a(mac, time);
        if (Objects.nonNull(periodOsgStat)) {
            return periodOsgStat.h();
        }
        return null;
    }

    public void b(String omadacId) {
        this.b.a(omadacId);
    }

    public void a(String omadacId, String siteId) {
        this.b.a(omadacId, siteId);
    }

    public void a(int mode, String omadacId, String siteId, String mac) {
        if ((1 & mode) == 1) {
            this.b.c(siteId, mac);
        }
    }

    public void a(int mode, String omadacId, String siteId, List<String> macs) {
        if (com.tplink.smb.omada.monitor.common.g.a.a((String)omadacId)) {
            return;
        }
        if ((1 & mode) == 1) {
            for (String mac : macs) {
                this.b.c(siteId, mac);
            }
        }
    }

    public void a(String omadacId, String siteId, String mac) {
        if (com.tplink.smb.omada.monitor.common.g.a.a((String)omadacId)) {
            return;
        }
        this.b.a(omadacId, siteId, mac);
    }

    public Set<String> a(long time) {
        Collection<String> siteMacPairs = this.b.c();
        if (CollectionUtils.isEmpty(siteMacPairs)) {
            a.info("oswStatCache getSiteMac is empty,time:{}", (Object)time);
            return Collections.EMPTY_SET;
        }
        HashMap siteMacsMap = new HashMap(16);
        siteMacPairs.forEach(siteMacPair -> {
            try {
                String siteId = siteMacPair.split(":")[0];
                String mac = siteMacPair.split(":")[1];
                if (siteMacsMap.containsKey(siteId)) {
                    ((Set)siteMacsMap.get(siteId)).add(mac);
                } else {
                    siteMacsMap.put(siteId, new HashSet<String>(Collections.singleton(mac)));
                }
            }
            catch (Exception ex) {
                a.warn("site mac pairs in cache error: {}, {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)siteMacPair), (Object)ex);
            }
        });
        String omadacId = this.b.d();
        for (Map.Entry siteMacsPair : siteMacsMap.entrySet()) {
            this.a(omadacId, (String)siteMacsPair.getKey(), (Collection)siteMacsPair.getValue(), time);
        }
        return siteMacsMap.keySet();
    }

    public void a(String omadacId, String siteId, Collection<String> osgMacs, long time) {
        osgMacs.forEach(mac -> {
            com.tplink.smb.omada.monitor.statistic.port.a.e.d osgStat = this.b.a((String)mac, time);
            if (osgStat != null && osgStat.a().equals(omadacId) && osgStat.b().equals(siteId)) {
                this.c.a(osgStat, time);
                this.f.a(omadacId, siteId, osgStat, time);
                this.i.a(osgStat, time);
            } else {
                if (a.isDebugEnabled()) {
                    a.debug("removeMacOfSiteId, osgStat is {}, omadacId {}, siteId {}, mac {}", new Object[]{x.a((Object)osgStat), omadacId, siteId, mac});
                }
                this.b.b(siteId, (String)mac);
            }
        });
    }

    public void a(String omadacId, String siteId, long time) {
        Collection<String> osgMacs = this.b.b(siteId);
        a.debug("statistic osgstat5min omadacId: {} siteId: {} macs: {}", new Object[]{omadacId, siteId, osgMacs});
        if (CollectionUtils.isEmpty(osgMacs)) {
            return;
        }
        this.a(omadacId, siteId, osgMacs, time);
    }

    private void a(Map<String, Set<String>> siteMacsMap, Collection<String> siteMacPairs) {
        siteMacPairs.forEach(siteMacPair -> {
            try {
                String siteId = siteMacPair.split(":")[0];
                String mac = siteMacPair.split(":")[1];
                if (siteMacsMap.containsKey(siteId)) {
                    ((Set)siteMacsMap.get(siteId)).add(mac);
                } else {
                    siteMacsMap.put(siteId, new HashSet<String>(Collections.singleton(mac)));
                }
            }
            catch (Exception ex) {
                a.warn("site mac pairs in cache error: {}, {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)siteMacPair), (Object)ex);
            }
        });
    }

    public Set<String> a(long start, long end, N granularity) {
        Collection<String> siteMacPairs = this.b.c();
        if (CollectionUtils.isEmpty(siteMacPairs)) {
            return Collections.EMPTY_SET;
        }
        HashMap<String, Set<String>> siteMacsMap = new HashMap<String, Set<String>>(16);
        this.a(siteMacsMap, siteMacPairs);
        String omadacId = this.b.d();
        for (Map.Entry siteMacsPair : siteMacsMap.entrySet()) {
            this.a(start, end, granularity, omadacId, (String)siteMacsPair.getKey(), (Collection)siteMacsPair.getValue());
        }
        return siteMacsMap.keySet();
    }

    private void a(long start, long end, N granularity, String omadacId, String siteId, Collection<String> osgMacs) {
        a targetOsgStatRepository;
        a sourceOsgStatRepository;
        if (granularity == N.c) {
            sourceOsgStatRepository = this.c;
            targetOsgStatRepository = this.d;
        } else if (granularity == N.d) {
            sourceOsgStatRepository = this.d;
            targetOsgStatRepository = this.e;
        } else {
            return;
        }
        a.debug("statistic osgstat{} omadacId: {} siteId: {} macs: {}", new Object[]{granularity.a(), omadacId, siteId, osgMacs});
        if (OmadacType.s() && granularity == N.c) {
            a.info("[STAT] {\"statName\":\"deviceCountInfo\",\"omadacId\":\"{}\",\"siteId\":\"{}\",\"deviceType\":\"gateway\",\"macList\":\"{}\"}", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.a(osgMacs, (PIIMaskStrategy)PIIMaskStrategy.ENCRYPT)});
        }
        if (CollectionUtils.isEmpty(osgMacs)) {
            return;
        }
        ArrayList<com.tplink.smb.omada.monitor.statistic.port.a.e.d> osgStats = new ArrayList<com.tplink.smb.omada.monitor.statistic.port.a.e.d>();
        osgMacs.forEach(mac -> {
            DeviceStatQueryDTO query = new DeviceStatQueryDTO(omadacId, siteId, (String)mac, (Long)start, (Long)end);
            List<OsgStatDTO> list = sourceOsgStatRepository.b(query);
            if (!CollectionUtils.isEmpty(list)) {
                com.tplink.smb.omada.monitor.statistic.port.a.e.d osgStat = new com.tplink.smb.omada.monitor.statistic.port.a.e.d(omadacId, siteId, (String)mac, list);
                osgStats.add(osgStat);
                if (osgStats.size() >= 100) {
                    targetOsgStatRepository.a(osgStats, end);
                    osgStats.clear();
                }
            }
        });
        if (!CollectionUtils.isEmpty(osgStats)) {
            targetOsgStatRepository.a(osgStats, end);
        }
    }

    public void a(long start, long end, N granularity, String omadacId, String siteId) {
        Collection<String> osgMacs = this.b.b(siteId);
        a.debug("statistic 1hour / 1day osgstat {} omadacId: {} siteId: {} macs: {}", new Object[]{granularity.a(), omadacId, siteId, osgMacs});
        if (CollectionUtils.isEmpty(osgMacs)) {
            return;
        }
        this.a(start, end, granularity, omadacId, siteId, osgMacs);
    }

    public OsgTotalTxAndRxDTO a(String omadacId, String siteId, String mac, List<Integer> ports) {
        g osgStat = this.b.d(mac);
        if (osgStat == null) {
            return new OsgTotalTxAndRxDTO();
        }
        Long tx = 0L;
        Long rx = 0L;
        if (CollectionUtils.isEmpty(ports)) {
            for (f portTraffic : osgStat.o().values()) {
                tx = I.b((Long)tx, (Long)portTraffic.g());
                rx = I.b((Long)rx, (Long)portTraffic.c());
            }
        } else {
            for (Integer port : ports) {
                f portTraffic = osgStat.o().get(port);
                if (portTraffic == null) continue;
                tx = I.b((Long)tx, (Long)portTraffic.g());
                rx = I.b((Long)rx, (Long)portTraffic.c());
            }
        }
        return new OsgTotalTxAndRxDTO(tx, rx);
    }

    public List<OsgHealthStatDTO> c(DeviceStatQueryDTO query, N granularity) {
        List<OsgStatDTO> statList = this.a(query, granularity);
        ArrayList<OsgHealthStatDTO> healthStatDTOS = new ArrayList<OsgHealthStatDTO>();
        for (OsgStatDTO statDTO : statList) {
            long portLossPkts = 0L;
            int linkDownCnt = 0;
            long portErrPkts = 0L;
            for (OsgStatDTO.OsgPortStatDTO portStatDTO : statDTO.getPorts()) {
                portLossPkts += portStatDTO.getDropPkts().longValue();
                linkDownCnt += portStatDTO.getLinkDownCnt().intValue();
                portErrPkts += portStatDTO.getErrPkts().longValue();
            }
            OsgHealthStatDTO dto = new OsgHealthStatDTO(statDTO.getTime(), statDTO.getCpu(), statDTO.getMem(), Long.valueOf(portLossPkts), Integer.valueOf(linkDownCnt), Long.valueOf(portErrPkts));
            healthStatDTOS.add(dto);
        }
        return healthStatDTOS;
    }

    public void b(String omadacId, String siteId, String mac, List<Integer> ports) {
        this.c.a(omadacId, siteId, mac, ports);
        this.d.a(omadacId, siteId, mac, ports);
        this.e.a(omadacId, siteId, mac, ports);
    }

    public void b(OsgInformDomainEventDTO osgInformDTO) {
        this.a(osgInformDTO);
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.b((OsgInformDomainEventDTO)object);
    }
}

