/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.statistic.e;

import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.e.a;
import com.tplink.smb.omada.device.manage.message.body.olt.OltInformBody;
import com.tplink.smb.omada.manager.c.b.k;
import com.tplink.smb.omada.manager.device.api.internal.device.d;
import com.tplink.smb.omada.manager.device.api.internal.event.inform.olt.OltInformDomainEventDTO;
import com.tplink.smb.omada.manager.olt.dto.OnuManagementRequestInternalDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OltStatDTO;
import com.tplink.smb.omada.monitor.statistic.c.b.b;
import com.tplink.smb.omada.monitor.statistic.common.dto.DeviceStatQueryDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.MacUtilDTO;
import com.tplink.smb.omada.monitor.statistic.port.a.d.c;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class n
implements DomainEventSubscriber<OltInformDomainEventDTO> {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(n.class);
    @Autowired
    private c b;
    @Autowired
    private b c;
    @Autowired
    private com.tplink.smb.omada.monitor.statistic.c.b.d d;
    @Autowired
    private com.tplink.smb.omada.monitor.statistic.c.b.c e;
    @Autowired
    private com.tplink.smb.omada.monitor.statistic.port.a.h.c f;
    @Autowired
    private d g;
    @Autowired
    private com.tplink.smb.omada.monitor.statistic.port.a.h.b h;
    @Autowired
    @Qualifier(value="monitorDeviceInformWorkGroup")
    private ExecutorService i;
    private com.tplink.smb.omada.monitor.common.g.a j = new com.tplink.smb.omada.monitor.common.g.a();

    @PostConstruct
    public void a() {
        DomainEventBusHolder.getHandlerRegistry().register(OltInformDomainEventDTO.class, (DomainEventSubscriber)this, this.i);
    }

    public void a(OltInformDomainEventDTO oltInformDTO) {
        this.b(oltInformDTO);
    }

    private void b(OltInformDomainEventDTO deviceInform) {
        com.tplink.smb.omada.monitor.statistic.port.a.d.d realtimeStat;
        OltInformBody informBody = (OltInformBody)deviceInform.getInformBody();
        if (informBody.getDeviceInfo() == null && informBody.getTrafficStat() == null && informBody.getTrafficStatX2() == null) {
            a.warn("No Device Info or Traffic Stat, informBody is {}", (Object)informBody);
            return;
        }
        OltInformDomainEventDTO lastDeviceInform = this.b.e(deviceInform.getDeviceMac());
        if (lastDeviceInform != null && lastDeviceInform.getTimestamp() >= deviceInform.getTimestamp()) {
            a.warn("current deviceInform is late!");
            a.warn("current deviceInform:{} and last DeviceInform:{} ", (Object)deviceInform.getTimestamp(), (Object)lastDeviceInform.getTimestamp());
            return;
        }
        if (lastDeviceInform == null) {
            realtimeStat = new com.tplink.smb.omada.monitor.statistic.port.a.d.d(deviceInform.getOmadacId(), deviceInform.getSiteId(), deviceInform.getDeviceMac());
        } else if (!deviceInform.getOmadacId().equals(lastDeviceInform.getOmadacId()) || !deviceInform.getSiteId().equals(lastDeviceInform.getSiteId())) {
            this.a(17, deviceInform.getOmadacId(), deviceInform.getSiteId(), deviceInform.getDeviceMac());
            realtimeStat = new com.tplink.smb.omada.monitor.statistic.port.a.d.d(deviceInform.getOmadacId(), deviceInform.getSiteId(), deviceInform.getDeviceMac());
        } else {
            realtimeStat = this.b.d(lastDeviceInform.getDeviceMac());
        }
        if (Objects.isNull(realtimeStat)) {
            realtimeStat = new com.tplink.smb.omada.monitor.statistic.port.a.d.d(deviceInform.getOmadacId(), deviceInform.getSiteId(), deviceInform.getDeviceMac());
        }
        if (lastDeviceInform != null && lastDeviceInform.getTimestamp() != 0L) {
            long messageTime = deviceInform.getTimestamp() / 1000L / 300L;
            long cacheTime = lastDeviceInform.getTimestamp() / 1000L / 300L;
            a.debug("save PeriodStat in cache is {}", (Object)realtimeStat);
            this.b.c(realtimeStat);
            if (messageTime > cacheTime) {
                a.debug("messageTime > cacheTime");
                realtimeStat = new com.tplink.smb.omada.monitor.statistic.port.a.d.d(deviceInform.getOmadacId(), deviceInform.getSiteId(), deviceInform.getDeviceMac());
                realtimeStat.a(deviceInform, lastDeviceInform, (long)deviceInform.getTimestamp());
                a.debug("Another 5 min save Realtime Stat in cache is {}", (Object)realtimeStat);
                this.b.b(realtimeStat);
            } else {
                a.debug("messageTime <= cacheTime,messageTime is:{},cacheTime is:{}", (Object)messageTime, (Object)cacheTime);
                realtimeStat.a(deviceInform, lastDeviceInform, (long)deviceInform.getTimestamp());
                this.b.a(realtimeStat);
            }
        } else {
            realtimeStat.a(deviceInform, lastDeviceInform, (long)deviceInform.getTimestamp());
            this.b.c(realtimeStat);
            this.b.a(realtimeStat);
        }
        this.b.a(deviceInform);
    }

    public Set<String> a(long time) {
        a.debug("start to calculate olt stat.");
        Collection<String> siteMacPairs = this.b.c();
        if (CollectionUtils.isEmpty(siteMacPairs)) {
            a.info("oltStatCache getSiteMac is empty,time:{}", (Object)time);
            return Collections.EMPTY_SET;
        }
        HashMap siteMacsMap = new HashMap(16);
        siteMacPairs.forEach(siteMacPair -> {
            try {
                String siteId = siteMacPair.split(":")[0];
                String mac = siteMacPair.split(":")[1];
                if (siteMacsMap.containsKey(siteId)) {
                    ((Set)siteMacsMap.get(siteId)).add(mac);
                } else {
                    siteMacsMap.put(siteId, new HashSet<String>(Collections.singleton(mac)));
                }
            }
            catch (Exception ex) {
                a.warn("site mac pairs in cache error: {}, {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)siteMacPair), (Object)ex);
            }
        });
        String omadacId = this.b.d();
        for (Map.Entry siteMacsPair : siteMacsMap.entrySet()) {
            a.debug("olt macs :{}", siteMacsPair.getValue());
            this.a(omadacId, (String)siteMacsPair.getKey(), (Collection)siteMacsPair.getValue(), time);
        }
        return siteMacsMap.keySet();
    }

    public Set<String> a(long start, long end, N granularity) {
        Collection<String> siteMacPairs = this.b.c();
        if (CollectionUtils.isEmpty(siteMacPairs)) {
            return Collections.EMPTY_SET;
        }
        HashMap<String, Set<String>> siteMacsMap = new HashMap<String, Set<String>>(16);
        this.a(siteMacsMap, siteMacPairs);
        String omadacId = this.b.d();
        for (Map.Entry siteMacsPair : siteMacsMap.entrySet()) {
            this.a(start, end, granularity, omadacId, (String)siteMacsPair.getKey(), (Collection)siteMacsPair.getValue());
        }
        return siteMacsMap.keySet();
    }

    private void a(Map<String, Set<String>> siteMacsMap, Collection<String> siteMacPairs) {
        siteMacPairs.forEach(siteMacPair -> {
            try {
                String siteId = siteMacPair.split(":")[0];
                String mac = siteMacPair.split(":")[1];
                if (siteMacsMap.containsKey(siteId)) {
                    ((Set)siteMacsMap.get(siteId)).add(mac);
                } else {
                    siteMacsMap.put(siteId, new HashSet<String>(Collections.singleton(mac)));
                }
            }
            catch (Exception ex) {
                a.warn("site mac pairs in cache error: {}, {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)siteMacPair), (Object)ex);
            }
        });
    }

    public void a(String omadacId, String siteId, Collection<String> oltMacs, long time) {
        oltMacs.forEach(mac -> {
            com.tplink.smb.omada.monitor.statistic.port.a.d.d stat = this.b.a((String)mac, time);
            int activeOnuCounts = this.a((String)mac, omadacId);
            if (stat != null && stat.d().equals(omadacId) && stat.e().equals(siteId)) {
                a.debug("transfer stat :{}", (Object)stat);
                stat.b(activeOnuCounts);
                for (Map.Entry<String, com.tplink.smb.omada.monitor.statistic.port.a.d.a> entry : stat.c().entrySet()) {
                    com.tplink.smb.omada.monitor.statistic.port.a.d.a portTraffic = entry.getValue();
                    portTraffic.a(N.a);
                }
                a.debug("save olt 5min stat :{}", (Object)stat);
                this.c.a(stat, time);
            } else {
                this.b.b(siteId, (String)mac);
            }
        });
    }

    public void a(String omadacId, String siteId, long time) {
        Collection<String> macs = this.b.b(siteId);
        if (CollectionUtils.isEmpty(macs)) {
            return;
        }
        this.a(omadacId, siteId, time, macs);
    }

    private void a(String omadacId, String siteId, long time, Collection<String> macs) {
        ArrayList<String> macList = new ArrayList<String>(macs);
        macList.forEach(mac -> {
            com.tplink.smb.omada.monitor.statistic.port.a.d.d stat = this.b.a((String)mac, time);
            int activeOnuCounts = this.a((String)mac, omadacId);
            if (stat != null && stat.d().equals(omadacId) && stat.e().equals(siteId)) {
                a.debug("transfer stat :{}", (Object)stat);
                stat.b(activeOnuCounts);
                for (Map.Entry<String, com.tplink.smb.omada.monitor.statistic.port.a.d.a> entry : stat.c().entrySet()) {
                    com.tplink.smb.omada.monitor.statistic.port.a.d.a portTraffic = entry.getValue();
                    portTraffic.a(N.a);
                }
                a.debug("save olt 5min stat :{}", (Object)stat);
                this.c.a(stat, time);
            } else {
                this.b.b(siteId, (String)mac);
            }
        });
    }

    public void a(int mode, String omadacId, String siteId, String mac) {
        if ((1 & mode) == 1) {
            this.b.c(siteId, mac);
        }
    }

    public void a(int mode, String omadacId, String siteId, List<String> macs) {
        if (com.tplink.smb.omada.monitor.common.g.a.a((String)omadacId)) {
            return;
        }
        if ((1 & mode) == 1) {
            for (String mac : macs) {
                this.b.c(siteId, mac);
            }
        }
    }

    public void a(long start, long end, N granularity, String omadacId, String siteId) {
        Collection<String> oltMacs = this.b.b(siteId);
        if (CollectionUtils.isEmpty(oltMacs)) {
            return;
        }
        this.a(start, end, granularity, omadacId, siteId, oltMacs);
    }

    private void a(long start, long end, N granularity, String omadacId, String siteId, Collection<String> oltMacs) {
        com.tplink.smb.omada.monitor.statistic.c.b.a targetOltStatRepository;
        com.tplink.smb.omada.monitor.statistic.c.b.a sourceOltStatRepository;
        if (granularity == N.c) {
            sourceOltStatRepository = this.c;
            targetOltStatRepository = this.d;
        } else if (granularity == N.d) {
            sourceOltStatRepository = this.d;
            targetOltStatRepository = this.e;
        } else {
            return;
        }
        if (OmadacType.s() && granularity == N.c) {
            a.info("[STAT] {\"statName\":\"deviceCountInfo\",\"omadacId\":\"{}\",\"siteId\":\"{}\",\"deviceType\":\"ltitch\",\"macList\":\"{}\"}", new Object[]{omadacId, siteId, oltMacs});
        }
        a.debug("statistic oltstat{} omadacId: {} siteId: {} macs: {}", new Object[]{granularity.a(), omadacId, siteId, oltMacs});
        if (CollectionUtils.isEmpty(oltMacs)) {
            return;
        }
        ArrayList<com.tplink.smb.omada.monitor.statistic.port.a.d.d> oltStats = new ArrayList<com.tplink.smb.omada.monitor.statistic.port.a.d.d>();
        oltMacs.forEach(mac -> {
            DeviceStatQueryDTO query = new DeviceStatQueryDTO(omadacId, siteId, (String)mac, (Long)start, (Long)end);
            List<OltStatDTO> list = sourceOltStatRepository.b(query);
            if (!CollectionUtils.isEmpty(list)) {
                com.tplink.smb.omada.monitor.statistic.port.a.d.d oltStat = new com.tplink.smb.omada.monitor.statistic.port.a.d.d(omadacId, siteId, (String)mac, list, end, granularity);
                oltStats.add(oltStat);
                if (oltStats.size() >= 100) {
                    targetOltStatRepository.a(oltStats, end);
                    oltStats.clear();
                }
            }
        });
        targetOltStatRepository.a(oltStats, end);
    }

    public List<OltStatDTO> a(DeviceStatQueryDTO query, N granularity) {
        switch (granularity) {
            case a: {
                return this.c.b(query);
            }
            case c: {
                return this.d.b(query);
            }
            case d: {
                return this.e.b(query);
            }
        }
        return Collections.emptyList();
    }

    public List<MacUtilDTO> a(N granularity, String omadacId, String siteId, long start, long end) {
        switch (granularity) {
            case a: {
                return this.c.g(omadacId, siteId, start, end);
            }
            case c: {
                return this.d.g(omadacId, siteId, start, end);
            }
            case d: 
            case e: {
                return this.e.g(omadacId, siteId, start, end);
            }
        }
        a.info("invalid timeRange");
        return Collections.emptyList();
    }

    public List<MacUtilDTO> b(N granularity, String omadacId, String siteId, long start, long end) {
        switch (granularity) {
            case a: {
                return this.c.h(omadacId, siteId, start, end);
            }
            case c: {
                return this.d.h(omadacId, siteId, start, end);
            }
            case d: 
            case e: {
                return this.e.h(omadacId, siteId, start, end);
            }
        }
        a.info("invalid timeRange");
        return Collections.emptyList();
    }

    private int a(String mac, String omadacId) {
        OnuManagementRequestInternalDTO onuManagementListQueryRequestDTO = new OnuManagementRequestInternalDTO();
        onuManagementListQueryRequestDTO.setMac(mac);
        onuManagementListQueryRequestDTO.setOmadacId(omadacId);
        OperationResponse onuInformationConfigListResponse = this.g.a(onuManagementListQueryRequestDTO);
        if (Objects.isNull(onuInformationConfigListResponse)) {
            a.warn("No OnuInformationConfigList Response");
            return 0;
        }
        if (!onuInformationConfigListResponse.success()) {
            return 0;
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)onuInformationConfigListResponse.getResult()))) {
            return 0;
        }
        a.debug("OnuInformationConfigList size is {}", (Object)((List)onuInformationConfigListResponse.getResult()).size());
        return (int)((List)onuInformationConfigListResponse.getResult()).stream().filter(onuInformationConfigDTO -> Objects.equals(onuInformationConfigDTO.getActiveStatus(), k.a)).count();
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.a((OltInformDomainEventDTO)object);
    }
}

