/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.statistic.e;

import com.google.common.collect.Sets;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.DeviceOutlineDTO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.ActiveDeviceVO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.DeviceTrafficActivityVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.ApStatDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.BaseDeviceStatDTO;
import com.tplink.smb.omada.monitor.statistic.common.b.a;
import com.tplink.smb.omada.monitor.statistic.common.dto.DeviceStatQueryDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.LiteActiveSsidDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.MacTrafficDTO;
import com.tplink.smb.omada.monitor.statistic.e.f;
import com.tplink.smb.omada.monitor.statistic.e.h;
import com.tplink.smb.omada.monitor.statistic.port.a.b.b;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class e {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(e.class);
    @Autowired
    private b b;
    @Autowired
    private f c;
    @Autowired
    private h d;
    @Autowired
    private com.tplink.smb.omada.manager.device.api.internal.device.b e;
    @Autowired
    private com.tplink.smb.omada.monitor.report.a f;

    public List<ActiveDeviceVO> a(String omadacId, String siteId, Long start, Long end, int numberMostActivities, int numberDistribution) {
        N granularity = N.a((long)start, (long)end);
        granularity = N.d.equals((Object)granularity) ? granularity : N.c;
        Long startTime = com.tplink.smb.omada.monitor.statistic.common.b.f.a(start, granularity);
        Long endTime = com.tplink.smb.omada.monitor.statistic.common.b.f.b(end, granularity);
        Map<String, DeviceOutlineDTO> deviceMap = this.e.a(new com.tplink.smb.omada.manager.device.api.internal.device.dto.b(omadacId, siteId, DeviceTypeEnum.a.b())).stream().filter(DeviceOutlineDTO::isIndbStatus).collect(Collectors.toMap(DeviceOutlineDTO::getMac, v2 -> v2, (v1, v2) -> v1));
        if (CollectionUtils.isEmpty(deviceMap)) {
            return Collections.emptyList();
        }
        List<MacTrafficDTO> trafficList = this.a(granularity, omadacId, siteId, (long)startTime, (long)endTime);
        if (CollectionUtils.isEmpty(trafficList)) {
            return Collections.emptyList();
        }
        int limit = Math.min(Math.max(numberMostActivities, numberDistribution), deviceMap.keySet().size());
        return com.tplink.smb.omada.monitor.statistic.common.b.e.a(deviceMap, trafficList, limit);
    }

    public List<LiteActiveSsidDTO> a(String omadacId, String siteId) {
        return this.b(omadacId, siteId);
    }

    private List<ActiveDeviceVO> b(String omadacId, String siteId, Long start, Long end, int numberMostActivities, int numberDistribution) {
        Map<String, DeviceOutlineDTO> deviceMap = this.e.a(new com.tplink.smb.omada.manager.device.api.internal.device.dto.b(omadacId, siteId, DeviceTypeEnum.a.b())).stream().filter(DeviceOutlineDTO::isIndbStatus).collect(Collectors.toMap(DeviceOutlineDTO::getMac, v2 -> v2, (v1, v2) -> v1));
        if (CollectionUtils.isEmpty(deviceMap)) {
            return Collections.emptyList();
        }
        end = end - 720L;
        long dbEndTime = end / 3600L * 3600L;
        long cacheEndTime = (end / 3600L + 1L) * 3600L;
        List<MacTrafficDTO> trafficList = this.a(N.c, omadacId, siteId, (long)start, dbEndTime);
        if (a.isDebugEnabled()) {
            a.debug("get Lite Active Devices in db is {} time {}", (Object)x.a(trafficList), (Object)dbEndTime);
        }
        List<MacTrafficDTO> macTrafficByCache = this.c.a(omadacId, siteId, (Long)cacheEndTime);
        if (a.isDebugEnabled()) {
            a.debug("get Lite Active Devices in cache is {} time {}", (Object)x.a(macTrafficByCache), (Object)cacheEndTime);
        }
        if (CollectionUtils.isEmpty(trafficList = this.a(trafficList, macTrafficByCache))) {
            return Collections.emptyList();
        }
        int limit = Math.min(Math.max(numberMostActivities, numberDistribution), deviceMap.keySet().size());
        List<ActiveDeviceVO> activeAps = com.tplink.smb.omada.monitor.statistic.common.b.e.a(deviceMap, trafficList, limit);
        this.b.b(activeAps, omadacId, siteId, start, end);
        return activeAps;
    }

    private boolean a(Long end, N granularity) {
        long endTime;
        if (!N.c.equals((Object)granularity)) {
            return false;
        }
        long currentTime = System.currentTimeMillis() / 1000L / 3600L;
        return currentTime - (endTime = end / 3600L) < 2L;
    }

    private List<MacTrafficDTO> a(List<MacTrafficDTO> trafficList, List<MacTrafficDTO> macTrafficByCache) {
        if (CollectionUtils.isEmpty(trafficList)) {
            return macTrafficByCache;
        }
        if (CollectionUtils.isEmpty(macTrafficByCache)) {
            return trafficList;
        }
        Map trafficMap = trafficList.stream().collect(Collectors.toMap(MacTrafficDTO::getMac, Function.identity()));
        for (MacTrafficDTO macTrafficDTO : macTrafficByCache) {
            String mac = macTrafficDTO.getMac();
            if (trafficMap.containsKey(mac)) {
                Long traffic = ((MacTrafficDTO)trafficMap.get(macTrafficDTO.getMac())).getTraffic() + macTrafficDTO.getTraffic();
                trafficMap.put(mac, new MacTrafficDTO(mac, traffic));
                continue;
            }
            trafficMap.put(mac, macTrafficDTO);
        }
        return trafficMap.values().stream().sorted(Comparator.comparing(MacTrafficDTO::getTraffic).reversed()).collect(Collectors.toList());
    }

    public List<DeviceTrafficActivityVO> a(String omadacId, String siteId, N granularity, Long start, Long end) {
        DeviceStatQueryDTO statisticQuery = new DeviceStatQueryDTO(omadacId, siteId, start, end);
        List<ApStatDTO> list = this.d.a(statisticQuery, granularity);
        List<DeviceTrafficActivityVO> deviceTrafficActivityVOS = com.tplink.smb.omada.monitor.statistic.common.b.a.a(list, granularity.equals((Object)N.e));
        if (a.isDebugEnabled()) {
            a.debug("get Lite Traffic Activities is {}", (Object)x.a(deviceTrafficActivityVOS));
        }
        deviceTrafficActivityVOS = this.f.a(start, end, granularity, deviceTrafficActivityVOS, DeviceTrafficActivityVO.class);
        return deviceTrafficActivityVOS;
    }

    public List<DeviceTrafficActivityVO> a(String omadacId, String siteId, Long time) {
        HashSet attrs;
        Long start = time - 86400L - 3600L;
        DeviceStatQueryDTO statisticQuery = new DeviceStatQueryDTO(omadacId, siteId, "all_ap", start, time, attrs = Sets.newHashSet((Object[])new String[]{"t2g", "t5g", "t5g2", "t6g", "time"}), null);
        List<ApStatDTO> list = this.c.a(statisticQuery, N.c);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        list = new ArrayList(list.stream().collect(Collectors.toMap(BaseDeviceStatDTO::getTime, v2 -> v2, (v1, v2) -> v2, TreeMap::new)).values());
        int size = list.size();
        ArrayList<ApStatDTO> sampleList = new ArrayList<ApStatDTO>();
        long leftTime = com.tplink.smb.omada.monitor.statistic.common.b.f.d(start);
        long rightTime = leftTime + 7200L;
        int index = 0;
        while (leftTime <= time) {
            ApStatDTO statDTO = new ApStatDTO();
            if (index + 1 > size) {
                statDTO.setTime(leftTime);
            } else if (list.get(index).getTime() < rightTime && list.get(index).getTime() >= leftTime) {
                if (index + 1 < size && list.get(index + 1).getTime() < rightTime && list.get(index + 1).getTime() >= leftTime) {
                    statDTO = this.a(list.get(index), list.get(index + 1));
                    ++index;
                } else {
                    statDTO = list.get(index);
                }
                ++index;
            } else {
                statDTO.setTime(leftTime);
            }
            sampleList.add(statDTO);
            leftTime = rightTime;
            rightTime = leftTime + 7200L;
        }
        return com.tplink.smb.omada.monitor.statistic.common.b.a.a(sampleList, false);
    }

    private List<MacTrafficDTO> a(N granularity, String omadacId, String siteId, long start, long end) {
        return this.c.b(omadacId, siteId);
    }

    private List<LiteActiveSsidDTO> b(String omadacId, String siteId) {
        return this.c.c(omadacId, siteId);
    }

    private ApStatDTO a(ApStatDTO pre, ApStatDTO next) {
        if (pre == null) {
            return next;
        }
        if (next == null) {
            return pre;
        }
        ApStatDTO statDTO = new ApStatDTO();
        statDTO.setTime(pre.getTime().longValue());
        statDTO.setTraffic2g(ApStatDTO.ApTrafficDTO.merge((ApStatDTO.ApTrafficDTO)pre.getTraffic2g(), (ApStatDTO.ApTrafficDTO)next.getTraffic2g()));
        statDTO.setTraffic5g(ApStatDTO.ApTrafficDTO.merge((ApStatDTO.ApTrafficDTO)pre.getTraffic5g(), (ApStatDTO.ApTrafficDTO)next.getTraffic5g()));
        statDTO.setTraffic5g2(ApStatDTO.ApTrafficDTO.merge((ApStatDTO.ApTrafficDTO)pre.getTraffic5g2(), (ApStatDTO.ApTrafficDTO)next.getTraffic5g2()));
        statDTO.setTraffic6g(ApStatDTO.ApTrafficDTO.merge((ApStatDTO.ApTrafficDTO)pre.getTraffic6g(), (ApStatDTO.ApTrafficDTO)next.getTraffic6g()));
        return statDTO;
    }
}

