/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.statistic.e;

import com.google.common.collect.Sets;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.DeviceOutlineDTO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.ActiveApsVO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.ActiveDeviceVO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.DeviceTrafficActivityVO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.DeviceTrafficDistributionVO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.DropEapVO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.RetryDropRateVO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.RetryEapVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.ApStatDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.BaseDeviceStatDTO;
import com.tplink.smb.omada.monitor.common.g.a;
import com.tplink.smb.omada.monitor.statistic.common.b.e;
import com.tplink.smb.omada.monitor.statistic.common.dto.ApRetryDropDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.DeviceStatQueryDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.MacTrafficDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.RDRateDTO;
import com.tplink.smb.omada.monitor.statistic.e.c;
import com.tplink.smb.omada.monitor.statistic.e.f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class b {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    @Autowired
    private com.tplink.smb.omada.monitor.statistic.port.a.b.b b;
    @Autowired
    private c c;
    @Autowired
    private com.tplink.smb.omada.manager.device.api.internal.device.b d;
    @Autowired
    private com.tplink.smb.omada.monitor.report.a e;
    @Autowired
    private f f;

    public List<ActiveDeviceVO> a(String omadacId, String siteId, Long start, Long end, int numberMostActivities, int numberDistribution) {
        N granularity = N.a((long)start, (long)end);
        List<ActiveDeviceVO> activeAps = this.b.a(omadacId, siteId, start = com.tplink.smb.omada.monitor.statistic.common.b.f.a(start, granularity), end = com.tplink.smb.omada.monitor.statistic.common.b.f.b(end, granularity));
        if (activeAps != null) {
            a.info("retrieve active ap from cache");
            return activeAps;
        }
        Map<String, DeviceOutlineDTO> deviceMap = this.d.a(new com.tplink.smb.omada.manager.device.api.internal.device.dto.b(omadacId, siteId, DeviceTypeEnum.a.b(), Boolean.valueOf(false), null)).stream().filter(DeviceOutlineDTO::isIndbStatus).collect(Collectors.toMap(DeviceOutlineDTO::getMac, v2 -> v2, (v1, v2) -> v1));
        if (CollectionUtils.isEmpty(deviceMap)) {
            return Collections.emptyList();
        }
        List<MacTrafficDTO> trafficList = this.a(granularity, omadacId, siteId, (long)start, end);
        if (CollectionUtils.isEmpty(trafficList)) {
            return Collections.emptyList();
        }
        int limit = Math.min(Math.max(numberMostActivities, numberDistribution), deviceMap.keySet().size());
        activeAps = com.tplink.smb.omada.monitor.statistic.common.b.e.a(deviceMap, trafficList, limit);
        this.b.a(activeAps, omadacId, siteId, start, end);
        return activeAps;
    }

    public ActiveApsVO b(String omadacId, String siteId, Long start, Long end, int numberMostActivities, int numberDistribution) {
        N granularity = N.a((long)start, (long)end);
        start = com.tplink.smb.omada.monitor.statistic.common.b.f.a(start, granularity);
        end = com.tplink.smb.omada.monitor.statistic.common.b.f.b(end, granularity);
        double totalTraffic = 0.0;
        Map<String, DeviceOutlineDTO> deviceMap = this.d.a(new com.tplink.smb.omada.manager.device.api.internal.device.dto.b(omadacId, siteId, DeviceTypeEnum.a.b(), Boolean.valueOf(false), null)).stream().filter(DeviceOutlineDTO::isIndbStatus).collect(Collectors.toMap(DeviceOutlineDTO::getMac, v2 -> v2, (v1, v2) -> v1));
        if (CollectionUtils.isEmpty(deviceMap)) {
            return new ActiveApsVO(new ArrayList(), Double.valueOf(totalTraffic));
        }
        List<MacTrafficDTO> trafficList = com.tplink.smb.omada.monitor.common.g.a.a((String)omadacId) ? this.a(omadacId, siteId) : this.a(granularity, omadacId, siteId, (long)start, end);
        if (CollectionUtils.isEmpty(trafficList)) {
            return new ActiveApsVO(new ArrayList(), Double.valueOf(totalTraffic));
        }
        int limit = Math.min(Math.max(numberMostActivities, numberDistribution), deviceMap.keySet().size());
        List<ActiveDeviceVO> activeAps = com.tplink.smb.omada.monitor.statistic.common.b.e.a(deviceMap, trafficList, limit);
        totalTraffic = trafficList.stream().mapToDouble(macTrafficDto -> com.tplink.smb.omada.monitor.statistic.common.b.f.a((double)macTrafficDto.getTraffic().longValue() / 1.073741824E9)).sum();
        return new ActiveApsVO(activeAps, Double.valueOf(totalTraffic));
    }

    public List<DeviceTrafficDistributionVO> a(String omadacId, String siteId, Long start, Long end, int numberMostActivities, int numberDistribution, Locale locale) {
        N granularity = N.a((long)start, (long)end);
        List<DeviceTrafficDistributionVO> distributionVOS = this.b.d(omadacId, siteId, start = com.tplink.smb.omada.monitor.statistic.common.b.f.a(start, granularity), end = com.tplink.smb.omada.monitor.statistic.common.b.f.b(end, granularity));
        if (distributionVOS != null) {
            a.info("retrieve ap distribution from cache");
            return distributionVOS;
        }
        Map<String, DeviceOutlineDTO> deviceMap = this.d.a(new com.tplink.smb.omada.manager.device.api.internal.device.dto.b(omadacId, siteId, DeviceTypeEnum.a.b(), Boolean.valueOf(true), null)).stream().filter(DeviceOutlineDTO::isIndbStatus).collect(Collectors.toMap(DeviceOutlineDTO::getMac, v2 -> v2, (v1, v2) -> v1));
        if (CollectionUtils.isEmpty(deviceMap)) {
            return Collections.emptyList();
        }
        Set<String> macSet = deviceMap.keySet();
        int limit = Math.min(Math.max(numberMostActivities, numberDistribution), macSet.size());
        List<MacTrafficDTO> trafficList = this.a(granularity, omadacId, siteId, (long)start, end);
        if (CollectionUtils.isEmpty(trafficList)) {
            return Collections.emptyList();
        }
        distributionVOS = com.tplink.smb.omada.monitor.statistic.common.b.e.a(deviceMap, trafficList, limit, locale);
        this.b.d(distributionVOS, omadacId, siteId, start, end);
        return distributionVOS;
    }

    public List<DeviceTrafficActivityVO> a(String omadacId, String siteId, Long start, Long end) {
        N granularity = N.a((long)start, (long)end);
        DeviceStatQueryDTO statisticQuery = new DeviceStatQueryDTO(omadacId, siteId, "all_ap", start, end);
        List<ApStatDTO> list = this.c.a(statisticQuery, granularity);
        List<DeviceTrafficActivityVO> deviceTrafficActivityVOS = com.tplink.smb.omada.monitor.statistic.common.b.a.a(list, granularity.equals((Object)N.e));
        deviceTrafficActivityVOS = this.e.a(start, end, granularity, deviceTrafficActivityVOS, DeviceTrafficActivityVO.class);
        return deviceTrafficActivityVOS;
    }

    public List<DeviceTrafficActivityVO> a(String omadacId, String siteId, Long time) {
        HashSet attrs;
        Long start = time - 86400L - 3600L;
        DeviceStatQueryDTO statisticQuery = new DeviceStatQueryDTO(omadacId, siteId, "all_ap", start, time, attrs = Sets.newHashSet((Object[])new String[]{"t2g", "t5g", "t5g2", "t6g", "time"}), null);
        List<ApStatDTO> list = this.c.a(statisticQuery, N.c);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        list = new ArrayList(list.stream().collect(Collectors.toMap(BaseDeviceStatDTO::getTime, v2 -> v2, (v1, v2) -> v2, TreeMap::new)).values());
        int size = list.size();
        ArrayList<ApStatDTO> sampleList = new ArrayList<ApStatDTO>();
        long leftTime = com.tplink.smb.omada.monitor.statistic.common.b.f.d(start);
        long rightTime = leftTime + 7200L;
        int index = 0;
        while (leftTime <= time) {
            ApStatDTO statDTO = new ApStatDTO();
            if (index + 1 > size) {
                statDTO.setTime(leftTime);
            } else if (list.get(index).getTime() < rightTime && list.get(index).getTime() >= leftTime) {
                if (index + 1 < size && list.get(index + 1).getTime() < rightTime && list.get(index + 1).getTime() >= leftTime) {
                    statDTO = this.a(list.get(index), list.get(index + 1));
                    ++index;
                } else {
                    statDTO = list.get(index);
                }
                ++index;
            } else {
                statDTO.setTime(leftTime);
            }
            sampleList.add(statDTO);
            leftTime = rightTime;
            rightTime = leftTime + 7200L;
        }
        return com.tplink.smb.omada.monitor.statistic.common.b.a.a(sampleList, false);
    }

    public List<DeviceTrafficActivityVO> b(String omadacId, String siteId, Long start, Long end) {
        N granularity = N.c;
        DeviceStatQueryDTO statisticQuery = new DeviceStatQueryDTO(omadacId, siteId, "all_ap", start, end);
        List<ApStatDTO> list = this.c.a(statisticQuery, granularity);
        return com.tplink.smb.omada.monitor.statistic.common.b.a.a(list, false);
    }

    public RetryDropRateVO a(String omadacId, String siteId, Long start, Long end, int count) {
        Map<String, DeviceOutlineDTO> deviceMap = this.d.a(new com.tplink.smb.omada.manager.device.api.internal.device.dto.b(omadacId, siteId, DeviceTypeEnum.a.b(), Boolean.valueOf(true), null)).stream().filter(DeviceOutlineDTO::isIndbStatus).collect(Collectors.toMap(DeviceOutlineDTO::getMac, v2 -> v2, (v1, v2) -> v1));
        if (CollectionUtils.isEmpty(deviceMap)) {
            return new RetryDropRateVO();
        }
        Set<String> macSet = deviceMap.keySet();
        N granularity = N.a((long)start, (long)end);
        if (macSet.size() > count * 2) {
            macSet = this.a(omadacId, siteId, macSet, (long)start, (long)end, granularity, count);
        }
        return this.a(omadacId, siteId, macSet, deviceMap, (long)start, end, granularity);
    }

    private List<MacTrafficDTO> a(N granularity, String omadacId, String siteId, long start, long end) {
        List<MacTrafficDTO> trafficList = this.b.f(omadacId, siteId, start, end);
        if (trafficList != null) {
            this.b.f(trafficList, omadacId, siteId, start, end);
            return trafficList;
        }
        return this.c.a(granularity, omadacId, siteId, start, end);
    }

    private List<MacTrafficDTO> a(String omadacId, String siteId) {
        return this.f.b(omadacId, siteId);
    }

    private RetryDropRateVO a(String omadacId, String siteId, Set<String> macSet, Map<String, DeviceOutlineDTO> deviceMap, long start, long end, N granularity) {
        LinkedList<RetryEapVO> retryEapVOS = new LinkedList<RetryEapVO>();
        LinkedList<DropEapVO> dropEapVOS = new LinkedList<DropEapVO>();
        for (String mac : macSet) {
            ApRetryDropDTO apRetryDrop;
            DeviceStatQueryDTO statisticQuery = new DeviceStatQueryDTO(omadacId, siteId, mac, (Long)start, (Long)end);
            List<ApStatDTO> list = this.c.a(statisticQuery, granularity);
            if (list == null) {
                return new RetryDropRateVO();
            }
            list = new ArrayList(list.stream().collect(Collectors.toMap(BaseDeviceStatDTO::getTime, v2 -> v2, (v1, v2) -> v2, TreeMap::new)).values());
            DeviceOutlineDTO device = deviceMap.get(mac);
            if (!granularity.equals((Object)N.e)) {
                apRetryDrop = com.tplink.smb.omada.monitor.statistic.common.b.a.a(device, list, false);
                if (apRetryDrop.getRetryEapVO() == null || apRetryDrop.getDropEapVO() == null) continue;
                retryEapVOS.add(apRetryDrop.getRetryEapVO());
                dropEapVOS.add(apRetryDrop.getDropEapVO());
                continue;
            }
            apRetryDrop = com.tplink.smb.omada.monitor.statistic.common.b.a.a(device, list, true);
            if (apRetryDrop.getRetryEapVO() == null || apRetryDrop.getDropEapVO() == null) continue;
            retryEapVOS.add(apRetryDrop.getRetryEapVO());
            dropEapVOS.add(apRetryDrop.getDropEapVO());
        }
        retryEapVOS.sort((retry1, retry2) -> retry2.getAvg().compareTo(retry1.getAvg()));
        dropEapVOS.sort((drop1, drop2) -> drop2.getAvg().compareTo(drop1.getAvg()));
        RetryDropRateVO retryDropRateVO = new RetryDropRateVO();
        retryDropRateVO.setDroppedEaps(dropEapVOS);
        retryDropRateVO.setRetryEaps(retryEapVOS);
        return retryDropRateVO;
    }

    private Set<String> a(String omadacId, String siteId, Set<String> macSet, long start, long end, N granularity, int count) {
        HashSet<String> targetMacSet = new HashSet<String>();
        int counter = 0;
        List<RDRateDTO> rRateList = this.c.b(granularity, omadacId, siteId, start, end);
        for (RDRateDTO dto : rRateList) {
            if (!macSet.contains(dto.get_id())) continue;
            targetMacSet.add(dto.get_id());
            if (count <= 0 || ++counter < count) continue;
            break;
        }
        ArrayList<RDRateDTO> dRateList = new ArrayList<RDRateDTO>(rRateList);
        dRateList.sort(Comparator.comparingDouble(RDRateDTO::getDr).reversed());
        counter = 0;
        for (RDRateDTO dto : dRateList) {
            if (!macSet.contains(dto.get_id())) continue;
            targetMacSet.add(dto.get_id());
            if (count <= 0 || ++counter < count) continue;
            break;
        }
        return targetMacSet;
    }

    private ApStatDTO a(ApStatDTO pre, ApStatDTO next) {
        if (pre == null) {
            return next;
        }
        if (next == null) {
            return pre;
        }
        ApStatDTO statDTO = new ApStatDTO();
        statDTO.setTime(pre.getTime().longValue());
        statDTO.setTraffic2g(ApStatDTO.ApTrafficDTO.merge((ApStatDTO.ApTrafficDTO)pre.getTraffic2g(), (ApStatDTO.ApTrafficDTO)next.getTraffic2g()));
        statDTO.setTraffic5g(ApStatDTO.ApTrafficDTO.merge((ApStatDTO.ApTrafficDTO)pre.getTraffic5g(), (ApStatDTO.ApTrafficDTO)next.getTraffic5g()));
        statDTO.setTraffic5g2(ApStatDTO.ApTrafficDTO.merge((ApStatDTO.ApTrafficDTO)pre.getTraffic5g2(), (ApStatDTO.ApTrafficDTO)next.getTraffic5g2()));
        statDTO.setTraffic6g(ApStatDTO.ApTrafficDTO.merge((ApStatDTO.ApTrafficDTO)pre.getTraffic6g(), (ApStatDTO.ApTrafficDTO)next.getTraffic6g()));
        return statDTO;
    }
}

