/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.statistic.common.b;

import com.tplink.smb.omada.common.constant.DeviceStatusEnum;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.DeviceOutlineDTO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.ActiveDeviceVO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.DeviceTrafficActivityVO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.DeviceTrafficDistributionVO;
import com.tplink.smb.omada.monitor.api.web.health.dto.ActiveApHealthVO;
import com.tplink.smb.omada.monitor.api.web.health.dto.ActiveOswHealthVO;
import com.tplink.smb.omada.monitor.api.web.report.vo.NameMacTrafficVO;
import com.tplink.smb.omada.monitor.api.web.report.vo.NameRebootVO;
import com.tplink.smb.omada.monitor.api.web.report.vo.NameTrafficVO;
import com.tplink.smb.omada.monitor.common.d.a;
import com.tplink.smb.omada.monitor.report.dto.SsidNameTrafficDTO;
import com.tplink.smb.omada.monitor.statistic.common.b.f;
import com.tplink.smb.omada.monitor.statistic.common.dto.MacRebootTimesDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.MacTrafficDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class e {
    private static final String a = "OTHERS";

    public static List<DeviceTrafficActivityVO> a(List<DeviceTrafficActivityVO> list) {
        int week = 7;
        int size = list.size();
        ArrayList<List<DeviceTrafficActivityVO>> listGroup = new ArrayList<List<DeviceTrafficActivityVO>>((int)Math.ceil(1.0 * (double)size / (double)week));
        for (int index = 0; index < size; index += week) {
            int next = Math.min(index + week, size);
            listGroup.add(list.subList(index, next));
        }
        ArrayList<DeviceTrafficActivityVO> weekTrafficActivities = new ArrayList<DeviceTrafficActivityVO>(listGroup.size());
        for (List list2 : listGroup) {
            double tx = 0.0;
            double rx = 0.0;
            for (DeviceTrafficActivityVO temp : list2) {
                tx += temp.getTxData().doubleValue();
                rx += temp.getDxData().doubleValue();
            }
            DeviceTrafficActivityVO weekTrafficActivity = new DeviceTrafficActivityVO();
            weekTrafficActivity.setTxData(Double.valueOf(f.a(tx)));
            weekTrafficActivity.setDxData(Double.valueOf(f.a(rx)));
            weekTrafficActivity.setTime(((DeviceTrafficActivityVO)list2.get(list2.size() - 1)).getTime().longValue());
            weekTrafficActivities.add(weekTrafficActivity);
        }
        weekTrafficActivities.sort(Comparator.comparing(DeviceTrafficActivityVO::getTime));
        return weekTrafficActivities;
    }

    public static List<ActiveDeviceVO> a(Map<String, DeviceOutlineDTO> deviceMap, List<MacTrafficDTO> trafficList, int limit) {
        ArrayList<ActiveDeviceVO> activities = new ArrayList<ActiveDeviceVO>();
        for (MacTrafficDTO dto : trafficList) {
            if (deviceMap.get(dto.getMac()) != null) {
                DeviceOutlineDTO deviceOutlineDTO = deviceMap.get(dto.getMac());
                ActiveDeviceVO activeDeviceVO = new ActiveDeviceVO();
                activeDeviceVO.setMac(dto.getMac());
                int status = 1;
                DeviceStatusEnum deviceStatus = DeviceStatusEnum.a((Integer)deviceOutlineDTO.getStatus());
                if (deviceStatus != null) {
                    status = deviceStatus.l().equals((Object)DeviceStatusEnum.a.b) ? 0 : 1;
                }
                activeDeviceVO.setStatus(Integer.valueOf(status));
                activeDeviceVO.setName(deviceOutlineDTO.getName());
                activeDeviceVO.setModel(deviceOutlineDTO.getModel());
                activeDeviceVO.setModelVersion(deviceOutlineDTO.getModelVersion());
                activeDeviceVO.setTraffic(Double.valueOf(f.a((double)dto.getTraffic().longValue() / 1.073741824E9)));
                activeDeviceVO.setDeviceSeriesType(deviceOutlineDTO.getDeviceSeriesType());
                activeDeviceVO.setSwitchType(deviceOutlineDTO.getSwitchType());
                activities.add(activeDeviceVO);
            }
            if (activities.size() < limit) continue;
            break;
        }
        return activities;
    }

    public static List<ActiveApHealthVO> b(Map<String, DeviceOutlineDTO> deviceMap, List<MacTrafficDTO> trafficList, int limit) {
        ArrayList<ActiveApHealthVO> activities = new ArrayList<ActiveApHealthVO>();
        if (CollectionUtils.isEmpty(trafficList)) {
            for (Map.Entry<String, DeviceOutlineDTO> entry : deviceMap.entrySet()) {
                String mac = entry.getKey();
                DeviceOutlineDTO deviceOutlineDTO = entry.getValue();
                ActiveApHealthVO activeDeviceVO = new ActiveApHealthVO();
                activeDeviceVO.setMac(mac);
                activeDeviceVO.setName(deviceOutlineDTO.getName());
                activeDeviceVO.setModel(deviceOutlineDTO.getModel());
                activeDeviceVO.setModelVersion(deviceOutlineDTO.getModelVersion());
                activeDeviceVO.setType(deviceOutlineDTO.getType());
                activeDeviceVO.setTraffic(Long.valueOf(0L));
                activeDeviceVO.setDeviceSeriesType(Optional.ofNullable(deviceOutlineDTO.getDeviceSeriesType()).orElse(1));
                activities.add(activeDeviceVO);
                if (activities.size() < limit) continue;
                break;
            }
        } else {
            for (MacTrafficDTO dto : trafficList) {
                if (deviceMap.get(dto.getMac()) != null) {
                    DeviceOutlineDTO deviceOutlineDTO = deviceMap.get(dto.getMac());
                    ActiveApHealthVO activeDeviceVO = new ActiveApHealthVO();
                    activeDeviceVO.setMac(dto.getMac());
                    activeDeviceVO.setName(deviceOutlineDTO.getName());
                    activeDeviceVO.setModel(deviceOutlineDTO.getModel());
                    activeDeviceVO.setModelVersion(deviceOutlineDTO.getModelVersion());
                    activeDeviceVO.setType(deviceOutlineDTO.getType());
                    activeDeviceVO.setTraffic(dto.getTraffic());
                    activeDeviceVO.setDeviceSeriesType(Optional.ofNullable(deviceOutlineDTO.getDeviceSeriesType()).orElse(1));
                    activities.add(activeDeviceVO);
                }
                if (activities.size() < limit) continue;
                break;
            }
        }
        return activities;
    }

    public static List<ActiveOswHealthVO> c(Map<String, DeviceOutlineDTO> deviceMap, List<MacTrafficDTO> trafficList, int limit) {
        ArrayList<ActiveOswHealthVO> activities = new ArrayList<ActiveOswHealthVO>();
        if (CollectionUtils.isEmpty(trafficList)) {
            for (Map.Entry<String, DeviceOutlineDTO> entry : deviceMap.entrySet()) {
                String mac = entry.getKey();
                DeviceOutlineDTO deviceOutlineDTO = entry.getValue();
                ActiveOswHealthVO activeDeviceVO = new ActiveOswHealthVO();
                activeDeviceVO.setMac(mac);
                activeDeviceVO.setName(deviceOutlineDTO.getName());
                activeDeviceVO.setModel(deviceOutlineDTO.getModel());
                activeDeviceVO.setModelVersion(deviceOutlineDTO.getModelVersion());
                activeDeviceVO.setType(deviceOutlineDTO.getType());
                activeDeviceVO.setTraffic(Long.valueOf(0L));
                activeDeviceVO.setDeviceSeriesType(Optional.ofNullable(deviceOutlineDTO.getDeviceSeriesType()).orElse(1));
                activities.add(activeDeviceVO);
                if (activities.size() < limit) continue;
                break;
            }
        } else {
            for (MacTrafficDTO dto : trafficList) {
                if (deviceMap.get(dto.getMac()) != null) {
                    DeviceOutlineDTO deviceOutlineDTO = deviceMap.get(dto.getMac());
                    ActiveOswHealthVO activeDeviceVO = new ActiveOswHealthVO();
                    activeDeviceVO.setMac(dto.getMac());
                    activeDeviceVO.setName(deviceOutlineDTO.getName());
                    activeDeviceVO.setModel(deviceOutlineDTO.getModel());
                    activeDeviceVO.setModelVersion(deviceOutlineDTO.getModelVersion());
                    activeDeviceVO.setTraffic(dto.getTraffic());
                    activeDeviceVO.setType(deviceOutlineDTO.getType());
                    activeDeviceVO.setDeviceSeriesType(Optional.ofNullable(deviceOutlineDTO.getDeviceSeriesType()).orElse(1));
                    activities.add(activeDeviceVO);
                }
                if (activities.size() < limit) continue;
                break;
            }
        }
        return activities;
    }

    public static List<DeviceTrafficDistributionVO> a(Map<String, DeviceOutlineDTO> deviceMap, List<MacTrafficDTO> trafficList, int limit, Locale locale) {
        ArrayList<DeviceTrafficDistributionVO> distributionVOS = new ArrayList<DeviceTrafficDistributionVO>();
        double totalTraffic = 0.0;
        double topTraffic = 0.0;
        long counter = 0L;
        for (MacTrafficDTO dto : trafficList) {
            if (deviceMap.get(dto.getMac()) == null) continue;
            double traffic = f.a((double)dto.getTraffic().longValue() / 1048576.0);
            if (distributionVOS.size() < limit) {
                DeviceOutlineDTO deviceOutlineDTO = deviceMap.get(dto.getMac());
                DeviceTrafficDistributionVO distribution = new DeviceTrafficDistributionVO();
                distribution.setMac(dto.getMac());
                distribution.setName(deviceOutlineDTO.getName());
                distribution.setTraffic(Double.valueOf(traffic));
                distributionVOS.add(distribution);
                topTraffic += traffic;
            }
            totalTraffic += traffic;
            ++counter;
        }
        if (totalTraffic < 0.0 || counter <= 0L) {
            return Collections.emptyList();
        }
        if (totalTraffic == 0.0) {
            double proportion = 1.0 / (double)counter * 100.0;
            for (DeviceTrafficDistributionVO vo : distributionVOS) {
                vo.setTrafficProportion(Double.valueOf(f.a(proportion)));
            }
            return distributionVOS;
        }
        for (DeviceTrafficDistributionVO vo : distributionVOS) {
            vo.setTrafficProportion(Double.valueOf(f.a(vo.getTraffic() / totalTraffic * 100.0)));
        }
        if (counter > (long)limit) {
            DeviceTrafficDistributionVO distribution = new DeviceTrafficDistributionVO();
            distribution.setName(com.tplink.smb.omada.monitor.common.d.a.a((String)a, (Locale)locale));
            distribution.setTraffic(Double.valueOf(f.a(totalTraffic - topTraffic)));
            distribution.setTrafficProportion(Double.valueOf(f.a((totalTraffic - topTraffic) / totalTraffic * 100.0)));
            distributionVOS.add(distribution);
        }
        return distributionVOS;
    }

    public static List<NameMacTrafficVO> b(Map<String, DeviceOutlineDTO> deviceMap, List<MacTrafficDTO> trafficList, int limit, Locale locale) {
        ArrayList<NameMacTrafficVO> nameMacTrafficVOS = new ArrayList<NameMacTrafficVO>();
        long totalTraffic = 0L;
        long topTraffic = 0L;
        long counter = 0L;
        for (MacTrafficDTO dto : trafficList) {
            if (deviceMap.get(dto.getMac()) == null) continue;
            long traffic = dto.getTraffic();
            if (nameMacTrafficVOS.size() < limit) {
                DeviceOutlineDTO deviceOutlineDTO = deviceMap.get(dto.getMac());
                NameMacTrafficVO nameMacTrafficVO = new NameMacTrafficVO();
                nameMacTrafficVO.setMac(dto.getMac());
                nameMacTrafficVO.setName(deviceOutlineDTO.getName());
                nameMacTrafficVO.setTraffic(Long.valueOf(traffic));
                nameMacTrafficVOS.add(nameMacTrafficVO);
                topTraffic += traffic;
            }
            totalTraffic += traffic;
            ++counter;
        }
        if (totalTraffic < 0L || counter <= 0L) {
            return Collections.emptyList();
        }
        if (counter > (long)limit) {
            NameMacTrafficVO otherVO = new NameMacTrafficVO();
            otherVO.setName(com.tplink.smb.omada.monitor.common.d.a.a((String)a, (Locale)locale));
            otherVO.setTraffic(Long.valueOf(totalTraffic - topTraffic));
            nameMacTrafficVOS.add(otherVO);
        }
        return nameMacTrafficVOS;
    }

    public static List<NameRebootVO> c(Map<String, DeviceOutlineDTO> deviceMap, List<MacRebootTimesDTO> rebootList, int limit, Locale locale) {
        ArrayList<NameRebootVO> nameRebootVOS = new ArrayList<NameRebootVO>();
        int totalRebootTimes = 0;
        int topRebootTimes = 0;
        long counter = 0L;
        for (MacRebootTimesDTO dto : rebootList) {
            int rebootTimes;
            if (deviceMap.get(dto.getMac()) == null) continue;
            int n2 = rebootTimes = dto.getRebootTimes() == null ? 0 : dto.getRebootTimes();
            if (nameRebootVOS.size() < limit) {
                DeviceOutlineDTO deviceOutlineDTO = deviceMap.get(dto.getMac());
                NameRebootVO nameRebootVO = new NameRebootVO();
                nameRebootVO.setName(deviceOutlineDTO.getName());
                nameRebootVO.setRebootTimes(Integer.valueOf(rebootTimes));
                nameRebootVOS.add(nameRebootVO);
                topRebootTimes += rebootTimes;
            }
            totalRebootTimes += rebootTimes;
            ++counter;
        }
        if (totalRebootTimes < 0 || counter <= 0L) {
            return Collections.emptyList();
        }
        if (counter > (long)limit) {
            NameRebootVO nameRebootVO = new NameRebootVO();
            nameRebootVO.setName(com.tplink.smb.omada.monitor.common.d.a.a((String)a, (Locale)locale));
            nameRebootVO.setRebootTimes(Integer.valueOf(totalRebootTimes - topRebootTimes));
            nameRebootVOS.add(nameRebootVO);
        }
        return nameRebootVOS;
    }

    public static List<NameTrafficVO> a(List<SsidNameTrafficDTO> trafficList, int limit, Locale locale) {
        ArrayList<NameTrafficVO> nameTrafficVOS = new ArrayList<NameTrafficVO>();
        long totalTraffic = 0L;
        long topTraffic = 0L;
        long counter = 0L;
        for (SsidNameTrafficDTO dto : trafficList) {
            long traffic = dto.getTraffic();
            if (nameTrafficVOS.size() < limit) {
                NameTrafficVO nameTrafficVO = new NameTrafficVO();
                nameTrafficVO.setName(dto.getSsidName());
                nameTrafficVO.setTraffic(Long.valueOf(traffic));
                nameTrafficVOS.add(nameTrafficVO);
                topTraffic += traffic;
            }
            totalTraffic += traffic;
            ++counter;
        }
        if (totalTraffic < 0L || counter <= 0L) {
            return Collections.emptyList();
        }
        if (counter > (long)limit) {
            NameTrafficVO nameTrafficVO = new NameTrafficVO();
            nameTrafficVO.setName(com.tplink.smb.omada.monitor.common.d.a.a((String)a, (Locale)locale));
            nameTrafficVO.setTraffic(Long.valueOf(totalTraffic - topTraffic));
            nameTrafficVOS.add(nameTrafficVO);
        }
        return nameTrafficVOS;
    }

    @Generated
    private e() {
    }
}

