/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.statistic.common.b;

import com.tplink.smb.omada.common.constant.DeviceStatusEnum;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.DeviceOutlineDTO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.DeviceTrafficActivityVO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.DropEapVO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.DropVO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.RetryEapVO;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.network.RetryVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.ApStatDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.BaseDeviceStatDTO;
import com.tplink.smb.omada.monitor.statistic.common.b.e;
import com.tplink.smb.omada.monitor.statistic.common.b.f;
import com.tplink.smb.omada.monitor.statistic.common.dto.ApRetryDropDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class a {
    public static List<DeviceTrafficActivityVO> a(List<ApStatDTO> list, boolean isWeek) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        list = new ArrayList(list.stream().collect(Collectors.toMap(BaseDeviceStatDTO::getTime, v2 -> v2, (v1, v2) -> v2, TreeMap::new)).values());
        ArrayList<DeviceTrafficActivityVO> apTrafficActivities = new ArrayList<DeviceTrafficActivityVO>(list.size());
        for (ApStatDTO apStat : list) {
            DeviceTrafficActivityVO activity = new DeviceTrafficActivityVO();
            activity.setTime(apStat.getTime().longValue());
            activity.setTxData(Double.valueOf(f.a((double)apStat.sumTx() / 1048576.0)));
            activity.setDxData(Double.valueOf(f.a((double)apStat.sumRx() / 1048576.0)));
            apTrafficActivities.add(activity);
        }
        apTrafficActivities.sort(Comparator.comparing(DeviceTrafficActivityVO::getTime));
        if (isWeek) {
            return e.a(apTrafficActivities);
        }
        return apTrafficActivities;
    }

    public static ApRetryDropDTO a(DeviceOutlineDTO device, List<ApStatDTO> list, boolean isWeek) {
        if (CollectionUtils.isEmpty(list)) {
            return new ApRetryDropDTO();
        }
        if (isWeek) {
            return a.b(device, list);
        }
        return a.a(device, list);
    }

    private static ApRetryDropDTO a(DeviceOutlineDTO device, List<ApStatDTO> list) {
        double retryRateTotal = 0.0;
        double dropRateTotal = 0.0;
        ArrayList<RetryVO> retryVOS = new ArrayList<RetryVO>(list.size());
        ArrayList<DropVO> dropVOS = new ArrayList<DropVO>(list.size());
        for (ApStatDTO apStat : list) {
            long retryPackets = apStat.sumRetryPackets();
            long dropPackets = apStat.sumDropPackets();
            long totalPackets = apStat.sumTotalPackets();
            double tempRetryRate = 0.0;
            double tempDropRate = 0.0;
            if (totalPackets > 0L) {
                tempRetryRate = f.a(1.0 * (double)retryPackets / (double)totalPackets * 100.0);
                tempDropRate = f.a(1.0 * (double)dropPackets / (double)totalPackets * 100.0);
                retryRateTotal += tempRetryRate;
                dropRateTotal += tempDropRate;
            }
            RetryVO retryVO = new RetryVO();
            retryVO.setTime(apStat.getTime().longValue());
            retryVO.setRetryTimes(Integer.valueOf((int)retryPackets));
            retryVO.setRetryRate(Double.valueOf(tempRetryRate));
            retryVOS.add(retryVO);
            DropVO dropVO = new DropVO();
            dropVO.setTime(apStat.getTime().longValue());
            dropVO.setDropTimes(Integer.valueOf((int)dropPackets));
            dropVO.setDropRate(Double.valueOf(tempDropRate));
            dropVOS.add(dropVO);
        }
        return a.a(device, retryVOS, dropVOS, retryRateTotal, dropRateTotal, list.size());
    }

    private static ApRetryDropDTO b(DeviceOutlineDTO device, List<ApStatDTO> list) {
        list.sort(Comparator.comparing(BaseDeviceStatDTO::getTime));
        int week = 7;
        int size = list.size();
        ArrayList<List<ApStatDTO>> listGroup = new ArrayList<List<ApStatDTO>>((int)Math.ceil(1.0 * (double)size / (double)week));
        for (int index = 0; index < size; index += week) {
            int next = Math.min(index + week, size);
            listGroup.add(list.subList(index, next));
        }
        double retryRateTotal = 0.0;
        double dropRateTotal = 0.0;
        ArrayList<RetryVO> retryVOList = new ArrayList<RetryVO>(listGroup.size());
        ArrayList<DropVO> dropVOList = new ArrayList<DropVO>(listGroup.size());
        for (List list2 : listGroup) {
            long totalPackets = 0L;
            long retryPackets = 0L;
            long dropPackets = 0L;
            for (ApStatDTO apStat : list2) {
                retryPackets += apStat.sumRetryPackets();
                dropPackets += apStat.sumDropPackets();
                totalPackets += apStat.sumTotalPackets();
            }
            if (totalPackets == 0L) {
                return new ApRetryDropDTO();
            }
            double tempRetryRate = 1.0 * (double)retryPackets / (double)totalPackets * 100.0;
            double tempDropRate = 1.0 * (double)dropPackets / (double)totalPackets * 100.0;
            retryRateTotal += tempRetryRate;
            dropRateTotal += tempDropRate;
            RetryVO retryVO = new RetryVO();
            retryVO.setRetryTimes(Integer.valueOf((int)retryPackets));
            retryVO.setRetryRate(Double.valueOf(tempRetryRate));
            long moment = ((ApStatDTO)list2.get(list2.size() - 1)).getTime();
            retryVO.setTime(moment);
            retryVOList.add(retryVO);
            DropVO dropVO = new DropVO();
            dropVO.setDropTimes(Integer.valueOf((int)dropPackets));
            dropVO.setDropRate(Double.valueOf(tempDropRate));
            dropVO.setTime(moment);
            dropVOList.add(dropVO);
        }
        return a.a(device, retryVOList, dropVOList, retryRateTotal, dropRateTotal, list.size());
    }

    private static ApRetryDropDTO a(DeviceOutlineDTO device, List<RetryVO> retryVOS, List<DropVO> dropVOS, double retry, double drop, int size) {
        int status = 1;
        DeviceStatusEnum deviceStatus = DeviceStatusEnum.a((Integer)device.getStatus());
        if (deviceStatus != null) {
            status = deviceStatus.l().equals((Object)DeviceStatusEnum.a.b) ? 0 : 1;
        }
        RetryEapVO retryEapVO = new RetryEapVO();
        retryEapVO.setApMac(device.getMac());
        retryEapVO.setName(device.getName());
        retryEapVO.setModel(device.getModel());
        retryEapVO.setModelVersion(device.getModelVersion());
        retryEapVO.setAvg(Double.valueOf(f.a(retry / (double)size)));
        retryEapVO.setRetries(retryVOS);
        retryEapVO.setStatus(Integer.valueOf(status));
        retryEapVO.setType(DeviceTypeEnum.b((String)device.getType()).b());
        retryEapVO.setDeviceSeriesType(device.getDeviceSeriesType());
        DropEapVO dropEapVO = new DropEapVO();
        dropEapVO.setApMac(device.getMac());
        dropEapVO.setName(device.getName());
        dropEapVO.setModel(device.getModel());
        dropEapVO.setModelVersion(device.getModelVersion());
        dropEapVO.setAvg(Double.valueOf(f.a(drop / (double)size)));
        dropEapVO.setDropouts(dropVOS);
        dropEapVO.setStatus(Integer.valueOf(status));
        dropEapVO.setType(DeviceTypeEnum.b((String)device.getType()).b());
        dropEapVO.setDeviceSeriesType(device.getDeviceSeriesType());
        return new ApRetryDropDTO(retryEapVO, dropEapVO);
    }

    @Generated
    private a() {
    }
}

