/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.statistic.a;

import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.common.device.StandardOswPortIndex;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.e.a;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.OswStackManageInfoDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.OswStackMemberInfoDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.QueryOswStackDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.g;
import com.tplink.smb.omada.manager.device.api.internal.dto.osw.QuerySwitchesTypeDTO;
import com.tplink.smb.omada.monitor.api.web.health.dto.WanStatQueryVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.ApStatDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.BaseDeviceStatDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OltStatDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OltStatVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OsgStatDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OswStackDetailStatVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OswStackMemberStatVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OswStackStatQueryVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OswStatDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OswStatVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.PortStatVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.StatQueryVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.WanStatDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.DeviceStatQueryDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.OswStackStatQueryDTO;
import com.tplink.smb.omada.monitor.statistic.e.c;
import com.tplink.smb.omada.monitor.statistic.e.n;
import com.tplink.smb.omada.monitor.statistic.e.r;
import com.tplink.smb.omada.monitor.statistic.e.u;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class f {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(f.class);
    @Autowired
    private c b;
    @Autowired
    private r c;
    @Autowired
    private n d;
    @Autowired
    private u e;
    @Autowired
    private com.tplink.smb.omada.monitor.report.a f;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.site.wired.a.a g;
    @Autowired
    private g h;

    public OperationResponse a(String omadacId, String siteId, String mac, String type, StatQueryVO statQuery, N granularity) {
        List<ApStatDTO> statList;
        DeviceTypeEnum deviceTypeEnum = DeviceTypeEnum.b((String)type);
        if (deviceTypeEnum == null) {
            a.info("invalid device type {}", (Object)type);
            return OperationResponse.PARAM_ERROR;
        }
        Set<String> attrs = com.tplink.smb.omada.monitor.statistic.common.b.c.a(statQuery.getAttrs(), deviceTypeEnum, granularity);
        if (CollectionUtils.isEmpty(attrs)) {
            a.info("Failed to find valid attr in request {}", (Object)statQuery.getAttrs());
            return OperationResponse.PARAM_ERROR;
        }
        List queryPorts = statQuery.getPorts() == null ? Collections.emptyList() : statQuery.getPorts();
        List queryOltPorts = statQuery.getOltPorts() == null ? Collections.emptyList() : statQuery.getOltPorts();
        DeviceStatQueryDTO query = new DeviceStatQueryDTO(omadacId, siteId, mac, statQuery.getStart(), statQuery.getEnd(), attrs, queryPorts, queryOltPorts);
        switch (deviceTypeEnum) {
            case a: {
                statList = this.a(this.b.a(query, granularity), statQuery, granularity);
                break;
            }
            case c: {
                statList = this.b(this.e.a(query, granularity), statQuery, queryPorts, granularity);
                break;
            }
            case b: {
                statList = this.a(this.c.a(query, granularity), statQuery, queryPorts, granularity);
                break;
            }
            case d: {
                statList = this.c(this.d.a(query, granularity), statQuery, queryOltPorts, granularity);
                break;
            }
            default: {
                a.info("unsupported device type {}", (Object)deviceTypeEnum);
                return OperationResponse.PARAM_ERROR;
            }
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, new ArrayList(statList.stream().collect(Collectors.toMap(BaseDeviceStatDTO::getTime, v2 -> v2, (v1, v2) -> v2, TreeMap::new)).values()));
    }

    public OperationResponse<OswStatVO> a(String omadacId, String siteId, String mac, StatQueryVO statQuery, N granularity) {
        Set<String> attrs = com.tplink.smb.omada.monitor.statistic.common.b.c.a(statQuery.getAttrs(), DeviceTypeEnum.c, granularity);
        if (CollectionUtils.isEmpty(attrs)) {
            a.info("Failed to find valid attr in request {}", (Object)statQuery.getAttrs());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d.b(), com.tplink.smb.omada.common.g.b.g.c(), null);
        }
        List queryPorts = statQuery.getPorts() == null ? Collections.emptyList() : statQuery.getPorts();
        DeviceStatQueryDTO query = new DeviceStatQueryDTO(omadacId, siteId, mac, statQuery.getStart(), statQuery.getEnd(), attrs, queryPorts);
        List<OswStatDTO> statList = this.e.a(query, granularity);
        OswStatVO oswStatVO = new OswStatVO();
        statList = this.b(statList, statQuery, queryPorts, granularity);
        oswStatVO.setStatList(new ArrayList(statList.stream().collect(Collectors.toMap(BaseDeviceStatDTO::getTime, v2 -> v2, (v1, v2) -> v2, TreeMap::new)).values()));
        oswStatVO.setPortMap(this.a(statQuery.getAttrs(), oswStatVO.getStatList()));
        oswStatVO.setSwitchType((Integer)this.h.a(new QuerySwitchesTypeDTO(omadacId, siteId, Collections.singleton(mac))).getSwitchesTypeMap().get(mac));
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)oswStatVO);
    }

    public OperationResponse<List<OswStackMemberStatVO>> b(String omadacId, String siteId, String stackId, StatQueryVO statQuery, N granularity) {
        Set<String> attrs = com.tplink.smb.omada.monitor.statistic.common.b.c.a(statQuery.getAttrs(), DeviceTypeEnum.c, granularity);
        if (CollectionUtils.isEmpty(attrs)) {
            a.info("Failed to find valid attr in request {}", (Object)statQuery.getAttrs());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d.b(), com.tplink.smb.omada.common.g.b.g.c(), null);
        }
        List queryPorts = StandardOswPortIndex.resolvePortStrs((List)statQuery.getStandardPorts());
        if (queryPorts == null) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        Map unitPortsMap = queryPorts.stream().collect(Collectors.groupingBy(StandardOswPortIndex::getUnit, Collectors.mapping(StandardOswPortIndex::getPort, Collectors.toList())));
        OperationResponse response = this.g.a(QueryOswStackDTO.builder().omadacId(omadacId).siteId(siteId).stackId(stackId).build());
        if (!response.success()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.HC);
        }
        OswStackManageInfoDTO stackInfoDTO = (OswStackManageInfoDTO)response.getResult();
        if (CollectionUtils.isEmpty((Collection)stackInfoDTO.getMembers())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.HC);
        }
        ArrayList<OswStackMemberStatVO> results = new ArrayList<OswStackMemberStatVO>();
        for (OswStackMemberInfoDTO member : stackInfoDTO.getMembers()) {
            Integer unit = member.getUnit();
            if (!unitPortsMap.containsKey(unit)) continue;
            StatQueryVO memberStatQueryVO = new StatQueryVO();
            memberStatQueryVO.setStart(statQuery.getStart());
            memberStatQueryVO.setEnd(statQuery.getEnd());
            memberStatQueryVO.setAttrs(statQuery.getAttrs());
            memberStatQueryVO.setPorts(unitPortsMap.get(unit));
            OperationResponse<OswStatVO> memberResp = this.a(omadacId, siteId, member.getMac(), memberStatQueryVO, granularity);
            if (!memberResp.success()) {
                a.warn("fail to get stack {} member mac {} stat in omadacId {}, siteId {}", new Object[]{stackId, com.tplink.smb.omada.common.util.e.a.d((String)member.getMac()), omadacId, siteId});
                continue;
            }
            OswStatVO oswStatVO = (OswStatVO)memberResp.getResult();
            OswStackMemberStatVO stackMemberStatVO = this.a(oswStatVO, member);
            results.add(stackMemberStatVO);
        }
        return OperationResponse.success(results);
    }

    private OswStackMemberStatVO a(OswStatVO oswStatVO, OswStackMemberInfoDTO memberInfoDTO) {
        OswStackMemberStatVO oswStackMemberStatVO = OswStackMemberStatVO.builder().unit(memberInfoDTO.getUnit()).mac(memberInfoDTO.getMac()).build();
        oswStatVO.getStatList().forEach(oswStatDTO -> oswStatDTO.getPorts().forEach(oswPortStatDTO -> oswPortStatDTO.setStandardPort(StandardOswPortIndex.buildDefaultWithUnitAndPort((Integer)memberInfoDTO.getUnit(), (Integer)oswPortStatDTO.getPort()).toStandardStr())));
        oswStackMemberStatVO.setStatList(oswStatVO.getStatList());
        oswStackMemberStatVO.setPortMap(oswStatVO.getPortMap().entrySet().stream().collect(Collectors.toMap(e2 -> StandardOswPortIndex.buildDefaultWithUnitAndPort((Integer)memberInfoDTO.getUnit(), (Integer)((Integer)e2.getKey())).toStandardStr(), Map.Entry::getValue)));
        return oswStackMemberStatVO;
    }

    public Map<Integer, PortStatVO> a(List<String> attrs, List<OswStatDTO> statList) {
        ConcurrentHashMap<Integer, PortStatVO> map = new ConcurrentHashMap<Integer, PortStatVO>();
        statList.forEach(stat -> stat.getPorts().forEach(port -> {
            long tx = 0L;
            long rx = 0L;
            if (!Objects.isNull(map.get(port.getPort()))) {
                tx = Objects.isNull(((PortStatVO)map.get(port.getPort())).getTx()) ? 0L : ((PortStatVO)map.get(port.getPort())).getTx();
                long l2 = rx = Objects.isNull(((PortStatVO)map.get(port.getPort())).getRx()) ? 0L : ((PortStatVO)map.get(port.getPort())).getRx();
            }
            if (attrs.contains("tx")) {
                tx += Objects.isNull(port.getTx()) ? 0L : port.getTx();
                rx += Objects.isNull(port.getRx()) ? 0L : port.getRx();
            } else if (attrs.contains("txRate")) {
                tx += Objects.isNull(port.getTxRate()) ? 0L : port.getTxRate();
                rx += Objects.isNull(port.getRxRate()) ? 0L : port.getRxRate();
            } else if (attrs.contains("txPkts")) {
                tx += Objects.isNull(port.getTxPkts()) ? 0L : port.getTxPkts();
                rx += Objects.isNull(port.getRxPkts()) ? 0L : port.getRxPkts();
            } else if (attrs.contains("txBroadPkts")) {
                tx += Objects.isNull(port.getTxBroadPkts()) ? 0L : port.getTxBroadPkts();
                rx += Objects.isNull(port.getRxBroadPkts()) ? 0L : port.getRxBroadPkts();
            } else if (attrs.contains("txMultiPkts")) {
                tx += Objects.isNull(port.getTxMultiPkts()) ? 0L : port.getTxMultiPkts();
                rx += Objects.isNull(port.getRxMultiPkts()) ? 0L : port.getRxMultiPkts();
            }
            PortStatVO oswPortStatVO = (PortStatVO)map.get(port.getPort());
            if (Objects.isNull(oswPortStatVO)) {
                oswPortStatVO = new PortStatVO();
            }
            oswPortStatVO.setTx(Long.valueOf(tx));
            oswPortStatVO.setRx(Long.valueOf(rx));
            oswPortStatVO.setAll(Long.valueOf(rx + tx));
            map.put(port.getPort(), oswPortStatVO);
        }));
        return map;
    }

    public Map<String, PortStatVO> b(List<String> attrs, List<OltStatDTO> statList) {
        ConcurrentHashMap<String, PortStatVO> map = new ConcurrentHashMap<String, PortStatVO>();
        statList.forEach(stat -> stat.getPorts().forEach(port -> {
            long tx = 0L;
            long rx = 0L;
            if (!Objects.isNull(map.get(port.getPort()))) {
                tx = Objects.isNull(((PortStatVO)map.get(port.getPort())).getTx()) ? 0L : ((PortStatVO)map.get(port.getPort())).getTx();
                long l2 = rx = Objects.isNull(((PortStatVO)map.get(port.getPort())).getRx()) ? 0L : ((PortStatVO)map.get(port.getPort())).getRx();
            }
            if (attrs.contains("tx")) {
                tx += Objects.isNull(port.getTx()) ? 0L : port.getTx();
                rx += Objects.isNull(port.getRx()) ? 0L : port.getRx();
            } else if (attrs.contains("txRate")) {
                tx += Objects.isNull(port.getTxRate()) ? 0L : port.getTxRate().longValue();
                rx += Objects.isNull(port.getRxRate()) ? 0L : port.getRxRate().longValue();
            } else if (attrs.contains("txPkts")) {
                tx += Objects.isNull(port.getTxPackets()) ? 0L : port.getTxPackets();
                rx += Objects.isNull(port.getRxPackets()) ? 0L : port.getRxPackets();
            } else if (attrs.contains("txBroadcastPackets")) {
                tx += Objects.isNull(port.getTxBroadcastPackets()) ? 0L : port.getTxBroadcastPackets();
                rx += Objects.isNull(port.getRxBroadcastPackets()) ? 0L : port.getRxBroadcastPackets();
            } else if (attrs.contains("txMulticastPackets")) {
                tx += Objects.isNull(port.getTxMulticastPackets()) ? 0L : port.getTxMulticastPackets();
                rx += Objects.isNull(port.getRxMulticastPackets()) ? 0L : port.getRxMulticastPackets();
            }
            PortStatVO oltPortStatVO = (PortStatVO)map.get(port.getPort());
            if (Objects.isNull(oltPortStatVO)) {
                oltPortStatVO = new PortStatVO();
            }
            oltPortStatVO.setTx(Long.valueOf(tx));
            oltPortStatVO.setRx(Long.valueOf(rx));
            oltPortStatVO.setAll(Long.valueOf(rx + tx));
            map.put(port.getPort(), oltPortStatVO);
        }));
        return map;
    }

    public List<ApStatDTO> a(List<ApStatDTO> apQuery, StatQueryVO statQuery, N granularity) {
        List<ApStatDTO> apStatDTOS = this.f.a(statQuery.getStart(), statQuery.getEnd(), granularity, apQuery, ApStatDTO.class);
        return apStatDTOS;
    }

    public List<OsgStatDTO> a(List<OsgStatDTO> osgQuery, StatQueryVO statQuery, List<Integer> queryPorts, N granularity) {
        List ports = queryPorts.stream().map(port -> {
            OsgStatDTO.OsgPortStatDTO osgPort = new OsgStatDTO.OsgPortStatDTO();
            osgPort.setPort(port);
            return osgPort;
        }).collect(Collectors.toList());
        List<OsgStatDTO> osgStatDTOS = this.f.a(statQuery.getStart(), statQuery.getEnd(), granularity, osgQuery, OsgStatDTO.class);
        osgStatDTOS.forEach(o2 -> {
            if (CollectionUtil.isEmpty((Collection)o2.getPorts())) {
                o2.setPorts(ports);
            }
        });
        return osgStatDTOS;
    }

    public List<OswStatDTO> b(List<OswStatDTO> oswQuery, StatQueryVO statQuery, List<Integer> queryPorts, N granularity) {
        List ports = queryPorts.stream().map(port -> {
            OswStatDTO.OswPortStatDTO oswPort = new OswStatDTO.OswPortStatDTO();
            oswPort.setPort(port);
            return oswPort;
        }).collect(Collectors.toList());
        List<OswStatDTO> oswStatDTOS = this.f.a(statQuery.getStart(), statQuery.getEnd(), granularity, oswQuery, OswStatDTO.class);
        oswStatDTOS.forEach(o2 -> {
            if (CollectionUtil.isEmpty((Collection)o2.getPorts())) {
                o2.setPorts(ports);
            }
        });
        return oswStatDTOS;
    }

    public List<OltStatDTO> c(List<OltStatDTO> oltQuery, StatQueryVO statQuery, List<String> queryPorts, N granularity) {
        List ports = queryPorts.stream().map(port -> {
            OltStatDTO.OltPortStatDTO oltPort = new OltStatDTO.OltPortStatDTO();
            oltPort.setPort(port);
            return oltPort;
        }).collect(Collectors.toList());
        List<OltStatDTO> oltStatDTOS = this.f.a(statQuery.getStart(), statQuery.getEnd(), granularity, oltQuery, OltStatDTO.class);
        oltStatDTOS.forEach(o2 -> {
            if (CollectionUtil.isEmpty((Collection)o2.getPorts())) {
                o2.setPorts(ports);
            }
        });
        return oltStatDTOS;
    }

    public OperationResponse a(String omadacId, String siteId, String mac, WanStatQueryVO statQuery) {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ports.add(statQuery.getPort());
        DeviceStatQueryDTO queryDTO = new DeviceStatQueryDTO(omadacId, siteId, mac, statQuery.getStart(), statQuery.getEnd(), com.tplink.smb.omada.monitor.statistic.common.b.c.c, ports);
        N granularity = N.a((int)statQuery.getGranularity());
        List<WanStatDTO> statList = this.c.b(queryDTO, granularity);
        TreeMap<Long, WanStatDTO> statDTOMap = statList.stream().collect(Collectors.toMap(WanStatDTO::getTime, v2 -> v2, (v1, v2) -> v2, TreeMap::new));
        if (CollectionUtils.isEmpty((Map)statDTOMap)) {
            statDTOMap = new TreeMap<Long, WanStatDTO>();
        }
        switch (granularity) {
            case a: {
                long start = (statQuery.getStart() / 300L + 1L) * 300L;
                long end = (statQuery.getEnd() / 300L - 1L) * 300L;
                for (long time = start; time <= end; time += 300L) {
                    long finalTime = time;
                    statDTOMap.computeIfAbsent(time, v2 -> new WanStatDTO(finalTime));
                }
                break;
            }
            case c: {
                long start = (statQuery.getStart() / 3600L + 1L) * 3600L;
                long end = (statQuery.getEnd() / 3600L - 1L) * 3600L;
                for (long time = start; time <= end; time += 3600L) {
                    long finalTime = time;
                    statDTOMap.computeIfAbsent(time, v2 -> new WanStatDTO(finalTime));
                }
                break;
            }
            case d: {
                long start;
                long days = (statQuery.getEnd() - statQuery.getStart()) / 86400L;
                if (statDTOMap.isEmpty()) break;
                long statEndTime = ((WanStatDTO)new ArrayList(statDTOMap.values()).get(statDTOMap.size() - 1)).getTime();
                long noDataDay = (statQuery.getEnd() - statEndTime) / 86400L;
                long end = noDataDay > 0L ? statEndTime + noDataDay * 86400L : statEndTime;
                for (long time = start = end - 86400L * days; time <= end; time += 86400L) {
                    long finalTime = time;
                    statDTOMap.computeIfAbsent(time, v2 -> new WanStatDTO(finalTime));
                }
                break;
            }
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, new ArrayList(statDTOMap.values()));
    }

    public OperationResponse<OltStatVO> c(String omadacId, String siteId, String mac, StatQueryVO statQuery, N granularity) {
        Set<String> attrs = com.tplink.smb.omada.monitor.statistic.common.b.c.a(statQuery.getAttrs(), DeviceTypeEnum.d, granularity);
        if (CollectionUtils.isEmpty(attrs)) {
            a.info("Failed to find valid attr in request {}", (Object)statQuery.getAttrs());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d.b(), com.tplink.smb.omada.common.g.b.d.c(), null);
        }
        List queryPorts = statQuery.getOltPorts() == null ? Collections.emptyList() : statQuery.getOltPorts();
        DeviceStatQueryDTO query = new DeviceStatQueryDTO(omadacId, siteId, mac, statQuery.getStart(), statQuery.getEnd(), attrs, null, queryPorts);
        List<OltStatDTO> statList = this.d.a(query, granularity);
        OltStatVO oltStatVO = new OltStatVO();
        statList = this.c(statList, statQuery, queryPorts, granularity);
        oltStatVO.setStatList(new ArrayList(statList.stream().collect(Collectors.toMap(BaseDeviceStatDTO::getTime, v2 -> v2, (v1, v2) -> v2, TreeMap::new)).values()));
        oltStatVO.setPortMap(this.b(statQuery.getAttrs(), oltStatVO.getStatList()));
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)oltStatVO);
    }

    public OperationResponse<List<OswStackDetailStatVO>> a(String omadacId, String siteId, String stackId, OswStackStatQueryVO queryVO) {
        Long start = queryVO.getStart();
        Long end = queryVO.getEnd();
        Integer interval = queryVO.getInterval();
        if (Objects.isNull(start) || Objects.isNull(end) || end <= start || Objects.isNull(interval)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        N granularityEnum = this.a(interval);
        if (Objects.isNull(granularityEnum)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        Set<String> attrs = com.tplink.smb.omada.monitor.statistic.common.b.c.a(queryVO.getAttrs(), DeviceTypeEnum.c, granularityEnum);
        if (CollectionUtils.isEmpty(attrs)) {
            a.info("Failed to find valid attr in request {}", (Object)queryVO.getAttrs());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        OperationResponse stackInfoResp = this.g.a(QueryOswStackDTO.builder().omadacId(omadacId).siteId(siteId).stackId(stackId).build());
        if (!stackInfoResp.success() || Objects.isNull(stackInfoResp.getResult())) {
            a.info("fail to get stack info by stackId : {}", (Object)stackId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        OswStackManageInfoDTO stackInfo = (OswStackManageInfoDTO)stackInfoResp.getResult();
        if (CollectionUtils.isEmpty((Collection)stackInfo.getMembers())) {
            a.info("fail to get stack members from stackId : {}", (Object)stackId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.HC);
        }
        HashMap macUnitMap = new HashMap();
        if (Boolean.TRUE.equals(stackInfo.getNeedCheckLicense())) {
            stackInfo.getMembers().stream().filter(dto -> Boolean.TRUE.equals(dto.getActive())).forEach(dto -> {
                String unitMac = dto.getMac();
                macUnitMap.put(unitMac, dto.getUnit());
            });
        } else {
            stackInfo.getMembers().forEach(dto -> {
                String unitMac = dto.getMac();
                macUnitMap.put(unitMac, dto.getUnit());
            });
        }
        ArrayList<Integer> emptyPort = new ArrayList<Integer>();
        OswStackStatQueryDTO query = new OswStackStatQueryDTO(omadacId, siteId, new ArrayList<String>(macUnitMap.keySet()), start, end, attrs, emptyPort);
        Map<String, List<OswStatDTO>> unitStatMap = this.e.a(query, granularityEnum);
        TreeMap<Long, OswStackDetailStatVO> oswStackDetailStatMap = new TreeMap<Long, OswStackDetailStatVO>();
        for (Map.Entry<String, List<OswStatDTO>> entry : unitStatMap.entrySet()) {
            String unitMac = entry.getKey();
            Integer unit = (Integer)macUnitMap.get(unitMac);
            for (OswStatDTO oswStatDTO : entry.getValue()) {
                Long time = oswStatDTO.getTime();
                OswStackDetailStatVO oswStackDetailStatVO = oswStackDetailStatMap.computeIfAbsent(time, OswStackDetailStatVO::buildDefaultByTime);
                this.a(unit, oswStackDetailStatVO, oswStatDTO);
            }
        }
        this.a(oswStackDetailStatMap, start, end, granularityEnum);
        return OperationResponse.success(new ArrayList(oswStackDetailStatMap.values()));
    }

    private void a(Map<Long, OswStackDetailStatVO> map, long queryStartTime, long queryEndTime, N timeGranularityEnum) {
        long end;
        long timeUnit = switch (timeGranularityEnum) {
            case N.a -> 300L;
            case N.c -> 3600L;
            default -> 86400L;
        };
        long timeUnitNum = (queryEndTime - queryStartTime) / timeUnit;
        if (timeUnit != 86400L) {
            start = (queryStartTime / timeUnit + 1L) * timeUnit;
            end = queryEndTime / timeUnit * timeUnit;
        } else {
            if (CollectionUtils.isEmpty(map)) {
                end = queryEndTime / 3600L * 3600L;
            } else {
                long latestStatTime = queryEndTime / 3600L * 3600L - timeUnitNum * timeUnit;
                for (Map.Entry<Long, OswStackDetailStatVO> entry : map.entrySet()) {
                    latestStatTime = Math.max(latestStatTime, entry.getKey());
                }
                end = latestStatTime;
            }
            while (end + timeUnit < queryEndTime) {
                end += timeUnit;
            }
            start = end - timeUnit * timeUnitNum;
        }
        for (long t2 = start; t2 <= end; t2 += timeUnit) {
            map.computeIfAbsent(t2, OswStackDetailStatVO::buildEmptyByTime);
        }
    }

    private void a(Integer unit, OswStackDetailStatVO oswStackDetailStatVO, OswStatDTO oswStatDTO) {
        oswStackDetailStatVO.getCpu().add(OswStackDetailStatVO.OswStackDetailIntPropertyDTO.builder().unit(unit).value(oswStatDTO.getCpu()).build());
        oswStackDetailStatVO.getMem().add(OswStackDetailStatVO.OswStackDetailIntPropertyDTO.builder().unit(unit).value(oswStatDTO.getMem()).build());
        if (CollectionUtils.isEmpty((Collection)oswStatDTO.getPorts())) {
            return;
        }
        long dropPktsNum = 0L;
        long txErrPktsNum = 0L;
        long rxErrPktsNum = 0L;
        for (OswStatDTO.OswPortStatDTO portStatDTO : oswStatDTO.getPorts()) {
            if (Objects.nonNull(portStatDTO.getDropPkts())) {
                dropPktsNum += portStatDTO.getDropPkts().longValue();
            }
            if (Objects.nonNull(portStatDTO.getTxErrPkts())) {
                txErrPktsNum += portStatDTO.getTxErrPkts().longValue();
            }
            if (!Objects.nonNull(portStatDTO.getRxErrPkts())) continue;
            rxErrPktsNum += portStatDTO.getRxErrPkts().longValue();
        }
        oswStackDetailStatVO.getDropPkts().add(OswStackDetailStatVO.OswStackDetailLongPropertyDTO.builder().unit(unit).value(Long.valueOf(dropPktsNum)).build());
        oswStackDetailStatVO.getTxErrPkts().add(OswStackDetailStatVO.OswStackDetailLongPropertyDTO.builder().unit(unit).value(Long.valueOf(txErrPktsNum)).build());
        oswStackDetailStatVO.getRxErrPkts().add(OswStackDetailStatVO.OswStackDetailLongPropertyDTO.builder().unit(unit).value(Long.valueOf(rxErrPktsNum)).build());
    }

    private N a(Integer interval) {
        if (Objects.isNull(interval)) {
            return null;
        }
        switch (interval) {
            case 0: {
                return N.a;
            }
            case 1: {
                return N.c;
            }
            case 2: {
                return N.d;
            }
        }
        return null;
    }
}

