/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.statistic.a.d;

import com.tplink.smb.omada.anomaly.api.dto.health.osw.OswHealthScoreDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.DeviceOutlineDTO;
import com.tplink.smb.omada.monitor.api.web.health.dto.ActiveOswHealthVO;
import com.tplink.smb.omada.monitor.api.web.health.dto.TopCpuUsageHealthVO;
import com.tplink.smb.omada.monitor.api.web.health.dto.TopMemUsageHealthVO;
import com.tplink.smb.omada.monitor.api.web.health.dto.TopOswErrorPacketVO;
import com.tplink.smb.omada.monitor.api.web.health.dto.TopOswPacketLossVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OswStatDTO;
import com.tplink.smb.omada.monitor.statistic.common.b.e;
import com.tplink.smb.omada.monitor.statistic.common.dto.MacTrafficDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import org.springframework.util.CollectionUtils;

public class b {
    private b() {
    }

    public static List<ActiveOswHealthVO> a(int number, Map<String, DeviceOutlineDTO> deviceMap, List<MacTrafficDTO> trafficList, Map<String, OswHealthScoreDTO> healthMap) {
        if (CollectionUtils.isEmpty(deviceMap)) {
            return Collections.emptyList();
        }
        int limit = Math.min(number, deviceMap.keySet().size());
        List<ActiveOswHealthVO> deviceHealthVOList = e.c(deviceMap, trafficList, limit);
        for (ActiveOswHealthVO activeOswHealthVO : deviceHealthVOList) {
            OswHealthScoreDTO oswHealthScoreDTO = healthMap.get(activeOswHealthVO.getMac());
            if (Objects.nonNull(oswHealthScoreDTO)) {
                activeOswHealthVO.setHealthScore(oswHealthScoreDTO.getScore());
                continue;
            }
            activeOswHealthVO.setHealthScore(Integer.valueOf(-1));
        }
        return deviceHealthVOList;
    }

    public static List<TopCpuUsageHealthVO> a(int number, Map<String, DeviceOutlineDTO> deviceMap, Map<String, List<OswStatDTO>> oswStatMap, Map<String, OswHealthScoreDTO> healthMap) {
        if (CollectionUtils.isEmpty(deviceMap)) {
            return Collections.emptyList();
        }
        TreeSet<TopCpuUsageHealthVO> treeSet = new TreeSet<TopCpuUsageHealthVO>((v0, v1) -> v1.getCpuUtil().compareTo(v0.getCpuUtil()) != 0 ? v1.getCpuUtil().compareTo(v0.getCpuUtil()) : v0.getMac().compareTo(v1.getMac()));
        for (Map.Entry<String, DeviceOutlineDTO> entry : deviceMap.entrySet()) {
            String mac = entry.getKey();
            DeviceOutlineDTO deviceOutlineDTO = entry.getValue();
            List<OswStatDTO> oswStatDTOList = oswStatMap.get(mac);
            int cpuUtil = 0;
            if (!CollectionUtils.isEmpty(oswStatDTOList)) {
                cpuUtil = oswStatDTOList.stream().flatMapToInt(oswStatDTO -> IntStream.of((int)oswStatDTO.getCpu())).sum() / oswStatDTOList.size();
            }
            TopCpuUsageHealthVO vo = new TopCpuUsageHealthVO(deviceOutlineDTO.getName(), Integer.valueOf(cpuUtil), deviceOutlineDTO.getMac(), deviceOutlineDTO.getModel(), deviceOutlineDTO.getModelVersion(), deviceOutlineDTO.getType(), deviceOutlineDTO.getDeviceSeriesType());
            treeSet.add(vo);
        }
        ArrayList<TopCpuUsageHealthVO> totalList = new ArrayList<TopCpuUsageHealthVO>(treeSet);
        ArrayList<TopCpuUsageHealthVO> result = totalList.size() >= number ? totalList.subList(0, number) : totalList;
        for (TopCpuUsageHealthVO topCpuUsageHealthVO : result) {
            OswHealthScoreDTO oswHealthScoreDTO = healthMap.get(topCpuUsageHealthVO.getMac());
            if (Objects.nonNull(oswHealthScoreDTO)) {
                topCpuUsageHealthVO.setHealthScore(oswHealthScoreDTO.getScore());
                continue;
            }
            topCpuUsageHealthVO.setHealthScore(Integer.valueOf(-1));
        }
        return result;
    }

    public static List<TopMemUsageHealthVO> b(int number, Map<String, DeviceOutlineDTO> deviceMap, Map<String, List<OswStatDTO>> oswStatMap, Map<String, OswHealthScoreDTO> healthMap) {
        if (CollectionUtils.isEmpty(deviceMap)) {
            return Collections.emptyList();
        }
        TreeSet<TopMemUsageHealthVO> treeSet = new TreeSet<TopMemUsageHealthVO>((v0, v1) -> v1.getMemUtil().compareTo(v0.getMemUtil()) != 0 ? v1.getMemUtil().compareTo(v0.getMemUtil()) : v0.getMac().compareTo(v1.getMac()));
        for (Map.Entry<String, DeviceOutlineDTO> entry : deviceMap.entrySet()) {
            String mac = entry.getKey();
            DeviceOutlineDTO deviceOutlineDTO = entry.getValue();
            List<OswStatDTO> oswStatDTOList = oswStatMap.get(mac);
            int memUtil = 0;
            if (!CollectionUtils.isEmpty(oswStatDTOList)) {
                memUtil = oswStatDTOList.stream().flatMapToInt(oswStatDTO -> IntStream.of((int)oswStatDTO.getMem())).sum() / oswStatDTOList.size();
            }
            TopMemUsageHealthVO vo = new TopMemUsageHealthVO(deviceOutlineDTO.getName(), Integer.valueOf(memUtil), deviceOutlineDTO.getMac(), deviceOutlineDTO.getModel(), deviceOutlineDTO.getModelVersion(), deviceOutlineDTO.getType(), deviceOutlineDTO.getDeviceSeriesType());
            treeSet.add(vo);
        }
        ArrayList<TopMemUsageHealthVO> totalList = new ArrayList<TopMemUsageHealthVO>(treeSet);
        ArrayList<TopMemUsageHealthVO> result = totalList.size() >= number ? totalList.subList(0, number) : totalList;
        for (TopMemUsageHealthVO topMemUsageHealthVO : result) {
            OswHealthScoreDTO oswHealthScoreDTO = healthMap.get(topMemUsageHealthVO.getMac());
            if (Objects.nonNull(oswHealthScoreDTO)) {
                topMemUsageHealthVO.setHealthScore(oswHealthScoreDTO.getScore());
                continue;
            }
            topMemUsageHealthVO.setHealthScore(Integer.valueOf(-1));
        }
        return result;
    }

    static List<TopOswErrorPacketVO> c(int number, Map<String, DeviceOutlineDTO> deviceMap, Map<String, List<OswStatDTO>> oswStatMap, Map<String, OswHealthScoreDTO> healthMap) {
        if (CollectionUtils.isEmpty(deviceMap)) {
            return Collections.emptyList();
        }
        TreeSet<TopOswErrorPacketVO> treeSet = new TreeSet<TopOswErrorPacketVO>((v0, v1) -> v1.getErrPkts().compareTo(v0.getErrPkts()) != 0 ? v1.getErrPkts().compareTo(v0.getErrPkts()) : v0.getMac().compareTo(v1.getMac()));
        for (Map.Entry<String, DeviceOutlineDTO> entry : deviceMap.entrySet()) {
            String mac = entry.getKey();
            DeviceOutlineDTO deviceOutlineDTO = entry.getValue();
            List<OswStatDTO> oswStatDTOList = oswStatMap.get(mac);
            int portCnt = 0;
            AtomicInteger errPort = new AtomicInteger();
            AtomicLong errPkts = new AtomicLong(0L);
            HashMap<Integer, List> portErrPktMap = new HashMap<Integer, List>();
            if (!CollectionUtils.isEmpty(oswStatDTOList)) {
                for (OswStatDTO oswStatDTO : oswStatDTOList) {
                    portCnt = Math.max(oswStatDTO.getPorts().size(), portCnt);
                    for (OswStatDTO.OswPortStatDTO dto : oswStatDTO.getPorts()) {
                        Integer port2 = dto.getPort();
                        if (portErrPktMap.containsKey(port2)) {
                            ((List)portErrPktMap.get(port2)).add(dto.getRxErrPkts() + dto.getTxErrPkts());
                            continue;
                        }
                        ArrayList<Long> list = new ArrayList<Long>();
                        list.add(dto.getRxErrPkts() + dto.getTxErrPkts());
                        portErrPktMap.put(port2, list);
                    }
                }
            }
            portErrPktMap.forEach((port, portErrPkts) -> {
                long errPkt = (Long)Collections.max(portErrPkts) - (Long)Collections.min(portErrPkts);
                if (errPkt > 0L) {
                    errPort.addAndGet(1);
                    errPkts.addAndGet(errPkt);
                }
            });
            TopOswErrorPacketVO vo = new TopOswErrorPacketVO(deviceOutlineDTO.getName(), Integer.valueOf(portCnt), Integer.valueOf(errPort.intValue()), Long.valueOf(errPkts.longValue()), deviceOutlineDTO.getMac(), deviceOutlineDTO.getModel(), deviceOutlineDTO.getModelVersion(), deviceOutlineDTO.getType(), deviceOutlineDTO.getDeviceSeriesType());
            treeSet.add(vo);
        }
        ArrayList<TopOswErrorPacketVO> totalList = new ArrayList<TopOswErrorPacketVO>(treeSet);
        ArrayList<TopOswErrorPacketVO> result = totalList.size() >= number ? totalList.subList(0, number) : totalList;
        for (TopOswErrorPacketVO topOswErrorPacketVO : result) {
            OswHealthScoreDTO oswHealthScoreDTO = healthMap.get(topOswErrorPacketVO.getMac());
            if (Objects.nonNull(oswHealthScoreDTO)) {
                topOswErrorPacketVO.setHealthScore(oswHealthScoreDTO.getScore());
                continue;
            }
            topOswErrorPacketVO.setHealthScore(Integer.valueOf(-1));
        }
        return result;
    }

    static List<TopOswPacketLossVO> d(int number, Map<String, DeviceOutlineDTO> deviceMap, Map<String, List<OswStatDTO>> oswStatMap, Map<String, OswHealthScoreDTO> healthMap) {
        if (CollectionUtils.isEmpty(deviceMap)) {
            return Collections.emptyList();
        }
        TreeSet<TopOswPacketLossVO> treeSet = new TreeSet<TopOswPacketLossVO>((v0, v1) -> v1.getLossPkts().compareTo(v0.getLossPkts()) != 0 ? v1.getLossPkts().compareTo(v0.getLossPkts()) : v0.getMac().compareTo(v1.getMac()));
        for (Map.Entry<String, DeviceOutlineDTO> entry : deviceMap.entrySet()) {
            String mac = entry.getKey();
            DeviceOutlineDTO deviceOutlineDTO = entry.getValue();
            List<OswStatDTO> oswStatDTOList = oswStatMap.get(mac);
            int portCnt = 0;
            AtomicInteger lossPort = new AtomicInteger();
            AtomicLong lossPkts = new AtomicLong(0L);
            HashMap<Integer, List> portLossPktMap = new HashMap<Integer, List>();
            if (!CollectionUtils.isEmpty(oswStatDTOList)) {
                for (OswStatDTO oswStatDTO : oswStatDTOList) {
                    portCnt = Math.max(oswStatDTO.getPorts().size(), portCnt);
                    for (OswStatDTO.OswPortStatDTO dto : oswStatDTO.getPorts()) {
                        Integer port2 = dto.getPort();
                        if (portLossPktMap.containsKey(port2)) {
                            ((List)portLossPktMap.get(port2)).add(dto.getDropPkts());
                            continue;
                        }
                        ArrayList<Long> list = new ArrayList<Long>();
                        list.add(dto.getDropPkts());
                        portLossPktMap.put(port2, list);
                    }
                }
            }
            portLossPktMap.forEach((port, portLossPkts) -> {
                long lossPkt = (Long)Collections.max(portLossPkts) - (Long)Collections.min(portLossPkts);
                if (lossPkt > 0L) {
                    lossPort.addAndGet(1);
                    lossPkts.addAndGet(lossPkt);
                }
            });
            TopOswPacketLossVO vo = new TopOswPacketLossVO(deviceOutlineDTO.getName(), Integer.valueOf(portCnt), Integer.valueOf(lossPort.intValue()), Long.valueOf(lossPkts.longValue()), deviceOutlineDTO.getMac(), deviceOutlineDTO.getModel(), deviceOutlineDTO.getModelVersion(), deviceOutlineDTO.getType(), deviceOutlineDTO.getDeviceSeriesType());
            treeSet.add(vo);
        }
        ArrayList<TopOswPacketLossVO> totalList = new ArrayList<TopOswPacketLossVO>(treeSet);
        ArrayList<TopOswPacketLossVO> result = totalList.size() >= number ? totalList.subList(0, number) : totalList;
        for (TopOswPacketLossVO topOswPacketLossVO : result) {
            OswHealthScoreDTO oswHealthScoreDTO = healthMap.get(topOswPacketLossVO.getMac());
            if (Objects.nonNull(oswHealthScoreDTO)) {
                topOswPacketLossVO.setHealthScore(oswHealthScoreDTO.getScore());
                continue;
            }
            topOswPacketLossVO.setHealthScore(Integer.valueOf(-1));
        }
        return result;
    }
}

