/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.report.d.a.b;

import cn.hutool.core.convert.Convert;
import com.tplink.nbu.common.utils.MapUtils;
import com.tplink.smb.omada.client.api.internal.d;
import com.tplink.smb.omada.client.api.internal.dto.SsidSummaryDTO;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.common.report.dto.CsvExportBaseDTO;
import com.tplink.smb.omada.common.util.I;
import com.tplink.smb.omada.monitor.api.web.report.v6.CardInfoVO;
import com.tplink.smb.omada.monitor.api.web.report.v6.TopSsidTrafficVO;
import com.tplink.smb.omada.monitor.api.web.report.v6.csv.dto.TopSsidTrafficCsvDTO;
import com.tplink.smb.omada.monitor.api.web.report.vo.NameClientsVO;
import com.tplink.smb.omada.monitor.api.web.report.vo.NameTrafficVO;
import com.tplink.smb.omada.monitor.api.web.report.vo.SsidSummaryVO;
import com.tplink.smb.omada.monitor.report.c.b;
import com.tplink.smb.omada.monitor.report.d.a.a;
import com.tplink.smb.omada.monitor.report.d.c;
import com.tplink.smb.omada.monitor.report.dto.ReportTabParamDTO;
import com.tplink.smb.omada.monitor.report.dto.SsidNameTrafficDTO;
import com.tplink.smb.omada.monitor.statistic.common.b.e;
import com.tplink.smb.omada.monitor.statistic.e.y;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class x
extends a<List<TopSsidTrafficVO>> {
    @Generated
    private static final Logger b = LoggerFactory.getLogger(x.class);
    private static final int c = 20;
    @Autowired
    private y d;
    @Autowired
    private d e;

    @Override
    public String a() {
        return com.tplink.smb.omada.monitor.report.d.c.D.a();
    }

    @Override
    public void a(CardInfoVO cardInfoVO, ReportTabParamDTO params) {
        long startTime = System.currentTimeMillis();
        List<TopSsidTrafficVO> topSsidTrafficVO = (List<TopSsidTrafficVO>)this.b(params, List.class);
        if (CollectionUtils.isEmpty((Collection)topSsidTrafficVO)) {
            topSsidTrafficVO = this.e(params);
            this.a(params, topSsidTrafficVO);
        }
        cardInfoVO.setTopSsidByTraffic((List)topSsidTrafficVO);
        b.debug("getting card {} finished, omadacId:{}, siteId:{}, time spent for getting cards: {}", new Object[]{this.a(), params.getOmadacId(), params.getSiteId(), System.currentTimeMillis() - startTime});
    }

    @Override
    public void a(CardInfoVO cardInfoVO, Map<String, List<CsvExportBaseDTO>> csvDataMap, ReportTabParamDTO params) {
        if (Objects.isNull(cardInfoVO) || CollectionUtils.isEmpty((Collection)cardInfoVO.getTopSsidByTraffic())) {
            return;
        }
        ArrayList<CsvExportBaseDTO> ssidCsvList = new ArrayList<CsvExportBaseDTO>();
        for (TopSsidTrafficVO ssid : cardInfoVO.getTopSsidByTraffic()) {
            ssidCsvList.add((CsvExportBaseDTO)Convert.convert(TopSsidTrafficCsvDTO.class, (Object)ssid));
        }
        csvDataMap.put(com.tplink.smb.omada.monitor.report.d.c.D.a(), ssidCsvList);
    }

    public List<TopSsidTrafficVO> e(ReportTabParamDTO params) {
        ArrayList<TopSsidTrafficVO> topSsidTrafficVOList = new ArrayList<TopSsidTrafficVO>();
        int topK = params.getTopK() == null ? 20 : params.getTopK();
        SsidSummaryVO ssidSummary = this.a(params.getOmadacId(), params.getSiteId(), (long)params.getStart(), (long)params.getEnd(), params.getGranularity(), params.getLocale());
        if (Objects.isNull(ssidSummary) || CollectionUtils.isEmpty((Collection)ssidSummary.getSsidTraffic())) {
            return topSsidTrafficVOList;
        }
        long totalTraffic = ssidSummary.getSsidTraffic().stream().filter(p2 -> p2.getTraffic() != null).mapToLong(NameTrafficVO::getTraffic).sum();
        int i2 = 0;
        Map<Object, Object> nameClientsVOMap = new HashMap(16);
        if (!CollectionUtils.isEmpty((Collection)ssidSummary.getClientsNum())) {
            nameClientsVOMap = ssidSummary.getClientsNum().stream().collect(Collectors.groupingBy(NameClientsVO::getName));
        }
        for (NameTrafficVO ssidTraffic : ssidSummary.getSsidTraffic()) {
            if (i2 >= topK) break;
            TopSsidTrafficVO topSsidTrafficVO = new TopSsidTrafficVO();
            topSsidTrafficVO.setTraffic(ssidTraffic.getTraffic());
            topSsidTrafficVO.setSsid(ssidTraffic.getName());
            if (totalTraffic > 0L) {
                topSsidTrafficVO.setTrafficRatio(Integer.valueOf((int)Math.round(100.0 * (double)ssidTraffic.getTraffic().longValue() / (double)totalTraffic)));
            } else {
                topSsidTrafficVO.setTrafficRatio(Integer.valueOf(0));
            }
            if (!(MapUtils.isEmpty(nameClientsVOMap) || CollectionUtils.isEmpty((Collection)((Collection)nameClientsVOMap.get(ssidTraffic.getName()))) || Objects.isNull(((List)nameClientsVOMap.get(ssidTraffic.getName())).get(0)))) {
                topSsidTrafficVO.setClientCount(Long.valueOf(((NameClientsVO)((List)nameClientsVOMap.get(ssidTraffic.getName())).get(0)).getClients().intValue()));
            } else {
                topSsidTrafficVO.setClientCount(Long.valueOf(0L));
            }
            topSsidTrafficVOList.add(topSsidTrafficVO);
            ++i2;
        }
        return topSsidTrafficVOList;
    }

    public SsidSummaryVO a(String omadacId, String siteId, long start, long end, N granularity, Locale locale) {
        List<SsidNameTrafficDTO> trafficList = this.d.a(granularity, omadacId, siteId, start, end);
        long totalSsidTraffic = 0L;
        List<Object> ssidTrafficList = new ArrayList();
        if (!CollectionUtils.isEmpty(trafficList)) {
            trafficList = trafficList.stream().filter(p2 -> p2.getSsidName() != null).collect(Collectors.toList());
            ssidTrafficList = com.tplink.smb.omada.monitor.statistic.common.b.e.a(trafficList, Integer.MAX_VALUE, locale);
            for (NameTrafficVO nameTrafficVO : ssidTrafficList) {
                totalSsidTraffic += I.a((Long)nameTrafficVO.getTraffic());
            }
        }
        long startMills = TimeUnit.MILLISECONDS.convert(start, TimeUnit.SECONDS);
        long endMills = TimeUnit.MILLISECONDS.convert(end, TimeUnit.SECONDS);
        SsidSummaryDTO ssidSummaryDTO = this.e.a(omadacId, siteId, com.tplink.smb.omada.monitor.report.c.b.a(granularity), startMills, endMills);
        ArrayList clientsNumList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)ssidSummaryDTO.getSsids())) {
            ssidSummaryDTO.getSsids().forEach(ssidStat -> clientsNumList.add(new NameClientsVO(ssidStat.getSsid(), Integer.valueOf(ssidStat.getClients()))));
        }
        return SsidSummaryVO.builder().ssidTraffic(ssidTrafficList).totalSsidTraffic(Long.valueOf(totalSsidTraffic)).clientsNum(clientsNumList).build();
    }
}

