/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.report.d.a.b;

import com.tplink.smb.omada.anomaly.api.b.A;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.report.dto.CsvExportBaseDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.DeviceOutlineDTO;
import com.tplink.smb.omada.monitor.api.web.report.v6.ApInterferenceVO;
import com.tplink.smb.omada.monitor.api.web.report.v6.CardInfoVO;
import com.tplink.smb.omada.monitor.api.web.report.v6.TopApByInterferenceVO;
import com.tplink.smb.omada.monitor.api.web.report.v6.csv.dto.TopApInterferenceCsvDTO;
import com.tplink.smb.omada.monitor.report.d.a.a;
import com.tplink.smb.omada.monitor.report.d.b;
import com.tplink.smb.omada.monitor.report.d.c;
import com.tplink.smb.omada.monitor.report.dto.ReportTabParamDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.MacApStatDTO;
import com.tplink.smb.omada.monitor.statistic.port.a.c.e;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class u
extends a<TopApByInterferenceVO> {
    @Generated
    private static final Logger b = LoggerFactory.getLogger(u.class);
    private static final int c = 20;
    @Autowired
    private com.tplink.smb.omada.monitor.statistic.e.c d;
    @Autowired
    private e e;
    @Autowired
    private com.tplink.smb.omada.anomaly.api.internal.health.b f;

    @Override
    public String a() {
        return com.tplink.smb.omada.monitor.report.d.c.z.a();
    }

    @Override
    public void a(CardInfoVO cardInfoVO, ReportTabParamDTO params) {
        long startTime = System.currentTimeMillis();
        TopApByInterferenceVO topApByInterferenceVO = (TopApByInterferenceVO)this.a(params, TopApByInterferenceVO.class);
        if (Objects.isNull(topApByInterferenceVO)) {
            topApByInterferenceVO = this.e(params);
            this.b(params, topApByInterferenceVO);
        }
        cardInfoVO.setTopApByInterference(topApByInterferenceVO);
        b.debug("getting card {} finished, omadacId:{}, siteId:{}, time spent for getting cards: {}", new Object[]{this.a(), params.getOmadacId(), params.getSiteId(), System.currentTimeMillis() - startTime});
    }

    @Override
    public void a(CardInfoVO cardInfoVO, Map<String, List<CsvExportBaseDTO>> csvDataMap, ReportTabParamDTO params) {
        if (Objects.isNull(cardInfoVO) || Objects.isNull(cardInfoVO.getTopApByInterference())) {
            return;
        }
        ArrayList<CsvExportBaseDTO> interCsvList = new ArrayList<CsvExportBaseDTO>();
        this.a(cardInfoVO.getTopApByInterference().getTopAp2gInterList(), interCsvList, A.a.b());
        this.a(cardInfoVO.getTopApByInterference().getTopAp2gInterList(), interCsvList, A.b.b());
        this.a(cardInfoVO.getTopApByInterference().getTopAp2gInterList(), interCsvList, A.d.b());
        csvDataMap.put(com.tplink.smb.omada.monitor.report.d.b.E.a(), interCsvList);
    }

    public void a(List<ApInterferenceVO> apInterferenceVOs, List<CsvExportBaseDTO> interCsvList, String radio) {
        if (com.tplink.smb.ecsp.common.util.CollectionUtils.isNotEmpty(apInterferenceVOs)) {
            for (ApInterferenceVO apInterferenceVO : apInterferenceVOs) {
                TopApInterferenceCsvDTO dto = new TopApInterferenceCsvDTO();
                dto.setRadio(radio);
                dto.setDevice(apInterferenceVO.getDevice());
                dto.setInterference(apInterferenceVO.getInterference());
                dto.setRxUtil(apInterferenceVO.getRxUtil());
                dto.setTxUtil(apInterferenceVO.getTxUtil());
                dto.setInterUtil(apInterferenceVO.getInterUtil());
                interCsvList.add((CsvExportBaseDTO)dto);
            }
        }
    }

    public TopApByInterferenceVO e(ReportTabParamDTO params) {
        TopApByInterferenceVO topApByInterferenceVO = new TopApByInterferenceVO();
        Map<String, DeviceOutlineDTO> deviceMap = this.a(params.getOmadacId(), params.getSiteId(), DeviceTypeEnum.a);
        if (CollectionUtils.isEmpty(deviceMap)) {
            return topApByInterferenceVO;
        }
        int limit = params.getTopK() == null ? 20 : params.getTopK();
        List<MacApStatDTO> macApStatDTOList = this.d.h(params.getGranularity(), params.getOmadacId(), params.getSiteId(), params.getStart(), params.getEnd());
        topApByInterferenceVO.setTopAp2gInterList(this.a(macApStatDTOList, deviceMap, limit));
        topApByInterferenceVO.setTopAp5gInterList(this.b(macApStatDTOList, deviceMap, limit));
        topApByInterferenceVO.setTopAp6gInterList(this.c(macApStatDTOList, deviceMap, limit));
        return topApByInterferenceVO;
    }

    private List<ApInterferenceVO> a(List<MacApStatDTO> statList, Map<String, DeviceOutlineDTO> deviceMap, int limit) {
        if (com.tplink.smb.ecsp.common.util.CollectionUtils.isEmpty(statList)) {
            return new ArrayList<ApInterferenceVO>();
        }
        int i2 = 0;
        statList.forEach(macApStatDTO -> {
            DeviceOutlineDTO deviceOutlineDTO;
            if (macApStatDTO.getMac() != null && !Objects.isNull(deviceMap.get(macApStatDTO.getMac())) && macApStatDTO.getInterUtil2g() == null && Boolean.TRUE.equals((deviceOutlineDTO = (DeviceOutlineDTO)deviceMap.get(macApStatDTO.getMac())).getSupport2g())) {
                macApStatDTO.setInterUtil2g(0);
            }
        });
        statList = statList.stream().filter(stat -> {
            if (stat.getMac() != null && !Objects.isNull(deviceMap.get(stat.getMac()))) {
                return Boolean.TRUE.equals(((DeviceOutlineDTO)deviceMap.get(stat.getMac())).getSupport2g()) && Objects.nonNull(stat.getInterUtil2g());
            }
            return false;
        }).sorted(Comparator.comparing(MacApStatDTO::getInterUtil2g).reversed()).collect(Collectors.toList());
        ArrayList<ApInterferenceVO> apInterferenceList = new ArrayList<ApInterferenceVO>();
        for (MacApStatDTO apStatDTO : statList) {
            if (i2 >= limit) break;
            ApInterferenceVO apInterference = new ApInterferenceVO();
            if (Objects.isNull(deviceMap.get(apStatDTO.getMac()))) continue;
            DeviceOutlineDTO deviceOutlineDTO = deviceMap.get(apStatDTO.getMac());
            apInterference.setDevice(deviceOutlineDTO.getName());
            apInterference.setModel(deviceOutlineDTO.getModel());
            apInterference.setModelVersion(deviceOutlineDTO.getModelVersion());
            apInterference.setType(deviceOutlineDTO.getType());
            apInterference.setInterUtil(Integer.valueOf(apStatDTO.getInter2g() == null ? 0 : apStatDTO.getInter2g()));
            apInterference.setRxUtil(Integer.valueOf(apStatDTO.getRxUtil2g() == null ? 0 : apStatDTO.getRxUtil2g()));
            apInterference.setTxUtil(Integer.valueOf(apStatDTO.getTxUtil2g() == null ? 0 : apStatDTO.getTxUtil2g()));
            apInterference.setInterference(Integer.valueOf(apStatDTO.getInterUtil2g() == null ? 0 : apStatDTO.getInterUtil2g()));
            apInterferenceList.add(apInterference);
            ++i2;
        }
        return apInterferenceList;
    }

    private List<ApInterferenceVO> b(List<MacApStatDTO> statList, Map<String, DeviceOutlineDTO> deviceMap, int limit) {
        if (com.tplink.smb.ecsp.common.util.CollectionUtils.isEmpty(statList)) {
            return new ArrayList<ApInterferenceVO>();
        }
        int i2 = 0;
        statList = statList.stream().filter(stat -> {
            if (stat.getMac() != null && !Objects.isNull(deviceMap.get(stat.getMac()))) {
                return Boolean.TRUE.equals(((DeviceOutlineDTO)deviceMap.get(stat.getMac())).getSupport5g()) || Boolean.TRUE.equals(((DeviceOutlineDTO)deviceMap.get(stat.getMac())).getSupport5g2());
            }
            return false;
        }).sorted(Comparator.comparing(MacApStatDTO::getInter5gAnd5g2Total).reversed()).collect(Collectors.toList());
        ArrayList<ApInterferenceVO> apInterferenceList = new ArrayList<ApInterferenceVO>();
        for (MacApStatDTO apStatDTO : statList) {
            if (i2 >= limit) break;
            ApInterferenceVO apInterference = new ApInterferenceVO();
            if (Objects.isNull(deviceMap.get(apStatDTO.getMac()))) continue;
            DeviceOutlineDTO deviceOutlineDTO = deviceMap.get(apStatDTO.getMac());
            apInterference.setDevice(deviceOutlineDTO.getName());
            apInterference.setModel(deviceOutlineDTO.getModel());
            apInterference.setModelVersion(deviceOutlineDTO.getModelVersion());
            apInterference.setType(deviceOutlineDTO.getType());
            apInterference.setInterUtil(Integer.valueOf(Math.round((this.a(apStatDTO.getInter5g()) + this.a(apStatDTO.getInter5g2())) / 2)));
            apInterference.setRxUtil(Integer.valueOf(Math.round((this.a(apStatDTO.getRxUtil5g()) + this.a(apStatDTO.getRxUtil5g2())) / 2)));
            apInterference.setTxUtil(Integer.valueOf(Math.round((this.a(apStatDTO.getTxUtil5g()) + this.a(apStatDTO.getTxUtil5g2())) / 2)));
            apInterference.setInterference(apStatDTO.getInter5gAnd5g2Total());
            apInterferenceList.add(apInterference);
            ++i2;
        }
        return apInterferenceList;
    }

    private Integer a(Integer number) {
        return Optional.ofNullable(number).orElse(0);
    }

    private List<ApInterferenceVO> c(List<MacApStatDTO> statList, Map<String, DeviceOutlineDTO> deviceMap, int limit) {
        if (com.tplink.smb.ecsp.common.util.CollectionUtils.isEmpty(statList)) {
            return new ArrayList<ApInterferenceVO>();
        }
        int i2 = 0;
        statList.forEach(macApStatDTO -> {
            DeviceOutlineDTO deviceOutlineDTO;
            if (macApStatDTO.getMac() != null && !Objects.isNull(deviceMap.get(macApStatDTO.getMac())) && macApStatDTO.getInterUtil6g() == null && Boolean.TRUE.equals((deviceOutlineDTO = (DeviceOutlineDTO)deviceMap.get(macApStatDTO.getMac())).getSupport6g())) {
                macApStatDTO.setInterUtil6g(0);
            }
        });
        statList = statList.stream().filter(stat -> {
            if (stat.getMac() != null && !Objects.isNull(deviceMap.get(stat.getMac()))) {
                return Boolean.TRUE.equals(((DeviceOutlineDTO)deviceMap.get(stat.getMac())).getSupport6g()) && Objects.nonNull(stat.getInterUtil6g());
            }
            return false;
        }).sorted(Comparator.comparing(MacApStatDTO::getInterUtil6g).reversed()).collect(Collectors.toList());
        ArrayList<ApInterferenceVO> apInterferenceList = new ArrayList<ApInterferenceVO>();
        for (MacApStatDTO apStatDTO : statList) {
            if (i2 >= limit) break;
            ApInterferenceVO apInterference = new ApInterferenceVO();
            if (Objects.isNull(deviceMap.get(apStatDTO.getMac()))) continue;
            DeviceOutlineDTO deviceOutlineDTO = deviceMap.get(apStatDTO.getMac());
            apInterference.setDevice(deviceOutlineDTO.getName());
            apInterference.setModel(deviceOutlineDTO.getModel());
            apInterference.setModelVersion(deviceOutlineDTO.getModelVersion());
            apInterference.setType(deviceOutlineDTO.getType());
            apInterference.setInterUtil(Integer.valueOf(apStatDTO.getInter6g() == null ? 0 : apStatDTO.getInter6g()));
            apInterference.setRxUtil(Integer.valueOf(apStatDTO.getRxUtil6g() == null ? 0 : apStatDTO.getRxUtil6g()));
            apInterference.setTxUtil(Integer.valueOf(apStatDTO.getTxUtil6g() == null ? 0 : apStatDTO.getTxUtil6g()));
            apInterference.setInterference(Integer.valueOf(apStatDTO.getInterUtil6g() == null ? 0 : apStatDTO.getInterUtil6g()));
            apInterferenceList.add(apInterference);
            ++i2;
        }
        return apInterferenceList;
    }
}

