/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.report.d.a.b;

import cn.hutool.core.convert.Convert;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.common.report.dto.CsvExportBaseDTO;
import com.tplink.smb.omada.common.util.I;
import com.tplink.smb.omada.logmanager.api.internal.dto.LogClassifyInfoRequestDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.LogClassifyNumInfoDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.LogTypeEnum;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.DeviceOutlineDTO;
import com.tplink.smb.omada.monitor.api.web.report.v6.CardInfoVO;
import com.tplink.smb.omada.monitor.api.web.report.v6.SwitchAlertRebootVO;
import com.tplink.smb.omada.monitor.api.web.report.v6.csv.dto.AlertSummaryCsvDTO;
import com.tplink.smb.omada.monitor.api.web.report.v6.csv.dto.RebootTimeCsvDTO;
import com.tplink.smb.omada.monitor.api.web.report.vo.NameRebootVO;
import com.tplink.smb.omada.monitor.api.web.report.vo.SwitchAlertVO;
import com.tplink.smb.omada.monitor.api.web.report.vo.SwitchRebootTimesVO;
import com.tplink.smb.omada.monitor.report.d.a.a;
import com.tplink.smb.omada.monitor.report.d.b;
import com.tplink.smb.omada.monitor.report.d.c;
import com.tplink.smb.omada.monitor.report.dto.ReportTabParamDTO;
import com.tplink.smb.omada.monitor.statistic.common.b.e;
import com.tplink.smb.omada.monitor.statistic.common.dto.MacRebootTimesDTO;
import com.tplink.smb.omada.monitor.statistic.e.u;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class p
extends a<SwitchAlertRebootVO> {
    @Generated
    private static final Logger b = LoggerFactory.getLogger(p.class);
    private static final int c = 5;
    @Autowired
    private u d;
    @Autowired
    private com.tplink.smb.omada.logmanager.api.internal.c e;

    @Override
    public String a() {
        return com.tplink.smb.omada.monitor.report.d.c.q.a();
    }

    @Override
    public void a(CardInfoVO cardInfoVO, ReportTabParamDTO params) {
        long startTime = System.currentTimeMillis();
        SwitchAlertRebootVO switchAlertVO = (SwitchAlertRebootVO)this.a(params, SwitchAlertRebootVO.class);
        if (Objects.isNull(switchAlertVO)) {
            switchAlertVO = this.e(params);
            this.b(params, switchAlertVO);
        }
        cardInfoVO.setSwitchAlertReboot(switchAlertVO);
        b.debug("getting card {} finished, omadacId:{}, siteId:{}, time spent for getting cards: {}", new Object[]{this.a(), params.getOmadacId(), params.getSiteId(), System.currentTimeMillis() - startTime});
    }

    @Override
    public void a(CardInfoVO cardInfoVO, Map<String, List<CsvExportBaseDTO>> csvDataMap, ReportTabParamDTO params) {
        if (Objects.isNull(cardInfoVO) || Objects.isNull(cardInfoVO.getSwitchAlertReboot())) {
            return;
        }
        SwitchAlertRebootVO switchAlertReboot = cardInfoVO.getSwitchAlertReboot();
        if (Objects.nonNull(switchAlertReboot.getSwitchAlert())) {
            AlertSummaryCsvDTO alertCsvDTO = (AlertSummaryCsvDTO)Convert.convert(AlertSummaryCsvDTO.class, (Object)switchAlertReboot.getSwitchAlert());
            List<AlertSummaryCsvDTO> alertCsvData = List.of(alertCsvDTO);
            csvDataMap.put(com.tplink.smb.omada.monitor.report.d.b.q.a(), alertCsvData);
        }
        if (Objects.nonNull(switchAlertReboot.getSwitchRebootTimes())) {
            SwitchRebootTimesVO switchRebootTimes = switchAlertReboot.getSwitchRebootTimes();
            ArrayList<CsvExportBaseDTO> rebootCsvData = new ArrayList<CsvExportBaseDTO>();
            if (switchRebootTimes.getFirstSwitch() != null) {
                rebootCsvData.add((CsvExportBaseDTO)Convert.convert(RebootTimeCsvDTO.class, (Object)switchRebootTimes.getFirstSwitch()));
            }
            if (switchRebootTimes.getSecondSwitch() != null) {
                rebootCsvData.add((CsvExportBaseDTO)Convert.convert(RebootTimeCsvDTO.class, (Object)switchRebootTimes.getSecondSwitch()));
            }
            if (switchRebootTimes.getThirdSwitch() != null) {
                rebootCsvData.add((CsvExportBaseDTO)Convert.convert(RebootTimeCsvDTO.class, (Object)switchRebootTimes.getThirdSwitch()));
            }
            if (switchRebootTimes.getFourthSwitch() != null) {
                rebootCsvData.add((CsvExportBaseDTO)Convert.convert(RebootTimeCsvDTO.class, (Object)switchRebootTimes.getFourthSwitch()));
            }
            if (switchRebootTimes.getFifthSwitch() != null) {
                rebootCsvData.add((CsvExportBaseDTO)Convert.convert(RebootTimeCsvDTO.class, (Object)switchRebootTimes.getFifthSwitch()));
            }
            csvDataMap.put(com.tplink.smb.omada.monitor.report.d.b.r.a(), rebootCsvData);
        }
    }

    public SwitchAlertRebootVO e(ReportTabParamDTO params) {
        SwitchAlertRebootVO switchAlertVO = new SwitchAlertRebootVO();
        switchAlertVO.setSwitchAlert(this.a(params.getOmadacId(), params.getSiteId(), (long)params.getStart(), (long)params.getEnd(), params.getIsRoot()));
        switchAlertVO.setSwitchRebootTimes(this.a(params.getOmadacId(), params.getSiteId(), params.getStart(), params.getEnd(), params.getGranularity(), params.getLocale()));
        return switchAlertVO;
    }

    public SwitchAlertVO a(String omadacId, String siteId, long start, long end, boolean isRoot) {
        LogClassifyInfoRequestDTO requestDTO = LogClassifyInfoRequestDTO.builder().omadacId(omadacId).siteId(siteId).deviceType(DeviceTypeEnum.c).startTime(Long.valueOf(TimeUnit.MILLISECONDS.convert(start, TimeUnit.SECONDS))).endTime(Long.valueOf(TimeUnit.MILLISECONDS.convert(end, TimeUnit.SECONDS))).isRoot(Boolean.valueOf(isRoot)).logTypeEnum(LogTypeEnum.a).build();
        OperationResponse logClassifyNumInfoOpt = this.e.a(requestDTO);
        if (!logClassifyNumInfoOpt.success() || Objects.isNull(logClassifyNumInfoOpt.getResult())) {
            return SwitchAlertVO.getDefault();
        }
        LogClassifyNumInfoDTO dto = (LogClassifyNumInfoDTO)logClassifyNumInfoOpt.getResult();
        return SwitchAlertVO.builder().infoAlerts(Long.valueOf(I.a((Long)dto.getInfoNum()))).warningAlerts(Long.valueOf(I.a((Long)dto.getWarningNum()))).errorAlerts(Long.valueOf(I.a((Long)dto.getErrorNum()))).criticalAlerts(Long.valueOf(I.a((Long)dto.getCriticalNum()))).totalAlerts(Long.valueOf(this.a(dto.getInfoNum(), dto.getWarningNum(), dto.getErrorNum(), dto.getCriticalNum()))).build();
    }

    public SwitchRebootTimesVO a(String omadacId, String siteId, Long start, Long end, N granularity, Locale locale) {
        Map<String, DeviceOutlineDTO> deviceMap = this.a(omadacId, siteId, DeviceTypeEnum.c);
        if (CollectionUtils.isEmpty(deviceMap)) {
            return SwitchRebootTimesVO.getDefault();
        }
        Set<String> macSet = deviceMap.keySet();
        int totalTimes = 0;
        List<MacRebootTimesDTO> macRebootTimesList = this.d.c(granularity, omadacId, siteId, start, end);
        if (CollectionUtils.isEmpty(macRebootTimesList)) {
            return SwitchRebootTimesVO.getDefault();
        }
        for (MacRebootTimesDTO macRebootTimesDTO : macRebootTimesList) {
            totalTimes += macRebootTimesDTO.getRebootTimes() == null ? 0 : macRebootTimesDTO.getRebootTimes();
        }
        int limit = Math.min(5, macSet.size());
        ArrayList nameRebootVOList = new ArrayList();
        com.tplink.smb.omada.monitor.statistic.common.b.e.c(deviceMap, macRebootTimesList, limit, locale).forEach(distVO -> nameRebootVOList.add(new NameRebootVO(distVO.getName(), distVO.getRebootTimes())));
        return SwitchRebootTimesVO.builder().totalSwitchTimes(Integer.valueOf(totalTimes)).firstSwitch(nameRebootVOList.size() >= 1 ? (NameRebootVO)nameRebootVOList.get(0) : null).secondSwitch(nameRebootVOList.size() >= 2 ? (NameRebootVO)nameRebootVOList.get(1) : null).thirdSwitch(nameRebootVOList.size() >= 3 ? (NameRebootVO)nameRebootVOList.get(2) : null).fourthSwitch(nameRebootVOList.size() >= 4 ? (NameRebootVO)nameRebootVOList.get(3) : null).fifthSwitch(nameRebootVOList.size() >= 5 ? (NameRebootVO)nameRebootVOList.get(4) : null).build();
    }
}

