/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.report.d.a.b;

import cn.hutool.core.convert.Convert;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.common.report.dto.CsvExportBaseDTO;
import com.tplink.smb.omada.common.util.I;
import com.tplink.smb.omada.common.util.W;
import com.tplink.smb.omada.logmanager.api.internal.dto.LogClassifyInfoRequestDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.LogClassifyNumInfoDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.LogTypeEnum;
import com.tplink.smb.omada.manager.configuration.api.internal.dto.DstInfoDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.DeviceOutlineDTO;
import com.tplink.smb.omada.monitor.api.web.report.v6.AlertVO;
import com.tplink.smb.omada.monitor.api.web.report.v6.CardInfoVO;
import com.tplink.smb.omada.monitor.api.web.report.v6.GatewaySummaryVO;
import com.tplink.smb.omada.monitor.api.web.report.v6.csv.dto.AlertSummaryCsvDTO;
import com.tplink.smb.omada.monitor.api.web.report.v6.csv.dto.CpuMemUtilCsvDTO;
import com.tplink.smb.omada.monitor.api.web.report.vo.GatewayCpuMemUtilListVO;
import com.tplink.smb.omada.monitor.api.web.report.vo.GatewayCpuMemUtilVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.BaseDeviceStatDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OsgStatDTO;
import com.tplink.smb.omada.monitor.report.d.a.a;
import com.tplink.smb.omada.monitor.report.d.b;
import com.tplink.smb.omada.monitor.report.d.c;
import com.tplink.smb.omada.monitor.report.dto.ReportTabParamDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class j
extends a<GatewaySummaryVO> {
    @Generated
    private static final Logger b = LoggerFactory.getLogger(j.class);
    @Autowired
    private com.tplink.smb.omada.manager.device.api.internal.device.b c;
    @Autowired
    private com.tplink.smb.omada.monitor.report.a d;
    @Autowired
    private com.tplink.smb.omada.logmanager.api.internal.c e;

    @Override
    public String a() {
        return com.tplink.smb.omada.monitor.report.d.c.l.a();
    }

    @Override
    public void a(CardInfoVO cardInfoVO, ReportTabParamDTO params) {
        long startTime = System.currentTimeMillis();
        GatewaySummaryVO gatewaySummaryVO = (GatewaySummaryVO)this.b(params, List.class);
        if (Objects.isNull(gatewaySummaryVO)) {
            gatewaySummaryVO = this.e(params);
            this.a(params, gatewaySummaryVO);
        }
        cardInfoVO.setGatewaySummary(gatewaySummaryVO);
        b.debug("getting card {} finished, omadacId:{}, siteId:{}, time spent for getting cards: {}", new Object[]{this.a(), params.getOmadacId(), params.getSiteId(), System.currentTimeMillis() - startTime});
    }

    @Override
    public void a(CardInfoVO cardInfoVO, Map<String, List<CsvExportBaseDTO>> csvDataMap, ReportTabParamDTO params) {
        if (Objects.isNull(cardInfoVO) || Objects.isNull(cardInfoVO.getGatewaySummary())) {
            return;
        }
        GatewaySummaryVO gatewaySummaryVO = cardInfoVO.getGatewaySummary();
        if (Objects.nonNull(gatewaySummaryVO.getGatewayAlert())) {
            AlertSummaryCsvDTO csvDTO = (AlertSummaryCsvDTO)Convert.convert(AlertSummaryCsvDTO.class, (Object)gatewaySummaryVO.getGatewayAlert());
            csvDataMap.put(com.tplink.smb.omada.monitor.report.d.b.k.a(), List.of(csvDTO));
        }
        if (!CollectionUtils.isEmpty((Collection)gatewaySummaryVO.getGatewayUltilization())) {
            ArrayList<CpuMemUtilCsvDTO> cpuMemUtilCsvDTOList = new ArrayList<CpuMemUtilCsvDTO>();
            DstInfoDTO dstInfoDTO = this.b(params.getOmadacId(), params.getSiteId());
            String timeZoneId = this.a(params.getOmadacId(), params.getSiteId());
            for (GatewayCpuMemUtilListVO gatewayCpuMemUtilVO : gatewaySummaryVO.getGatewayUltilization()) {
                CpuMemUtilCsvDTO dto = new CpuMemUtilCsvDTO();
                dto.setTime(com.tplink.smb.omada.monitor.common.i.c.d((DstInfoDTO)dstInfoDTO, (String)timeZoneId, (Long)gatewayCpuMemUtilVO.getTime()));
                dto.setCpuUtil(gatewayCpuMemUtilVO.getCpuUtil());
                dto.setMemUtil(gatewayCpuMemUtilVO.getMemUtil());
                cpuMemUtilCsvDTOList.add(dto);
            }
            csvDataMap.put(com.tplink.smb.omada.monitor.report.d.b.l.a(), new ArrayList(cpuMemUtilCsvDTOList));
        }
    }

    public GatewaySummaryVO e(ReportTabParamDTO params) {
        GatewaySummaryVO gatewaySummaryVO = new GatewaySummaryVO();
        gatewaySummaryVO.setGatewayUltilization(this.f(params).getGatewayCpuMemUtilList());
        gatewaySummaryVO.setGatewayAlert(this.a(params.getOmadacId(), params.getSiteId(), (long)params.getStart(), (long)params.getEnd(), params.getIsRoot()));
        return gatewaySummaryVO;
    }

    public AlertVO a(String omadacId, String siteId, long start, long end, boolean isRoot) {
        LogClassifyInfoRequestDTO requestDTO = LogClassifyInfoRequestDTO.builder().omadacId(omadacId).siteId(siteId).deviceType(DeviceTypeEnum.b).startTime(Long.valueOf(TimeUnit.MILLISECONDS.convert(start, TimeUnit.SECONDS))).endTime(Long.valueOf(TimeUnit.MILLISECONDS.convert(end, TimeUnit.SECONDS))).isRoot(Boolean.valueOf(isRoot)).logTypeEnum(LogTypeEnum.a).build();
        OperationResponse logClassifyNumInfoOpt = this.e.a(requestDTO);
        if (!logClassifyNumInfoOpt.success() || Objects.isNull(logClassifyNumInfoOpt.getResult())) {
            return AlertVO.getDefault();
        }
        LogClassifyNumInfoDTO dto = (LogClassifyNumInfoDTO)logClassifyNumInfoOpt.getResult();
        AlertVO vo = new AlertVO();
        vo.setInfoAlerts(Long.valueOf(I.a((Long)dto.getInfoNum())));
        vo.setWarningAlerts(Long.valueOf(I.a((Long)dto.getWarningNum())));
        vo.setErrorAlerts(Long.valueOf(I.a((Long)dto.getErrorNum())));
        vo.setCriticalAlerts(Long.valueOf(I.a((Long)dto.getCriticalNum())));
        vo.setTotalAlerts(Long.valueOf(this.a(dto.getInfoNum(), dto.getWarningNum(), dto.getErrorNum(), dto.getCriticalNum())));
        return vo;
    }

    public GatewayCpuMemUtilVO f(ReportTabParamDTO params) {
        List deviceList = this.c.a(new com.tplink.smb.omada.manager.device.api.internal.device.dto.b(params.getOmadacId(), params.getSiteId(), DeviceTypeEnum.b.b()));
        List<GatewayCpuMemUtilListVO> emptyList = this.d.a(params.getStart(), params.getEnd(), params.getGranularity(), null, GatewayCpuMemUtilListVO.class);
        if (CollectionUtils.isEmpty((Collection)deviceList)) {
            return new GatewayCpuMemUtilVO(emptyList);
        }
        DeviceOutlineDTO gatewayOutline = (DeviceOutlineDTO)deviceList.get(0);
        String mac = gatewayOutline.getMac();
        if (Objects.isNull(mac)) {
            return new GatewayCpuMemUtilVO(emptyList);
        }
        List<OsgStatDTO> osgStatList = this.d(params);
        ArrayList<GatewayCpuMemUtilListVO> cpuMemUtilList = new ArrayList<GatewayCpuMemUtilListVO>();
        if (!CollectionUtils.isEmpty(osgStatList)) {
            osgStatList = new ArrayList(osgStatList.stream().collect(Collectors.toMap(BaseDeviceStatDTO::getTime, v2 -> v2, (v1, v2) -> v2, TreeMap::new)).values());
            osgStatList.forEach(osgStatDTO -> cpuMemUtilList.add(new GatewayCpuMemUtilListVO(osgStatDTO.getTime(), osgStatDTO.getCpu(), osgStatDTO.getMem())));
        }
        if (params.getGranularity() != N.a) {
            N timeGranularityEnum;
            long lastTime;
            if (params.getGranularity() == N.c) {
                lastTime = W.f((long)params.getEnd());
                timeGranularityEnum = N.a;
            } else {
                lastTime = W.e((long)params.getEnd());
                timeGranularityEnum = N.c;
            }
            ReportTabParamDTO paramDTO = this.a(params, lastTime, timeGranularityEnum);
            List<OsgStatDTO> osgStatList2 = this.d(paramDTO);
            if (!CollectionUtils.isEmpty(osgStatList2)) {
                double cpu = osgStatList2.stream().filter(v2 -> v2.getCpu() != null).mapToLong(BaseDeviceStatDTO::getCpu).average().orElse(0.0);
                double mem = osgStatList2.stream().filter(v2 -> v2.getMem() != null).mapToLong(BaseDeviceStatDTO::getMem).average().orElse(0.0);
                cpuMemUtilList.add(new GatewayCpuMemUtilListVO(Long.valueOf(lastTime + N.a((N)params.getGranularity())), Integer.valueOf((int)Math.round(cpu)), Integer.valueOf((int)Math.round(mem))));
            }
        }
        List<GatewayCpuMemUtilListVO> gatewayCpuMemUtilList = this.d.a(params.getStart(), params.getEnd(), params.getGranularity(), cpuMemUtilList, GatewayCpuMemUtilListVO.class);
        GatewayCpuMemUtilVO vo = new GatewayCpuMemUtilVO();
        vo.setGatewayCpuMemUtilList(gatewayCpuMemUtilList);
        return vo;
    }
}

