/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.report.d.a.a;

import cn.hutool.core.convert.Convert;
import com.tplink.smb.omada.client.api.internal.d;
import com.tplink.smb.omada.client.api.internal.dto.ClientDistributionDTO;
import com.tplink.smb.omada.client.api.internal.dto.SsidStatDTO;
import com.tplink.smb.omada.client.api.internal.dto.SsidSummaryDTO;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.common.report.dto.CsvExportBaseDTO;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.monitor.api.web.report.v6.CardInfoVO;
import com.tplink.smb.omada.monitor.api.web.report.v6.ClientsOverviewVO;
import com.tplink.smb.omada.monitor.api.web.report.v6.SiteTrafficSummaryDTO;
import com.tplink.smb.omada.monitor.api.web.report.v6.SsidDistributionVO;
import com.tplink.smb.omada.monitor.api.web.report.v6.SsidStatVO;
import com.tplink.smb.omada.monitor.api.web.report.v6.csv.dto.ClientsOverviewCsvDTO;
import com.tplink.smb.omada.monitor.api.web.report.v6.csv.dto.SsidDistributionCsvDTO;
import com.tplink.smb.omada.monitor.report.d.a.a;
import com.tplink.smb.omada.monitor.report.d.b;
import com.tplink.smb.omada.monitor.report.dto.ReportTabParamDTO;
import com.tplink.smb.omada.monitor.statistic.c.f.e;
import com.tplink.smb.omada.monitor.statistic.c.f.f;
import com.tplink.smb.omada.monitor.statistic.c.f.g;
import com.tplink.smb.omada.monitor.statistic.common.dto.SsidStatQueryDTO;
import com.tplink.smb.omada.monitor.statistic.e.w;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class c
extends a<ClientsOverviewVO> {
    @Generated
    private static final Logger b = LoggerFactory.getLogger(c.class);
    @Autowired
    private d c;
    @Autowired
    private w d;
    @Autowired
    private e e;
    @Autowired
    private g f;
    @Autowired
    private f g;

    @Override
    public String a() {
        return com.tplink.smb.omada.monitor.report.d.c.F.a();
    }

    @Override
    public void a(CardInfoVO cardInfoVO, ReportTabParamDTO params) {
        long startTime = System.currentTimeMillis();
        ClientsOverviewVO clientsOverviewVO = (ClientsOverviewVO)this.a(params, ClientsOverviewVO.class);
        if (Objects.isNull(clientsOverviewVO)) {
            clientsOverviewVO = this.a(params.getOmadacId(), params.getSiteId(), params.getGranularity(), params.getStart(), params.getEnd());
            this.b(params, clientsOverviewVO);
        }
        cardInfoVO.setClientsOverview(clientsOverviewVO);
        b.debug("getting card ClientsOverviewCardService finished, time spent for getting cards: {}", (Object)(System.currentTimeMillis() - startTime));
    }

    @Override
    public void a(CardInfoVO cardInfoVO, Map<String, List<CsvExportBaseDTO>> csvDataMap, ReportTabParamDTO params) {
        if (Objects.isNull(cardInfoVO) || Objects.isNull(cardInfoVO.getClientsOverview())) {
            return;
        }
        ClientsOverviewCsvDTO csvDTO = (ClientsOverviewCsvDTO)Convert.convert(ClientsOverviewCsvDTO.class, (Object)cardInfoVO.getClientsOverview());
        csvDataMap.put(com.tplink.smb.omada.monitor.report.d.b.M.a(), List.of(csvDTO));
        if (Objects.nonNull(cardInfoVO.getClientsOverview().getClientsSsidDistribution())) {
            ArrayList<CsvExportBaseDTO> ssidCsvList = new ArrayList<CsvExportBaseDTO>();
            this.a(cardInfoVO.getClientsOverview().getClientsSsidDistribution().getFirstSsid(), ssidCsvList);
            this.a(cardInfoVO.getClientsOverview().getClientsSsidDistribution().getSecondSsid(), ssidCsvList);
            this.a(cardInfoVO.getClientsOverview().getClientsSsidDistribution().getThirdSsid(), ssidCsvList);
            this.a(cardInfoVO.getClientsOverview().getClientsSsidDistribution().getFourthSsid(), ssidCsvList);
            this.a(cardInfoVO.getClientsOverview().getClientsSsidDistribution().getFifthSsid(), ssidCsvList);
            csvDataMap.put(com.tplink.smb.omada.monitor.report.d.b.N.a(), ssidCsvList);
        }
    }

    public void a(SsidStatVO ssidStat, List<CsvExportBaseDTO> ssidCsvList) {
        if (Objects.nonNull(ssidStat)) {
            SsidDistributionCsvDTO dto = new SsidDistributionCsvDTO();
            dto.setSsid(ssidStat.getSsid());
            dto.setClientsNum(Integer.valueOf(ssidStat.getClientsNum()));
            ssidCsvList.add((CsvExportBaseDTO)dto);
        }
    }

    public ClientsOverviewVO a(String omadacId, String siteId, N granularity, Long start, Long end) {
        long startMills = TimeUnit.MILLISECONDS.convert(start, TimeUnit.SECONDS);
        long endMills = TimeUnit.MILLISECONDS.convert(end, TimeUnit.SECONDS);
        ClientDistributionDTO clientDistributionDTO = this.c.b(omadacId, siteId, startMills, endMills);
        SiteTrafficSummaryDTO siteTrafficSummary = this.d.f(omadacId, siteId, start, end, granularity);
        int totalClientsNum = clientDistributionDTO.getClients();
        int averageClientNum = (int)((long)totalClientsNum * TimeUnit.DAYS.toSeconds(1L) / (end - start));
        long averageClientTraffic = totalClientsNum == 0 ? 0L : (Optional.ofNullable(siteTrafficSummary.getAp2gTraffic()).orElse(0L) + Optional.ofNullable(siteTrafficSummary.getAp5gTraffic()).orElse(0L) + Optional.ofNullable(siteTrafficSummary.getAp6gTraffic()).orElse(0L) + Optional.ofNullable(siteTrafficSummary.getOsgTx()).orElse(0L) + Optional.ofNullable(siteTrafficSummary.getOsgRx()).orElse(0L) + Optional.ofNullable(siteTrafficSummary.getOswTx()).orElse(0L) + Optional.ofNullable(siteTrafficSummary.getOswRx()).orElse(0L)) / (long)totalClientsNum;
        SsidSummaryDTO ssidSummaryDTO = this.c.a(omadacId, siteId, com.tplink.smb.omada.monitor.report.c.b.a(granularity), startMills, endMills);
        SsidStatQueryDTO ssidStatQuery = new SsidStatQueryDTO(omadacId, siteId, null, start, end);
        SsidDistributionVO clientsSsidDistributionVO = this.a(ssidSummaryDTO.getSsids(), ssidStatQuery, granularity);
        ClientsOverviewVO vo = new ClientsOverviewVO();
        vo.setTotalClientsNum(Integer.valueOf(totalClientsNum));
        vo.setWirelessClientsNum(Integer.valueOf(clientDistributionDTO.getWirelessClients()));
        vo.setWiredClientsNum(Integer.valueOf(clientDistributionDTO.getWiredClients()));
        vo.setClients2gNum(Integer.valueOf(clientDistributionDTO.getClients2g()));
        vo.setClients5gNum(Integer.valueOf(clientDistributionDTO.getClients5g()));
        vo.setClients6gNum(Integer.valueOf(clientDistributionDTO.getClients6g()));
        vo.setAverageClientNum(Integer.valueOf(averageClientNum));
        vo.setAverageClientTraffic(Long.valueOf(averageClientTraffic));
        vo.setClientsSsidDistribution(clientsSsidDistributionVO);
        return vo;
    }

    public Set<String> a(N granularity, SsidStatQueryDTO ssidStatQuery) {
        return switch (granularity) {
            case N.a -> this.e.a(ssidStatQuery);
            case N.c -> this.f.a(ssidStatQuery);
            case N.d -> this.g.a(ssidStatQuery);
            default -> Collections.emptySet();
        };
    }

    public SsidDistributionVO a(List<SsidStatDTO> ssidStatDTOList, SsidStatQueryDTO ssidStatQuery, N granularity) {
        SsidDistributionVO vo = new SsidDistributionVO();
        if (Objects.isNull(ssidStatDTOList) || ssidStatDTOList.size() < 6) {
            Set<String> ssidNameSet = this.a(granularity, ssidStatQuery);
            b.debug("Get ssidStatDTOList:{},ssidNameSet:{} for omadacId {}, siteId {}", new Object[]{ssidStatDTOList, ssidNameSet, ssidStatQuery.getOmadacId(), ssidStatQuery.getSiteId()});
            if (Objects.isNull(ssidStatDTOList)) {
                ssidStatDTOList = new ArrayList<SsidStatDTO>();
            }
            ssidStatDTOList.forEach(ssidStatDTO -> ssidNameSet.remove(ssidStatDTO.getSsid()));
            ssidNameSet.stream().filter(T::a).map(ssidName -> new SsidStatDTO(ssidName, 0)).forEach(ssidStatDTOList::add);
        }
        if (ssidStatDTOList.size() > 5) {
            int otherClients = ssidStatDTOList.stream().skip(5L).mapToInt(SsidStatDTO::getClients).sum();
            vo.setOtherSsid(new SsidStatVO("Others", otherClients));
        }
        block7: for (int i2 = 0; i2 < 5; ++i2) {
            if (i2 >= ssidStatDTOList.size()) continue;
            SsidStatDTO dto = ssidStatDTOList.get(i2);
            switch (i2) {
                case 0: {
                    vo.setFirstSsid(new SsidStatVO(dto.getSsid(), dto.getClients()));
                    continue block7;
                }
                case 1: {
                    vo.setSecondSsid(new SsidStatVO(dto.getSsid(), dto.getClients()));
                    continue block7;
                }
                case 2: {
                    vo.setThirdSsid(new SsidStatVO(dto.getSsid(), dto.getClients()));
                    continue block7;
                }
                case 3: {
                    vo.setFourthSsid(new SsidStatVO(dto.getSsid(), dto.getClients()));
                    continue block7;
                }
                case 4: {
                    vo.setFifthSsid(new SsidStatVO(dto.getSsid(), dto.getClients()));
                    continue block7;
                }
            }
        }
        return vo;
    }
}

