/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.log.component.client.local;

import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventCenter;
import com.tplink.smb.log.component.common.exception.LogComponentException;
import com.tplink.smb.log.component.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SendLogToServerService {
    @Autowired
    private EventCenter eventCenter;
    private final String topic;

    public SendLogToServerService(String topic) {
        if (StringUtils.isNull((String)topic)) {
            throw new LogComponentException("topic should not be null.");
        }
        this.topic = topic;
    }

    public void sendLogToServer(String message) {
        this.eventCenter.send(this.topic, ((Event.EventBuilder)Event.builder().message((Object)message)).build());
    }

    public void sendLogToServer(String message, String partitionKey) {
        this.eventCenter.send(this.topic, partitionKey, ((Event.EventBuilder)Event.builder().message((Object)message)).build());
    }
}

