/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.meshfailover;

import com.tplink.smb.meshfailover.a;
import com.tplink.smb.meshfailover.b;
import com.tplink.smb.meshfailover.b.c;
import com.tplink.smb.meshfailover.b.d;
import com.tplink.smb.meshfailover.b.e;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateThroughput {
    private static final boolean IS_PRINT_LOG_TRACE_ENABLE = false;
    private static final Logger log = LoggerFactory.getLogger(CalculateThroughput.class);
    private static final int DEFAULT_LIST_SIZE = 4;
    private static final int DEFAULT_MATRIX_SIZE = 50;
    private static final String ROOT_FATHER_DEVICE_MAC = "00-00-00-00-00-00";

    public List<d> getCandidateApThr(c dto) {
        List<d> candidateApList = dto.c();
        List<com.tplink.smb.meshfailover.b.b> apNodeInfos = dto.a();
        Map<String, com.tplink.smb.meshfailover.b.b> apNodeInfoMap = apNodeInfos.stream().collect(Collectors.toMap(com.tplink.smb.meshfailover.b.b::a, Function.identity(), (v1, v2) -> v2));
        Map<String, e> patParameterMap = dto.b();
        com.tplink.smb.meshfailover.c.c logUtils = new com.tplink.smb.meshfailover.c.c("RFPlanning-V2.1-meshfailover-getCandidateApThr");
        logUtils.a(dto);
        int unionBandNum = 4;
        for (d candidateAp : candidateApList) {
            e currentPat;
            com.tplink.smb.meshfailover.b.b currentApNode = (com.tplink.smb.meshfailover.b.b)apNodeInfoMap.get(candidateAp.a());
            if (currentApNode == null || (currentPat = patParameterMap.get(candidateAp.b())) == null) continue;
            com.tplink.smb.meshfailover.b.a currentAlgPat = a.a(currentPat);
            for (int j2 = 0; j2 < currentAlgPat.b(); ++j2) {
                if (!candidateAp.c().equals(currentAlgPat.c().get(j2)) || !candidateAp.f().equals(currentAlgPat.d().get(j2)) || !candidateAp.g().equals(currentAlgPat.e().get(j2))) continue;
                float txRate = a.a(candidateAp.d(), currentAlgPat.f().get(j2), currentAlgPat.g().get(j2), currentAlgPat.h().get(j2));
                txRate = txRate * 0.5f * (float)candidateAp.h().intValue();
                Float throughput = this.calculateThroughput(candidateAp, currentApNode, Float.valueOf(txRate), unionBandNum, apNodeInfoMap, candidateApList);
                candidateAp.c(Math.round(throughput.floatValue()));
            }
        }
        logUtils.a(candidateApList);
        return candidateApList;
    }

    private Float calculateThroughput(d candidateAp, com.tplink.smb.meshfailover.b.b currentApNode, Float txRate, int unionBandNum, Map<String, com.tplink.smb.meshfailover.b.b> apNodeInfoMap, List<d> candidateApList) {
        if (candidateAp == null || currentApNode == null) {
            return Float.valueOf(0.0f);
        }
        List<List<Float>> matrixA = CalculateThroughput.initList(50);
        ArrayList<Float> vectorB = new ArrayList<Float>(Collections.nCopies(50, Float.valueOf(0.0f)));
        ArrayList<Float> vectorC = new ArrayList<Float>(Collections.nCopies(50, Float.valueOf(0.0f)));
        List<List<Float>> txRateTable = CalculateThroughput.initList(4);
        List<List<Float>> channelLoadTable = CalculateThroughput.initList(4);
        List<List<Float>> interferenceTable = CalculateThroughput.initList(4);
        ArrayList<Float> plcRestVector = new ArrayList<Float>(Collections.nCopies(50, Float.valueOf(0.0f)));
        ArrayList<Float> eternetRestVector = new ArrayList<Float>(Collections.nCopies(50, Float.valueOf(0.0f)));
        int nodeOrder = 0;
        int nodeNum = this.countNodeNum(apNodeInfoMap, currentApNode);
        if (nodeNum == -1) {
            return Float.valueOf(0.0f);
        }
        if (nodeNum == 1) {
            return Float.valueOf((float)currentApNode.e().get(candidateAp.c()).intValue() * 0.01f * txRate.floatValue());
        }
        int unKnown = (unionBandNum + 2) * nodeNum - (unionBandNum + 1);
        int inequation = (unionBandNum + 4) * nodeNum - 4;
        while (!currentApNode.b().equals(ROOT_FATHER_DEVICE_MAC)) {
            this.fillTable(currentApNode, nodeOrder, nodeNum, candidateApList, txRateTable, channelLoadTable, interferenceTable, plcRestVector, eternetRestVector);
            currentApNode = apNodeInfoMap.get(currentApNode.b());
            ++nodeOrder;
        }
        this.fillTable(currentApNode, nodeOrder, nodeNum, candidateApList, txRateTable, channelLoadTable, interferenceTable, plcRestVector, eternetRestVector);
        this.fillMatrix(matrixA, vectorB, vectorC, nodeNum, txRate, unionBandNum, candidateAp.c(), interferenceTable, txRateTable, channelLoadTable, plcRestVector, eternetRestVector);
        this.martrixDisplay(matrixA, unKnown, inequation);
        this.vertorBDisplay(vectorB, inequation);
        this.vertorCDisplay(vectorC, unKnown);
        this.txRateTableDisplay(txRateTable, nodeNum - 1, 4);
        this.channelLoadTableDisplay(channelLoadTable, nodeNum, 4);
        return Float.valueOf(b.a(matrixA, vectorB, vectorC, unKnown, inequation));
    }

    private int countNodeNum(Map<String, com.tplink.smb.meshfailover.b.b> apNodeInfoMap, com.tplink.smb.meshfailover.b.b currentApNode) {
        int cnt = 1;
        while (!currentApNode.b().equals(ROOT_FATHER_DEVICE_MAC)) {
            currentApNode = apNodeInfoMap.get(currentApNode.b());
            ++cnt;
            if (currentApNode == null) {
                log.warn("Missing some AP Info, Please check or just wait some minutes.");
                return -1;
            }
            if (cnt <= 4) continue;
            log.warn("nodeNum:{} cannot be greater than 4, record related information, currentApMac:{}, currentApParentMac:{}, apNodeInfoMap:{}", new Object[]{cnt, currentApNode.a(), currentApNode.b(), apNodeInfoMap});
            return 4;
        }
        return cnt;
    }

    private Integer calculateChannelUtilizationByChildNum(Integer childNum) {
        int channelUtilization;
        if (childNum == null) {
            childNum = 0;
        }
        return 95 - (channelUtilization = 10 + childNum * 20) < 0 ? 0 : 95 - channelUtilization;
    }

    private void fillTable(com.tplink.smb.meshfailover.b.b currentApNode, Integer nodeOrder, Integer nodeNum, List<d> candidateApList, List<List<Float>> txRateTable, List<List<Float>> channelLoadTable, List<List<Float>> interferenceTable, List<Float> plcRestVector, List<Float> eternetRestVector) {
        int i2;
        if (nodeOrder < nodeNum) {
            for (i2 = 0; i2 < 4; ++i2) {
                txRateTable.get(i2).set(nodeOrder, Float.valueOf(currentApNode.f().get(i2).intValue()));
            }
        }
        if (nodeOrder != 0) {
            for (d candidateAp : candidateApList) {
                if (!Objects.equals(candidateAp.a(), currentApNode.a()) || candidateAp.d() <= 5) continue;
                interferenceTable.get(candidateAp.c()).set(nodeOrder, Float.valueOf(1.0f));
            }
        }
        for (i2 = 0; i2 < 4; ++i2) {
            Integer tmp = Integer.max(1, Integer.min(95, currentApNode.e().get(i2)));
            channelLoadTable.get(i2).set(nodeOrder, Float.valueOf((float)tmp.intValue() * 0.01f));
        }
        plcRestVector.set(nodeOrder, Float.valueOf((float)(currentApNode.j() * currentApNode.h()) * 0.01f));
        eternetRestVector.set(nodeOrder, Float.valueOf((float)(currentApNode.k() * currentApNode.i()) * 0.01f));
    }

    private void fillMatrix(List<List<Float>> matrixA, List<Float> vectorB, List<Float> vectorC, Integer nodeNum, Float apTxRate, Integer unionBandNum, Integer connectBand, List<List<Float>> interferenceTable, List<List<Float>> txRateTable, List<List<Float>> channelLoadTable, List<Float> plcRestVector, List<Float> eternetRestVector) {
        int k;
        int j2;
        int i2;
        int[] wirelessBaseRow = new int[unionBandNum.intValue()];
        int[] wirelessBaseCol = new int[unionBandNum.intValue()];
        for (i2 = 0; i2 < nodeNum; ++i2) {
            for (j2 = 0; j2 < nodeNum - 1; ++j2) {
                for (k = 0; k < 4; ++k) {
                    wirelessBaseRow[k] = nodeNum * k;
                    wirelessBaseCol[k] = 1 + (nodeNum - 1) * k;
                    if (i2 != j2 && i2 != j2 + 1) continue;
                    matrixA.get(i2 + wirelessBaseRow[k]).set(j2 + wirelessBaseCol[k], Float.valueOf(1.0f / txRateTable.get(k).get(j2).floatValue()));
                }
            }
        }
        for (i2 = 0; i2 < nodeNum; ++i2) {
            for (k = 0; k < 4; ++k) {
                wirelessBaseRow[k] = nodeNum * k;
                vectorB.set(i2 + wirelessBaseRow[k], channelLoadTable.get(k).get(i2));
            }
        }
        int plcBaseRow = unionBandNum * nodeNum;
        int plcBaseCol = 1 + unionBandNum * (nodeNum - 1);
        for (i2 = 0; i2 < nodeNum - 1; ++i2) {
            matrixA.get(i2 + plcBaseRow).set(i2 + plcBaseCol, Float.valueOf(1.0f));
            vectorB.set(plcBaseRow + i2, plcRestVector.get(i2));
        }
        int ethernetBaseRow = (unionBandNum + 1) * nodeNum - 1;
        int ethernetBaseCol = 1 + (unionBandNum + 1) * (nodeNum - 1);
        for (i2 = 0; i2 < nodeNum - 1; ++i2) {
            matrixA.get(i2 + ethernetBaseRow).set(i2 + ethernetBaseCol, Float.valueOf(1.0f));
            vectorB.set(ethernetBaseRow + i2, eternetRestVector.get(i2));
        }
        int equationBaseRow = (unionBandNum + 2) * nodeNum - 2;
        int equationBaseCol = 1;
        for (i2 = 0; i2 <= nodeNum - 1; ++i2) {
            for (j2 = 0; j2 < 6; ++j2) {
                matrixA.get(2 * i2 + equationBaseRow).set(equationBaseCol + i2 + j2 * (nodeNum - 1), Float.valueOf(-1.0f));
                matrixA.get(2 * i2 + 1 + equationBaseRow).set(equationBaseCol + i2 + j2 * (nodeNum - 1), Float.valueOf(1.0f));
            }
            matrixA.get(2 * i2 + equationBaseRow).set(0, Float.valueOf(1.0f));
            matrixA.get(2 * i2 + 1 + equationBaseRow).set(0, Float.valueOf(-1.0f));
        }
        matrixA.get(nodeNum * connectBand).set(0, Float.valueOf(1.0f / apTxRate.floatValue()));
        for (i2 = 0; i2 < nodeNum; ++i2) {
            if (!(interferenceTable.get(connectBand).get(i2).floatValue() > 0.5f)) continue;
            matrixA.get(nodeNum * connectBand + i2).set(0, Float.valueOf(1.0f / apTxRate.floatValue()));
            matrixA.get(nodeNum * connectBand).set(i2 + (nodeNum - 1) * connectBand, Float.valueOf(1.0f / txRateTable.get(connectBand).get(i2 - 1).floatValue()));
        }
        vectorC.set(0, Float.valueOf(1.0f));
    }

    private int getMaxBandNum(List<com.tplink.smb.meshfailover.b.b> apNodeInfos) {
        int maxBandNum = 0;
        for (com.tplink.smb.meshfailover.b.b apNodeInfo : apNodeInfos) {
            if (apNodeInfo.c() <= maxBandNum) continue;
            maxBandNum = apNodeInfo.c();
        }
        return maxBandNum;
    }

    private static List<List<Float>> initList(int size) {
        ArrayList<List<Float>> defaultFloatList = new ArrayList<List<Float>>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            ArrayList<Float> defaultList = new ArrayList<Float>(Collections.nCopies(50, Float.valueOf(0.0f)));
            defaultFloatList.add(i2, defaultList);
        }
        return defaultFloatList;
    }

    private void martrixDisplay(List<List<Float>> matrix, int cols, int rows) {
    }

    private void txRateTableDisplay(List<List<Float>> matrix, int cols, int rows) {
    }

    private void channelLoadTableDisplay(List<List<Float>> matrix, int cols, int rows) {
    }

    private void vertorBDisplay(List<Float> vector, int length) {
    }

    private void vertorCDisplay(List<Float> vector, int length) {
    }
}

