/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.properties;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tplink.smb.omada.anomaly.core.properties.a;
import com.tplink.smb.omada.common.concurrent.thread.CommonExecutorProperties;
import com.tplink.smb.omada.insight.core.eventcenter.properties.SchedulePartitionProperties;
import io.micrometer.core.instrument.Tag;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SchedulePartitionProperties.class})
public class AnomalyExecutorConfiguration {
    @Generated
    private static final Logger c = LoggerFactory.getLogger(AnomalyExecutorConfiguration.class);
    public static final String a = "scheduleAnomalyWorkGroup";
    public static final String b = "anomalyStorageWorkGroup";
    @Autowired
    private SchedulePartitionProperties d;
    @Autowired
    private com.tplink.smb.omada.insight.a.a e;
    @Autowired
    private CommonExecutorProperties f;

    @Lazy
    @Bean(name={"scheduleAnomalyWorkGroup"})
    @ConditionalOnMissingBean(name={"scheduleAnomalyWorkGroup"})
    public ScheduledExecutorService scheduleAnomalyWorkGroup() {
        String poolName = "schedule-anomaly-pool";
        int partitions = this.d.getPartitions();
        int corePoolSize = Math.min(this.f.getCommCoreThreads(), 4);
        c.debug("init {} with partitions = {}, core pool size = {}", new Object[]{poolName, partitions, corePoolSize});
        ScheduledExecutorService executor = this.a(poolName, corePoolSize);
        return this.e.a(executor, poolName, new Tag[0]);
    }

    @Lazy
    @Bean(name={"anomalyStorageWorkGroup"})
    @ConditionalOnMissingBean(name={"anomalyStorageWorkGroup"})
    public ScheduledExecutorService anomalyStorageWorkGroup() {
        String poolName = "anomaly-storage-pool";
        int processors = Runtime.getRuntime().availableProcessors();
        int corePoolSize = Math.min(processors + 1, 4);
        c.debug("init {}, core thread size = {}", (Object)poolName, (Object)corePoolSize);
        ScheduledExecutorService executor = this.a(poolName, corePoolSize);
        return this.e.a(executor, poolName, new Tag[0]);
    }

    private ScheduledExecutorService a(String poolName, int corePoolSize) {
        return new ScheduledThreadPoolExecutor(corePoolSize, new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new a(this, poolName));
    }
}

