/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.port.schedule;

import com.tplink.smb.component.schedule.api.ScheduleCenter;
import com.tplink.smb.component.schedule.api.ScheduleTask;
import com.tplink.smb.component.schedule.api.ScheduledEvent;
import com.tplink.smb.component.schedule.api.handler.ScheduledEventHandler;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.core.domain.a.j;
import com.tplink.smb.omada.anomaly.core.domain.a.k;
import com.tplink.smb.omada.anomaly.core.port.schedule.AnomalyScheduleTaskCronProperties;
import com.tplink.smb.omada.common.spring.b;
import com.tplink.smb.omada.insight.core.eventcenter.properties.SchedulePartitionProperties;
import com.tplink.smb.omada.judgement.a.e;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.apm.toolkit.trace.RunnableWrapper;
import org.apache.skywalking.apm.toolkit.trace.Trace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={SchedulePartitionProperties.class})
@b
public class a
implements ScheduledEventHandler {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    private static final String b = "insight_anomaly";
    private static final String c = "5min";
    private static final String d = "10min";
    private static final String e = "15min";
    private static final String f = "hourly";
    private static final String g = "2hour";
    private static final String h = "daily";
    private static final String i = "3day";
    private static final int j = 60;
    private int k;
    @Autowired
    private SchedulePartitionProperties l;
    @Autowired
    private ScheduleCenter m;
    @Autowired
    private j n;
    @Autowired
    private k o;
    @Autowired
    @Qualifier(value="scheduleAnomalyWorkGroup")
    private ScheduledExecutorService p;
    @Autowired
    private AnomalyScheduleTaskCronProperties q;
    @Autowired
    private e r;

    @PostConstruct
    public void a() {
        if (!this.r.a("health") && !this.r.a("abnormal")) {
            return;
        }
        this.k = new Random().nextInt(60);
        com.tplink.smb.omada.common.concurrent.thread.a.a(() -> {
            ScheduleTask fiveMinTask = ScheduleTask.builder().withIdentity(b, c).withCronTrigger(this.q.getFiveMinTask()).withEnableSharding(Integer.valueOf(this.l.getPartitions())).build();
            this.m.saveTask(fiveMinTask);
            ScheduleTask tenMinTask = ScheduleTask.builder().withIdentity(b, d).withCronTrigger(this.q.getTenMinTask()).withEnableSharding(Integer.valueOf(this.l.getPartitions())).build();
            this.m.saveTask(tenMinTask);
            ScheduleTask fifteenMinTask = ScheduleTask.builder().withIdentity(b, e).withCronTrigger(this.q.getFifteenMinTask()).withEnableSharding(Integer.valueOf(this.l.getPartitions())).build();
            this.m.saveTask(fifteenMinTask);
            ScheduleTask hourlyTask = ScheduleTask.builder().withIdentity(b, f).withCronTrigger(this.q.getOneHourTask()).withEnableSharding(Integer.valueOf(this.l.getPartitions())).build();
            this.m.saveTask(hourlyTask);
            ScheduleTask twoHourTask = ScheduleTask.builder().withIdentity(b, g).withCronTrigger(this.q.getTwoHourTask()).withEnableSharding(Integer.valueOf(this.l.getPartitions())).build();
            this.m.saveTask(twoHourTask);
            ScheduleTask dailyTask = ScheduleTask.builder().withIdentity(b, h).withCronTrigger(this.q.getOneDayTask()).withEnableSharding(Integer.valueOf(this.l.getPartitions())).build();
            this.m.saveTask(dailyTask);
            ScheduleTask threeDayTask = ScheduleTask.builder().withIdentity(b, i).withCronTrigger(this.q.getThreeDayTask()).withEnableSharding(Integer.valueOf(this.l.getPartitions())).build();
            this.m.saveTask(threeDayTask);
            this.m.registerEventHandler(b, (ScheduledEventHandler)this, (ExecutorService)this.p);
            a.info("anomaly detect schedule task started.");
        });
    }

    @Trace(operationName="anomalyDetect.handle")
    public void handle(ScheduledEvent scheduledEvent) {
        this.p.schedule((Runnable)RunnableWrapper.of(() -> {
            try {
                this.a(scheduledEvent);
            }
            catch (Exception e2) {
                a.warn("anomaly detect task exception: {}", (Object)e2.getMessage(), (Object)e2);
            }
            try {
                this.b(scheduledEvent);
            }
            catch (Exception e3) {
                a.warn("health v2 task exception: {}", (Object)e3.getMessage(), (Object)e3);
            }
        }), (long)this.k, TimeUnit.SECONDS);
    }

    private void a(ScheduledEvent scheduledEvent) {
        Integer partition = scheduledEvent.getShardingParam().getShardingIndex();
        String taskParam = scheduledEvent.getTaskParam();
        long time = scheduledEvent.getScheduledTime();
        switch (taskParam) {
            case "5min": 
            case "10min": 
            case "15min": {
                a.debug("start insight:anomaly:{}, partition = {}, time = {}", new Object[]{taskParam, partition, time});
                this.n.a(this.a(taskParam), partition, time);
                a.debug("done insight:anomaly:{}, partition = {}, time = {}", new Object[]{taskParam, partition, System.currentTimeMillis()});
                break;
            }
            case "hourly": {
                long endTime = scheduledEvent.getScheduledTime() / 1000L / 3600L * 3600L;
                a.debug("start device:health:hourly and insight:anomaly:hourly, partition = {}, time = {}", (Object)partition, (Object)time);
                this.n.a(com.tplink.smb.omada.anomaly.api.b.f.e, partition, time);
                this.o.a(partition, endTime);
                a.debug("done insight:anomaly:hourly and device:statistic:hourly:{} {}", (Object)partition, (Object)System.currentTimeMillis());
                break;
            }
            case "2hour": {
                long twoHourTime = scheduledEvent.getScheduledTime() / 1000L / 3600L * 3600L;
                a.debug("start device:health:2hour:{} {}", (Object)partition, (Object)twoHourTime);
                this.o.c(partition, twoHourTime);
                a.debug("done device:health:2hour:{} {}", (Object)partition, (Object)System.currentTimeMillis());
                break;
            }
            case "daily": {
                long dailyTime = scheduledEvent.getScheduledTime() / 1000L / 3600L * 3600L;
                a.debug("start device:health:daily:{} {}", (Object)partition, (Object)dailyTime);
                this.o.d(partition, dailyTime);
                a.debug("done device:health:daily:{} {}", (Object)partition, (Object)System.currentTimeMillis());
                break;
            }
            case "3day": {
                long threeDayTime = scheduledEvent.getScheduledTime() / 1000L / 3600L * 3600L;
                a.debug("start device:health:3day:{} {}", (Object)partition, (Object)threeDayTime);
                this.o.f(partition, threeDayTime);
                a.debug("done device:health:3day:{} {}", (Object)partition, (Object)System.currentTimeMillis());
                break;
            }
        }
    }

    private void b(ScheduledEvent scheduledEvent) {
        Integer partition = scheduledEvent.getShardingParam().getShardingIndex();
        String taskParam = scheduledEvent.getTaskParam();
        long time = scheduledEvent.getScheduledTime();
        switch (taskParam) {
            case "10min": {
                com.tplink.smb.omada.anomaly.api.e.a.a((Logger)a, (String)"start insight:health v2:{}, partition = {}, time = {}", (Object[])new Object[]{taskParam, partition, time});
                this.o.a(this.a(taskParam), partition, time);
                com.tplink.smb.omada.anomaly.api.e.a.a((Logger)a, (String)"done insight:health v2:{}, partition = {}, time = {}", (Object[])new Object[]{taskParam, partition, System.currentTimeMillis()});
                break;
            }
            case "hourly": {
                long endTime = scheduledEvent.getScheduledTime() / 1000L / 3600L * 3600L;
                com.tplink.smb.omada.anomaly.api.e.a.a((Logger)a, (String)"start insight:health v2 hourly, partition = {}, time = {}", (Object[])new Object[]{partition, time});
                this.o.b(partition, endTime);
                com.tplink.smb.omada.anomaly.api.e.a.a((Logger)a, (String)"done insight:health v2 hourly, partition = {}, time = {}", (Object[])new Object[]{partition, System.currentTimeMillis()});
                break;
            }
            case "daily": {
                long dailyTime = scheduledEvent.getScheduledTime() / 1000L / 3600L * 3600L;
                com.tplink.smb.omada.anomaly.api.e.a.a((Logger)a, (String)"start insight:health v2:daily. {} {}", (Object[])new Object[]{partition, dailyTime});
                this.o.e(partition, dailyTime);
                com.tplink.smb.omada.anomaly.api.e.a.a((Logger)a, (String)"end insight:health v2:daily. {} {}", (Object[])new Object[]{partition, System.currentTimeMillis()});
                break;
            }
        }
    }

    private f a(String taskParam) {
        switch (taskParam) {
            case "5min": {
                return com.tplink.smb.omada.anomaly.api.b.f.b;
            }
            case "10min": {
                return com.tplink.smb.omada.anomaly.api.b.f.c;
            }
            case "15min": {
                return com.tplink.smb.omada.anomaly.api.b.f.d;
            }
        }
        return null;
    }

    @PreDestroy
    public void b() {
        if (this.p != null) {
            this.p.shutdown();
        }
    }
}

