/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.port.cache;

import com.tplink.smb.omada.anomaly.api.dto.health.BaseHealthScoreDTO;
import com.tplink.smb.omada.anomaly.core.port.cache.dto.SimpleDeviceHealthScoreDTO;
import com.tplink.smb.omada.manager.device.api.internal.b.a;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.SiteDeviceHealthScoreDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.request.device.DevicesHealthScoreRequest;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class m {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(m.class);
    private static final String b = "device_health_score_cache_" + UUID.randomUUID().toString();
    private static final int c = 300;
    private static final int d = 1000;
    private static final AtomicLong e = new AtomicLong(0L);
    private static final Map<String, List<SimpleDeviceHealthScoreDTO>> f = new ConcurrentHashMap<String, List<SimpleDeviceHealthScoreDTO>>();
    @Autowired
    @Qualifier(value="anomalyStorageWorkGroup")
    private ScheduledExecutorService g;
    @Autowired
    private a h;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.port.d.a i;

    @PostConstruct
    public void a() {
        Runnable cacheAnomalyTask = () -> {
            try {
                this.a(true);
            }
            catch (Exception e2) {
                a.warn("schedule save device health score: {}", (Object)e2.getMessage(), (Object)e2);
            }
        };
        this.g.scheduleWithFixedDelay(cacheAnomalyTask, 300L + (long)new Random().nextInt(300), 300L, TimeUnit.SECONDS);
    }

    private static String a(String omadacId, String siteId) {
        return omadacId + ":" + siteId;
    }

    public <T extends BaseHealthScoreDTO> void a(String omadacId, String siteId, List<T> deviceHealthScores) {
        if (CollectionUtils.isEmpty(deviceHealthScores)) {
            return;
        }
        List<SimpleDeviceHealthScoreDTO> scoreDtoToSave = deviceHealthScores.stream().map(dto -> {
            SimpleDeviceHealthScoreDTO score = new SimpleDeviceHealthScoreDTO();
            score.setMac(dto.getMac());
            score.setTimestamp(dto.getTimestamp());
            m.a(score, dto);
            return score;
        }).collect(Collectors.toList());
        long currentSize = this.b(omadacId, siteId, scoreDtoToSave);
        if (currentSize >= 1000L) {
            this.a(false);
        } else {
            com.tplink.smb.omada.anomaly.api.e.a.a((Logger)a, (String)"skip save device health score in devicePO , collect size is {}, omadacId is {}, siteId is {}", (Object[])new Object[]{currentSize, omadacId, siteId});
        }
    }

    private void a(boolean triggerByTime) {
        if (!triggerByTime && e.get() < 1000L) {
            return;
        }
        this.c();
    }

    private Long b(String omadacId, String siteId, List<SimpleDeviceHealthScoreDTO> scoreDtoToSave) {
        return this.i.a(b, () -> {
            List scoreList = f.computeIfAbsent(m.a(omadacId, siteId), key -> new ArrayList());
            scoreList.addAll(scoreDtoToSave);
            return e.get();
        }, () -> {
            a.info("fail to get lock of {} , while add device health score to memory cache", (Object)b);
            return e.get();
        });
    }

    private Map<String, List<SimpleDeviceHealthScoreDTO>> b() {
        return this.i.a(b, () -> {
            HashMap<String, List<SimpleDeviceHealthScoreDTO>> data = new HashMap<String, List<SimpleDeviceHealthScoreDTO>>(f);
            f.clear();
            e.set(0L);
            return data;
        }, () -> {
            a.info("fail to get lock of {} , while schedule update device health score", (Object)b);
            return new HashMap(0);
        });
    }

    private void c() {
        long start = System.currentTimeMillis();
        Map<String, List<SimpleDeviceHealthScoreDTO>> data = this.b();
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        ArrayList dataToSave = new ArrayList();
        data.forEach((key, value) -> {
            String[] mapKey = key.split(":");
            if (CollectionUtils.isEmpty((Collection)value) || mapKey.length < 2) {
                return;
            }
            String omaacId = mapKey[0];
            String siteId = mapKey[1];
            Long timestamp = ((SimpleDeviceHealthScoreDTO)value.get(0)).getTimestamp();
            SiteDeviceHealthScoreDTO siteDeviceHealthScoreDTO = new SiteDeviceHealthScoreDTO();
            siteDeviceHealthScoreDTO.setOmadacId(omaacId);
            siteDeviceHealthScoreDTO.setSiteId(siteId);
            siteDeviceHealthScoreDTO.setTimestamp(timestamp);
            Map scoreMap = value.stream().collect(Collectors.toMap(SimpleDeviceHealthScoreDTO::getMac, SimpleDeviceHealthScoreDTO::getScore, (v1, v2) -> v2, HashMap::new));
            siteDeviceHealthScoreDTO.setDeviceScores(scoreMap);
            dataToSave.add(siteDeviceHealthScoreDTO);
        });
        if (CollectionUtils.isEmpty(dataToSave)) {
            return;
        }
        DevicesHealthScoreRequest devicesHealthScoreRequest = new DevicesHealthScoreRequest();
        devicesHealthScoreRequest.setSitesDeviceHealthScore(dataToSave);
        this.h.a(devicesHealthScoreRequest);
        long end = System.currentTimeMillis();
        a.info("save device health score to manager , site device health list size : {} use : {} ms ", (Object)dataToSave.size(), (Object)(end - start));
    }

    private static void a(SimpleDeviceHealthScoreDTO scoreDTO, BaseHealthScoreDTO dto) {
        Integer score = dto.getScore();
        if (Objects.nonNull(score) && score > 0) {
            scoreDTO.setScore(score);
        } else {
            scoreDTO.setScore(-1);
        }
    }
}

