/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.port.cache.health;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.B;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.health.HealthPreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.health.c;
import com.tplink.smb.omada.anomaly.core.port.cache.health.AggregateHealthPreprocessDTO;
import com.tplink.smb.omada.anomaly.core.port.f.a;
import com.tplink.smb.omada.common.util.W;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class b
implements c {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    private static final int b = 5;
    private static final int c = 20;
    private static final String d = "health:device.pre";
    private static final String e = "health:client.pre";
    private static final Map<String, List<HealthPreprocessDTO>> f = new ConcurrentHashMap<String, List<HealthPreprocessDTO>>();
    private static final Map<String, List<HealthPreprocessDTO>> g = new ConcurrentHashMap<String, List<HealthPreprocessDTO>>();
    private static final int h = 10000;
    private static final int i = 150;
    private static Cache<String, Long> j = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(150L, TimeUnit.SECONDS).build();
    @Autowired
    private CacheService k;
    @Autowired
    @Qualifier(value="anomalyStorageWorkGroup")
    private ScheduledExecutorService l;

    @PostConstruct
    public void a() {
        Runnable cachePreDataTask = () -> {
            try {
                this.a(B.a, f);
                this.a(B.b, g);
            }
            catch (Exception e2) {
                a.warn("schedule cache health pre data exception: {}", (Object)e2.getMessage(), (Object)e2);
            }
        };
        this.l.scheduleWithFixedDelay(cachePreDataTask, 5L + (long)new Random().nextInt(5), 5L, TimeUnit.SECONDS);
    }

    @Override
    public void a(String omadacId, String siteId, HealthPreprocessDTO healthPreprocessDTO) {
        if (Objects.isNull(healthPreprocessDTO)) {
            return;
        }
        B scoreObject = healthPreprocessDTO.getScoreObject();
        Map<String, List<HealthPreprocessDTO>> dataMap = scoreObject == B.b ? g : f;
        List healthPreprocessDTOList = dataMap.computeIfAbsent(this.a(omadacId, siteId), key -> Collections.synchronizedList(new ArrayList()));
        healthPreprocessDTOList.add(healthPreprocessDTO);
    }

    @Override
    public List<AggregateHealthPreprocessDTO> a(String omadacId, String siteId, Long scoreTime, B scoreObject) {
        String cacheName = this.a(scoreObject);
        if (Objects.isNull(cacheName)) {
            return Collections.emptyList();
        }
        String cacheKey = this.a(scoreTime, omadacId, siteId);
        int sortedSetSize = this.k.getSortedSetSize(cacheName, cacheKey);
        if (sortedSetSize == 0) {
            return Collections.emptyList();
        }
        ArrayList<AggregateHealthPreprocessDTO> aggregateDTOList = new ArrayList<AggregateHealthPreprocessDTO>();
        int pageCount = (int)Math.ceil((double)sortedSetSize * 1.0 / 20.0);
        a.debug("poll health pre data, cacheName {}, cacheKey {}, page count is {}", new Object[]{cacheName, cacheKey, pageCount});
        for (int i2 = 0; i2 < pageCount; ++i2) {
            aggregateDTOList.addAll(this.k.pollFirst(cacheName, cacheKey, 20, AggregateHealthPreprocessDTO.class));
        }
        return aggregateDTOList;
    }

    private void a(B scoreObject, Map<String, List<HealthPreprocessDTO>> preDataMap) {
        HashMap<String, List<HealthPreprocessDTO>> tempMap = new HashMap<String, List<HealthPreprocessDTO>>(preDataMap);
        preDataMap.clear();
        tempMap.forEach((key, value) -> {
            String[] mapKey = key.split(":");
            if (mapKey.length < 2) {
                a.debug("Invalid key of health preData: {}", key);
                return;
            }
            this.a(mapKey[0], mapKey[1], scoreObject, (List<HealthPreprocessDTO>)value);
        });
    }

    private void a(String omadacId, String siteId, B scoreObject, List<HealthPreprocessDTO> preDataList) {
        List dataList;
        if (CollectionUtils.isEmpty(preDataList)) {
            return;
        }
        HashMap<Long, List> dataListByPeriod = new HashMap<Long, List>();
        for (HealthPreprocessDTO healthPreprocessDTO : preDataList) {
            Long periodTime = (healthPreprocessDTO.getTimestamp() / 1000L + 600L) / 600L * 600L;
            dataList = dataListByPeriod.computeIfAbsent(periodTime, key -> new ArrayList());
            dataList.add(healthPreprocessDTO);
        }
        for (Map.Entry entry : dataListByPeriod.entrySet()) {
            String cacheName = this.a(scoreObject);
            dataList = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)dataList) || Objects.isNull(cacheName)) continue;
            String cacheKey = this.a((Long)entry.getKey(), omadacId, siteId);
            int size = dataList.size();
            List aggregateList = com.tplink.smb.omada.anomaly.core.port.f.a.a(dataList, size, 20);
            for (List<HealthPreprocessDTO> list : aggregateList) {
                AggregateHealthPreprocessDTO aggregateHealthDTO = new AggregateHealthPreprocessDTO(list);
                long timestamp = list.get(0).getTimestamp() / 1000L;
                this.k.addSortedSetValue(cacheName, cacheKey, (Object)aggregateHealthDTO, (double)timestamp);
            }
            String expireKey = this.a(cacheKey, (Long)entry.getKey(), scoreObject);
            long l2 = Optional.ofNullable((Long)j.getIfPresent((Object)expireKey)).orElse(0L);
            if (!W.a((long)l2, (int)150000)) continue;
            a.debug("expire pre handle cache, cache name is {}, cache key is {}, expire time is {}", new Object[]{cacheName, cacheKey, 3600000L});
            this.k.expireKey(cacheName, cacheKey, 3600000L, TimeUnit.MILLISECONDS);
            j.put((Object)expireKey, (Object)System.currentTimeMillis());
        }
    }

    private String a(B scoreObject) {
        switch (scoreObject) {
            case a: {
                return d;
            }
            case b: {
                return e;
            }
        }
        return null;
    }

    private String a(long time, String omadacId, String siteId) {
        return time + ":" + omadacId + ":" + siteId;
    }

    private String a(String omadacId, String siteId) {
        return omadacId + ":" + siteId;
    }

    private String a(String cacheKey, long time, B scoreObject) {
        return cacheKey + ":" + time + ":" + scoreObject.a();
    }

    private String a(String cacheName, long time) {
        return cacheName + ":" + time;
    }
}

