/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.port.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.AbstractDeviceDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.b.a.b;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.g;
import com.tplink.smb.omada.anomaly.core.port.cache.AggregateCausePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.port.cache.CausePreprocessDataDTO;
import com.tplink.smb.omada.anomaly.core.port.f.a;
import com.tplink.smb.omada.common.util.W;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class f
implements g {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(f.class);
    private static final String b = "insight";
    private static final String c = "ad.cause.pre";
    private static final Long d = 0x6DDD00L;
    private static final Long e = d / 2L;
    private static final String f = "o";
    private static final String g = "s";
    private static final String h = "insight:ad.cause.pre";
    private static final int i = 20;
    private static final int j = 5;
    private static final int k = 20000;
    private static final long l = 0L;
    private static final int m = 100;
    private static final int n = 5400;
    private static final Map<String, List<CausePreprocessDataDTO>> o = new ConcurrentHashMap<String, List<CausePreprocessDataDTO>>();
    private static Cache<String, Long> p = CacheBuilder.newBuilder().maximumSize(20000L).expireAfterWrite(e.longValue(), TimeUnit.MILLISECONDS).build();
    @Autowired
    private CacheService q;
    @Autowired
    @Qualifier(value="anomalyStorageWorkGroup")
    private ScheduledExecutorService r;

    @Override
    public void a(String omadacId, String siteId, DevicePreprocessDTO devicePreprocessDTO, long timeStamp) {
        long time = devicePreprocessDTO.getTime();
        Map<String, AbstractDeviceDTO> preprocessData = devicePreprocessDTO.getPreprocessData();
        for (Map.Entry<String, AbstractDeviceDTO> entry : preprocessData.entrySet()) {
            List devicePreprocessDTOList = o.computeIfAbsent(this.a(omadacId, siteId, entry.getKey()), key -> Collections.synchronizedList(new ArrayList()));
            CausePreprocessDataDTO causePreprocessDataDTO = new CausePreprocessDataDTO();
            causePreprocessDataDTO.setOmadacId(omadacId);
            causePreprocessDataDTO.setSiteId(siteId);
            causePreprocessDataDTO.setTime(time);
            causePreprocessDataDTO.setMac(devicePreprocessDTO.getMac());
            causePreprocessDataDTO.setCauseCode(entry.getKey());
            causePreprocessDataDTO.setPreprocessData(entry.getValue());
            devicePreprocessDTOList.add(causePreprocessDataDTO);
        }
    }

    @Override
    public Map<String, List<CausePreprocessDataDTO>> a(String omadacId, String siteId, String causeCode, long startTime, long endTime) {
        String cacheKey = this.b(omadacId, siteId, causeCode);
        int cacheSize = this.q.getSortedSetSize(h, cacheKey);
        List preDataList = new ArrayList();
        if (cacheSize > 100) {
            int dateNumberPreSecond = cacheSize / 5400;
            double second = Math.ceil(100.0 / (double)dateNumberPreSecond);
            long i2 = startTime;
            while (startTime < endTime) {
                preDataList.addAll(this.q.rangeSortedByScore(h, cacheKey, (double)i2, (double)i2 + second, AggregateCausePreprocessDTO.class));
                startTime = (long)((double)startTime + second);
            }
        } else {
            preDataList = (List)this.q.rangeSortedByScore(h, cacheKey, (double)startTime, (double)endTime, AggregateCausePreprocessDTO.class);
        }
        HashMap<String, List<CausePreprocessDataDTO>> macCauseDTOMap = new HashMap<String, List<CausePreprocessDataDTO>>();
        if (CollectionUtils.isNotEmpty(preDataList)) {
            preDataList.forEach(aggregateCauseDTO -> aggregateCauseDTO.getCausePreprocessDataDTOList().forEach(causeDTO -> {
                String mac = causeDTO.getMac();
                List macPreDataList = macCauseDTOMap.computeIfAbsent(mac, key -> new ArrayList());
                macPreDataList.add(causeDTO);
            }));
        }
        return macCauseDTOMap;
    }

    @Override
    public void a(String omadacId, String siteId, long time) {
        this.r.submit(() -> com.tplink.smb.omada.anomaly.core.domain.model.b.a.b.a.forEach(causeEnum -> {
            String cacheKey = this.b(omadacId, siteId, causeEnum.a());
            int cacheSize = this.q.getSortedSetSize(h, cacheKey);
            if (cacheSize > 100) {
                Collection cache;
                while (!CollectionUtils.isEmpty((Collection)(cache = this.q.pollFirst(h, cacheKey, 100, 0.0, (double)time, AggregateCausePreprocessDTO.class)))) {
                }
            } else {
                this.q.pollSortedByScore(h, cacheKey, 0.0, (double)time, AggregateCausePreprocessDTO.class);
            }
        }));
    }

    @PostConstruct
    public void a() {
        Runnable cachePreDataTask = () -> {
            try {
                this.a(o);
            }
            catch (Exception e2) {
                a.warn("schedule cache cause pre data exception: {}", (Object)e2.getMessage(), (Object)e2);
            }
        };
        this.r.scheduleWithFixedDelay(cachePreDataTask, 5L + (long)new Random().nextInt(5), 5L, TimeUnit.SECONDS);
    }

    private void a(String omadacId, String siteId, String causeCode, List<CausePreprocessDataDTO> preDataList) {
        if (CollectionUtils.isEmpty(preDataList)) {
            return;
        }
        preDataList.removeAll(Collections.singleton(null));
        int size = preDataList.size();
        List<List<CausePreprocessDataDTO>> aggregateList = com.tplink.smb.omada.anomaly.core.port.f.a.a(preDataList, size, 20);
        for (List<CausePreprocessDataDTO> causePreprocessDataDTOList : aggregateList) {
            long maxTimestamp = com.tplink.smb.omada.anomaly.core.port.cache.f.a(causePreprocessDataDTOList);
            String cacheKey = this.b(omadacId, siteId, causeCode);
            AggregateCausePreprocessDTO aggregateData = new AggregateCausePreprocessDTO(causePreprocessDataDTOList);
            this.q.addSortedSetValue(h, cacheKey, (Object)aggregateData, (double)maxTimestamp);
            long cacheExpireLastSeen = Optional.ofNullable((Long)p.getIfPresent((Object)cacheKey)).orElse(0L);
            if (!W.a((long)cacheExpireLastSeen, (long)e)) continue;
            a.debug("expire cause pre handle cache, cache name is {}, cache key is {}", (Object)h, (Object)cacheKey);
            this.q.expireKey(h, cacheKey, d.longValue(), TimeUnit.MILLISECONDS);
            p.put((Object)cacheKey, (Object)System.currentTimeMillis());
        }
    }

    private void a(Map<String, List<CausePreprocessDataDTO>> preDataMap) {
        HashMap<String, List<CausePreprocessDataDTO>> tempMap = new HashMap<String, List<CausePreprocessDataDTO>>(preDataMap);
        preDataMap.clear();
        tempMap.forEach((key, value) -> {
            String[] mapKey = key.split(":");
            if (mapKey.length < 3) {
                return;
            }
            this.a(mapKey[0], mapKey[1], mapKey[2], (List<CausePreprocessDataDTO>)value);
        });
    }

    private String a(String omadacId, String siteId, String causeCode) {
        return omadacId + ":" + siteId + ":" + causeCode;
    }

    private static long a(List<CausePreprocessDataDTO> causePreprocessDataDTOList) {
        long currentTime = System.currentTimeMillis();
        if (CollectionUtils.isEmpty(causePreprocessDataDTOList)) {
            return currentTime;
        }
        int lastIndex = causePreprocessDataDTOList.size() - 1;
        CausePreprocessDataDTO lastDTO = causePreprocessDataDTOList.get(lastIndex);
        a.debug("get timestamp for cause pre data list, last index {} data is: {}", (Object)lastIndex, (Object)lastDTO);
        return Objects.nonNull(lastDTO) && Objects.nonNull(lastDTO.getTime()) ? lastDTO.getTime() : currentTime;
    }

    private String b(String omadacId, String siteId, String causeCode) {
        return "o:" + omadacId + ":s:" + siteId + ":" + causeCode;
    }
}

