/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.port.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.nbu.common.pii.utils.PIIJacksonUtil;
import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.e;
import com.tplink.smb.omada.anomaly.core.port.cache.AggregatePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.port.f.a;
import com.tplink.smb.omada.common.util.W;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class b
implements e {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    private static final String b = "insight";
    private static final String c = "ad.pre";
    private static final String d = "ad.pre.n";
    private static final String e = "o";
    private static final String f = "s";
    private static final String g = "insight:ad.pre";
    private static final int h = 2;
    private static final int i = 20;
    private static final int j = 5;
    private static final int k = 20;
    private static final int l = 6;
    private static final int m = 20000;
    private static final int n = 150;
    private static final Map<String, List<DevicePreprocessDTO>> o = new ConcurrentHashMap<String, List<DevicePreprocessDTO>>();
    private static final Map<String, List<DevicePreprocessDTO>> p = new ConcurrentHashMap<String, List<DevicePreprocessDTO>>();
    private static final Map<String, List<DevicePreprocessDTO>> q = new ConcurrentHashMap<String, List<DevicePreprocessDTO>>();
    private static final Map<String, List<DevicePreprocessDTO>> r = new ConcurrentHashMap<String, List<DevicePreprocessDTO>>();
    private static Cache<String, Long> s = CacheBuilder.newBuilder().maximumSize(20000L).expireAfterWrite(150L, TimeUnit.SECONDS).build();
    @Autowired
    private CacheService t;
    @Autowired
    @Qualifier(value="anomalyStorageWorkGroup")
    private ScheduledExecutorService u;

    private String a(String omadacId, String siteId) {
        return omadacId + ":" + siteId;
    }

    private String a(String cacheName, long time) {
        return cacheName + ":" + time;
    }

    private String a(long time, String omadacId, String siteId, f detectPeriodEnum) {
        return time + ":o:" + omadacId + ":s:" + siteId + ":" + detectPeriodEnum.d();
    }

    private String a(long time, String omadacId, String siteId, f detectPeriodEnum, int setNumber) {
        return this.a(time, omadacId, siteId, detectPeriodEnum) + ":" + setNumber;
    }

    @PostConstruct
    public void a() {
        Runnable cachePreDataTask = () -> {
            try {
                this.a(o, com.tplink.smb.omada.anomaly.api.b.f.b);
                this.a(p, com.tplink.smb.omada.anomaly.api.b.f.c);
                this.a(q, com.tplink.smb.omada.anomaly.api.b.f.d);
                this.a(r, com.tplink.smb.omada.anomaly.api.b.f.e);
            }
            catch (Exception e2) {
                a.warn("schedule cache anomaly pre data exception: {}", (Object)e2.getMessage(), (Object)e2);
            }
        };
        this.u.scheduleWithFixedDelay(cachePreDataTask, 5L + (long)new Random().nextInt(5), 5L, TimeUnit.SECONDS);
    }

    private void a(Map<String, List<DevicePreprocessDTO>> preDataMap, f detectPeriod) {
        HashMap<String, List<DevicePreprocessDTO>> tempMap = new HashMap<String, List<DevicePreprocessDTO>>(preDataMap);
        preDataMap.clear();
        tempMap.forEach((key, value) -> {
            String[] mapKey = key.split(":");
            if (mapKey.length < 2) {
                return;
            }
            this.a(mapKey[0], mapKey[1], detectPeriod, (List<DevicePreprocessDTO>)value);
        });
    }

    @Override
    public void a(String omadacId, String siteId, f detectPeriodEnum, DevicePreprocessDTO devicePreprocessDTO, long timeStamp) {
        Map<String, List<DevicePreprocessDTO>> preDataMap;
        if (CollectionUtils.isEmptyMap(devicePreprocessDTO.getPreprocessData())) {
            return;
        }
        switch (detectPeriodEnum) {
            case b: {
                preDataMap = o;
                break;
            }
            case c: {
                preDataMap = p;
                break;
            }
            case d: {
                preDataMap = q;
                break;
            }
            case e: {
                preDataMap = r;
                break;
            }
            default: {
                return;
            }
        }
        List devicePreprocessDTOSet = preDataMap.computeIfAbsent(this.a(omadacId, siteId), key -> Collections.synchronizedList(new ArrayList()));
        devicePreprocessDTOSet.add(devicePreprocessDTO);
    }

    private void a(String omadacId, String siteId, f detectPeriodEnum, List<DevicePreprocessDTO> preDataList) {
        if (CollectionUtils.isEmpty(preDataList)) {
            return;
        }
        preDataList.removeAll(Collections.singleton(null));
        int size = preDataList.size();
        long maxTimestamp = this.a(preDataList);
        List<List<DevicePreprocessDTO>> aggregateList = com.tplink.smb.omada.anomaly.core.port.f.a.a(preDataList, size, 20);
        if (com.tplink.smb.omada.anomaly.api.b.f.a().equals((Object)detectPeriodEnum)) {
            this.a(omadacId, siteId, maxTimestamp, aggregateList);
            return;
        }
        long timeInCacheName = com.tplink.smb.omada.anomaly.core.port.f.a.a(detectPeriodEnum, maxTimestamp);
        String cacheName = g;
        String cacheKey = this.a(timeInCacheName, omadacId, siteId, detectPeriodEnum);
        for (List<DevicePreprocessDTO> devicePreprocessDTOList : aggregateList) {
            AggregatePreprocessDTO aggregateData = new AggregatePreprocessDTO(devicePreprocessDTOList);
            this.t.addSortedSetValue(cacheName, cacheKey, (Object)aggregateData, (double)maxTimestamp);
        }
        long cacheExpireLastSeen = Optional.ofNullable((Long)s.getIfPresent((Object)cacheKey)).orElse(0L);
        if (W.a((long)cacheExpireLastSeen, (long)detectPeriodEnum.c())) {
            long expireTime = 2L * detectPeriodEnum.c();
            a.debug("expire pre handle cache, cache name is {}, cache key is {}, expire time is {}", new Object[]{cacheName, cacheKey, expireTime});
            this.t.expireKey(cacheName, cacheKey, expireTime, TimeUnit.MILLISECONDS);
            s.put((Object)cacheKey, (Object)System.currentTimeMillis());
        }
    }

    private void a(String omadacId, String siteId, long maxTimestamp, @Nonnull List<List<DevicePreprocessDTO>> aggregateList) {
        f detectPeriodEnum = com.tplink.smb.omada.anomaly.api.b.f.a();
        int aggregateListSize = aggregateList.size();
        long timeInCacheName = com.tplink.smb.omada.anomaly.core.port.f.a.a(detectPeriodEnum, maxTimestamp);
        String cacheName = g;
        for (int i2 = 0; i2 < aggregateListSize; ++i2) {
            AggregatePreprocessDTO aggregateData = new AggregatePreprocessDTO(aggregateList.get(i2));
            String cacheKey = i2 <= 6 ? this.a(timeInCacheName, omadacId, siteId, detectPeriodEnum) : this.a(timeInCacheName, omadacId, siteId, detectPeriodEnum, (i2 - 6) / 6);
            this.t.addSortedSetValue(cacheName, cacheKey, (Object)aggregateData, (double)maxTimestamp);
            long cacheExpireLastSeen = Optional.ofNullable((Long)s.getIfPresent((Object)cacheKey)).orElse(0L);
            if (!W.a((long)cacheExpireLastSeen, (long)detectPeriodEnum.c())) continue;
            long expireTime = 2L * detectPeriodEnum.c();
            a.debug("expire pre handle cache for max period, cache name is {}, cache key is {}, expire time is {}", new Object[]{cacheName, cacheKey, expireTime});
            this.t.expireKey(cacheName, cacheKey, expireTime, TimeUnit.MILLISECONDS);
            s.put((Object)cacheKey, (Object)System.currentTimeMillis());
        }
        if (aggregateListSize > 6) {
            String maxSetNumCacheName = d;
            String cacheKey = this.a(timeInCacheName, omadacId, siteId, detectPeriodEnum);
            Integer maxSetNumberInCache = (Integer)this.t.get(maxSetNumCacheName, cacheKey, Integer.class);
            int maxSetNumberIn5s = (aggregateListSize - 6) / 6;
            if (maxSetNumberInCache == null || maxSetNumberIn5s > maxSetNumberInCache) {
                a.debug("save pre handle cache max set num for hourly period, cache name is {}, cache key is {}, value is {}", new Object[]{maxSetNumCacheName, cacheKey, maxSetNumberIn5s});
                this.t.set(maxSetNumCacheName, cacheKey, (Object)maxSetNumberIn5s, 2L * detectPeriodEnum.c(), TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public List<AggregatePreprocessDTO> a(String omadacId, String siteId, f detectPeriodEnum, Long detectTime) {
        String cacheName = g;
        String cacheKey = this.a(detectTime, omadacId, siteId, detectPeriodEnum);
        List<AggregatePreprocessDTO> preDataList = this.b(cacheName, cacheKey);
        if (!com.tplink.smb.omada.anomaly.api.b.f.a().equals((Object)detectPeriodEnum)) {
            return preDataList;
        }
        String maxSetNumCacheName = d;
        Integer maxSetNumber = (Integer)this.t.get(maxSetNumCacheName, cacheKey, Integer.class);
        if (maxSetNumber != null && maxSetNumber >= 0) {
            a.debug("poll pre handle data from more set, cacheName {}, max set number is {}", (Object)maxSetNumCacheName, (Object)maxSetNumber);
            for (int zSetNumber = 0; zSetNumber <= maxSetNumber; ++zSetNumber) {
                cacheKey = this.a(detectTime, omadacId, siteId, detectPeriodEnum, zSetNumber);
                preDataList.addAll(this.b(cacheName, cacheKey));
            }
        }
        return preDataList;
    }

    private List<AggregatePreprocessDTO> b(String cacheName, String cacheKey) {
        int sortedSetSize = this.t.getSortedSetSize(cacheName, cacheKey);
        if (sortedSetSize == 0) {
            return Collections.emptyList();
        }
        ArrayList<AggregatePreprocessDTO> aggregatePreprocessDTOList = new ArrayList<AggregatePreprocessDTO>();
        int pageCount = (int)Math.ceil((double)sortedSetSize * 1.0 / 20.0);
        a.debug("poll pre handle data, cacheName {}, cacheKey {}, page count is {}", new Object[]{cacheName, cacheKey, pageCount});
        for (int i2 = 0; i2 < pageCount; ++i2) {
            aggregatePreprocessDTOList.addAll(this.t.pollFirst(cacheName, cacheKey, 20, AggregatePreprocessDTO.class));
        }
        return aggregatePreprocessDTOList;
    }

    private long a(List<DevicePreprocessDTO> devicePreprocessDTOList) {
        long currentTime = System.currentTimeMillis();
        if (CollectionUtils.isEmpty(devicePreprocessDTOList)) {
            return currentTime;
        }
        int lastIndex = devicePreprocessDTOList.size() - 1;
        DevicePreprocessDTO lastDTO = devicePreprocessDTOList.get(lastIndex);
        a.debug("get timestamp for pre data list, last index {} data is: {}", (Object)lastIndex, (Object)PIIJacksonUtil.parseToStr((Object)lastDTO));
        return Objects.nonNull(lastDTO) && Objects.nonNull(lastDTO.getTime()) ? lastDTO.getTime() : currentTime;
    }
}

