/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.port.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.core.domain.model.a.b;
import com.tplink.smb.omada.anomaly.core.domain.model.a.c;
import com.tplink.smb.omada.anomaly.core.port.cache.AggregateAnomalyDTO;
import com.tplink.smb.omada.common.util.W;
import com.tplink.smb.omada.common.util.x;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class a
implements c {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    private static final String b = "insight";
    private static final String c = "ad";
    private static final String d = "o";
    private static final String e = "s";
    private static final String f = "insight:ad";
    private static final int g = 5;
    private static final int h = 80;
    private static final int i = 60;
    private static final int j = 20000;
    private static final int k = 30;
    private static final Map<String, List<b>> l = new ConcurrentHashMap<String, List<b>>();
    private static Cache<String, Long> m = CacheBuilder.newBuilder().maximumSize(20000L).expireAfterWrite(30L, TimeUnit.MINUTES).build();
    private static final long n = com.tplink.smb.omada.anomaly.api.b.f.a().c();
    private static final long o = n / 2L;
    @Autowired
    private CacheService p;
    @Autowired
    @Qualifier(value="anomalyStorageWorkGroup")
    private ScheduledExecutorService q;

    private String b(String omadacId, String siteId) {
        return omadacId + ":" + siteId;
    }

    private String c(String omadacId, String siteId) {
        return "o:" + omadacId + ":s:" + siteId;
    }

    @PostConstruct
    public void a() {
        Runnable cacheAnomalyTask = () -> {
            try {
                HashMap<String, List<b>> tempMap = new HashMap<String, List<b>>(l);
                l.clear();
                tempMap.forEach((key, value) -> {
                    String[] mapKey = key.split(":");
                    if (mapKey.length < 2) {
                        return;
                    }
                    this.b(mapKey[0], mapKey[1], (List<b>)value);
                });
            }
            catch (Exception e2) {
                a.warn("schedule cache anomaly event exception: {}", (Object)e2.getMessage(), (Object)e2);
            }
        };
        this.q.scheduleWithFixedDelay(cacheAnomalyTask, 5L + (long)new Random().nextInt(5), 5L, TimeUnit.SECONDS);
    }

    private void b(String omadacId, String siteId, List<b> anomalyEventList) {
        if (CollectionUtils.isEmpty(anomalyEventList)) {
            return;
        }
        int size = anomalyEventList.size();
        List<List<b>> aggregateList = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventList, size, 80);
        String cacheKey = this.c(omadacId, siteId);
        for (List<b> anomalyEvents : aggregateList) {
            AggregateAnomalyDTO aggregateData = new AggregateAnomalyDTO(anomalyEvents);
            long maxTimestamp = this.a(anomalyEvents);
            this.p.addSortedSetValue(f, cacheKey, (Object)aggregateData, (double)maxTimestamp);
        }
        long cacheExpireLastSeen = Optional.ofNullable((Long)m.getIfPresent((Object)cacheKey)).orElse(0L);
        if (W.a((long)cacheExpireLastSeen, (long)o)) {
            this.p.expireKey(f, cacheKey, n, TimeUnit.MILLISECONDS);
            m.put((Object)cacheKey, (Object)System.currentTimeMillis());
        }
    }

    @Override
    public void a(String omadacId, String siteId, List<b> anomalyEventList) {
        if (CollectionUtils.isEmpty(anomalyEventList)) {
            return;
        }
        if (a.isDebugEnabled()) {
            a.debug("going to cache anomaly or cause list: {}", (Object)x.a(anomalyEventList));
        }
        List anomalyEventListForCache = anomalyEventList.stream().map(b::b).collect(Collectors.toList());
        List anomalyList = l.computeIfAbsent(this.b(omadacId, siteId), key -> new ArrayList());
        anomalyList.addAll(anomalyEventListForCache);
    }

    @Override
    public List<b> a(String omadacId, String siteId, long detectTime, f detectPeriodEnum) {
        String cacheKey = this.c(omadacId, siteId);
        int anomalySetSize = this.p.getSortedSetSize(f, cacheKey);
        if (anomalySetSize == 0) {
            return Collections.emptyList();
        }
        int pageCount = (int)Math.ceil((double)anomalySetSize * 1.0 / 60.0 / (double)com.tplink.smb.omada.anomaly.api.b.f.a().c() * (double)detectPeriodEnum.c());
        a.debug("get cached anomaly, cacheName {}, cacheKey {}, page count {}", new Object[]{f, cacheKey, pageCount});
        long startTime = detectTime - detectPeriodEnum.c();
        long pageTimeRange = (detectTime - startTime) / (long)pageCount;
        ArrayList<AggregateAnomalyDTO> aggregateAnomalyList = new ArrayList<AggregateAnomalyDTO>();
        for (int i2 = 0; i2 < pageCount; ++i2) {
            long pageStartTime = startTime + (long)i2 * pageTimeRange;
            long pageEndTime = i2 == pageCount - 1 ? detectTime : pageStartTime + pageTimeRange;
            boolean isMaxDetectPeriod = com.tplink.smb.omada.anomaly.api.b.f.a().equals((Object)detectPeriodEnum);
            aggregateAnomalyList.addAll(this.a(cacheKey, pageStartTime, pageEndTime, isMaxDetectPeriod));
        }
        ArrayList<b> anomalyEventList = new ArrayList<b>();
        aggregateAnomalyList.stream().map(AggregateAnomalyDTO::getAnomalyEventList).forEach(anomalyEventList::addAll);
        return anomalyEventList;
    }

    @Nonnull
    private List<AggregateAnomalyDTO> a(String cacheKey, long startTime, long detectTime, boolean isMaxDetectPeriod) {
        if (isMaxDetectPeriod) {
            return new ArrayList<AggregateAnomalyDTO>(this.p.pollSortedByScore(f, cacheKey, (double)startTime, (double)detectTime, AggregateAnomalyDTO.class));
        }
        return new ArrayList<AggregateAnomalyDTO>(this.p.rangeSortedByScore(f, cacheKey, (double)startTime, (double)detectTime, AggregateAnomalyDTO.class));
    }

    @Override
    public void a(String omadacId, String siteId) {
        this.p.deleteKey(f, this.c(omadacId, siteId));
    }

    private long a(List<b> anomalyEventList) {
        long maxTime = 0L;
        for (b anomalyEvent : anomalyEventList) {
            if (Objects.isNull(anomalyEvent.k())) {
                a.info("invalid anomaly event of omadacId: {} siteId: {} anomalyCode: {}", new Object[]{anomalyEvent.i(), anomalyEvent.j(), anomalyEvent.m()});
                continue;
            }
            if (anomalyEvent.k() <= maxTime) continue;
            maxTime = anomalyEvent.k();
        }
        return maxTime;
    }
}

