/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.setting;

import com.tplink.smb.omada.anomaly.api.b.e;
import com.tplink.smb.omada.anomaly.api.b.h;
import com.tplink.smb.omada.anomaly.core.domain.model.setting.AnomalyEventSettingDTO;
import com.tplink.smb.omada.common.gridquery.QueryDataVO;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class AnomalySettingQueryDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnomalySettingQueryDTO.class);
    public static final String ENABLE = "enable";
    public static final int ENABLE_TRUE = 0;
    public static final int ENABLE_FALSE = 1;
    public static final String LEVEL = "level";
    public static final String CATEGORY = "category";
    private Integer currentPage;
    private Integer currentPageSize;
    private Boolean enableFilter;
    private Set<Integer> categories;
    private Set<Integer> levels;

    public boolean satisfy(AnomalyEventSettingDTO anomalyEventSettingDTO) {
        if (Objects.isNull(anomalyEventSettingDTO)) {
            return false;
        }
        if (Objects.nonNull(this.enableFilter) && !Objects.equals(anomalyEventSettingDTO.getEnable(), this.enableFilter)) {
            return false;
        }
        if (!CollectionUtils.isEmpty(this.categories) && !this.categories.contains(anomalyEventSettingDTO.getCategory())) {
            return false;
        }
        return CollectionUtils.isEmpty(this.levels) || this.levels.contains(anomalyEventSettingDTO.getLevel());
    }

    public boolean satisfyCategory(AnomalyEventSettingDTO anomalyEventSettingDTO) {
        if (Objects.isNull(anomalyEventSettingDTO)) {
            return false;
        }
        return CollectionUtils.isEmpty(this.categories) || this.categories.contains(anomalyEventSettingDTO.getCategory());
    }

    public boolean satisfyEnable(AnomalyEventSettingDTO anomalyEventSettingDTO) {
        if (Objects.isNull(anomalyEventSettingDTO)) {
            return false;
        }
        return !Objects.nonNull(this.enableFilter) || Objects.equals(anomalyEventSettingDTO.getEnable(), this.enableFilter);
    }

    public boolean satisfyLevel(AnomalyEventSettingDTO anomalyEventSettingDTO) {
        if (Objects.isNull(anomalyEventSettingDTO)) {
            return false;
        }
        return CollectionUtils.isEmpty(this.levels) || this.levels.contains(anomalyEventSettingDTO.getLevel());
    }

    public static Optional<AnomalySettingQueryDTO> buildFromQuery(QueryDataVO queryDataVO) {
        String levelStr;
        String categoryStr;
        boolean paramValid;
        Map filters;
        AnomalySettingQueryDTO anomalySettingQueryDTO;
        block8: {
            anomalySettingQueryDTO = new AnomalySettingQueryDTO();
            anomalySettingQueryDTO.setCurrentPage(queryDataVO.getCurrentPage());
            anomalySettingQueryDTO.setCurrentPageSize(queryDataVO.getCurrentPageSize());
            if (CollectionUtils.isEmpty((Map)queryDataVO.getFilters())) {
                return Optional.of(anomalySettingQueryDTO);
            }
            filters = queryDataVO.getFilters();
            if (Objects.nonNull(filters.get(ENABLE)) && filters.get(ENABLE) instanceof String) {
                String enableStr = (String)filters.get(ENABLE);
                try {
                    int enable = Integer.parseInt(enableStr);
                    if (enable == 0) {
                        anomalySettingQueryDTO.setEnableFilter(true);
                        break block8;
                    }
                    if (enable == 1) {
                        anomalySettingQueryDTO.setEnableFilter(false);
                        break block8;
                    }
                    return Optional.empty();
                }
                catch (NumberFormatException e2) {
                    log.info("Fail to transfer filters.enable {}", (Object)enableStr);
                    return Optional.empty();
                }
            }
        }
        if (Objects.nonNull(filters.get(CATEGORY)) && filters.get(CATEGORY) instanceof String && !(paramValid = AnomalySettingQueryDTO.handleCategoryFilter(categoryStr = (String)filters.get(CATEGORY), anomalySettingQueryDTO))) {
            return Optional.empty();
        }
        if (Objects.nonNull(filters.get(LEVEL)) && filters.get(LEVEL) instanceof String && !(paramValid = AnomalySettingQueryDTO.handleLevelFilter(levelStr = (String)filters.get(LEVEL), anomalySettingQueryDTO))) {
            return Optional.empty();
        }
        return Optional.of(anomalySettingQueryDTO);
    }

    private static boolean handleCategoryFilter(String categoryStr, AnomalySettingQueryDTO anomalySettingQueryDTO) {
        String[] categoryStrList = categoryStr.split(",");
        HashSet<Integer> categories = new HashSet<Integer>();
        try {
            for (String s2 : categoryStrList) {
                int category = Integer.parseInt(s2);
                if (!e.b((int)category)) {
                    return false;
                }
                categories.add(category);
            }
        }
        catch (NumberFormatException e2) {
            log.warn("Fail to transfer filters.category {}", (Object)categoryStr);
            return false;
        }
        anomalySettingQueryDTO.setCategories(categories);
        return true;
    }

    private static boolean handleLevelFilter(String levelStr, AnomalySettingQueryDTO anomalySettingQueryDTO) {
        String[] levelStrList = levelStr.split(",");
        HashSet<Integer> levels = new HashSet<Integer>();
        try {
            for (String s2 : levelStrList) {
                int level = Integer.parseInt(s2);
                if (!h.b((int)level)) {
                    return false;
                }
                levels.add(Integer.parseInt(s2));
            }
        }
        catch (NumberFormatException e2) {
            log.warn("Fail to transfer filters.level {}", (Object)levelStr);
            return false;
        }
        anomalySettingQueryDTO.setLevels(levels);
        return true;
    }

    @Generated
    public AnomalySettingQueryDTO() {
    }

    @Generated
    public Integer getCurrentPage() {
        return this.currentPage;
    }

    @Generated
    public Integer getCurrentPageSize() {
        return this.currentPageSize;
    }

    @Generated
    public Boolean getEnableFilter() {
        return this.enableFilter;
    }

    @Generated
    public Set<Integer> getCategories() {
        return this.categories;
    }

    @Generated
    public Set<Integer> getLevels() {
        return this.levels;
    }

    @Generated
    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    @Generated
    public void setCurrentPageSize(Integer currentPageSize) {
        this.currentPageSize = currentPageSize;
    }

    @Generated
    public void setEnableFilter(Boolean enableFilter) {
        this.enableFilter = enableFilter;
    }

    @Generated
    public void setCategories(Set<Integer> categories) {
        this.categories = categories;
    }

    @Generated
    public void setLevels(Set<Integer> levels) {
        this.levels = levels;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof AnomalySettingQueryDTO)) {
            return false;
        }
        AnomalySettingQueryDTO other = (AnomalySettingQueryDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$currentPage = this.getCurrentPage();
        Integer other$currentPage = other.getCurrentPage();
        if (this$currentPage == null ? other$currentPage != null : !((Object)this$currentPage).equals(other$currentPage)) {
            return false;
        }
        Integer this$currentPageSize = this.getCurrentPageSize();
        Integer other$currentPageSize = other.getCurrentPageSize();
        if (this$currentPageSize == null ? other$currentPageSize != null : !((Object)this$currentPageSize).equals(other$currentPageSize)) {
            return false;
        }
        Boolean this$enableFilter = this.getEnableFilter();
        Boolean other$enableFilter = other.getEnableFilter();
        if (this$enableFilter == null ? other$enableFilter != null : !((Object)this$enableFilter).equals(other$enableFilter)) {
            return false;
        }
        Set<Integer> this$categories = this.getCategories();
        Set<Integer> other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        Set<Integer> this$levels = this.getLevels();
        Set<Integer> other$levels = other.getLevels();
        return !(this$levels == null ? other$levels != null : !((Object)this$levels).equals(other$levels));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnomalySettingQueryDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $currentPage = this.getCurrentPage();
        result = result * 59 + ($currentPage == null ? 43 : ((Object)$currentPage).hashCode());
        Integer $currentPageSize = this.getCurrentPageSize();
        result = result * 59 + ($currentPageSize == null ? 43 : ((Object)$currentPageSize).hashCode());
        Boolean $enableFilter = this.getEnableFilter();
        result = result * 59 + ($enableFilter == null ? 43 : ((Object)$enableFilter).hashCode());
        Set<Integer> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        Set<Integer> $levels = this.getLevels();
        result = result * 59 + ($levels == null ? 43 : ((Object)$levels).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AnomalySettingQueryDTO(currentPage=" + this.getCurrentPage() + ", currentPageSize=" + this.getCurrentPageSize() + ", enableFilter=" + this.getEnableFilter() + ", categories=" + this.getCategories() + ", levels=" + this.getLevels() + ")";
    }
}

