/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.rule.osw.throughput;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.AbstractDeviceDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.OswPortRateDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.OswPortStatusDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.OswPortTrafficDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.PortTrafficDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.c;
import com.tplink.smb.omada.anomaly.core.domain.a.e;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.a;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.b;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.osw.throughput.PortDropRateExceedThresholdDetector;
import com.tplink.smb.omada.anomaly.core.domain.model.setting.AnomalyEventSettingDTO;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.insight.api.web.anomaly.dto.ClientObjectDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortTrafficTooHighDetector
implements a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(PortTrafficTooHighDetector.class);
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a b;
    @Autowired
    private e c;
    private static final List<com.tplink.smb.omada.anomaly.api.b.c> d = new ArrayList<com.tplink.smb.omada.anomaly.api.b.c>(Arrays.asList(com.tplink.smb.omada.anomaly.api.b.c.bR, com.tplink.smb.omada.anomaly.api.b.c.cm));

    @Override
    public com.tplink.smb.omada.anomaly.api.b.c a() {
        return com.tplink.smb.omada.anomaly.api.b.c.bO;
    }

    @Override
    public f c() {
        return f.d;
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> a(com.tplink.smb.omada.anomaly.core.domain.model.b.b anomalyDetectTimeRange, String mac, List<DevicePreprocessDTO> devicePreDataList) {
        if (CollectionUtils.isEmpty(devicePreDataList)) {
            a.debug("skip abnormal {} anomaly detect for mac {} omadac {} site {}, for data is empty", new Object[]{this.a(), mac, anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b()});
            return Collections.emptyList();
        }
        HashMap<String, List<OswPortTrafficDTO>> portTrafficsMap = new HashMap<String, List<OswPortTrafficDTO>>();
        HashMap<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>> clientTrafficsMap = new HashMap<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>>();
        PortTrafficTooHighDetector.a(devicePreDataList, portTrafficsMap, clientTrafficsMap);
        if (a.isDebugEnabled()) {
            a.debug("oamdacId : {} siteId : {} deviceMac : {} port traffic map {} \n client traffic map {}", new Object[]{anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b(), mac, x.a(portTrafficsMap), x.a(clientTrafficsMap)});
        }
        AnomalyEventSettingDTO anomalyEventSettingDTO = anomalyDetectTimeRange.e().get(this.a().a());
        int highSpeedThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSettingDTO, "threshold", 90);
        int highSpeedRadioThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSettingDTO, "count", 80);
        HashSet<String> portIds = new HashSet<String>();
        for (Map.Entry<String, List<OswPortTrafficDTO>> entry : portTrafficsMap.entrySet()) {
            this.a(mac, highSpeedThreshold, highSpeedRadioThreshold, portIds, entry);
        }
        if (CollectionUtils.isNotEmpty(portIds)) {
            com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.b.a()).a(mac).c(anomalyDetectTimeRange.a()).d(anomalyDetectTimeRange.b()).a(anomalyDetectTimeRange.d()).a(this.a()).a(this.a(anomalyEventSettingDTO)).b(true).a();
            HashMap<String, List<OswPortTrafficDTO>> hashMap = new HashMap<String, List<OswPortTrafficDTO>>();
            HashMap<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>> clientHighTrafficMap = new HashMap<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>>();
            for (String portId : portIds) {
                clientHighTrafficMap.put(portId, (List)clientTrafficsMap.get(portId));
                hashMap.put(portId, (List)portTrafficsMap.get(portId));
            }
            List<PortTrafficInfo> portTrafficInfoList = PortTrafficTooHighDetector.a(hashMap);
            SwitchPortTraffic switchPortTraffic = new SwitchPortTraffic(new ArrayList<String>(portIds), portTrafficInfoList);
            HashMap<String, Object> detailParam = new HashMap<String, Object>();
            detailParam.put("switchPortTraffic", switchPortTraffic);
            anomalyEvent.a(CollectionUtils.toStringMap((String[])new String[]{"devMac", mac, "portId", T.a(portIds, (String)",")}), CollectionUtils.toStringMap((String[])new String[]{"count", String.valueOf(highSpeedRadioThreshold), "threshold", String.valueOf(highSpeedThreshold)}), detailParam, Collections.singletonMap(mac, this.c.a(anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b(), mac)), null, null);
            PortTrafficTooHighDetector.a(anomalyDetectTimeRange, mac, anomalyEvent, clientHighTrafficMap);
            return Collections.singletonList(anomalyEvent);
        }
        return Collections.emptyList();
    }

    private void a(String mac, int highSpeedThreshold, int highSpeedRadioThreshold, Set<String> portIds, Map.Entry<String, List<OswPortTrafficDTO>> entry) {
        Long maxBandwidth = null;
        ArrayList<Long> txRateList = new ArrayList<Long>();
        ArrayList<Long> rxRateList = new ArrayList<Long>();
        try {
            for (OswPortTrafficDTO portTraffic : entry.getValue()) {
                if (Objects.isNull(maxBandwidth) && Objects.nonNull(portTraffic.getPortStatus())) {
                    maxBandwidth = portTraffic.getPortStatus().getMaxRate();
                }
                if (Objects.isNull(portTraffic.getPortRate())) continue;
                if (CollectionUtils.isNotEmpty((Collection)portTraffic.getPortRate().getTxRates())) {
                    txRateList.addAll(portTraffic.getPortRate().getTxRates());
                }
                if (!CollectionUtils.isNotEmpty((Collection)portTraffic.getPortRate().getRxRates())) continue;
                rxRateList.addAll(portTraffic.getPortRate().getRxRates());
            }
        }
        catch (Exception e2) {
            a.debug("device mac:{},Exception:{} occurred in port traffic too high detector", new Object[]{mac, e2.getMessage(), e2});
        }
        if (Objects.isNull(maxBandwidth)) {
            return;
        }
        if (this.a(txRateList, maxBandwidth, highSpeedThreshold, highSpeedRadioThreshold) || this.a(rxRateList, maxBandwidth, highSpeedThreshold, highSpeedRadioThreshold)) {
            portIds.add(entry.getKey());
        }
    }

    @Override
    public Boolean a(com.tplink.smb.omada.anomaly.core.domain.model.a.b newAnomalyEvent, com.tplink.smb.omada.anomaly.core.domain.model.a.b presidentEvent) {
        if (!this.b(newAnomalyEvent, presidentEvent)) {
            return false;
        }
        return com.tplink.smb.omada.anomaly.core.port.f.a.a(newAnomalyEvent, presidentEvent);
    }

    private boolean a(List<Long> rateList, Long maxBandwitch, int highSpeedThreshold, int highSpeedRadioThreshold) {
        if (CollectionUtils.isEmpty(rateList)) {
            return false;
        }
        long totalCount = 0L;
        long highRateCount = 0L;
        for (Long rate : rateList) {
            if (Objects.isNull(rate)) continue;
            ++totalCount;
            if (rate * 100L < maxBandwitch * (long)highSpeedThreshold) continue;
            ++highRateCount;
        }
        return highRateCount > 0L && highRateCount * 100L >= totalCount * (long)highSpeedRadioThreshold;
    }

    static List<PortTrafficInfo> a(Map<String, List<OswPortTrafficDTO>> map) {
        TreeMap trafficInfoMap = new TreeMap();
        for (Map.Entry<String, List<OswPortTrafficDTO>> entry : map.entrySet()) {
            entry.getValue().forEach(portTraffic -> {
                if (Objects.isNull(portTraffic.getTimestamp()) || Objects.isNull(portTraffic.getPortStatus())) {
                    return;
                }
                OswPortStatusDTO portStatusDTO = portTraffic.getPortStatus();
                List list = trafficInfoMap.computeIfAbsent(portTraffic.getTimestamp(), t2 -> new ArrayList());
                list.add(new PortTrafficDetail((String)entry.getKey(), portStatusDTO.getTx() + portStatusDTO.getRx()));
            });
        }
        ArrayList<PortTrafficInfo> portTrafficInfoList = new ArrayList<PortTrafficInfo>();
        for (Map.Entry entry : trafficInfoMap.entrySet()) {
            portTrafficInfoList.add(new PortTrafficInfo((Long)entry.getKey(), (List)entry.getValue()));
        }
        return portTrafficInfoList;
    }

    static void a(List<DevicePreprocessDTO> devicePreDataList, Map<String, List<OswPortTrafficDTO>> portTrafficsMap, Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>> clientTrafficsMap) {
        String preDataMapKey = com.tplink.smb.omada.anomaly.api.b.c.bO.a();
        for (DevicePreprocessDTO devicePreprocessDTO : devicePreDataList) {
            if (Objects.isNull(devicePreprocessDTO) || CollectionUtils.isEmptyMap(devicePreprocessDTO.getPreprocessData()) || Objects.isNull(devicePreprocessDTO.getPreprocessData().get(preDataMapKey))) continue;
            AbstractDeviceDTO abstractDeviceDTO = devicePreprocessDTO.getPreprocessData().get(preDataMapKey);
            PortTrafficDTO portTrafficDTO = (PortTrafficDTO)abstractDeviceDTO;
            Map porTrafficMap = portTrafficDTO.getPortTrafficMap();
            Map portTrafficMapV2 = portTrafficDTO.getPortTrafficMapV2();
            PortTrafficTooHighDetector.a(portTrafficsMap, porTrafficMap, portTrafficMapV2);
            Map clientTrafficMap = portTrafficDTO.getClientTrafficMap();
            Map clientTrafficMapV2 = portTrafficDTO.getClientTrafficMapV2();
            PortTrafficTooHighDetector.b(clientTrafficsMap, clientTrafficMap, clientTrafficMapV2);
        }
    }

    static void a(Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>> clientTrafficMap, Map<String, com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a> clientMap) {
        for (Map.Entry<String, com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a> entry : clientMap.entrySet()) {
            List dtoList = clientTrafficMap.computeIfAbsent(entry.getKey(), s2 -> new ArrayList());
            dtoList.add(entry.getValue());
        }
    }

    static void a(Map<String, List<OswPortTrafficDTO>> portTrafficsMap, Map<Integer, c> portTrafficMap, Map<String, OswPortTrafficDTO> portTrafficMapV2) {
        if (!CollectionUtils.isEmptyMap(portTrafficMap)) {
            for (Map.Entry<Object, Object> entry : portTrafficMap.entrySet()) {
                String portKey = String.valueOf(entry.getKey());
                c portTraffic = (c)entry.getValue();
                OswPortTrafficDTO oswPortTrafficDTO = new OswPortTrafficDTO();
                oswPortTrafficDTO.setTimestamp(Long.valueOf(portTraffic.a()));
                oswPortTrafficDTO.setPortStatus(new OswPortStatusDTO(Long.valueOf(portTraffic.b()), Long.valueOf(portTraffic.c()), Long.valueOf(portTraffic.d())));
                oswPortTrafficDTO.setPortRate(new OswPortRateDTO(portTraffic.e(), portTraffic.f()));
                List dtoList = portTrafficsMap.computeIfAbsent(portKey, s2 -> new ArrayList());
                dtoList.add(oswPortTrafficDTO);
            }
        }
        if (!CollectionUtils.isEmptyMap(portTrafficMapV2)) {
            for (Map.Entry<Object, Object> entry : portTrafficMapV2.entrySet()) {
                List dtoList = portTrafficsMap.computeIfAbsent((String)entry.getKey(), s2 -> new ArrayList());
                dtoList.add((OswPortTrafficDTO)entry.getValue());
            }
        }
    }

    static void b(Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>> clientTrafficsMap, Map<Integer, com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a> clientTrafficMap, Map<String, com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a> clientTrafficMapV2) {
        List dtoList;
        if (!CollectionUtils.isEmptyMap(clientTrafficMap)) {
            for (Map.Entry<Object, com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a> entry : clientTrafficMap.entrySet()) {
                dtoList = clientTrafficsMap.computeIfAbsent(String.valueOf(entry.getKey()), s2 -> new ArrayList());
                dtoList.add(entry.getValue());
            }
        }
        if (!CollectionUtils.isEmptyMap(clientTrafficMapV2)) {
            for (Map.Entry<Object, com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a> entry : clientTrafficMapV2.entrySet()) {
                dtoList = clientTrafficsMap.computeIfAbsent((String)entry.getKey(), s2 -> new ArrayList());
                dtoList.add(entry.getValue());
            }
        }
    }

    static void a(com.tplink.smb.omada.anomaly.core.domain.model.b.b anomalyDetectTimeRange, String mac, com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent, Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>> clientHighTrafficMap) {
        com.tplink.smb.omada.anomaly.core.domain.model.a.b cause = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(mac).c(anomalyDetectTimeRange.a()).d(anomalyDetectTimeRange.b()).a(anomalyDetectTimeRange.d()).a(com.tplink.smb.omada.anomaly.api.b.c.cm).a(com.tplink.smb.omada.anomaly.api.b.c.cm.c()).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(com.tplink.smb.omada.anomaly.api.b.c.cm)).a();
        ArrayList<PortDropRateExceedThresholdDetector.ClientTrafficInfo> clientTraffics = new ArrayList<PortDropRateExceedThresholdDetector.ClientTrafficInfo>();
        Map<String, ClientObjectDTO> clients = PortTrafficTooHighDetector.b(clientHighTrafficMap);
        for (Map.Entry<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>> entry : clientHighTrafficMap.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)entry.getValue())) continue;
            List list = entry.getValue().stream().map(com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a::a).collect(Collectors.toList());
            clientTraffics.add(new PortDropRateExceedThresholdDetector.ClientTrafficInfo(entry.getValue().get(0).c(), (Long)Collections.max(list) - (Long)Collections.min(list)));
        }
        HashMap<String, Object> detailParam = new HashMap<String, Object>();
        detailParam.put("clientTraffic", clientTraffics);
        cause.a(null, null, detailParam, null, clients, null);
        anomalyEvent.d(cause);
    }

    static Map<String, ClientObjectDTO> b(Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>> clientHighTrafficMap) {
        HashMap<String, ClientObjectDTO> map = new HashMap<String, ClientObjectDTO>();
        for (List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a> clientTrafficList : clientHighTrafficMap.values()) {
            if (CollectionUtils.isEmpty(clientTrafficList)) continue;
            for (com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a clientTraffic : clientTrafficList) {
                ClientObjectDTO clientObjectDTO = ClientObjectDTO.builder().deviceType(clientTraffic.f()).ip(clientTraffic.h()).manager(Boolean.valueOf(false)).name(com.tplink.smb.omada.anomaly.core.port.f.a.a(clientTraffic.g(), clientTraffic.c())).build();
                map.put(clientTraffic.c(), clientObjectDTO);
            }
        }
        return map;
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.api.b.c> e() {
        return d;
    }

    @Override
    public void a(String omadacId, String siteId, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEventSet, Map<String, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b>> causeMap, com.tplink.smb.omada.anomaly.core.domain.model.b.a associateResult) {
        for (com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent : anomalyEventSet) {
            String deviceMac = anomalyEvent.g();
            Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> loopCauses = causeMap.get(com.tplink.smb.omada.anomaly.core.domain.model.rule.b.a(deviceMac, com.tplink.smb.omada.anomaly.api.b.c.cn));
            if (!CollectionUtils.isNotEmpty(loopCauses)) continue;
            this.a(omadacId, siteId, associateResult, anomalyEvent, loopCauses, anomalyEvent.g(), true);
        }
    }

    @KeepClass
    public static class SwitchPortTraffic {
        List<String> portIds;
        List<PortTrafficInfo> switchPortTrafficList;

        @Generated
        public List<String> getPortIds() {
            return this.portIds;
        }

        @Generated
        public List<PortTrafficInfo> getSwitchPortTrafficList() {
            return this.switchPortTrafficList;
        }

        @Generated
        public void setPortIds(List<String> portIds) {
            this.portIds = portIds;
        }

        @Generated
        public void setSwitchPortTrafficList(List<PortTrafficInfo> switchPortTrafficList) {
            this.switchPortTrafficList = switchPortTrafficList;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof SwitchPortTraffic)) {
                return false;
            }
            SwitchPortTraffic other = (SwitchPortTraffic)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$portIds = this.getPortIds();
            List<String> other$portIds = other.getPortIds();
            if (this$portIds == null ? other$portIds != null : !((Object)this$portIds).equals(other$portIds)) {
                return false;
            }
            List<PortTrafficInfo> this$switchPortTrafficList = this.getSwitchPortTrafficList();
            List<PortTrafficInfo> other$switchPortTrafficList = other.getSwitchPortTrafficList();
            return !(this$switchPortTrafficList == null ? other$switchPortTrafficList != null : !((Object)this$switchPortTrafficList).equals(other$switchPortTrafficList));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SwitchPortTraffic;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $portIds = this.getPortIds();
            result = result * 59 + ($portIds == null ? 43 : ((Object)$portIds).hashCode());
            List<PortTrafficInfo> $switchPortTrafficList = this.getSwitchPortTrafficList();
            result = result * 59 + ($switchPortTrafficList == null ? 43 : ((Object)$switchPortTrafficList).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PortTrafficTooHighDetector.SwitchPortTraffic(portIds=" + this.getPortIds() + ", switchPortTrafficList=" + this.getSwitchPortTrafficList() + ")";
        }

        @Generated
        public SwitchPortTraffic(List<String> portIds, List<PortTrafficInfo> switchPortTrafficList) {
            this.portIds = portIds;
            this.switchPortTrafficList = switchPortTrafficList;
        }
    }

    @KeepClass
    public static class PortTrafficInfo {
        long time;
        List<PortTrafficDetail> portTraffic;

        public boolean hasTraffic() {
            if (CollectionUtils.isEmpty(this.portTraffic)) {
                return false;
            }
            for (PortTrafficDetail portTrafficDetail : this.portTraffic) {
                if (portTrafficDetail.getTraffic() <= 0L) continue;
                return true;
            }
            return false;
        }

        @Generated
        public long getTime() {
            return this.time;
        }

        @Generated
        public List<PortTrafficDetail> getPortTraffic() {
            return this.portTraffic;
        }

        @Generated
        public void setTime(long time) {
            this.time = time;
        }

        @Generated
        public void setPortTraffic(List<PortTrafficDetail> portTraffic) {
            this.portTraffic = portTraffic;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof PortTrafficInfo)) {
                return false;
            }
            PortTrafficInfo other = (PortTrafficInfo)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTime() != other.getTime()) {
                return false;
            }
            List<PortTrafficDetail> this$portTraffic = this.getPortTraffic();
            List<PortTrafficDetail> other$portTraffic = other.getPortTraffic();
            return !(this$portTraffic == null ? other$portTraffic != null : !((Object)this$portTraffic).equals(other$portTraffic));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PortTrafficInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            List<PortTrafficDetail> $portTraffic = this.getPortTraffic();
            result = result * 59 + ($portTraffic == null ? 43 : ((Object)$portTraffic).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PortTrafficTooHighDetector.PortTrafficInfo(time=" + this.getTime() + ", portTraffic=" + this.getPortTraffic() + ")";
        }

        @Generated
        public PortTrafficInfo(long time, List<PortTrafficDetail> portTraffic) {
            this.time = time;
            this.portTraffic = portTraffic;
        }
    }

    @KeepClass
    public static class PortTrafficDetail {
        String portId;
        long traffic;

        @Generated
        public String getPortId() {
            return this.portId;
        }

        @Generated
        public long getTraffic() {
            return this.traffic;
        }

        @Generated
        public void setPortId(String portId) {
            this.portId = portId;
        }

        @Generated
        public void setTraffic(long traffic) {
            this.traffic = traffic;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof PortTrafficDetail)) {
                return false;
            }
            PortTrafficDetail other = (PortTrafficDetail)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTraffic() != other.getTraffic()) {
                return false;
            }
            String this$portId = this.getPortId();
            String other$portId = other.getPortId();
            return !(this$portId == null ? other$portId != null : !this$portId.equals(other$portId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PortTrafficDetail;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $traffic = this.getTraffic();
            result = result * 59 + (int)($traffic >>> 32 ^ $traffic);
            String $portId = this.getPortId();
            result = result * 59 + ($portId == null ? 43 : $portId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PortTrafficTooHighDetector.PortTrafficDetail(portId=" + this.getPortId() + ", traffic=" + this.getTraffic() + ")";
        }

        @Generated
        public PortTrafficDetail(String portId, long traffic) {
            this.portId = portId;
            this.traffic = traffic;
        }
    }
}

