/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.rule.osw.throughput;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.c;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.OswPortRateDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.OswPortTrafficDTO;
import com.tplink.smb.omada.anomaly.core.domain.a.e;
import com.tplink.smb.omada.anomaly.core.domain.model.a.b;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.a;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.osw.throughput.PortTrafficTooHighDetector;
import com.tplink.smb.omada.anomaly.core.domain.model.setting.AnomalyEventSettingDTO;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.h;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.osw.OswDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.osw.OswLagDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.g;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LAGGroupLoadGapDetector
implements a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(LAGGroupLoadGapDetector.class);
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a b;
    @Autowired
    private e c;
    @Autowired
    private g d;

    @Override
    public c a() {
        return com.tplink.smb.omada.anomaly.api.b.c.bP;
    }

    @Override
    public f c() {
        return f.d;
    }

    @Override
    public List<b> a(com.tplink.smb.omada.anomaly.core.domain.model.b.b anomalyDetectTimeRange, String mac, List<DevicePreprocessDTO> devicePreDataList) {
        int rateRatioThreshold;
        com.tplink.smb.omada.manager.device.api.internal.device.dto.g request;
        h querySingleDeviceResponse;
        if (CollectionUtils.isEmpty(devicePreDataList)) {
            a.debug("skip abnormal {} anomaly detect for mac {} omadac {} site {}, for data is empty", new Object[]{this.a(), mac, anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b()});
            return Collections.emptyList();
        }
        HashMap<String, List<OswPortTrafficDTO>> portTrafficsMap = new HashMap<String, List<OswPortTrafficDTO>>();
        HashMap<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>> clientTrafficsMap = new HashMap<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>>();
        PortTrafficTooHighDetector.a(devicePreDataList, portTrafficsMap, clientTrafficsMap);
        if (a.isDebugEnabled()) {
            a.debug("oamdacId : {} siteId : {} deviceMac : {} port traffic map {} \n client traffic map {}", new Object[]{anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b(), mac, x.a(portTrafficsMap), x.a(clientTrafficsMap)});
        }
        if (!(querySingleDeviceResponse = this.d.a(request = new com.tplink.smb.omada.manager.device.api.internal.device.dto.g(anomalyDetectTimeRange.a(), mac))).b()) {
            a.debug("query singleDeviceResponse failed for omadacId : {} siteId : {} mac: {}", new Object[]{anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b(), mac});
            return Collections.emptyList();
        }
        OswDTO oswDTO = (OswDTO)querySingleDeviceResponse.c();
        List lagDTOS = oswDTO.getLagDTOS();
        if (oswDTO.getOswStackSetting() != null && oswDTO.getOswStackSetting().getStackId() != null) {
            lagDTOS = oswDTO.getStackLagDTOS();
        }
        if (CollectionUtils.isEmpty((Collection)lagDTOS)) {
            a.debug("end process LAG_GROUP_PORT_LOAD_GAP_TOO_HIGH for not lag , omadacId : {} deviceMac : {}", (Object)anomalyDetectTimeRange.a(), (Object)mac);
            return Collections.emptyList();
        }
        AnomalyEventSettingDTO anomalyEventSettingDTO = anomalyDetectTimeRange.e().get(this.a().a());
        int rateDifferenceThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSettingDTO, "threshold", 50);
        Set<OswLagDTO> detectedOswLags = this.a(lagDTOS, portTrafficsMap, rateDifferenceThreshold, rateRatioThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSettingDTO, "count", 80), mac);
        if (CollectionUtils.isNotEmpty(detectedOswLags)) {
            ArrayList<b> list = new ArrayList<b>();
            for (OswLagDTO oswLagDTO : detectedOswLags) {
                b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.b.a()).a(mac).c(anomalyDetectTimeRange.a()).d(anomalyDetectTimeRange.b()).a(anomalyDetectTimeRange.d()).a(this.a()).a(this.a(anomalyEventSettingDTO)).a();
                ArrayList<LagPortTraffic> lagPortTraffics = new ArrayList<LagPortTraffic>();
                HashMap<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>> clientHighTrafficMap = new HashMap<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>>();
                Set<String> ports = CollectionUtils.isEmpty((Collection)oswLagDTO.getStandardPorts()) ? oswLagDTO.getPorts().stream().map(String::valueOf).collect(Collectors.toSet()) : oswLagDTO.getStandardPorts();
                HashMap<String, List<OswPortTrafficDTO>> lagPortHighTrafficMap = new HashMap<String, List<OswPortTrafficDTO>>();
                ports.forEach(portId -> {
                    lagPortHighTrafficMap.put((String)portId, (List)portTrafficsMap.get(portId));
                    clientHighTrafficMap.put((String)portId, (List)clientTrafficsMap.get(portId));
                });
                List<PortTrafficTooHighDetector.PortTrafficInfo> portTrafficInfoList = PortTrafficTooHighDetector.a(lagPortHighTrafficMap);
                lagPortTraffics.add(new LagPortTraffic(new ArrayList<String>(ports), portTrafficInfoList));
                HashMap<String, Object> detailParam = new HashMap<String, Object>();
                if (!this.a(lagPortTraffics)) continue;
                detailParam.put("lagPortTraffic", lagPortTraffics);
                anomalyEvent.a(CollectionUtils.toStringMap((String[])new String[]{"devMac", mac, "lagId", oswLagDTO.getId()}), CollectionUtils.toStringMap((String[])new String[]{"count", String.valueOf(rateRatioThreshold), "threshold", String.valueOf(rateDifferenceThreshold)}), detailParam, Collections.singletonMap(mac, this.c.a(anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b(), mac)), null, null);
                PortTrafficTooHighDetector.a(anomalyDetectTimeRange, mac, anomalyEvent, clientHighTrafficMap);
                anomalyEvent.a(true);
                list.add(anomalyEvent);
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean a(b newAnomalyEvent, b presidentEvent) {
        if (!this.b(newAnomalyEvent, presidentEvent)) {
            return false;
        }
        Map<String, String> newTitleParams = newAnomalyEvent.p();
        Map<String, String> oldTitleParams = presidentEvent.p();
        if (CollectionUtils.isEmptyMap(newTitleParams) || CollectionUtils.isEmptyMap(oldTitleParams)) {
            return false;
        }
        if (!newTitleParams.containsKey("lagId")) {
            return false;
        }
        if (!oldTitleParams.containsValue(newTitleParams.get("lagId"))) {
            return false;
        }
        com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(presidentEvent, newAnomalyEvent);
        return true;
    }

    private Set<OswLagDTO> a(List<OswLagDTO> oswLags, Map<String, List<OswPortTrafficDTO>> portTrafficMap, int rateDifferenceThreshold, int rateRatioThreshold, String deviceMac) {
        HashSet<OswLagDTO> detectedLags = new HashSet<OswLagDTO>();
        for (OswLagDTO lagDTO : oswLags) {
            boolean rxCondition;
            HashMap<String, List<OswPortTrafficDTO>> lagPortTrafficMap = new HashMap<String, List<OswPortTrafficDTO>>();
            if (CollectionUtils.isEmpty((Collection)lagDTO.getStandardPorts())) {
                ((Set)Optional.ofNullable(lagDTO.getPorts()).orElse(new HashSet())).forEach(port -> lagPortTrafficMap.put(String.valueOf(port), (List)portTrafficMap.get(String.valueOf(port))));
            } else {
                lagDTO.getStandardPorts().forEach(standardPort -> lagPortTrafficMap.put((String)standardPort, (List)portTrafficMap.get(standardPort)));
            }
            if (CollectionUtils.isEmptyMap(lagPortTrafficMap)) continue;
            ArrayList<List<Long>> lagPortRateTxList = new ArrayList<List<Long>>();
            ArrayList<List<Long>> lagPortRateRxList = new ArrayList<List<Long>>();
            this.a(lagPortTrafficMap, lagPortRateTxList, lagPortRateRxList);
            AtomicInteger txCount = new AtomicInteger(0);
            AtomicInteger rxCount = new AtomicInteger(0);
            this.a(lagPortRateTxList, txCount, rateDifferenceThreshold);
            this.a(lagPortRateRxList, rxCount, rateDifferenceThreshold);
            a.debug("device Mac : {} \n lagPortRateTxList : {}  \nlagPortRateRxList : {}", new Object[]{deviceMac, lagPortRateTxList, lagPortRateRxList});
            a.debug("deviceMac : {} tx count : {}  {} / {} rx count : {} {} / {}", new Object[]{deviceMac, txCount.get(), txCount.intValue(), lagPortRateTxList.size(), rxCount.get(), rxCount.intValue(), lagPortRateRxList.size()});
            boolean txCondition = txCount.get() > 0 && txCount.get() * 100 >= lagPortRateTxList.size() * rateRatioThreshold;
            boolean bl = rxCondition = rxCount.get() > 0 && rxCount.get() * 100 >= lagPortRateRxList.size() * rateRatioThreshold;
            if (!txCondition && !rxCondition) continue;
            detectedLags.add(lagDTO);
        }
        return detectedLags;
    }

    private void a(List<List<Long>> lagPortRateTxList, AtomicInteger count, int rateDifferenceThreshold) {
        for (List<Long> list : lagPortRateTxList) {
            boolean isLoadGap = false;
            long max = Collections.max(list);
            if (max > 0L) {
                long diff = max - Collections.min(list);
                boolean bl = isLoadGap = diff * 100L >= max * (long)rateDifferenceThreshold;
            }
            if (!isLoadGap) continue;
            count.getAndIncrement();
        }
    }

    private void a(Map<String, List<OswPortTrafficDTO>> lagPortTrafficMap, List<List<Long>> lagPortRateTxList, List<List<Long>> lagPortRateRxList) {
        HashMap<Long, List> timeBasedTxRateMap = new HashMap<Long, List>();
        HashMap<Long, List> timeBasedRxRateMap = new HashMap<Long, List>();
        for (Map.Entry<String, List<OswPortTrafficDTO>> entry : lagPortTrafficMap.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)entry.getValue())) continue;
            entry.getValue().forEach(portTraffic -> {
                Long timestamp = portTraffic.getTimestamp();
                if (Objects.isNull(timestamp)) {
                    return;
                }
                List txRates = Optional.ofNullable(portTraffic.getPortRate()).map(OswPortRateDTO::getTxRates).orElse(new ArrayList());
                List rxRates = Optional.ofNullable(portTraffic.getPortRate()).map(OswPortRateDTO::getRxRates).orElse(new ArrayList());
                List timePortsTxRates = timeBasedTxRateMap.computeIfAbsent(timestamp, t2 -> new ArrayList());
                List timePortsRxRates = timeBasedRxRateMap.computeIfAbsent(timestamp, t2 -> new ArrayList());
                this.a(timePortsTxRates, txRates);
                this.a(timePortsRxRates, rxRates);
            });
        }
        timeBasedTxRateMap.forEach((k2, v2) -> lagPortRateTxList.addAll((Collection<List<Long>>)v2));
        timeBasedRxRateMap.forEach((k2, v2) -> lagPortRateRxList.addAll((Collection<List<Long>>)v2));
    }

    public boolean a(List<LagPortTraffic> lagPortTraffics) {
        if (CollectionUtils.isEmpty(lagPortTraffics)) {
            return false;
        }
        for (LagPortTraffic lagPortTraffic : lagPortTraffics) {
            if (CollectionUtils.isEmpty(lagPortTraffic.getSwitchPortTraffic())) continue;
            for (PortTrafficTooHighDetector.PortTrafficInfo portTrafficInfo : lagPortTraffic.getSwitchPortTraffic()) {
                if (!portTrafficInfo.hasTraffic()) continue;
                return true;
            }
        }
        return false;
    }

    private void a(List<List<Long>> lagPortRateList, List<Long> rates) {
        if (CollectionUtils.isEmpty(lagPortRateList)) {
            for (Long txRate : rates) {
                lagPortRateList.add(new ArrayList<Long>(Arrays.asList(txRate)));
            }
        } else {
            this.b(lagPortRateList, rates);
        }
    }

    private void b(List<List<Long>> lagPortRateList, List<Long> rates) {
        for (int i2 = 0; i2 < rates.size(); ++i2) {
            if (lagPortRateList.size() > i2 && Objects.nonNull(lagPortRateList.get(i2))) {
                lagPortRateList.get(i2).add(rates.get(i2));
                continue;
            }
            lagPortRateList.add(new ArrayList<Long>(Arrays.asList(rates.get(i2))));
        }
    }

    @KeepClass
    static class LagPortTraffic {
        List<String> portIds;
        List<PortTrafficTooHighDetector.PortTrafficInfo> switchPortTraffic;

        @Generated
        public List<String> getPortIds() {
            return this.portIds;
        }

        @Generated
        public List<PortTrafficTooHighDetector.PortTrafficInfo> getSwitchPortTraffic() {
            return this.switchPortTraffic;
        }

        @Generated
        public void setPortIds(List<String> portIds) {
            this.portIds = portIds;
        }

        @Generated
        public void setSwitchPortTraffic(List<PortTrafficTooHighDetector.PortTrafficInfo> switchPortTraffic) {
            this.switchPortTraffic = switchPortTraffic;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof LagPortTraffic)) {
                return false;
            }
            LagPortTraffic other = (LagPortTraffic)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$portIds = this.getPortIds();
            List<String> other$portIds = other.getPortIds();
            if (this$portIds == null ? other$portIds != null : !((Object)this$portIds).equals(other$portIds)) {
                return false;
            }
            List<PortTrafficTooHighDetector.PortTrafficInfo> this$switchPortTraffic = this.getSwitchPortTraffic();
            List<PortTrafficTooHighDetector.PortTrafficInfo> other$switchPortTraffic = other.getSwitchPortTraffic();
            return !(this$switchPortTraffic == null ? other$switchPortTraffic != null : !((Object)this$switchPortTraffic).equals(other$switchPortTraffic));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LagPortTraffic;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $portIds = this.getPortIds();
            result = result * 59 + ($portIds == null ? 43 : ((Object)$portIds).hashCode());
            List<PortTrafficTooHighDetector.PortTrafficInfo> $switchPortTraffic = this.getSwitchPortTraffic();
            result = result * 59 + ($switchPortTraffic == null ? 43 : ((Object)$switchPortTraffic).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LAGGroupLoadGapDetector.LagPortTraffic(portIds=" + this.getPortIds() + ", switchPortTraffic=" + this.getSwitchPortTraffic() + ")";
        }

        @Generated
        public LagPortTraffic(List<String> portIds, List<PortTrafficTooHighDetector.PortTrafficInfo> switchPortTraffic) {
            this.portIds = portIds;
            this.switchPortTraffic = switchPortTraffic;
        }
    }
}

