/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.rule.osw.hardware;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.hardware.OswPortStatusSwitchFrequentDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.a.c;
import com.tplink.smb.omada.anomaly.core.domain.model.a.e;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.a;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.b;
import com.tplink.smb.omada.anomaly.core.domain.model.setting.AnomalyEventSettingDTO;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.insight.api.web.anomaly.dto.DeviceObjectDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortStatusSwitchFrequentDetector
implements a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(PortStatusSwitchFrequentDetector.class);
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a b;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.e c;
    @Autowired
    private c d;
    private static final long e = 60000L;
    private static final List<com.tplink.smb.omada.anomaly.api.b.c> f = new ArrayList<com.tplink.smb.omada.anomaly.api.b.c>(Arrays.asList(com.tplink.smb.omada.anomaly.api.b.c.bU, com.tplink.smb.omada.anomaly.api.b.c.bV, com.tplink.smb.omada.anomaly.api.b.c.bW));
    private static final List<com.tplink.smb.omada.anomaly.api.b.c> g = Arrays.asList(com.tplink.smb.omada.anomaly.api.b.c.bV, com.tplink.smb.omada.anomaly.api.b.c.bW);

    @Override
    public com.tplink.smb.omada.anomaly.api.b.c a() {
        return com.tplink.smb.omada.anomaly.api.b.c.bs;
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.api.b.c> d() {
        return f;
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.api.b.c> e() {
        return Collections.singletonList(com.tplink.smb.omada.anomaly.api.b.c.cn);
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> a(DevicePreprocessDTO devicePreprocessDTO) {
        OswPortStatusSwitchFrequentDTO portStatusSwitchFrequentDTO = (OswPortStatusSwitchFrequentDTO)devicePreprocessDTO.getPreprocessData().get(this.a().a());
        if (Objects.isNull(portStatusSwitchFrequentDTO.getData())) {
            a.debug("skip abnormal {} anomaly detect for mac {} omadac {} site {}, for data is empty", new Object[]{this.a(), devicePreprocessDTO.getMac(), devicePreprocessDTO.getOmadacId(), devicePreprocessDTO.getSiteId()});
            return Collections.emptyList();
        }
        if (a.isDebugEnabled()) {
            a.debug("detect anomaly event {} for Osw {},preHandle data:{}", new Object[]{this.a(), devicePreprocessDTO.getMac(), x.a((Object)portStatusSwitchFrequentDTO)});
        }
        AnomalyEventSettingDTO anomalyEventSettingDTO = devicePreprocessDTO.getAnomalyEventSettings().get(this.a().a());
        int timeRange = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSettingDTO, "timeRange", 1);
        int changedTimes = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSettingDTO, "changedTimes", 4);
        DeviceObjectDTO deviceObjectDTO = this.c.c(devicePreprocessDTO.getOmadacId(), devicePreprocessDTO.getSiteId(), devicePreprocessDTO.getMac());
        com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.b.a()).a(devicePreprocessDTO.getMac()).c(devicePreprocessDTO.getOmadacId()).d(devicePreprocessDTO.getSiteId()).a((long)devicePreprocessDTO.getTime()).a(this.a()).a(this.a(anomalyEventSettingDTO)).b(true).a();
        ArrayList portIds = new ArrayList();
        ArrayList ports = new ArrayList();
        ArrayList<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyAndCause = new ArrayList<com.tplink.smb.omada.anomaly.core.domain.model.a.b>();
        Integer portNum = deviceObjectDTO.getPortNum();
        portStatusSwitchFrequentDTO.getData().getPorts().forEach(port -> {
            List upTimes = port.getUpTimes();
            List downTimes = port.getDownTimes();
            if (CollectionUtils.isEmpty((Collection)upTimes) || CollectionUtils.isEmpty((Collection)downTimes)) {
                a.warn("Invalid port status switch frequently of device: {}", (Object)devicePreprocessDTO.getMac());
                return;
            }
            Collections.sort(upTimes);
            Collections.sort(downTimes);
            long startTime = PortStatusSwitchFrequentDetector.a(Math.min((Long)upTimes.get(0), (Long)downTimes.get(0)));
            long endTime = PortStatusSwitchFrequentDetector.b(Math.max((Long)upTimes.get(upTimes.size() - 1), (Long)downTimes.get(downTimes.size() - 1)));
            if (Objects.nonNull(portNum) && port.getRealPort() > portNum) {
                portIds.add("LAG " + (port.getRealPort() - portNum));
            } else {
                portIds.add(String.valueOf(port.getRealPort()));
            }
            ports.add(new Port((int)port.getRealPort(), port.getUpTimes(), port.getDownTimes(), startTime, endTime));
            anomalyAndCause.add(this.a(devicePreprocessDTO, port.getRealPort(), (List<Long>)port.getUpTimes(), (List<Long>)port.getDownTimes(), startTime, endTime));
        });
        HashMap<String, Object> detailParam = new HashMap<String, Object>();
        detailParam.put("ports", ports);
        anomalyEvent.a(CollectionUtils.toStringMap((String[])new String[]{"devMac", devicePreprocessDTO.getMac(), "portId", T.a(portIds, (String)",")}), CollectionUtils.toStringMap((String[])new String[]{"timeRange", String.valueOf(timeRange), "changedTimes", String.valueOf(changedTimes)}), detailParam, Collections.singletonMap(devicePreprocessDTO.getMac(), deviceObjectDTO), null, null);
        com.tplink.smb.omada.anomaly.core.domain.model.a.b cableAbnormalCause = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(anomalyEvent.g()).c(anomalyEvent.i()).d(anomalyEvent.j()).a(anomalyEvent.k()).a(com.tplink.smb.omada.anomaly.api.b.c.bU).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(com.tplink.smb.omada.anomaly.api.b.c.bU)).a();
        anomalyEvent.d(cableAbnormalCause);
        anomalyAndCause.add(anomalyEvent);
        return anomalyAndCause;
    }

    private com.tplink.smb.omada.anomaly.core.domain.model.a.b a(DevicePreprocessDTO devicePreprocessDTO, Integer port, List<Long> upTimes, List<Long> downTimes, long startTime, long endTime) {
        com.tplink.smb.omada.anomaly.api.b.c cableAbnormalCauseForApCause = com.tplink.smb.omada.anomaly.api.b.c.l;
        com.tplink.smb.omada.anomaly.core.domain.model.a.b cableAbnormalCauseForAp = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.b.a()).a(devicePreprocessDTO.getMac()).c(devicePreprocessDTO.getOmadacId()).d(devicePreprocessDTO.getSiteId()).a((long)devicePreprocessDTO.getTime()).a(cableAbnormalCauseForApCause).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(cableAbnormalCauseForApCause)).b(true).a();
        String oswMac = devicePreprocessDTO.getMac();
        cableAbnormalCauseForAp.a(CollectionUtils.toStringMap((String[])new String[]{"devMac", oswMac, "portId", String.valueOf(port)}), null, CollectionUtils.toMap((Object[])new Object[]{"startTime", startTime, "endTime", endTime, "upTimes", upTimes, "downTimes", downTimes}), Collections.singletonMap(oswMac, this.c.a(devicePreprocessDTO.getOmadacId(), devicePreprocessDTO.getSiteId(), oswMac)), null);
        return cableAbnormalCauseForAp;
    }

    @Override
    public void a(String omadacId, String siteId, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEventSet, Map<String, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b>> causeMap, com.tplink.smb.omada.anomaly.core.domain.model.b.a associateResult) {
        for (com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent : anomalyEventSet) {
            String deviceMac = anomalyEvent.g();
            List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> cacheAnomalyAndCauseList = this.d.a(omadacId, siteId, anomalyEvent.k(), com.tplink.smb.omada.anomaly.api.b.f.d);
            this.a(causeMap, cacheAnomalyAndCauseList);
            HashSet<com.tplink.smb.omada.anomaly.core.domain.model.a.b> opticalCauses = new HashSet<com.tplink.smb.omada.anomaly.core.domain.model.a.b>();
            Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> loopCauses = causeMap.get(com.tplink.smb.omada.anomaly.core.domain.model.rule.b.a(deviceMac, com.tplink.smb.omada.anomaly.api.b.c.cn));
            for (com.tplink.smb.omada.anomaly.api.b.c causeEnum : g) {
                Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> causes = causeMap.get(com.tplink.smb.omada.anomaly.core.domain.model.rule.b.a(deviceMac, causeEnum));
                if (Objects.isNull(causes)) continue;
                opticalCauses.addAll(causes);
            }
            if (CollectionUtils.isNotEmpty(loopCauses)) {
                PortStatusSwitchFrequentDetector.a(anomalyEvent, loopCauses, associateResult, 3600000L);
            }
            if (!CollectionUtils.isNotEmpty(opticalCauses)) continue;
            PortStatusSwitchFrequentDetector.a(anomalyEvent, opticalCauses, associateResult, 300000L);
        }
    }

    private void a(Map<String, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b>> causeMap, List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> cacheAnomalyAndCauseList) {
        if (CollectionUtils.isEmpty(cacheAnomalyAndCauseList)) {
            return;
        }
        for (com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent : cacheAnomalyAndCauseList) {
            String key = com.tplink.smb.omada.anomaly.core.domain.model.rule.b.a(anomalyEvent.g(), anomalyEvent.m());
            Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> set = causeMap.get(key);
            if (CollectionUtils.isEmpty(set)) {
                set = new HashSet<com.tplink.smb.omada.anomaly.core.domain.model.a.b>();
            }
            set.add(anomalyEvent);
            causeMap.put(key, set);
        }
    }

    public static void a(com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> causeEventSet, com.tplink.smb.omada.anomaly.core.domain.model.b.a associateResult, Long timeRange) {
        ArrayList events = new ArrayList();
        causeEventSet.stream().filter(anomalyCause -> anomalyEvent.k() >= anomalyCause.k() && anomalyEvent.k() - anomalyCause.k() < timeRange).forEach(events::add);
        if (CollectionUtils.isNotEmpty(events)) {
            com.tplink.smb.omada.anomaly.core.domain.model.a.b causeEvent = (com.tplink.smb.omada.anomaly.core.domain.model.a.b)events.get(events.size() - 1);
            associateResult.a(com.tplink.smb.omada.anomaly.core.domain.model.a.e.a().a(com.tplink.smb.omada.anomaly.core.domain.model.a.e.a(anomalyEvent.f(), causeEvent.f())).a(anomalyEvent.i()).b(anomalyEvent.j()).a(anomalyEvent.f()).b(causeEvent.f()).a());
        }
    }

    private static Long a(Long time) {
        long min = time / 60000L;
        return min * 60000L;
    }

    private static Long b(Long time) {
        long max = time / 60000L;
        return (max + 1L) * 60000L;
    }

    @KeepClass
    private static class Port {
        int portId;
        long startTime;
        long endTime;
        List<Long> upTimes;
        List<Long> downTimes;

        Port(int portId, List<Long> upTimes, List<Long> downTimes, long startTime, long endTime) {
            this.portId = portId;
            this.upTimes = upTimes;
            this.downTimes = downTimes;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        @Generated
        public int getPortId() {
            return this.portId;
        }

        @Generated
        public long getStartTime() {
            return this.startTime;
        }

        @Generated
        public long getEndTime() {
            return this.endTime;
        }

        @Generated
        public List<Long> getUpTimes() {
            return this.upTimes;
        }

        @Generated
        public List<Long> getDownTimes() {
            return this.downTimes;
        }

        @Generated
        public void setPortId(int portId) {
            this.portId = portId;
        }

        @Generated
        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        @Generated
        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        @Generated
        public void setUpTimes(List<Long> upTimes) {
            this.upTimes = upTimes;
        }

        @Generated
        public void setDownTimes(List<Long> downTimes) {
            this.downTimes = downTimes;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof Port)) {
                return false;
            }
            Port other = (Port)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPortId() != other.getPortId()) {
                return false;
            }
            if (this.getStartTime() != other.getStartTime()) {
                return false;
            }
            if (this.getEndTime() != other.getEndTime()) {
                return false;
            }
            List<Long> this$upTimes = this.getUpTimes();
            List<Long> other$upTimes = other.getUpTimes();
            if (this$upTimes == null ? other$upTimes != null : !((Object)this$upTimes).equals(other$upTimes)) {
                return false;
            }
            List<Long> this$downTimes = this.getDownTimes();
            List<Long> other$downTimes = other.getDownTimes();
            return !(this$downTimes == null ? other$downTimes != null : !((Object)this$downTimes).equals(other$downTimes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Port;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPortId();
            long $startTime = this.getStartTime();
            result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
            long $endTime = this.getEndTime();
            result = result * 59 + (int)($endTime >>> 32 ^ $endTime);
            List<Long> $upTimes = this.getUpTimes();
            result = result * 59 + ($upTimes == null ? 43 : ((Object)$upTimes).hashCode());
            List<Long> $downTimes = this.getDownTimes();
            result = result * 59 + ($downTimes == null ? 43 : ((Object)$downTimes).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PortStatusSwitchFrequentDetector.Port(portId=" + this.getPortId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", upTimes=" + this.getUpTimes() + ", downTimes=" + this.getDownTimes() + ")";
        }

        @Generated
        public Port(int portId, long startTime, long endTime, List<Long> upTimes, List<Long> downTimes) {
            this.portId = portId;
            this.startTime = startTime;
            this.endTime = endTime;
            this.upTimes = upTimes;
            this.downTimes = downTimes;
        }
    }
}

