/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.rule.osw.hardware;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.c;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.AbstractDeviceDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.hardware.OswPortDetectedErrMessageDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.hardware.PortInfoDTO;
import com.tplink.smb.omada.anomaly.core.domain.a.e;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.a;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.b;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.osw.hardware.PortStatusSwitchFrequentDetector;
import com.tplink.smb.omada.anomaly.core.domain.model.setting.AnomalyEventSettingDTO;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortDetectedErrorMessageDetector
implements a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(PortDetectedErrorMessageDetector.class);
    private static final List<c> b = new ArrayList<c>(Arrays.asList(com.tplink.smb.omada.anomaly.api.b.c.bT, com.tplink.smb.omada.anomaly.api.b.c.bW, com.tplink.smb.omada.anomaly.api.b.c.bV));
    private static final List<c> c = Arrays.asList(com.tplink.smb.omada.anomaly.api.b.c.bV, com.tplink.smb.omada.anomaly.api.b.c.bW);
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a d;
    @Autowired
    private e e;

    @Override
    public c a() {
        return com.tplink.smb.omada.anomaly.api.b.c.br;
    }

    @Override
    public f c() {
        return f.b;
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> a(com.tplink.smb.omada.anomaly.core.domain.model.b.b anomalyDetectTimeRange, String mac, List<DevicePreprocessDTO> devicePreDataList) {
        if (CollectionUtils.isEmpty(devicePreDataList)) {
            a.debug("skip abnormal {} anomaly detect for mac {} omadac {} site {}, for data is empty", new Object[]{this.a(), mac, anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b()});
            return Collections.emptyList();
        }
        HashMap<Integer, List<PortInfoDTO>> portInfoMap = new HashMap<Integer, List<PortInfoDTO>>(8);
        this.a(portInfoMap, devicePreDataList);
        a.debug("detect anomaly event {} for Osw {},preHandle data:{}", new Object[]{this.a(), mac, x.a(portInfoMap)});
        HashSet<Integer> errorPort = new HashSet<Integer>();
        HashMap<Integer, List> errPortMap = new HashMap<Integer, List>(8);
        for (Map.Entry entry : portInfoMap.entrySet()) {
            List errPkts = ((List)entry.getValue()).stream().map(PortInfoDTO::getErrPkts).collect(Collectors.toList());
            if ((Long)Collections.max(errPkts) - (Long)Collections.min(errPkts) <= 0L) continue;
            errorPort.add((Integer)entry.getKey());
            errPortMap.put((Integer)entry.getKey(), (List)entry.getValue());
        }
        if (!CollectionUtils.isEmpty(errorPort)) {
            AnomalyEventSettingDTO anomalyEventSettingDTO = anomalyDetectTimeRange.e().get(this.a().a());
            com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.d.a()).a(mac).c(anomalyDetectTimeRange.a()).d(anomalyDetectTimeRange.b()).a(anomalyDetectTimeRange.d()).a(this.a()).a(this.a(anomalyEventSettingDTO)).b(true).a();
            com.tplink.smb.omada.anomaly.core.domain.model.a.b cause = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(mac).c(anomalyDetectTimeRange.a()).d(anomalyDetectTimeRange.b()).a(anomalyDetectTimeRange.d()).a(com.tplink.smb.omada.anomaly.api.b.c.bT).a(com.tplink.smb.omada.anomaly.api.b.c.bT.c()).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(com.tplink.smb.omada.anomaly.api.b.c.bT)).a();
            TreeMap errPortInfoMap = new TreeMap();
            for (Map.Entry entry : errPortMap.entrySet()) {
                ((List)entry.getValue()).forEach(portInfoDTO -> {
                    if (Objects.isNull(errPortInfoMap.get(portInfoDTO.getTimestamp()))) {
                        ArrayList<PortInfo> list = new ArrayList<PortInfo>();
                        list.add(new PortInfo(portInfoDTO.getPort(), portInfoDTO.getErrPkts()));
                        errPortInfoMap.put(portInfoDTO.getTimestamp(), list);
                    } else {
                        ((List)errPortInfoMap.get(portInfoDTO.getTimestamp())).add(new PortInfo(portInfoDTO.getPort(), portInfoDTO.getErrPkts()));
                    }
                });
            }
            ArrayList<ErrorPort> errorPorts = new ArrayList<ErrorPort>();
            for (Map.Entry entry : errPortInfoMap.entrySet()) {
                errorPorts.add(new ErrorPort((Long)entry.getKey(), (List)entry.getValue()));
            }
            SwitchErrPorts switchErrPorts = new SwitchErrPorts(new ArrayList<Integer>(errorPort), errorPorts);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("switchErrPorts", switchErrPorts);
            anomalyEvent.a(CollectionUtils.toStringMap((String[])new String[]{"devMac", mac, "portId", T.a(errorPort, (String)",")}), null, hashMap, Collections.singletonMap(mac, this.e.a(anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b(), mac)), null, null);
            anomalyEvent.d(cause);
            return Collections.singletonList(anomalyEvent);
        }
        return Collections.emptyList();
    }

    @Override
    public List<c> d() {
        return b;
    }

    @Override
    public void a(String omadacId, String siteId, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEventSet, Map<String, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b>> causeMap, com.tplink.smb.omada.anomaly.core.domain.model.b.a associateResult) {
        for (com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent : anomalyEventSet) {
            String deviceMac = anomalyEvent.g();
            HashSet<com.tplink.smb.omada.anomaly.core.domain.model.a.b> opticalCauses = new HashSet<com.tplink.smb.omada.anomaly.core.domain.model.a.b>();
            for (c causeEnum : c) {
                Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> causes = causeMap.get(com.tplink.smb.omada.anomaly.core.domain.model.rule.b.a(deviceMac, causeEnum));
                if (!CollectionUtils.isNotEmpty(causes)) continue;
                opticalCauses.addAll(causes);
            }
            if (!CollectionUtils.isNotEmpty(opticalCauses)) continue;
            PortStatusSwitchFrequentDetector.a(anomalyEvent, opticalCauses, associateResult, 300000L);
        }
    }

    @Override
    public Boolean a(com.tplink.smb.omada.anomaly.core.domain.model.a.b newAnomalyEvent, com.tplink.smb.omada.anomaly.core.domain.model.a.b presidentEvent) {
        if (!this.b(newAnomalyEvent, presidentEvent)) {
            return false;
        }
        return com.tplink.smb.omada.anomaly.core.port.f.a.a(newAnomalyEvent, presidentEvent);
    }

    private void a(Map<Integer, List<PortInfoDTO>> portInfoMap, List<DevicePreprocessDTO> devicePreDataList) {
        for (DevicePreprocessDTO devicePreprocessDTO : devicePreDataList) {
            if (Objects.isNull(devicePreprocessDTO) || Objects.isNull(devicePreprocessDTO.getPreprocessData().get(this.a().a()))) continue;
            AbstractDeviceDTO abstractDeviceDTO = devicePreprocessDTO.getPreprocessData().get(this.a().a());
            Map portErrInfoMap = ((OswPortDetectedErrMessageDTO)abstractDeviceDTO).getPortInfos();
            for (Map.Entry entry : portErrInfoMap.entrySet()) {
                if (Objects.isNull(portInfoMap.get(entry.getKey()))) {
                    ArrayList<PortInfoDTO> dtoList = new ArrayList<PortInfoDTO>();
                    dtoList.add((PortInfoDTO)entry.getValue());
                    portInfoMap.put((Integer)entry.getKey(), dtoList);
                    continue;
                }
                portInfoMap.get(entry.getKey()).add((PortInfoDTO)entry.getValue());
            }
        }
    }

    @KeepClass
    private class ErrorPort {
        long time;
        List<PortInfo> errPort;

        @Generated
        public long getTime() {
            return this.time;
        }

        @Generated
        public List<PortInfo> getErrPort() {
            return this.errPort;
        }

        @Generated
        public void setTime(long time) {
            this.time = time;
        }

        @Generated
        public void setErrPort(List<PortInfo> errPort) {
            this.errPort = errPort;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof ErrorPort)) {
                return false;
            }
            ErrorPort other = (ErrorPort)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTime() != other.getTime()) {
                return false;
            }
            List<PortInfo> this$errPort = this.getErrPort();
            List<PortInfo> other$errPort = other.getErrPort();
            return !(this$errPort == null ? other$errPort != null : !((Object)this$errPort).equals(other$errPort));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ErrorPort;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            List<PortInfo> $errPort = this.getErrPort();
            result = result * 59 + ($errPort == null ? 43 : ((Object)$errPort).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PortDetectedErrorMessageDetector.ErrorPort(time=" + this.getTime() + ", errPort=" + this.getErrPort() + ")";
        }

        @Generated
        public ErrorPort(long time, List<PortInfo> errPort) {
            this.time = time;
            this.errPort = errPort;
        }

        @Generated
        public ErrorPort() {
        }
    }

    @KeepClass
    private class SwitchErrPorts {
        List<Integer> portIds;
        List<ErrorPort> errPortList;

        @Generated
        public List<Integer> getPortIds() {
            return this.portIds;
        }

        @Generated
        public List<ErrorPort> getErrPortList() {
            return this.errPortList;
        }

        @Generated
        public void setPortIds(List<Integer> portIds) {
            this.portIds = portIds;
        }

        @Generated
        public void setErrPortList(List<ErrorPort> errPortList) {
            this.errPortList = errPortList;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof SwitchErrPorts)) {
                return false;
            }
            SwitchErrPorts other = (SwitchErrPorts)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Integer> this$portIds = this.getPortIds();
            List<Integer> other$portIds = other.getPortIds();
            if (this$portIds == null ? other$portIds != null : !((Object)this$portIds).equals(other$portIds)) {
                return false;
            }
            List<ErrorPort> this$errPortList = this.getErrPortList();
            List<ErrorPort> other$errPortList = other.getErrPortList();
            return !(this$errPortList == null ? other$errPortList != null : !((Object)this$errPortList).equals(other$errPortList));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SwitchErrPorts;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Integer> $portIds = this.getPortIds();
            result = result * 59 + ($portIds == null ? 43 : ((Object)$portIds).hashCode());
            List<ErrorPort> $errPortList = this.getErrPortList();
            result = result * 59 + ($errPortList == null ? 43 : ((Object)$errPortList).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PortDetectedErrorMessageDetector.SwitchErrPorts(portIds=" + this.getPortIds() + ", errPortList=" + this.getErrPortList() + ")";
        }

        @Generated
        public SwitchErrPorts(List<Integer> portIds, List<ErrorPort> errPortList) {
            this.portIds = portIds;
            this.errPortList = errPortList;
        }

        @Generated
        public SwitchErrPorts() {
        }
    }

    @KeepClass
    private class PortInfo {
        int portId;
        long errPackets;

        @Generated
        public int getPortId() {
            return this.portId;
        }

        @Generated
        public long getErrPackets() {
            return this.errPackets;
        }

        @Generated
        public void setPortId(int portId) {
            this.portId = portId;
        }

        @Generated
        public void setErrPackets(long errPackets) {
            this.errPackets = errPackets;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof PortInfo)) {
                return false;
            }
            PortInfo other = (PortInfo)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPortId() != other.getPortId()) {
                return false;
            }
            return this.getErrPackets() == other.getErrPackets();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PortInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPortId();
            long $errPackets = this.getErrPackets();
            result = result * 59 + (int)($errPackets >>> 32 ^ $errPackets);
            return result;
        }

        @Generated
        public String toString() {
            return "PortDetectedErrorMessageDetector.PortInfo(portId=" + this.getPortId() + ", errPackets=" + this.getErrPackets() + ")";
        }

        @Generated
        public PortInfo(int portId, long errPackets) {
            this.portId = portId;
            this.errPackets = errPackets;
        }
    }
}

