/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.rule.osw.hardware;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.c;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.api.b.w;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.AbstractDeviceDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.hardware.OswCpuUtilDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.a;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.a.e;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.b;
import com.tplink.smb.omada.anomaly.core.domain.model.setting.AnomalyEventSettingDTO;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswCpuPktsInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OswHighCpuUtilDetector
implements a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(OswHighCpuUtilDetector.class);
    private static BigDecimal b = BigDecimal.valueOf(0.01);
    private static final int c = OmadacType.s() ? 3 : 12;
    private static final List<c> d = new ArrayList<c>(Arrays.asList(com.tplink.smb.omada.anomaly.api.b.c.bS, com.tplink.smb.omada.anomaly.api.b.c.bu));
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a e;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.e f;
    @Autowired
    private e g;

    @Override
    public c a() {
        return com.tplink.smb.omada.anomaly.api.b.c.bq;
    }

    @Override
    public f c() {
        return com.tplink.smb.omada.anomaly.api.b.f.c;
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> a(com.tplink.smb.omada.anomaly.core.domain.model.b.b anomalyDetectTimeRange, String mac, List<DevicePreprocessDTO> devicePreDataList) {
        if (CollectionUtils.isEmpty(devicePreDataList)) {
            return Collections.emptyList();
        }
        ArrayList<OswCpuUtilDTO> cpuUtilList = new ArrayList<OswCpuUtilDTO>();
        for (DevicePreprocessDTO devicePreprocessDTO : devicePreDataList) {
            AbstractDeviceDTO abstractDeviceDTO = devicePreprocessDTO.getPreprocessData().get(this.a().a());
            if (Objects.isNull(abstractDeviceDTO)) continue;
            cpuUtilList.add((OswCpuUtilDTO)abstractDeviceDTO);
        }
        if (CollectionUtils.isEmpty(cpuUtilList) || cpuUtilList.size() < c) {
            a.debug("skip abnormal {} anomaly detect for mac {} omadac {} site {}, for data is not enough", new Object[]{this.a(), mac, anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b()});
            return Collections.emptyList();
        }
        if (a.isDebugEnabled()) {
            a.debug("high cpu util anomaly detect for mac {}  omadac {} site {}, cpuUtilList is: {}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)mac), anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b(), x.a(cpuUtilList)});
        }
        TreeMap oswCpuUtilMap = new TreeMap();
        ArrayList<OswCpuPktsInfo.ProtoRxPkts> protoRxPktsList = new ArrayList<OswCpuPktsInfo.ProtoRxPkts>();
        cpuUtilList.forEach(oswCpuUtilDTO -> {
            oswCpuUtilMap.put(oswCpuUtilDTO.getTime(), new OswCpuUtil(oswCpuUtilDTO.getTime(), oswCpuUtilDTO.getCpuUtil()));
            if (Objects.nonNull(oswCpuUtilDTO.getProtoRxPkts())) {
                protoRxPktsList.add(oswCpuUtilDTO.getProtoRxPkts());
            }
        });
        AnomalyEventSettingDTO anomalyEventSettingDTO = anomalyDetectTimeRange.e().get(this.a().a());
        int cpuRiskThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSettingDTO, "threshold", 90);
        int cpuRatioThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSettingDTO, "count", 80);
        long highCpuUtilCount = cpuUtilList.stream().filter(cpuUtil -> cpuUtil != null && cpuUtil.getCpuUtil() >= cpuRiskThreshold).count();
        ArrayList<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEventList = new ArrayList<com.tplink.smb.omada.anomaly.core.domain.model.a.b>();
        if (highCpuUtilCount * 100L >= (long)(cpuUtilList.size() * cpuRatioThreshold)) {
            com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.e.a()).a(mac).c(anomalyDetectTimeRange.a()).d(anomalyDetectTimeRange.b()).a(anomalyDetectTimeRange.d()).a(this.a()).a(this.a(anomalyEventSettingDTO)).b(true).a();
            anomalyEvent.a(CollectionUtils.toStringMap((String[])new String[]{"devMac", mac}), CollectionUtils.toStringMap((String[])new String[]{"devMac", mac, "count", String.valueOf(cpuRatioThreshold), "threshold", String.valueOf(cpuRiskThreshold)}), Collections.singletonMap("cpuUtils", oswCpuUtilMap.values()), Collections.singletonMap(mac, this.f.a(anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b(), mac)), null, null);
            anomalyEventList.add(anomalyEvent);
            if (CollectionUtils.isNotEmpty(protoRxPktsList)) {
                com.tplink.smb.omada.anomaly.core.domain.model.a.b cause = this.a(protoRxPktsList, anomalyDetectTimeRange, mac);
                anomalyEvent.d(cause);
                anomalyEventList.add(cause);
            }
            return anomalyEventList;
        }
        return Collections.emptyList();
    }

    @Override
    public List<c> e() {
        return d;
    }

    @Override
    public void a(String omadacId, String siteId, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEventSet, Map<String, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b>> causeMap, com.tplink.smb.omada.anomaly.core.domain.model.b.a associateResult) {
        for (com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent : anomalyEventSet) {
            String deviceMac = anomalyEvent.g();
            Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> loopCauses = causeMap.get(com.tplink.smb.omada.anomaly.core.domain.model.rule.b.a(deviceMac, com.tplink.smb.omada.anomaly.api.b.c.cn));
            if (CollectionUtils.isNotEmpty(loopCauses)) {
                this.a(anomalyEvent.i(), anomalyEvent.j(), associateResult, anomalyEvent, loopCauses, null, true);
            }
            this.g.a(anomalyEvent, com.tplink.smb.omada.anomaly.api.b.c.eG);
        }
    }

    private com.tplink.smb.omada.anomaly.core.domain.model.a.b a(List<OswCpuPktsInfo.ProtoRxPkts> protoRxPktsList, com.tplink.smb.omada.anomaly.core.domain.model.b.b anomalyDetectTimeRange, String mac) {
        HashMap<Integer, Long> protoRxPktsMap = new HashMap<Integer, Long>();
        long igmp = 0L;
        long dhcp = 0L;
        long l2pt = 0L;
        long arp = 0L;
        long lbd = 0L;
        long mld = 0L;
        long lldp = 0L;
        long mstp = 0L;
        long pppoe = 0L;
        long dldp = 0L;
        long proto8021x = 0L;
        long gvrp = 0L;
        long voip = 0L;
        long slow = 0L;
        for (OswCpuPktsInfo.ProtoRxPkts protoRxPkts : protoRxPktsList) {
            igmp += Objects.isNull(protoRxPkts.getIgmp()) ? 0L : protoRxPkts.getIgmp();
            dhcp += Objects.isNull(protoRxPkts.getDhcp()) ? 0L : protoRxPkts.getDhcp();
            l2pt += Objects.isNull(protoRxPkts.getL2pt()) ? 0L : protoRxPkts.getL2pt();
            arp += Objects.isNull(protoRxPkts.getArp()) ? 0L : protoRxPkts.getArp();
            lbd += Objects.isNull(protoRxPkts.getLbd()) ? 0L : protoRxPkts.getLbd();
            mld += Objects.isNull(protoRxPkts.getMld()) ? 0L : protoRxPkts.getMld();
            lldp += Objects.isNull(protoRxPkts.getLldp()) ? 0L : protoRxPkts.getLldp();
            mstp += Objects.isNull(protoRxPkts.getMstp()) ? 0L : protoRxPkts.getMstp();
            pppoe += Objects.isNull(protoRxPkts.getPppoe()) ? 0L : protoRxPkts.getPppoe();
            dldp += Objects.isNull(protoRxPkts.getDldp()) ? 0L : protoRxPkts.getDldp();
            proto8021x += Objects.isNull(protoRxPkts.getProto8021x()) ? 0L : protoRxPkts.getProto8021x();
            gvrp += Objects.isNull(protoRxPkts.getGvrp()) ? 0L : protoRxPkts.getGvrp();
            voip += Objects.isNull(protoRxPkts.getVoip()) ? 0L : protoRxPkts.getVoip();
            slow += Objects.isNull(protoRxPkts.getSlow()) ? 0L : protoRxPkts.getSlow();
        }
        protoRxPktsMap.put(w.a.a(), igmp);
        protoRxPktsMap.put(w.b.a(), dhcp);
        protoRxPktsMap.put(w.c.a(), l2pt);
        protoRxPktsMap.put(w.d.a(), arp);
        protoRxPktsMap.put(w.e.a(), lbd);
        protoRxPktsMap.put(w.f.a(), mld);
        protoRxPktsMap.put(w.g.a(), lldp);
        protoRxPktsMap.put(w.h.a(), mstp);
        protoRxPktsMap.put(w.i.a(), pppoe);
        protoRxPktsMap.put(w.j.a(), dldp);
        protoRxPktsMap.put(w.k.a(), proto8021x);
        protoRxPktsMap.put(w.l.a(), gvrp);
        protoRxPktsMap.put(w.m.a(), voip);
        protoRxPktsMap.put(w.n.a(), slow);
        protoRxPktsMap.entrySet().removeIf(entry -> Objects.equals(0L, entry.getValue()));
        long totalPkts = protoRxPktsMap.values().stream().mapToLong(Long::longValue).sum();
        ArrayList<Protol> protols = new ArrayList<Protol>();
        for (Map.Entry entry2 : protoRxPktsMap.entrySet()) {
            BigDecimal currentProtocolPercent = BigDecimal.valueOf((double)((Long)entry2.getValue()).longValue() / (double)totalPkts * 100.0);
            if (currentProtocolPercent.compareTo(b) < 0) continue;
            double proportion = currentProtocolPercent.setScale(2, 4).doubleValue();
            Protol protol = new Protol((Integer)entry2.getKey(), proportion);
            protols.add(protol);
        }
        com.tplink.smb.omada.anomaly.core.domain.model.a.b cause = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.e.a()).a(mac).c(anomalyDetectTimeRange.a()).d(anomalyDetectTimeRange.b()).a(anomalyDetectTimeRange.d()).a(com.tplink.smb.omada.anomaly.api.b.c.bS).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(com.tplink.smb.omada.anomaly.api.b.c.bS)).b(true).a();
        HashMap<String, Object> detailParam = new HashMap<String, Object>();
        detailParam.put("protol", protols);
        cause.a(null, null, detailParam, null, null, null);
        return cause;
    }

    @KeepClass
    private static class Protol {
        private int protolName;
        private double proportion;

        @Generated
        public int getProtolName() {
            return this.protolName;
        }

        @Generated
        public double getProportion() {
            return this.proportion;
        }

        @Generated
        public void setProtolName(int protolName) {
            this.protolName = protolName;
        }

        @Generated
        public void setProportion(double proportion) {
            this.proportion = proportion;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof Protol)) {
                return false;
            }
            Protol other = (Protol)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getProtolName() != other.getProtolName()) {
                return false;
            }
            return Double.compare(this.getProportion(), other.getProportion()) == 0;
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Protol;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getProtolName();
            long $proportion = Double.doubleToLongBits(this.getProportion());
            result = result * 59 + (int)($proportion >>> 32 ^ $proportion);
            return result;
        }

        @Generated
        public String toString() {
            return "OswHighCpuUtilDetector.Protol(protolName=" + this.getProtolName() + ", proportion=" + this.getProportion() + ")";
        }

        @Generated
        public Protol(int protolName, double proportion) {
            this.protolName = protolName;
            this.proportion = proportion;
        }

        @Generated
        public Protol() {
        }
    }

    @KeepClass
    private static class OswCpuUtil {
        long time;
        int cpuUtil;

        @Generated
        public long getTime() {
            return this.time;
        }

        @Generated
        public int getCpuUtil() {
            return this.cpuUtil;
        }

        @Generated
        public void setTime(long time) {
            this.time = time;
        }

        @Generated
        public void setCpuUtil(int cpuUtil) {
            this.cpuUtil = cpuUtil;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof OswCpuUtil)) {
                return false;
            }
            OswCpuUtil other = (OswCpuUtil)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTime() != other.getTime()) {
                return false;
            }
            return this.getCpuUtil() == other.getCpuUtil();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OswCpuUtil;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            result = result * 59 + this.getCpuUtil();
            return result;
        }

        @Generated
        public String toString() {
            return "OswHighCpuUtilDetector.OswCpuUtil(time=" + this.getTime() + ", cpuUtil=" + this.getCpuUtil() + ")";
        }

        @Generated
        public OswCpuUtil(long time, int cpuUtil) {
            this.time = time;
            this.cpuUtil = cpuUtil;
        }

        @Generated
        public OswCpuUtil() {
        }
    }
}

