/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.rule.osw.access;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.c;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.AbstractDeviceDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.OswCertificationInfoDTO;
import com.tplink.smb.omada.anomaly.core.domain.a.e;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.b;
import com.tplink.smb.omada.anomaly.core.domain.model.setting.AnomalyEventSettingDTO;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.insight.api.web.anomaly.dto.ClientObjectDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Osw8021xCertificationDetector
implements com.tplink.smb.omada.anomaly.core.domain.model.rule.a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(Osw8021xCertificationDetector.class);
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a b;
    @Autowired
    private e c;
    private static final int d = 30;

    @Override
    public c a() {
        return com.tplink.smb.omada.anomaly.api.b.c.bx;
    }

    @Override
    public f c() {
        return f.e;
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> a(com.tplink.smb.omada.anomaly.core.domain.model.b.b anomalyDetectTimeRange, String mac, List<DevicePreprocessDTO> devicePreDataList) {
        if (CollectionUtils.isEmpty(devicePreDataList)) {
            a.debug("skip abnormal {} anomaly detect for mac {} omadac {} site {}, for data is empty", new Object[]{this.a(), mac, anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b()});
            return Collections.emptyList();
        }
        Map<String, AnomalyEventSettingDTO> anomalyEventSettings = anomalyDetectTimeRange.e();
        AnomalyEventSettingDTO certificationSuccessRateLowSetting = anomalyEventSettings.get(com.tplink.smb.omada.anomaly.api.b.c.bx.a());
        AnomalyEventSettingDTO certificationTimeLongSetting = anomalyEventSettings.get(com.tplink.smb.omada.anomaly.api.b.c.by.a());
        boolean successRateLowEventEnable = certificationSuccessRateLowSetting.getEnable();
        boolean longTimeEventEnable = certificationTimeLongSetting.getEnable();
        if (successRateLowEventEnable || longTimeEventEnable) {
            int longTimeThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(certificationTimeLongSetting, "threshold", 3000);
            a dataRecord = this.a(devicePreDataList, longTimeThreshold);
            if (this.a(dataRecord)) {
                return Collections.emptyList();
            }
            ArrayList<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEventList = new ArrayList<com.tplink.smb.omada.anomaly.core.domain.model.a.b>();
            if (successRateLowEventEnable) {
                int successRateThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(certificationSuccessRateLowSetting, "successRate", 50);
                int totalTimes = dataRecord.a().intValue();
                int successTimes = dataRecord.b().intValue();
                if (this.a(successTimes, totalTimes, successRateThreshold)) {
                    int successRate = (int)Math.round(dataRecord.b().doubleValue() * 100.0 / dataRecord.a().doubleValue());
                    com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.b.a()).a(mac).c(anomalyDetectTimeRange.a()).d(anomalyDetectTimeRange.b()).a(anomalyDetectTimeRange.d()).a(com.tplink.smb.omada.anomaly.api.b.c.bx).a(this.a(certificationSuccessRateLowSetting)).a();
                    Map<String, Object> detailMap = this.a(dataRecord.e());
                    Map<String, ClientObjectDTO> clientMap = this.a(dataRecord.e().keySet());
                    anomalyEvent.a(CollectionUtils.toStringMap((String[])new String[]{"devMac", mac}), CollectionUtils.toStringMap((String[])new String[]{"threshold", String.valueOf(successRateThreshold), "successRate", String.valueOf(successRate), "totalTimes", String.valueOf(totalTimes), "failedTimes", String.valueOf(totalTimes - successTimes)}), detailMap, Collections.singletonMap(mac, this.c.a(anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b(), mac)), clientMap, null);
                    anomalyEventList.add(anomalyEvent);
                }
            }
            if (longTimeEventEnable) {
                int countThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(certificationTimeLongSetting, "count", 50);
                if (this.b(dataRecord.c().intValue(), dataRecord.b().intValue(), countThreshold)) {
                    com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.b.a()).a(mac).c(anomalyDetectTimeRange.a()).d(anomalyDetectTimeRange.b()).a(anomalyDetectTimeRange.d()).a(com.tplink.smb.omada.anomaly.api.b.c.by).a(this.a(certificationTimeLongSetting)).a();
                    Map<String, Object> detailMap = this.a(dataRecord.f());
                    Set<String> clientMacs = dataRecord.f().stream().map(com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a::c).collect(Collectors.toSet());
                    Map<String, ClientObjectDTO> clientMap = this.a(clientMacs);
                    anomalyEvent.a(null, CollectionUtils.toStringMap((String[])new String[]{"count", String.valueOf(countThreshold), "threshold", String.valueOf(longTimeThreshold)}), detailMap, Collections.singletonMap(mac, this.c.a(anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b(), mac)), clientMap, null);
                    anomalyEventList.add(anomalyEvent);
                }
            }
            this.a(anomalyEventList, dataRecord.d(), dataRecord.e());
            return anomalyEventList;
        }
        return Collections.emptyList();
    }

    private boolean a(a dataRecord) {
        return CollectionUtils.isEmptyMap(dataRecord.d()) || dataRecord.a().intValue() < 30;
    }

    private a a(List<DevicePreprocessDTO> devicePreDataList, int longTimeThreshold) {
        a dataRecord = new a();
        for (DevicePreprocessDTO devicePreprocessDTO : devicePreDataList) {
            AbstractDeviceDTO abstractDeviceDTO = devicePreprocessDTO.getPreprocessData().get(this.a().a());
            if (Objects.isNull(abstractDeviceDTO)) continue;
            OswCertificationInfoDTO oswCertificationInfoDTO = (OswCertificationInfoDTO)abstractDeviceDTO;
            dataRecord.a().getAndAdd(oswCertificationInfoDTO.getCertificationInfos().size());
            dataRecord.d().put(oswCertificationInfoDTO.getTimestamp(), oswCertificationInfoDTO.getCertificationInfos());
            this.a(oswCertificationInfoDTO, dataRecord.b(), dataRecord.c(), longTimeThreshold, dataRecord.e(), dataRecord.f());
        }
        return dataRecord;
    }

    @Override
    public void a(String omadacId, String siteId, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEventSet, Map<String, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b>> causeMap, com.tplink.smb.omada.anomaly.core.domain.model.b.a associateResult) {
        for (com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent : anomalyEventSet) {
            String deviceMac = anomalyEvent.g();
            Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> causes = causeMap.get(com.tplink.smb.omada.anomaly.core.domain.model.rule.b.a(deviceMac, com.tplink.smb.omada.anomaly.api.b.c.bS));
            if (!CollectionUtils.isNotEmpty(causes)) continue;
            this.a(omadacId, siteId, associateResult, anomalyEvent, causes, null, false);
        }
    }

    private void a(OswCertificationInfoDTO oswCertificationInfoDTO, AtomicInteger successCount, AtomicInteger longTimeCount, Integer longTimeThreshold, Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> clientCertificationFailedMap, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a> longTimeCertificationInfos) {
        oswCertificationInfoDTO.getCertificationInfos().forEach(oswCertificationInfo -> {
            int result = oswCertificationInfo.g();
            switch (result) {
                case 0: {
                    successCount.getAndIncrement();
                    if (oswCertificationInfo.h() < longTimeThreshold) break;
                    longTimeCount.getAndIncrement();
                    longTimeCertificationInfos.add((com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a)oswCertificationInfo);
                    break;
                }
                case 1: 
                case 2: {
                    String clientMac = oswCertificationInfo.c();
                    if (clientCertificationFailedMap.containsKey(clientMac)) {
                        ((List)clientCertificationFailedMap.get(clientMac)).add(oswCertificationInfo);
                        break;
                    }
                    clientCertificationFailedMap.put(clientMac, new ArrayList<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>(Arrays.asList(oswCertificationInfo)));
                    break;
                }
            }
        });
    }

    private boolean a(int successCount, int totalCount, int successRateThreshold) {
        a.debug("successCount: {}, totalCount:{}", (Object)successCount, (Object)totalCount);
        return totalCount > 0 && successCount * 100 <= totalCount * successRateThreshold;
    }

    private boolean b(int longTimeCount, int successCount, int countThreshold) {
        a.debug("successCount: {}, longTimeCount:{}", (Object)successCount, (Object)longTimeCount);
        return successCount > 0 && longTimeCount * 100 >= successCount * countThreshold;
    }

    private Map<String, Object> a(List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a> longTimeCertificationInfos) {
        ArrayList<LongTimeClient> list = new ArrayList<LongTimeClient>();
        for (com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a oswCertificationInfo : longTimeCertificationInfos) {
            list.add(new LongTimeClient(oswCertificationInfo.c(), oswCertificationInfo.h()));
        }
        List detailList = list.stream().sorted(Comparator.comparing(LongTimeClient::getDuration, Comparator.reverseOrder())).limit(20L).collect(Collectors.toList());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clients", detailList);
        return map;
    }

    private Map<String, Object> a(Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> clientCertificationFailedMap) {
        ArrayList<FailedClient> list = new ArrayList<FailedClient>();
        for (Map.Entry<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> entry : clientCertificationFailedMap.entrySet()) {
            list.add(new FailedClient(entry.getKey(), entry.getValue().size()));
        }
        List detailList = list.stream().sorted(Comparator.comparing(FailedClient::getFailedTimes, Comparator.reverseOrder())).limit(20L).collect(Collectors.toList());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clients", detailList);
        return map;
    }

    private Map<String, ClientObjectDTO> a(Set<String> clientMacs) {
        HashMap<String, ClientObjectDTO> map = new HashMap<String, ClientObjectDTO>();
        clientMacs.forEach(mac -> {
            ClientObjectDTO clientObjectDTO = ClientObjectDTO.builder().manager(Boolean.valueOf(false)).name(mac).deviceType("unknown").build();
            map.put((String)mac, clientObjectDTO);
        });
        return map;
    }

    private void a(List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEventList, Map<Long, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> certificationMap, Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> clientCertificationFailedMap) {
        if (CollectionUtils.isEmpty(anomalyEventList)) {
            return;
        }
        this.a(anomalyEventList, certificationMap);
        for (com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent : anomalyEventList) {
            c anomalyCode = anomalyEvent.m();
            if (Objects.equals(com.tplink.smb.omada.anomaly.api.b.c.bx, anomalyCode)) {
                this.a(anomalyEvent, clientCertificationFailedMap);
                continue;
            }
            if (!Objects.equals(com.tplink.smb.omada.anomaly.api.b.c.by, anomalyCode)) continue;
            this.a(anomalyEvent);
        }
    }

    private void a(com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent, Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> clientCertificationFailedMap) {
        HashMap<String, Integer> clientAuthErrorTimes = new HashMap<String, Integer>();
        HashMap<String, Set<String>> authServerMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> entry : clientCertificationFailedMap.entrySet()) {
            List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a> list = entry.getValue();
            for (com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a oswCertificationInfo : list) {
                if (Objects.isNull(oswCertificationInfo.g())) continue;
                String clientMac = oswCertificationInfo.c();
                switch (oswCertificationInfo.g()) {
                    case 2: {
                        String serverIp = com.tplink.smb.omada.anomaly.core.port.f.a.a(oswCertificationInfo.d(), "--");
                        if (authServerMap.containsKey(serverIp)) {
                            ((Set)authServerMap.get(serverIp)).add(clientMac);
                            break;
                        }
                        authServerMap.put(serverIp, new HashSet<String>(Arrays.asList(clientMac)));
                        break;
                    }
                    case 1: {
                        int count = clientAuthErrorTimes.getOrDefault(clientMac, 0);
                        clientAuthErrorTimes.put(clientMac, count + 1);
                        break;
                    }
                }
            }
        }
        a.debug("osw : {} authServerMap : {} clientAuthErrorTimes : {}", new Object[]{anomalyEvent.g(), authServerMap, clientAuthErrorTimes});
        this.a(authServerMap, anomalyEvent);
        this.b(clientAuthErrorTimes, anomalyEvent);
    }

    private void a(Map<String, Set<String>> authServerMap, com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent) {
        if (CollectionUtils.isEmptyMap(authServerMap)) {
            return;
        }
        ArrayList<ServerAuthFailedClient> list = new ArrayList<ServerAuthFailedClient>();
        for (Map.Entry<String, Set<String>> entry : authServerMap.entrySet()) {
            list.add(new ServerAuthFailedClient(entry.getKey(), entry.getValue()));
        }
        HashMap<String, Object> detailParams = new HashMap<String, Object>();
        detailParams.put("serverIps", list);
        com.tplink.smb.omada.anomaly.core.domain.model.a.b cause = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(anomalyEvent.g()).c(anomalyEvent.i()).d(anomalyEvent.j()).a(anomalyEvent.k()).a(com.tplink.smb.omada.anomaly.api.b.c.cD).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(com.tplink.smb.omada.anomaly.api.b.c.cD)).a();
        cause.a(null, null, detailParams, null, null);
        a.debug("anomaly event: {} cause:{}", (Object)anomalyEvent, (Object)cause);
        anomalyEvent.d(cause);
    }

    private void b(Map<String, Integer> clientAuthErrorTimes, com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent) {
        if (CollectionUtils.isEmptyMap(clientAuthErrorTimes)) {
            return;
        }
        ArrayList<ClientAuthErrorTime> authInfoErrorList = new ArrayList<ClientAuthErrorTime>();
        for (Map.Entry<String, Integer> entry : clientAuthErrorTimes.entrySet()) {
            authInfoErrorList.add(new ClientAuthErrorTime(entry.getKey(), entry.getValue()));
        }
        com.tplink.smb.omada.anomaly.core.domain.model.a.b cause = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(anomalyEvent.g()).c(anomalyEvent.i()).d(anomalyEvent.j()).a(anomalyEvent.k()).a(com.tplink.smb.omada.anomaly.api.b.c.cG).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(com.tplink.smb.omada.anomaly.api.b.c.cG)).a();
        cause.a(null, null, CollectionUtils.toMap((Object[])new Object[]{"errorClients", authInfoErrorList}), null, null);
        a.debug("anomaly event: {} cause:{}", (Object)anomalyEvent, (Object)cause);
        anomalyEvent.d(cause);
    }

    private void a(com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent) {
        com.tplink.smb.omada.anomaly.core.domain.model.a.b cause = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().c(anomalyEvent.i()).d(anomalyEvent.j()).a(anomalyEvent.g()).a(com.tplink.smb.omada.anomaly.api.b.c.cE).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(com.tplink.smb.omada.anomaly.api.b.c.cE)).a();
        anomalyEvent.d(cause);
    }

    private void a(List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEventList, Map<Long, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> certificationMap) {
        HashMap<String, Integer> clientRequestTimes = new HashMap<String, Integer>();
        for (Map.Entry<Long, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> entry : certificationMap.entrySet()) {
            HashMap requestTimes = new HashMap();
            entry.getValue().forEach(oswCertificationInfo -> {
                String mac = oswCertificationInfo.c();
                int count = requestTimes.getOrDefault(mac, 0);
                requestTimes.put(mac, ++count);
            });
            for (Map.Entry stringIntegerEntry : requestTimes.entrySet()) {
                String mac = (String)stringIntegerEntry.getKey();
                int count = (Integer)stringIntegerEntry.getValue();
                if (count < 30) continue;
                int totalCount = clientRequestTimes.getOrDefault(mac, 0) + count;
                clientRequestTimes.put(mac, totalCount);
            }
        }
        if (CollectionUtils.isNotEmptyMap(clientRequestTimes)) {
            ArrayList<ClientRequest> list = new ArrayList<ClientRequest>();
            HashSet<String> clientMacs = new HashSet<String>();
            for (Map.Entry entry : clientRequestTimes.entrySet()) {
                list.add(new ClientRequest((String)entry.getKey(), (Integer)entry.getValue()));
                clientMacs.add((String)entry.getKey());
            }
            HashMap<String, Object> detailMap = new HashMap<String, Object>();
            detailMap.put("clients", list);
            com.tplink.smb.omada.anomaly.core.domain.model.a.b b2 = anomalyEventList.get(0);
            com.tplink.smb.omada.anomaly.core.domain.model.a.b cause = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(b2.g()).c(b2.i()).d(b2.j()).a(b2.k()).a(com.tplink.smb.omada.anomaly.api.b.c.cC).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(com.tplink.smb.omada.anomaly.api.b.c.cC)).a();
            Map<String, ClientObjectDTO> clientMap = this.a(clientMacs);
            cause.a(null, null, detailMap, null, clientMap);
            for (com.tplink.smb.omada.anomaly.core.domain.model.a.b event : anomalyEventList) {
                event.d(cause);
            }
        }
    }

    private static class a {
        AtomicInteger a = new AtomicInteger();
        AtomicInteger b = new AtomicInteger();
        AtomicInteger c = new AtomicInteger();
        Map<Long, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> d = new HashMap<Long, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>>();
        Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> e = new HashMap<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>>();
        List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a> f = new ArrayList<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>();

        a() {
        }

        @Generated
        public AtomicInteger a() {
            return this.a;
        }

        @Generated
        public AtomicInteger b() {
            return this.b;
        }

        @Generated
        public AtomicInteger c() {
            return this.c;
        }

        @Generated
        public Map<Long, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> d() {
            return this.d;
        }

        @Generated
        public Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> e() {
            return this.e;
        }

        @Generated
        public List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a> f() {
            return this.f;
        }

        @Generated
        public void a(AtomicInteger totalCount) {
            this.a = totalCount;
        }

        @Generated
        public void b(AtomicInteger successCount) {
            this.b = successCount;
        }

        @Generated
        public void c(AtomicInteger longTimeCount) {
            this.c = longTimeCount;
        }

        @Generated
        public void a(Map<Long, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> certificationMap) {
            this.d = certificationMap;
        }

        @Generated
        public void b(Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> clientCertificationFailedMap) {
            this.e = clientCertificationFailedMap;
        }

        @Generated
        public void a(List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a> longTimeCertificationInfos) {
            this.f = longTimeCertificationInfos;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof a)) {
                return false;
            }
            a other = (a)o2;
            if (!other.a(this)) {
                return false;
            }
            AtomicInteger this$totalCount = this.a();
            AtomicInteger other$totalCount = other.a();
            if (this$totalCount == null ? other$totalCount != null : !this$totalCount.equals(other$totalCount)) {
                return false;
            }
            AtomicInteger this$successCount = this.b();
            AtomicInteger other$successCount = other.b();
            if (this$successCount == null ? other$successCount != null : !this$successCount.equals(other$successCount)) {
                return false;
            }
            AtomicInteger this$longTimeCount = this.c();
            AtomicInteger other$longTimeCount = other.c();
            if (this$longTimeCount == null ? other$longTimeCount != null : !this$longTimeCount.equals(other$longTimeCount)) {
                return false;
            }
            Map<Long, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> this$certificationMap = this.d();
            Map<Long, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> other$certificationMap = other.d();
            if (this$certificationMap == null ? other$certificationMap != null : !((Object)this$certificationMap).equals(other$certificationMap)) {
                return false;
            }
            Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> this$clientCertificationFailedMap = this.e();
            Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> other$clientCertificationFailedMap = other.e();
            if (this$clientCertificationFailedMap == null ? other$clientCertificationFailedMap != null : !((Object)this$clientCertificationFailedMap).equals(other$clientCertificationFailedMap)) {
                return false;
            }
            List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a> this$longTimeCertificationInfos = this.f();
            List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a> other$longTimeCertificationInfos = other.f();
            return !(this$longTimeCertificationInfos == null ? other$longTimeCertificationInfos != null : !((Object)this$longTimeCertificationInfos).equals(other$longTimeCertificationInfos));
        }

        @Generated
        protected boolean a(Object other) {
            return other instanceof a;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AtomicInteger $totalCount = this.a();
            result = result * 59 + ($totalCount == null ? 43 : $totalCount.hashCode());
            AtomicInteger $successCount = this.b();
            result = result * 59 + ($successCount == null ? 43 : $successCount.hashCode());
            AtomicInteger $longTimeCount = this.c();
            result = result * 59 + ($longTimeCount == null ? 43 : $longTimeCount.hashCode());
            Map<Long, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> $certificationMap = this.d();
            result = result * 59 + ($certificationMap == null ? 43 : ((Object)$certificationMap).hashCode());
            Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a>> $clientCertificationFailedMap = this.e();
            result = result * 59 + ($clientCertificationFailedMap == null ? 43 : ((Object)$clientCertificationFailedMap).hashCode());
            List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.access.a> $longTimeCertificationInfos = this.f();
            result = result * 59 + ($longTimeCertificationInfos == null ? 43 : ((Object)$longTimeCertificationInfos).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Osw8021xCertificationDetector.DataRecord(totalCount=" + this.a() + ", successCount=" + this.b() + ", longTimeCount=" + this.c() + ", certificationMap=" + this.d() + ", clientCertificationFailedMap=" + this.e() + ", longTimeCertificationInfos=" + this.f() + ")";
        }
    }

    @KeepClass
    private static class LongTimeClient {
        String clientMac;
        int duration;

        @Generated
        public String getClientMac() {
            return this.clientMac;
        }

        @Generated
        public int getDuration() {
            return this.duration;
        }

        @Generated
        public void setClientMac(String clientMac) {
            this.clientMac = clientMac;
        }

        @Generated
        public void setDuration(int duration) {
            this.duration = duration;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof LongTimeClient)) {
                return false;
            }
            LongTimeClient other = (LongTimeClient)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDuration() != other.getDuration()) {
                return false;
            }
            String this$clientMac = this.getClientMac();
            String other$clientMac = other.getClientMac();
            return !(this$clientMac == null ? other$clientMac != null : !this$clientMac.equals(other$clientMac));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LongTimeClient;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDuration();
            String $clientMac = this.getClientMac();
            result = result * 59 + ($clientMac == null ? 43 : $clientMac.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Osw8021xCertificationDetector.LongTimeClient(clientMac=" + this.getClientMac() + ", duration=" + this.getDuration() + ")";
        }

        @Generated
        public LongTimeClient(String clientMac, int duration) {
            this.clientMac = clientMac;
            this.duration = duration;
        }
    }

    @KeepClass
    private static class FailedClient {
        String clientMac;
        int failedTimes;

        @Generated
        public String getClientMac() {
            return this.clientMac;
        }

        @Generated
        public int getFailedTimes() {
            return this.failedTimes;
        }

        @Generated
        public void setClientMac(String clientMac) {
            this.clientMac = clientMac;
        }

        @Generated
        public void setFailedTimes(int failedTimes) {
            this.failedTimes = failedTimes;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof FailedClient)) {
                return false;
            }
            FailedClient other = (FailedClient)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFailedTimes() != other.getFailedTimes()) {
                return false;
            }
            String this$clientMac = this.getClientMac();
            String other$clientMac = other.getClientMac();
            return !(this$clientMac == null ? other$clientMac != null : !this$clientMac.equals(other$clientMac));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FailedClient;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFailedTimes();
            String $clientMac = this.getClientMac();
            result = result * 59 + ($clientMac == null ? 43 : $clientMac.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Osw8021xCertificationDetector.FailedClient(clientMac=" + this.getClientMac() + ", failedTimes=" + this.getFailedTimes() + ")";
        }

        @Generated
        public FailedClient(String clientMac, int failedTimes) {
            this.clientMac = clientMac;
            this.failedTimes = failedTimes;
        }
    }

    @KeepClass
    private static class ServerAuthFailedClient {
        String serverIp;
        Set<String> clientMacs;

        @Generated
        public String getServerIp() {
            return this.serverIp;
        }

        @Generated
        public Set<String> getClientMacs() {
            return this.clientMacs;
        }

        @Generated
        public void setServerIp(String serverIp) {
            this.serverIp = serverIp;
        }

        @Generated
        public void setClientMacs(Set<String> clientMacs) {
            this.clientMacs = clientMacs;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof ServerAuthFailedClient)) {
                return false;
            }
            ServerAuthFailedClient other = (ServerAuthFailedClient)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$serverIp = this.getServerIp();
            String other$serverIp = other.getServerIp();
            if (this$serverIp == null ? other$serverIp != null : !this$serverIp.equals(other$serverIp)) {
                return false;
            }
            Set<String> this$clientMacs = this.getClientMacs();
            Set<String> other$clientMacs = other.getClientMacs();
            return !(this$clientMacs == null ? other$clientMacs != null : !((Object)this$clientMacs).equals(other$clientMacs));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ServerAuthFailedClient;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $serverIp = this.getServerIp();
            result = result * 59 + ($serverIp == null ? 43 : $serverIp.hashCode());
            Set<String> $clientMacs = this.getClientMacs();
            result = result * 59 + ($clientMacs == null ? 43 : ((Object)$clientMacs).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Osw8021xCertificationDetector.ServerAuthFailedClient(serverIp=" + this.getServerIp() + ", clientMacs=" + this.getClientMacs() + ")";
        }

        @Generated
        public ServerAuthFailedClient(String serverIp, Set<String> clientMacs) {
            this.serverIp = serverIp;
            this.clientMacs = clientMacs;
        }
    }

    @KeepClass
    private static class ClientAuthErrorTime {
        String clientMac;
        int authErrorTime;

        @Generated
        public String getClientMac() {
            return this.clientMac;
        }

        @Generated
        public int getAuthErrorTime() {
            return this.authErrorTime;
        }

        @Generated
        public void setClientMac(String clientMac) {
            this.clientMac = clientMac;
        }

        @Generated
        public void setAuthErrorTime(int authErrorTime) {
            this.authErrorTime = authErrorTime;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof ClientAuthErrorTime)) {
                return false;
            }
            ClientAuthErrorTime other = (ClientAuthErrorTime)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAuthErrorTime() != other.getAuthErrorTime()) {
                return false;
            }
            String this$clientMac = this.getClientMac();
            String other$clientMac = other.getClientMac();
            return !(this$clientMac == null ? other$clientMac != null : !this$clientMac.equals(other$clientMac));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClientAuthErrorTime;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAuthErrorTime();
            String $clientMac = this.getClientMac();
            result = result * 59 + ($clientMac == null ? 43 : $clientMac.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Osw8021xCertificationDetector.ClientAuthErrorTime(clientMac=" + this.getClientMac() + ", authErrorTime=" + this.getAuthErrorTime() + ")";
        }

        @Generated
        public ClientAuthErrorTime(String clientMac, int authErrorTime) {
            this.clientMac = clientMac;
            this.authErrorTime = authErrorTime;
        }
    }

    @KeepClass
    private static class ClientRequest {
        String clientMac;
        int requestTimes;

        @Generated
        public String getClientMac() {
            return this.clientMac;
        }

        @Generated
        public int getRequestTimes() {
            return this.requestTimes;
        }

        @Generated
        public void setClientMac(String clientMac) {
            this.clientMac = clientMac;
        }

        @Generated
        public void setRequestTimes(int requestTimes) {
            this.requestTimes = requestTimes;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof ClientRequest)) {
                return false;
            }
            ClientRequest other = (ClientRequest)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRequestTimes() != other.getRequestTimes()) {
                return false;
            }
            String this$clientMac = this.getClientMac();
            String other$clientMac = other.getClientMac();
            return !(this$clientMac == null ? other$clientMac != null : !this$clientMac.equals(other$clientMac));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClientRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRequestTimes();
            String $clientMac = this.getClientMac();
            result = result * 59 + ($clientMac == null ? 43 : $clientMac.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Osw8021xCertificationDetector.ClientRequest(clientMac=" + this.getClientMac() + ", requestTimes=" + this.getRequestTimes() + ")";
        }

        @Generated
        public ClientRequest(String clientMac, int requestTimes) {
            this.clientMac = clientMac;
            this.requestTimes = requestTimes;
        }
    }
}

