/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.rule.osg.throughput;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.c;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.AbstractDeviceDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.WanHighTrafficDTO;
import com.tplink.smb.omada.anomaly.core.domain.a.e;
import com.tplink.smb.omada.anomaly.core.domain.model.a.b;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.setting.AnomalyEventSettingDTO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.insight.api.web.anomaly.dto.ClientObjectDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.QuerySiteDTO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.BandwidthCtrlRuleVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WanHighTrafficDetector
implements com.tplink.smb.omada.anomaly.core.domain.model.rule.a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(WanHighTrafficDetector.class);
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a b;
    @Autowired
    private e c;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.site.a d;
    private static final int e = OmadacType.s() ? 3 : 18;

    @Override
    public c a() {
        return com.tplink.smb.omada.anomaly.api.b.c.cV;
    }

    @Override
    public f c() {
        return f.d;
    }

    @Override
    public List<b> a(com.tplink.smb.omada.anomaly.core.domain.model.b.b anomalyDetectTimeRange, String mac, List<DevicePreprocessDTO> devicePreDataList) {
        if (CollectionUtils.isEmpty(devicePreDataList)) {
            a.debug("skip abnormal {} anomaly detect for osg {} omadac {} site {}, for data is empty", new Object[]{this.a(), mac, anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b()});
            return Collections.emptyList();
        }
        HashMap<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.b>> trafficMap = new HashMap<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.b>>();
        HashMap<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>> clientTrafficMap = new HashMap<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>>();
        WanHighTrafficDetector.a(devicePreDataList, trafficMap, clientTrafficMap);
        if (a.isDebugEnabled()) {
            a.debug("wan traffic map{} \n client traffic map{}", (Object)x.a(trafficMap), (Object)x.a(clientTrafficMap));
        }
        AnomalyEventSettingDTO anomalyEventSettingDTO = anomalyDetectTimeRange.e().get(this.a().a());
        int wanHighTrafficThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSettingDTO, "threshold", 90);
        int wanTrafficRatioThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSettingDTO, "count", 80);
        Map<String, a> wanConfigMap = this.b(anomalyDetectTimeRange);
        HashSet<String> wanNames = new HashSet<String>();
        for (Map.Entry entry : trafficMap.entrySet()) {
            long maxDownBandwidth;
            long maxUpBandwidth;
            ArrayList<Long> txRateList = new ArrayList<Long>();
            ArrayList<Long> rxRateList = new ArrayList<Long>();
            for (com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.b wanTraffic : (List)entry.getValue()) {
                txRateList.add(wanTraffic.g());
                rxRateList.add(wanTraffic.h());
            }
            if (txRateList.size() < e && rxRateList.size() < e) continue;
            String wanId = (String)entry.getKey();
            if (wanConfigMap.containsKey(wanId)) {
                a config = wanConfigMap.get(wanId);
                maxUpBandwidth = config.a();
                maxDownBandwidth = config.b();
            } else {
                maxUpBandwidth = ((com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.b)((List)entry.getValue()).get(0)).f();
                maxDownBandwidth = ((com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.b)((List)entry.getValue()).get(0)).f();
            }
            if (!this.a(txRateList, maxUpBandwidth, wanHighTrafficThreshold, wanTrafficRatioThreshold) && !this.a(rxRateList, maxDownBandwidth, wanHighTrafficThreshold, wanTrafficRatioThreshold)) continue;
            wanNames.add((String)entry.getKey());
        }
        if (CollectionUtils.isNotEmpty(wanNames)) {
            b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.b.a()).a(mac).c(anomalyDetectTimeRange.a()).d(anomalyDetectTimeRange.b()).a(anomalyDetectTimeRange.d()).a(this.a()).a(this.a(anomalyEventSettingDTO)).a();
            WanPortTraffic wanPortTraffic = WanHighTrafficDetector.a(trafficMap, wanNames);
            HashMap<String, Object> detailParams = new HashMap<String, Object>();
            detailParams.put("wanPortTraffic", wanPortTraffic);
            anomalyEvent.a(null, CollectionUtils.toStringMap((String[])new String[]{"wanName", T.a(wanNames, (String)","), "count", String.valueOf(wanTrafficRatioThreshold), "threshold", String.valueOf(wanHighTrafficThreshold)}), detailParams, Collections.singletonMap(mac, this.c.a(anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b(), mac)), null, null);
            WanHighTrafficDetector.a(anomalyDetectTimeRange, mac, anomalyEvent, clientTrafficMap);
            anomalyEvent.a(true);
            return Collections.singletonList(anomalyEvent);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean a(b newAnomalyEvent, b presidentEvent) {
        if (!this.b(newAnomalyEvent, presidentEvent)) {
            return false;
        }
        return com.tplink.smb.omada.anomaly.core.port.f.a.b(newAnomalyEvent, presidentEvent);
    }

    private static WanPortTraffic a(Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.b>> trafficMap, Set<String> wanNames) {
        TreeMap treeMap = new TreeMap();
        for (String wanName : wanNames) {
            List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.b> wanTrafficList = trafficMap.get(wanName);
            wanTrafficList.forEach(wanTraffic -> {
                long time = wanTraffic.a();
                if (Objects.isNull(treeMap.get(time))) {
                    ArrayList<Traffics> list = new ArrayList<Traffics>();
                    list.add(new Traffics(wanName, wanTraffic.d() + wanTraffic.e()));
                    treeMap.put(time, list);
                } else {
                    ((List)treeMap.get(time)).add(new Traffics(wanName, wanTraffic.d() + wanTraffic.e()));
                }
            });
        }
        ArrayList<WanTraffics> wanTrafficList = new ArrayList<WanTraffics>();
        for (Map.Entry entry : treeMap.entrySet()) {
            wanTrafficList.add(new WanTraffics((Long)entry.getKey(), (List)entry.getValue()));
        }
        return new WanPortTraffic(new ArrayList<String>(wanNames), wanTrafficList);
    }

    private static void a(List<DevicePreprocessDTO> devicePreDataList, Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.b>> trafficMap, Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>> clientTrafficMap) {
        String preDataMapKey = com.tplink.smb.omada.anomaly.api.b.c.cV.a();
        for (DevicePreprocessDTO devicePreprocessDTO : devicePreDataList) {
            AbstractDeviceDTO abstractDeviceDTO;
            if (Objects.isNull(devicePreprocessDTO) || Objects.isNull(abstractDeviceDTO = devicePreprocessDTO.getPreprocessData().get(preDataMapKey))) continue;
            List wanTrafficList = ((WanHighTrafficDTO)abstractDeviceDTO).getWanTraffics();
            wanTrafficList.forEach(wanTraffic -> {
                String wanName = wanTraffic.b();
                if (Objects.isNull(trafficMap.get(wanName))) {
                    ArrayList<com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.b> list = new ArrayList<com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.b>();
                    list.add((com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.b)wanTraffic);
                    trafficMap.put(wanName, list);
                } else {
                    ((List)trafficMap.get(wanName)).add(wanTraffic);
                }
            });
            List clientTrafficList = ((WanHighTrafficDTO)abstractDeviceDTO).getClientTraffics();
            clientTrafficList.forEach(clientTraffic -> {
                String clientMac = clientTraffic.c();
                if (Objects.isNull(clientTrafficMap.get(clientMac))) {
                    ArrayList<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a> list = new ArrayList<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>();
                    list.add((com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a)clientTraffic);
                    clientTrafficMap.put(clientMac, list);
                } else {
                    ((List)clientTrafficMap.get(clientMac)).add(clientTraffic);
                }
            });
        }
    }

    private boolean a(List<Long> rateList, Long maxBandwitch, int wanHighTrafficThreshold, int wanTrafficRatioThreshold) {
        long count = rateList.stream().filter(rate -> rate != null && rate * 100L >= maxBandwitch * (long)wanHighTrafficThreshold).count();
        return count * 100L >= (long)(rateList.size() * wanTrafficRatioThreshold);
    }

    static void a(com.tplink.smb.omada.anomaly.core.domain.model.b.b anomalyDetectTimeRange, String mac, b anomalyEvent, Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>> clientHighTrafficMap) {
        b cause = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(mac).c(anomalyDetectTimeRange.a()).d(anomalyDetectTimeRange.b()).a(anomalyDetectTimeRange.d()).a(com.tplink.smb.omada.anomaly.api.b.c.du).a(com.tplink.smb.omada.anomaly.api.b.c.du.c()).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(com.tplink.smb.omada.anomaly.api.b.c.du)).a();
        ArrayList<ClientTrafficInfo> clientTraffics = new ArrayList<ClientTrafficInfo>();
        Map<String, ClientObjectDTO> clients = WanHighTrafficDetector.a(clientHighTrafficMap);
        for (Map.Entry<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>> entry : clientHighTrafficMap.entrySet()) {
            List list = entry.getValue().stream().map(com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a::a).collect(Collectors.toList());
            clientTraffics.add(new ClientTrafficInfo(entry.getKey(), (Long)Collections.max(list) - (Long)Collections.min(list)));
        }
        HashMap<String, Object> detailParam = new HashMap<String, Object>();
        detailParam.put("clientTraffic", clientTraffics);
        cause.a(null, null, detailParam, null, clients, null);
        anomalyEvent.d(cause);
    }

    private static Map<String, ClientObjectDTO> a(Map<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>> clientHighTrafficMap) {
        HashMap<String, ClientObjectDTO> clients = new HashMap<String, ClientObjectDTO>();
        for (Map.Entry<String, List<com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a>> entry : clientHighTrafficMap.entrySet()) {
            com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.throughput.a clientTraffic = entry.getValue().get(0);
            ClientObjectDTO clientObjectDTO = ClientObjectDTO.builder().deviceType(clientTraffic.f()).ip(clientTraffic.h()).manager(Boolean.valueOf(false)).name(Objects.isNull(clientTraffic.g()) ? clientTraffic.c() : clientTraffic.g()).build();
            clients.put(entry.getKey(), clientObjectDTO);
        }
        return clients;
    }

    private Map<String, a> b(com.tplink.smb.omada.anomaly.core.domain.model.b.b anomalyDetectTimeRange) {
        List bandwidthCtrlRuleList;
        QuerySiteDTO querySiteDTO = new QuerySiteDTO(anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b());
        OperationResponse response = this.d.b(querySiteDTO);
        HashMap<String, a> map = new HashMap<String, a>();
        if (response.success() && CollectionUtils.isNotEmpty((Collection)(bandwidthCtrlRuleList = (List)response.getResult()))) {
            for (BandwidthCtrlRuleVO bandwidthCtrlRule : bandwidthCtrlRuleList) {
                if (Boolean.FALSE.equals(bandwidthCtrlRule.getStatus()) || CollectionUtils.isEmpty((Collection)bandwidthCtrlRule.getWanPortIds())) continue;
                List wanPortIds = bandwidthCtrlRule.getWanPortIds();
                Integer upStreamBandwidth = bandwidthCtrlRule.getUpstreamBandwidth();
                Integer upStreamBandwidthUnit = bandwidthCtrlRule.getUpstreamBandwidthUnit();
                long upRate = this.a(upStreamBandwidth, upStreamBandwidthUnit);
                Integer downStreamBandwidth = bandwidthCtrlRule.getUpstreamBandwidth();
                Integer downStreamBandwidthUnit = bandwidthCtrlRule.getUpstreamBandwidthUnit();
                long downRate = this.a(downStreamBandwidth, downStreamBandwidthUnit);
                wanPortIds.forEach(wanId -> map.put((String)wanId, new a(upRate, downRate)));
            }
        }
        return map;
    }

    private long a(Integer streamBandwidth, Integer streamBandwidthUnit) {
        switch (streamBandwidthUnit) {
            case 1: {
                return (long)streamBandwidth.intValue() * 1000L;
            }
            case 2: {
                return (long)streamBandwidth.intValue() * 1000L * 1024L;
            }
        }
        return 0L;
    }

    static class a {
        long a;
        long b;

        @Generated
        public long a() {
            return this.a;
        }

        @Generated
        public long b() {
            return this.b;
        }

        @Generated
        public void a(long upRate) {
            this.a = upRate;
        }

        @Generated
        public void b(long downRate) {
            this.b = downRate;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof a)) {
                return false;
            }
            a other = (a)o2;
            if (!other.a(this)) {
                return false;
            }
            if (this.a() != other.a()) {
                return false;
            }
            return this.b() == other.b();
        }

        @Generated
        protected boolean a(Object other) {
            return other instanceof a;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $upRate = this.a();
            result = result * 59 + (int)($upRate >>> 32 ^ $upRate);
            long $downRate = this.b();
            result = result * 59 + (int)($downRate >>> 32 ^ $downRate);
            return result;
        }

        @Generated
        public String toString() {
            return "WanHighTrafficDetector.WanConfig(upRate=" + this.a() + ", downRate=" + this.b() + ")";
        }

        @Generated
        public a(long upRate, long downRate) {
            this.a = upRate;
            this.b = downRate;
        }
    }

    @KeepClass
    static class WanPortTraffic {
        List<String> wanNames;
        List<WanTraffics> wanTrafficList;

        @Generated
        public List<String> getWanNames() {
            return this.wanNames;
        }

        @Generated
        public List<WanTraffics> getWanTrafficList() {
            return this.wanTrafficList;
        }

        @Generated
        public void setWanNames(List<String> wanNames) {
            this.wanNames = wanNames;
        }

        @Generated
        public void setWanTrafficList(List<WanTraffics> wanTrafficList) {
            this.wanTrafficList = wanTrafficList;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof WanPortTraffic)) {
                return false;
            }
            WanPortTraffic other = (WanPortTraffic)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$wanNames = this.getWanNames();
            List<String> other$wanNames = other.getWanNames();
            if (this$wanNames == null ? other$wanNames != null : !((Object)this$wanNames).equals(other$wanNames)) {
                return false;
            }
            List<WanTraffics> this$wanTrafficList = this.getWanTrafficList();
            List<WanTraffics> other$wanTrafficList = other.getWanTrafficList();
            return !(this$wanTrafficList == null ? other$wanTrafficList != null : !((Object)this$wanTrafficList).equals(other$wanTrafficList));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WanPortTraffic;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $wanNames = this.getWanNames();
            result = result * 59 + ($wanNames == null ? 43 : ((Object)$wanNames).hashCode());
            List<WanTraffics> $wanTrafficList = this.getWanTrafficList();
            result = result * 59 + ($wanTrafficList == null ? 43 : ((Object)$wanTrafficList).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WanHighTrafficDetector.WanPortTraffic(wanNames=" + this.getWanNames() + ", wanTrafficList=" + this.getWanTrafficList() + ")";
        }

        @Generated
        public WanPortTraffic(List<String> wanNames, List<WanTraffics> wanTrafficList) {
            this.wanNames = wanNames;
            this.wanTrafficList = wanTrafficList;
        }
    }

    @KeepClass
    static class WanTraffics {
        long time;
        List<Traffics> wanTraffic;

        @Generated
        public long getTime() {
            return this.time;
        }

        @Generated
        public List<Traffics> getWanTraffic() {
            return this.wanTraffic;
        }

        @Generated
        public void setTime(long time) {
            this.time = time;
        }

        @Generated
        public void setWanTraffic(List<Traffics> wanTraffic) {
            this.wanTraffic = wanTraffic;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof WanTraffics)) {
                return false;
            }
            WanTraffics other = (WanTraffics)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTime() != other.getTime()) {
                return false;
            }
            List<Traffics> this$wanTraffic = this.getWanTraffic();
            List<Traffics> other$wanTraffic = other.getWanTraffic();
            return !(this$wanTraffic == null ? other$wanTraffic != null : !((Object)this$wanTraffic).equals(other$wanTraffic));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WanTraffics;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            List<Traffics> $wanTraffic = this.getWanTraffic();
            result = result * 59 + ($wanTraffic == null ? 43 : ((Object)$wanTraffic).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WanHighTrafficDetector.WanTraffics(time=" + this.getTime() + ", wanTraffic=" + this.getWanTraffic() + ")";
        }

        @Generated
        public WanTraffics(long time, List<Traffics> wanTraffic) {
            this.time = time;
            this.wanTraffic = wanTraffic;
        }
    }

    @KeepClass
    static class ClientTrafficInfo {
        String clientMac;
        long traffic;

        @Generated
        public String getClientMac() {
            return this.clientMac;
        }

        @Generated
        public long getTraffic() {
            return this.traffic;
        }

        @Generated
        public void setClientMac(String clientMac) {
            this.clientMac = clientMac;
        }

        @Generated
        public void setTraffic(long traffic) {
            this.traffic = traffic;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof ClientTrafficInfo)) {
                return false;
            }
            ClientTrafficInfo other = (ClientTrafficInfo)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTraffic() != other.getTraffic()) {
                return false;
            }
            String this$clientMac = this.getClientMac();
            String other$clientMac = other.getClientMac();
            return !(this$clientMac == null ? other$clientMac != null : !this$clientMac.equals(other$clientMac));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClientTrafficInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $traffic = this.getTraffic();
            result = result * 59 + (int)($traffic >>> 32 ^ $traffic);
            String $clientMac = this.getClientMac();
            result = result * 59 + ($clientMac == null ? 43 : $clientMac.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WanHighTrafficDetector.ClientTrafficInfo(clientMac=" + this.getClientMac() + ", traffic=" + this.getTraffic() + ")";
        }

        @Generated
        public ClientTrafficInfo(String clientMac, long traffic) {
            this.clientMac = clientMac;
            this.traffic = traffic;
        }
    }

    @KeepClass
    static class Traffics {
        String wanName;
        long traffic;

        @Generated
        public String getWanName() {
            return this.wanName;
        }

        @Generated
        public long getTraffic() {
            return this.traffic;
        }

        @Generated
        public void setWanName(String wanName) {
            this.wanName = wanName;
        }

        @Generated
        public void setTraffic(long traffic) {
            this.traffic = traffic;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof Traffics)) {
                return false;
            }
            Traffics other = (Traffics)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTraffic() != other.getTraffic()) {
                return false;
            }
            String this$wanName = this.getWanName();
            String other$wanName = other.getWanName();
            return !(this$wanName == null ? other$wanName != null : !this$wanName.equals(other$wanName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Traffics;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $traffic = this.getTraffic();
            result = result * 59 + (int)($traffic >>> 32 ^ $traffic);
            String $wanName = this.getWanName();
            result = result * 59 + ($wanName == null ? 43 : $wanName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WanHighTrafficDetector.Traffics(wanName=" + this.getWanName() + ", traffic=" + this.getTraffic() + ")";
        }

        @Generated
        public Traffics(String wanName, long traffic) {
            this.wanName = wanName;
            this.traffic = traffic;
        }
    }
}

