/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.rule.osg.throughput;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.c;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.AbstractDeviceDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.WanHighLossRateDTO;
import com.tplink.smb.omada.anomaly.core.domain.a.e;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.a;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.b;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.osg.throughput.WanHighLatencyDetector;
import com.tplink.smb.omada.anomaly.core.domain.model.setting.AnomalyEventSettingDTO;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WanHighLossDetector
implements a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(WanHighLossDetector.class);
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a b;
    @Autowired
    private e c;
    private static final int d = OmadacType.s() ? 3 : 18;

    @Override
    public c a() {
        return com.tplink.smb.omada.anomaly.api.b.c.cW;
    }

    @Override
    public f c() {
        return f.d;
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> a(com.tplink.smb.omada.anomaly.core.domain.model.b.b anomalyDetectTimeRange, String mac, List<DevicePreprocessDTO> devicePreDataList) {
        if (CollectionUtils.isEmpty(devicePreDataList)) {
            a.debug("skip abnormal {} anomaly detect for osg {} omadac {} site {}, for data is empty", new Object[]{this.a(), mac, anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b()});
            return Collections.emptyList();
        }
        HashMap<String, TreeMap<Long, com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.a>> wanLossMap = new HashMap<String, TreeMap<Long, com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.a>>();
        WanHighLossDetector.a(devicePreDataList, wanLossMap);
        if (a.isDebugEnabled()) {
            a.debug("detect anomaly event {} for osg {},preHandle data:{}", new Object[]{this.a(), mac, x.a(wanLossMap)});
        }
        HashMap<String, TreeMap<Long, Long>> highLossRateWanMap = new HashMap<String, TreeMap<Long, Long>>();
        AnomalyEventSettingDTO anomalyEventSettingDTO = anomalyDetectTimeRange.e().get(this.a().a());
        int highWanLossThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSettingDTO, "threshold", 10);
        int wanLossRatioThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSettingDTO, "count", 80);
        WanHighLossDetector.a(wanLossMap, highLossRateWanMap, highWanLossThreshold, wanLossRatioThreshold);
        if (!highLossRateWanMap.isEmpty()) {
            com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.b.a()).a(mac).c(anomalyDetectTimeRange.a()).d(anomalyDetectTimeRange.b()).a(anomalyDetectTimeRange.d()).a(this.a()).a(this.a(anomalyEventSettingDTO)).b(true).a();
            OsgWanLossRate osgWanLossRate = WanHighLossDetector.a(highLossRateWanMap);
            HashMap<String, Object> detailParams = new HashMap<String, Object>();
            detailParams.put("wanLossRate", osgWanLossRate);
            anomalyEvent.a(null, CollectionUtils.toStringMap((String[])new String[]{"wanName", T.a(highLossRateWanMap.keySet(), (String)","), "count", String.valueOf(wanLossRatioThreshold), "threshold", String.valueOf(highWanLossThreshold)}), detailParams, Collections.singletonMap(mac, this.c.a(anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b(), mac)), null, null);
            return Collections.singletonList(anomalyEvent);
        }
        return Collections.emptyList();
    }

    @Override
    public void a(String omadacId, String siteId, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEventSet, Map<String, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b>> causeMap, com.tplink.smb.omada.anomaly.core.domain.model.b.a associateResult) {
        for (com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent : anomalyEventSet) {
            String deviceMac = anomalyEvent.g();
            Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> causes = causeMap.get(com.tplink.smb.omada.anomaly.core.domain.model.rule.b.a(deviceMac, com.tplink.smb.omada.anomaly.api.b.c.cZ));
            if (CollectionUtils.isNotEmpty(causes)) {
                WanHighLatencyDetector.a(anomalyEvent, causes);
            } else {
                this.a(anomalyEvent);
            }
            anomalyEvent.a(true);
        }
    }

    @Override
    public Boolean a(com.tplink.smb.omada.anomaly.core.domain.model.a.b newAnomalyEvent, com.tplink.smb.omada.anomaly.core.domain.model.a.b presidentEvent) {
        if (!this.b(newAnomalyEvent, presidentEvent)) {
            return false;
        }
        return com.tplink.smb.omada.anomaly.core.port.f.a.b(newAnomalyEvent, presidentEvent);
    }

    private static OsgWanLossRate a(Map<String, TreeMap<Long, Long>> highLossRateWanMap) {
        TreeMap treeMap = new TreeMap();
        for (Map.Entry<String, TreeMap<Long, Long>> entry : highLossRateWanMap.entrySet()) {
            TreeMap<Long, Long> map = entry.getValue();
            for (Map.Entry<Long, Long> longEntry : map.entrySet()) {
                if (Objects.isNull(treeMap.get(longEntry.getKey()))) {
                    ArrayList<LossRates> list = new ArrayList<LossRates>();
                    list.add(new LossRates(entry.getKey(), longEntry.getValue().intValue()));
                    treeMap.put(longEntry.getKey(), list);
                    continue;
                }
                ((List)treeMap.get(longEntry.getKey())).add(new LossRates(entry.getKey(), longEntry.getValue().intValue()));
            }
        }
        ArrayList<WanLossRate> wanLossRateList = new ArrayList<WanLossRate>();
        for (Map.Entry entry : treeMap.entrySet()) {
            wanLossRateList.add(new WanLossRate((Long)entry.getKey(), (List)entry.getValue()));
        }
        return new OsgWanLossRate(new ArrayList<String>(highLossRateWanMap.keySet()), wanLossRateList);
    }

    private static void a(Map<String, TreeMap<Long, com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.a>> wanLossMap, Map<String, TreeMap<Long, Long>> highLossRateWanMap, int highWanLossThreshold, int wanLossRatioThreshold) {
        for (Map.Entry<String, TreeMap<Long, com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.a>> entry : wanLossMap.entrySet()) {
            long highLossRateCount;
            ArrayList<com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.a> list = new ArrayList<com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.a>(entry.getValue().values());
            int size = list.size();
            if (size < d) continue;
            TreeMap<Long, Long> wanLossRates = new TreeMap<Long, Long>();
            for (int i2 = size - 1; i2 > 0; --i2) {
                com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.a backWanLossInfo = (com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.a)list.get(i2);
                com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.a forwardWanLossInfo = (com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.a)list.get(i2 - 1);
                long lossPkts = backWanLossInfo.c() - forwardWanLossInfo.c();
                long totalPkts = backWanLossInfo.d() - forwardWanLossInfo.d();
                if (lossPkts < 0L || totalPkts <= 0L) break;
                double lossRate2 = (double)lossPkts * 100.0 / (double)totalPkts;
                wanLossRates.put(backWanLossInfo.a(), (long)lossRate2);
            }
            if (wanLossRates.isEmpty() || (highLossRateCount = wanLossRates.values().stream().filter(lossRate -> lossRate * 100L >= (long)highWanLossThreshold).count()) * 100L < (long)(wanLossRates.size() * wanLossRatioThreshold)) continue;
            highLossRateWanMap.put(entry.getKey(), wanLossRates);
        }
    }

    private static void a(List<DevicePreprocessDTO> devicePreDataList, Map<String, TreeMap<Long, com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.a>> wanLossMap) {
        String preDataMapKey = com.tplink.smb.omada.anomaly.api.b.c.cW.a();
        for (DevicePreprocessDTO devicePreprocessDTO : devicePreDataList) {
            AbstractDeviceDTO abstractDeviceDTO;
            if (Objects.isNull(devicePreprocessDTO) || Objects.isNull(abstractDeviceDTO = devicePreprocessDTO.getPreprocessData().get(preDataMapKey))) continue;
            List wanLossInfos = ((WanHighLossRateDTO)abstractDeviceDTO).getWanLossInfoList();
            wanLossInfos.forEach(wanLossInfo -> {
                String wanName = wanLossInfo.b();
                if (Objects.isNull(wanLossMap.get(wanName))) {
                    TreeMap<Long, com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.a> treeMap = new TreeMap<Long, com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.a>();
                    treeMap.put(wanLossInfo.a(), (com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.a)wanLossInfo);
                    wanLossMap.put(wanName, treeMap);
                } else {
                    ((TreeMap)wanLossMap.get(wanName)).put(wanLossInfo.a(), wanLossInfo);
                }
            });
        }
    }

    private void a(com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent) {
        com.tplink.smb.omada.anomaly.core.domain.model.a.b cause = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(anomalyEvent.g()).c(anomalyEvent.i()).d(anomalyEvent.j()).a(anomalyEvent.k()).a(com.tplink.smb.omada.anomaly.api.b.c.dv).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(com.tplink.smb.omada.anomaly.api.b.c.dv)).a();
        anomalyEvent.d(cause);
    }

    @KeepClass
    private static class OsgWanLossRate {
        List<String> wanNames;
        List<WanLossRate> wanLossRateList;

        @Generated
        public List<String> getWanNames() {
            return this.wanNames;
        }

        @Generated
        public List<WanLossRate> getWanLossRateList() {
            return this.wanLossRateList;
        }

        @Generated
        public void setWanNames(List<String> wanNames) {
            this.wanNames = wanNames;
        }

        @Generated
        public void setWanLossRateList(List<WanLossRate> wanLossRateList) {
            this.wanLossRateList = wanLossRateList;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof OsgWanLossRate)) {
                return false;
            }
            OsgWanLossRate other = (OsgWanLossRate)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$wanNames = this.getWanNames();
            List<String> other$wanNames = other.getWanNames();
            if (this$wanNames == null ? other$wanNames != null : !((Object)this$wanNames).equals(other$wanNames)) {
                return false;
            }
            List<WanLossRate> this$wanLossRateList = this.getWanLossRateList();
            List<WanLossRate> other$wanLossRateList = other.getWanLossRateList();
            return !(this$wanLossRateList == null ? other$wanLossRateList != null : !((Object)this$wanLossRateList).equals(other$wanLossRateList));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OsgWanLossRate;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $wanNames = this.getWanNames();
            result = result * 59 + ($wanNames == null ? 43 : ((Object)$wanNames).hashCode());
            List<WanLossRate> $wanLossRateList = this.getWanLossRateList();
            result = result * 59 + ($wanLossRateList == null ? 43 : ((Object)$wanLossRateList).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WanHighLossDetector.OsgWanLossRate(wanNames=" + this.getWanNames() + ", wanLossRateList=" + this.getWanLossRateList() + ")";
        }

        @Generated
        public OsgWanLossRate(List<String> wanNames, List<WanLossRate> wanLossRateList) {
            this.wanNames = wanNames;
            this.wanLossRateList = wanLossRateList;
        }
    }

    @KeepClass
    private static class LossRates {
        String wanName;
        int lossRate;

        @Generated
        public String getWanName() {
            return this.wanName;
        }

        @Generated
        public int getLossRate() {
            return this.lossRate;
        }

        @Generated
        public void setWanName(String wanName) {
            this.wanName = wanName;
        }

        @Generated
        public void setLossRate(int lossRate) {
            this.lossRate = lossRate;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof LossRates)) {
                return false;
            }
            LossRates other = (LossRates)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLossRate() != other.getLossRate()) {
                return false;
            }
            String this$wanName = this.getWanName();
            String other$wanName = other.getWanName();
            return !(this$wanName == null ? other$wanName != null : !this$wanName.equals(other$wanName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LossRates;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLossRate();
            String $wanName = this.getWanName();
            result = result * 59 + ($wanName == null ? 43 : $wanName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WanHighLossDetector.LossRates(wanName=" + this.getWanName() + ", lossRate=" + this.getLossRate() + ")";
        }

        @Generated
        public LossRates(String wanName, int lossRate) {
            this.wanName = wanName;
            this.lossRate = lossRate;
        }
    }

    @KeepClass
    private static class WanLossRate {
        long time;
        List<LossRates> lossRateList;

        @Generated
        public long getTime() {
            return this.time;
        }

        @Generated
        public List<LossRates> getLossRateList() {
            return this.lossRateList;
        }

        @Generated
        public void setTime(long time) {
            this.time = time;
        }

        @Generated
        public void setLossRateList(List<LossRates> lossRateList) {
            this.lossRateList = lossRateList;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof WanLossRate)) {
                return false;
            }
            WanLossRate other = (WanLossRate)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTime() != other.getTime()) {
                return false;
            }
            List<LossRates> this$lossRateList = this.getLossRateList();
            List<LossRates> other$lossRateList = other.getLossRateList();
            return !(this$lossRateList == null ? other$lossRateList != null : !((Object)this$lossRateList).equals(other$lossRateList));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WanLossRate;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            List<LossRates> $lossRateList = this.getLossRateList();
            result = result * 59 + ($lossRateList == null ? 43 : ((Object)$lossRateList).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WanHighLossDetector.WanLossRate(time=" + this.getTime() + ", lossRateList=" + this.getLossRateList() + ")";
        }

        @Generated
        public WanLossRate(long time, List<LossRates> lossRateList) {
            this.time = time;
            this.lossRateList = lossRateList;
        }
    }
}

