/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.rule.osg.throughput;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.c;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.AbstractDeviceDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.throughput.WanHighLatencyDTO;
import com.tplink.smb.omada.anomaly.core.domain.a.e;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.a;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.b;
import com.tplink.smb.omada.anomaly.core.domain.model.setting.AnomalyEventSettingDTO;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WanHighLatencyDetector
implements a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(WanHighLatencyDetector.class);
    private static final int b = OmadacType.s() ? 3 : 18;
    private static final List<c> c = new ArrayList<c>(Arrays.asList(com.tplink.smb.omada.anomaly.api.b.c.dw, com.tplink.smb.omada.anomaly.api.b.c.dx));
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a d;
    @Autowired
    private e e;

    @Override
    public c a() {
        return com.tplink.smb.omada.anomaly.api.b.c.cX;
    }

    @Override
    public f c() {
        return f.d;
    }

    @Override
    public List<c> d() {
        return c;
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> a(com.tplink.smb.omada.anomaly.core.domain.model.b.b anomalyDetectTimeRange, String mac, List<DevicePreprocessDTO> devicePreDataList) {
        if (CollectionUtils.isEmpty(devicePreDataList)) {
            a.debug("skip abnormal {} anomaly detect for osg {} omadac {} site {}, for data is empty", new Object[]{this.a(), mac, anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b()});
            return Collections.emptyList();
        }
        HashMap<String, TreeMap<Long, Integer>> wanLatencyMap = new HashMap<String, TreeMap<Long, Integer>>();
        this.a(devicePreDataList, wanLatencyMap);
        if (a.isDebugEnabled()) {
            a.debug("detect anomaly event {} for osg {},preHandle data:{}", new Object[]{this.a(), mac, x.a(wanLatencyMap)});
        }
        AnomalyEventSettingDTO anomalyEventSettingDTO = anomalyDetectTimeRange.e().get(this.a().a());
        int highLatencyThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSettingDTO, "threshold", 3000);
        int latencyRatioThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSettingDTO, "count", 80);
        HashSet<String> wanNames = new HashSet<String>();
        for (Map.Entry entry : wanLatencyMap.entrySet()) {
            long highLatencyCount;
            int size = ((TreeMap)entry.getValue()).size();
            if (size < b || (highLatencyCount = ((TreeMap)entry.getValue()).values().stream().filter(latency -> latency >= highLatencyThreshold).count()) * 100L < (long)(size * latencyRatioThreshold)) continue;
            wanNames.add((String)entry.getKey());
        }
        if (CollectionUtils.isNotEmpty(wanNames)) {
            com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.d.a()).a(mac).c(anomalyDetectTimeRange.a()).d(anomalyDetectTimeRange.b()).a(anomalyDetectTimeRange.d()).a(this.a()).a(this.a(anomalyEventSettingDTO)).a();
            OsgWanLatency osgWanLatency = this.a(wanLatencyMap, wanNames);
            anomalyEvent.a(null, CollectionUtils.toStringMap((String[])new String[]{"wanName", T.a(wanNames, (String)","), "count", String.valueOf(latencyRatioThreshold), "threshold", String.valueOf(highLatencyThreshold)}), Collections.singletonMap("osgWanLatency", osgWanLatency), Collections.singletonMap(mac, this.e.a(anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b(), mac)), null, null);
            return Collections.singletonList(anomalyEvent);
        }
        return Collections.emptyList();
    }

    @Override
    public void a(String omadacId, String siteId, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEventSet, Map<String, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b>> causeMap, com.tplink.smb.omada.anomaly.core.domain.model.b.a associateResult) {
        for (com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent : anomalyEventSet) {
            String deviceMac = anomalyEvent.g();
            Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> causes = causeMap.get(com.tplink.smb.omada.anomaly.core.domain.model.rule.b.a(deviceMac, com.tplink.smb.omada.anomaly.api.b.c.cZ));
            if (CollectionUtils.isNotEmpty(causes)) {
                WanHighLatencyDetector.a(anomalyEvent, causes);
            } else {
                this.a(anomalyEvent);
            }
            anomalyEvent.a(true);
        }
    }

    @Override
    public Boolean a(com.tplink.smb.omada.anomaly.core.domain.model.a.b newAnomalyEvent, com.tplink.smb.omada.anomaly.core.domain.model.a.b presidentEvent) {
        if (!this.b(newAnomalyEvent, presidentEvent)) {
            return false;
        }
        return com.tplink.smb.omada.anomaly.core.port.f.a.b(newAnomalyEvent, presidentEvent);
    }

    private OsgWanLatency a(Map<String, TreeMap<Long, Integer>> wanLatencyMap, Set<String> wanNames) {
        TreeMap treeMap = new TreeMap();
        for (String wanName : wanNames) {
            for (Map.Entry<Long, Integer> entry : wanLatencyMap.get(wanName).entrySet()) {
                if (Objects.isNull(treeMap.get(entry.getKey()))) {
                    ArrayList<WanLatency> list = new ArrayList<WanLatency>();
                    list.add(new WanLatency(wanName, entry.getValue()));
                    treeMap.put(entry.getKey(), list);
                    continue;
                }
                ((List)treeMap.get(entry.getKey())).add(new WanLatency(wanName, entry.getValue()));
            }
        }
        ArrayList<WanLatencyWithTime> latencyWithTimeList = new ArrayList<WanLatencyWithTime>();
        for (Map.Entry entry : treeMap.entrySet()) {
            latencyWithTimeList.add(new WanLatencyWithTime((Long)entry.getKey(), (List)entry.getValue()));
        }
        return new OsgWanLatency(new ArrayList<String>(wanNames), latencyWithTimeList);
    }

    private void a(List<DevicePreprocessDTO> devicePreDataList, Map<String, TreeMap<Long, Integer>> wanLatencyMap) {
        for (DevicePreprocessDTO devicePreprocessDTO : devicePreDataList) {
            AbstractDeviceDTO abstractDeviceDTO = devicePreprocessDTO.getPreprocessData().get(this.a().a());
            if (Objects.isNull(abstractDeviceDTO)) continue;
            WanHighLatencyDTO wanHighLatencyDTO = (WanHighLatencyDTO)abstractDeviceDTO;
            wanHighLatencyDTO.getWanInfos().forEach(wanInfo -> {
                String wanName = wanInfo.getWanName();
                long timestamp = wanInfo.getTimestamp();
                int latency = wanInfo.getLatency();
                if (Objects.isNull(wanLatencyMap.get(wanName))) {
                    TreeMap<Long, Integer> map = new TreeMap<Long, Integer>();
                    map.put(timestamp, latency);
                    wanLatencyMap.put(wanName, map);
                } else {
                    ((TreeMap)wanLatencyMap.get(wanName)).put(timestamp, latency);
                }
            });
        }
    }

    public static void a(com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> causeEventSet) {
        ArrayList events = new ArrayList();
        causeEventSet.stream().filter(anomalyCause -> anomalyEvent.k() > anomalyCause.k() && anomalyEvent.k() - anomalyCause.k() < 900000L).forEach(events::add);
        if (CollectionUtils.isNotEmpty(events)) {
            com.tplink.smb.omada.anomaly.core.domain.model.a.b cause = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(anomalyEvent.g()).c(anomalyEvent.i()).d(anomalyEvent.j()).a(anomalyEvent.k()).a(com.tplink.smb.omada.anomaly.api.b.c.ds).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(com.tplink.smb.omada.anomaly.api.b.c.ds)).a();
            anomalyEvent.d(cause);
        }
    }

    private void a(com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent) {
        c.forEach(causeEnum -> {
            com.tplink.smb.omada.anomaly.core.domain.model.a.b cause = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(anomalyEvent.g()).c(anomalyEvent.i()).d(anomalyEvent.j()).a(anomalyEvent.k()).a((c)causeEnum).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(causeEnum)).a();
            anomalyEvent.d(cause);
        });
    }

    @KeepClass
    private static class OsgWanLatency {
        List<String> wanNames;
        List<WanLatencyWithTime> wanLatencyList;

        @Generated
        public List<String> getWanNames() {
            return this.wanNames;
        }

        @Generated
        public List<WanLatencyWithTime> getWanLatencyList() {
            return this.wanLatencyList;
        }

        @Generated
        public void setWanNames(List<String> wanNames) {
            this.wanNames = wanNames;
        }

        @Generated
        public void setWanLatencyList(List<WanLatencyWithTime> wanLatencyList) {
            this.wanLatencyList = wanLatencyList;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof OsgWanLatency)) {
                return false;
            }
            OsgWanLatency other = (OsgWanLatency)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$wanNames = this.getWanNames();
            List<String> other$wanNames = other.getWanNames();
            if (this$wanNames == null ? other$wanNames != null : !((Object)this$wanNames).equals(other$wanNames)) {
                return false;
            }
            List<WanLatencyWithTime> this$wanLatencyList = this.getWanLatencyList();
            List<WanLatencyWithTime> other$wanLatencyList = other.getWanLatencyList();
            return !(this$wanLatencyList == null ? other$wanLatencyList != null : !((Object)this$wanLatencyList).equals(other$wanLatencyList));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OsgWanLatency;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $wanNames = this.getWanNames();
            result = result * 59 + ($wanNames == null ? 43 : ((Object)$wanNames).hashCode());
            List<WanLatencyWithTime> $wanLatencyList = this.getWanLatencyList();
            result = result * 59 + ($wanLatencyList == null ? 43 : ((Object)$wanLatencyList).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WanHighLatencyDetector.OsgWanLatency(wanNames=" + this.getWanNames() + ", wanLatencyList=" + this.getWanLatencyList() + ")";
        }

        @Generated
        public OsgWanLatency(List<String> wanNames, List<WanLatencyWithTime> wanLatencyList) {
            this.wanNames = wanNames;
            this.wanLatencyList = wanLatencyList;
        }
    }

    @KeepClass
    private static class WanLatency {
        String wanName;
        int latency;

        @Generated
        public String getWanName() {
            return this.wanName;
        }

        @Generated
        public int getLatency() {
            return this.latency;
        }

        @Generated
        public void setWanName(String wanName) {
            this.wanName = wanName;
        }

        @Generated
        public void setLatency(int latency) {
            this.latency = latency;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof WanLatency)) {
                return false;
            }
            WanLatency other = (WanLatency)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLatency() != other.getLatency()) {
                return false;
            }
            String this$wanName = this.getWanName();
            String other$wanName = other.getWanName();
            return !(this$wanName == null ? other$wanName != null : !this$wanName.equals(other$wanName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WanLatency;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLatency();
            String $wanName = this.getWanName();
            result = result * 59 + ($wanName == null ? 43 : $wanName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WanHighLatencyDetector.WanLatency(wanName=" + this.getWanName() + ", latency=" + this.getLatency() + ")";
        }

        @Generated
        public WanLatency(String wanName, int latency) {
            this.wanName = wanName;
            this.latency = latency;
        }
    }

    @KeepClass
    private static class WanLatencyWithTime {
        long time;
        List<WanLatency> wanLatency;

        @Generated
        public long getTime() {
            return this.time;
        }

        @Generated
        public List<WanLatency> getWanLatency() {
            return this.wanLatency;
        }

        @Generated
        public void setTime(long time) {
            this.time = time;
        }

        @Generated
        public void setWanLatency(List<WanLatency> wanLatency) {
            this.wanLatency = wanLatency;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof WanLatencyWithTime)) {
                return false;
            }
            WanLatencyWithTime other = (WanLatencyWithTime)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTime() != other.getTime()) {
                return false;
            }
            List<WanLatency> this$wanLatency = this.getWanLatency();
            List<WanLatency> other$wanLatency = other.getWanLatency();
            return !(this$wanLatency == null ? other$wanLatency != null : !((Object)this$wanLatency).equals(other$wanLatency));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WanLatencyWithTime;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            List<WanLatency> $wanLatency = this.getWanLatency();
            result = result * 59 + ($wanLatency == null ? 43 : ((Object)$wanLatency).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WanHighLatencyDetector.WanLatencyWithTime(time=" + this.getTime() + ", wanLatency=" + this.getWanLatency() + ")";
        }

        @Generated
        public WanLatencyWithTime(long time, List<WanLatency> wanLatency) {
            this.time = time;
            this.wanLatency = wanLatency;
        }
    }
}

